/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.open.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ovopark.cloud.core.kit.FileKit;
import com.ovopark.cloud.core.kit.LogKit;
import com.ovopark.cloud.core.plugin.activerecord.GG;
import com.ovopark.cloud.core.plugin.activerecord.MM;
import com.ovopark.cloud.core.plugin.cocosql.CoCoSqlKit;
import com.ovopark.cloud.core.plugin.cocosql.SqlEntity;
import com.ovopark.cloud.core.service.CoCoService;
import com.ovopark.open.api.rpc.FaceService;
import com.ovopark.open.service.entity.AbstractReturnCode;
import com.ovopark.open.service.entity.ApiReturnCode;
import com.ovopark.open.service.entity.FaceParm;
import com.ovopark.open.service.utils.AliyunPropUtil;
import com.ovopark.open.service.utils.BaseUtils;
import com.ovopark.open.service.utils.OssHelper;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.aspectj.util.FileUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="FaceService")
public class FaceServiceImpl
implements FaceService {
    public static final String RESULT_SUCCESS = "ok";
    private static final String VIP_TABLE_NAME = "is_vip";
    private static final String VIP_ENTERPRISE_TABLE_NAME = "is_vip_enterprise";
    private static final int CHECK_PHONE_NUMBER_YES = 1;
    private static String facePulsPlusIp = AliyunPropUtil.readStringValue("facePlusPlusIP");
    private static String accessUrl = AliyunPropUtil.readStringValue("oss.accessUrl");
    private static String fileTempCatalog = AliyunPropUtil.readStringValue("fileTempCatalog");
    @Autowired
    private CoCoService coco;

    @Transactional
    public GG addUser(String json, HttpServletRequest request) {
        String application_key = request.getParameter("_akey");
        String application_secret = request.getParameter("_asid");
        GG result = new GG();
        ArrayList<MM> errorList = new ArrayList<MM>();
        ArrayList<MM> successList = new ArrayList<MM>();
        AbstractReturnCode Abcode = null;
        List mmList = JSON.parseArray((String)json, MM.class);
        for (MM mm : mmList) {
            String validatemsg = BaseUtils.validateParmsNotNull(mm, "orgid", "departno", "username", "userid", "memberType", "mobilephone", "gender", "thirdpicurl", "checkrepeat");
            if (validatemsg.length() > 0) {
                Abcode = ApiReturnCode.DATA_NOT_NULL;
                MM error = new MM();
                error.set("userid", (Object)mm.getStr("userid"));
                error.set("result", (Object)Abcode.getDesc());
                error.set("code", (Object)Abcode.getCode());
                error.set("codename", (Object)Abcode.getName());
                errorList.add(error);
                continue;
            }
            boolean checkOk = true;
            Long l = this.coco.queryLong("select count(1) from auth_user where  application_key=? and application_secret=? and enterprise_id=?", new Object[]{application_key, application_secret, mm.get((Object)"orgid")});
            String userId = mm.getStr("userid");
            if (l > 0L) {
                Long isexist;
                Integer checkrepeat = mm.getInt("checkrepeat");
                String phoneNumber = mm.getStr("mobilephone");
                if (1 == checkrepeat && (isexist = this.coco.queryLong("select count(1) from is_vip where  phone_number=?", new Object[]{phoneNumber})) > 0L) {
                    checkOk = false;
                    Abcode = ApiReturnCode.PHONE_ALREADY_EXIST;
                    MM error = new MM();
                    error.set("userid", (Object)userId);
                    error.set("result", (Object)Abcode.getDesc());
                    error.set("code", (Object)Abcode.getCode());
                    error.set("codename", (Object)Abcode.getName());
                    errorList.add(error);
                }
                String face_url = "";
                String face_token = "";
                if (checkOk) {
                    String ossUrl = this.upload2Oss(mm.getStr("thirdpicurl"));
                    FaceParm faceParm = new FaceParm();
                    faceParm.setUrl(accessUrl + "/" + ossUrl);
                    faceParm.setDepId(mm.getInt("departno"));
                    faceParm.setEnterpriseId(mm.getInt("orgid"));
                    SqlEntity entity = CoCoSqlKit.getSqlEntity((String)"system.getEnterpriseAndDep");
                    MM enterprise_dep = this.coco.findFirstMM(entity.getSql(), new Object[]{mm.get((Object)"orgid"), mm.get((Object)"departno")});
                    faceParm.setEnterpriseName(enterprise_dep.getStr("enterprisename"));
                    faceParm.setDepName(enterprise_dep.getStr("depname"));
                    faceParm.setVipName(mm.getStr("username"));
                    String faceToken = this.getFaceToken(faceParm);
                    if (faceToken == null && !StringUtils.isBlank((String)ossUrl)) {
                        OssHelper.deleteFile(ossUrl);
                        checkOk = false;
                        Abcode = ApiReturnCode.FACE_SEVER_ERROR;
                        MM error = new MM();
                        error.set("userid", (Object)userId);
                        error.set("result", (Object)Abcode.getDesc());
                        error.set("code", (Object)Abcode.getCode());
                        error.set("codename", (Object)Abcode.getName());
                        errorList.add(error);
                    } else {
                        face_url = accessUrl + "/" + ossUrl;
                        face_token = faceToken;
                    }
                }
                if (!checkOk) continue;
                MM vip = new MM();
                vip.set("name", mm.get((Object)"username"));
                vip.set("phone_number", mm.get((Object)"mobilephone"));
                vip.set("gender", mm.get((Object)"gender"));
                vip.set("name", mm.get((Object)"username"));
                this.coco.save(VIP_TABLE_NAME, (Object)vip);
                Object vipId = vip.get((Object)"id");
                MM ip_enterprise = new MM();
                ip_enterprise.set("vip_id", vipId);
                ip_enterprise.set("enterprise_id", mm.get((Object)"orgid"));
                ip_enterprise.set("register_dep_id", mm.get((Object)"departno"));
                ip_enterprise.set("open_userid", mm.get((Object)"userid"));
                ip_enterprise.set("register_name", mm.get((Object)"username"));
                ip_enterprise.set("register_date", (Object)new Date());
                ip_enterprise.set("face_url", (Object)face_url);
                ip_enterprise.set("face_token", (Object)face_token);
                ip_enterprise.set("is_oss_url", (Object)1);
                ip_enterprise.set("reg_type", mm.get((Object)"memberType"));
                this.coco.save(VIP_ENTERPRISE_TABLE_NAME, (Object)ip_enterprise);
                Abcode = ApiReturnCode.ADD_SUCCESS;
                MM success = new MM();
                success.set("userid", (Object)userId);
                success.set("result", (Object)Abcode.getDesc());
                success.set("code", (Object)Abcode.getCode());
                success.set("codename", (Object)Abcode.getName());
                successList.add(success);
                continue;
            }
            Abcode = ApiReturnCode.IDENTITY_INFORMATION_WRONG;
            MM error = new MM();
            error.set("userid", (Object)userId);
            error.set("result", (Object)Abcode.getDesc());
            Abcode = ApiReturnCode.IDENTITY_INFORMATION_WRONG;
            error.set("code", (Object)Abcode.getCode());
            error.set("codename", (Object)Abcode.getName());
            errorList.add(error);
        }
        MM data = new MM();
        data.put((Object)"error", errorList);
        data.put((Object)"success", successList);
        result.setData((Object)data);
        if (errorList.size() == 0) {
            result.setCode(0);
            result.setCodename(ApiReturnCode.ADD_SUCCESS.getName());
            result.setIsError(false);
            result.setResult(ApiReturnCode.SUCCESS.getDesc());
        } else {
            result.setCode(100001);
            result.setCodename(ApiReturnCode.DATA_FALED.getName());
            result.setIsError(true);
            result.setResult(ApiReturnCode.DATA_FALED.getDesc());
        }
        return result;
    }

    private String getFaceToken(FaceParm faceParm) {
        block5: {
            CloseableHttpClient httpclient = HttpClients.createDefault();
            try {
                if (StringUtils.isBlank((String)facePulsPlusIp)) {
                    facePulsPlusIp = "139.129.251.201:9999";
                }
                String url = "http://" + facePulsPlusIp + "/Face/Vip/Regist";
                LogKit.info((Object)("url = " + url));
                HttpPost httpPost = new HttpPost(url);
                httpPost.addHeader("Content-type", "application/json; charset=utf-8");
                httpPost.setHeader("Accept", "application/json");
                httpPost.setEntity((HttpEntity)new StringEntity(JSONObject.toJSONString((Object)faceParm), Charset.forName("UTF-8")));
                CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
                if (response.getStatusLine().getStatusCode() != 200) break block5;
                HttpEntity httpEntity = response.getEntity();
                String string = EntityUtils.toString((HttpEntity)httpEntity);
                LogKit.info((Object)("face++ string = " + string));
                JSONObject josnResult = JSONObject.parseObject((String)string);
                if (RESULT_SUCCESS.equals(josnResult.getString("result"))) {
                    String faceToken = josnResult.getString("face_token");
                    if (!StringUtils.isBlank((String)faceToken)) {
                        return faceToken;
                    }
                    break block5;
                }
                return null;
            }
            catch (Exception e) {
                LogKit.error((Object)("getFaceToken:" + e));
                return null;
            }
        }
        return null;
    }

    private String upload2Oss(String thirdpicurl) {
        String ossUrl = "";
        String suffix = thirdpicurl.substring(thirdpicurl.lastIndexOf("."));
        String tempfilename = System.currentTimeMillis() + suffix;
        File third_file = new File(fileTempCatalog + tempfilename);
        InputStream in = FileKit.getInputStreamByGet((String)thirdpicurl);
        FileKit.saveData((InputStream)in, (File)third_file);
        ossUrl = OssHelper.uploadFile(third_file);
        FileUtil.deleteContents((File)third_file);
        return ossUrl;
    }
}

