/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.open.service.utils;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.model.MatchMode;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PolicyConditions;
import com.ovopark.open.service.utils.AliyunPropUtil;
import com.ovopark.open.service.utils.DateUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class OssHelper {
    private static Logger logger = LoggerFactory.getLogger(OssHelper.class);
    private static String ossBucketName;
    private static String ossEndPoint;
    private static String accessKeyId;
    private static String accessKeySecret;
    private static String accessUrl;

    public static String uploadFile(File file) {
        String newFileName = OssHelper.genImageName(file.getName());
        String imagePath = OssHelper.getImagePath(newFileName);
        OssHelper.putObject(file, newFileName, imagePath);
        return imagePath;
    }

    public static String uploadFileExt(File file, String ext) {
        String newFileName = OssHelper.genImageName(file.getName());
        if (!StringUtils.isEmpty((Object)ext)) {
            newFileName = newFileName.substring(0, newFileName.lastIndexOf(".")) + ext;
        }
        String imagePath = OssHelper.getImagePath(newFileName);
        OssHelper.putObject(file, newFileName, imagePath);
        return imagePath;
    }

    public static String uploadFileWithName(File file, String fileName) {
        String newFileName = OssHelper.genImageName(file.getName());
        if (!StringUtils.isEmpty((Object)fileName)) {
            newFileName = fileName;
        }
        String imagePath = OssHelper.getImagePath(newFileName);
        OssHelper.putObject(file, newFileName, imagePath);
        return imagePath;
    }

    public static String uploadLocalFile(String localFilePath) {
        String newFileName = OssHelper.genImageName(localFilePath.substring(localFilePath.lastIndexOf("/") + 1));
        String imagePath = OssHelper.getImagePath(newFileName);
        OssHelper.putObject(new File(localFilePath), newFileName, imagePath);
        return imagePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream downLoadFile(String imagePath) {
        OSSClient client = null;
        InputStream input = null;
        try {
            client = new OSSClient(ossEndPoint, accessKeyId, accessKeySecret);
            OSSObject image = client.getObject(ossBucketName, imagePath);
            if (image != null) {
                input = image.getObjectContent();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
        finally {
            client.shutdown();
        }
        return input;
    }

    public static void deleteFile(String filePath) {
        OSSClient client = null;
        try {
            client = new OSSClient(ossEndPoint, accessKeyId, accessKeySecret);
            client.deleteObject(ossBucketName, filePath);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
        finally {
            client.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getOssPolicy() {
        OSSClient client = null;
        String dir = "front";
        try {
            client = new OSSClient(ossEndPoint, accessKeyId, accessKeySecret);
            long expireTime = 30L;
            long expireEndTime = System.currentTimeMillis() + expireTime * 1000L;
            Date expiration = new Date(expireEndTime);
            PolicyConditions policyConds = new PolicyConditions();
            policyConds.addConditionItem("content-length-range", 0L, 1048576000L);
            policyConds.addConditionItem(MatchMode.StartWith, "key", dir);
            String postPolicy = client.generatePostPolicy(expiration, policyConds);
            byte[] binaryData = postPolicy.getBytes("utf-8");
            String encodedPolicy = BinaryUtil.toBase64String((byte[])binaryData);
            String postSignature = client.calculatePostSignature(postPolicy);
            LinkedHashMap<String, String> respMap = new LinkedHashMap<String, String>();
            respMap.put("accessid", accessKeyId);
            respMap.put("policy", encodedPolicy);
            respMap.put("signature", postSignature);
            respMap.put("dir", dir);
            respMap.put("host", accessUrl);
            respMap.put("expire", String.valueOf(expireEndTime / 1000L));
            String string = JSONObject.toJSONString(respMap);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
        finally {
            client.shutdown();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putObject(File file, String fileName, String imagePath) {
        OSSClient client = null;
        try {
            client = new OSSClient(ossEndPoint, accessKeyId, accessKeySecret);
            FileInputStream input = new FileInputStream(file);
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentType(OssHelper.contentType(fileName.substring(fileName.lastIndexOf(".") + 1)));
            meta.setCacheControl("no-cache");
            client.putObject(ossBucketName, imagePath, (InputStream)input, meta);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
        finally {
            client.shutdown();
        }
    }

    private static String contentType(String fileType) {
        fileType = fileType.toLowerCase();
        String contentType = "";
        switch (fileType) {
            case "bmp": {
                contentType = "image/bmp";
                break;
            }
            case "gif": {
                contentType = "image/gif";
                break;
            }
            case "png": 
            case "jpeg": 
            case "jpg": {
                contentType = "image/jpeg";
                break;
            }
            case "html": {
                contentType = "text/html";
                break;
            }
            case "txt": {
                contentType = "text/plain";
                break;
            }
            case "vsd": {
                contentType = "application/vnd.visio";
                break;
            }
            case "ppt": 
            case "pptx": {
                contentType = "application/vnd.ms-powerpoint";
                break;
            }
            case "doc": 
            case "docx": {
                contentType = "application/msword";
                break;
            }
            case "xml": {
                contentType = "text/xml";
                break;
            }
            case "mp4": {
                contentType = "video/mp4";
                break;
            }
            default: {
                contentType = "application/octet-stream";
            }
        }
        return contentType;
    }

    public static String genImageName(String suffix) {
        String extName = suffix.substring(suffix.lastIndexOf("."));
        long millis = System.currentTimeMillis();
        Random random = new Random();
        int end3 = random.nextInt(999);
        String str = millis + String.format("%03d", end3);
        return str + extName;
    }

    public static String getImagePath(String imageName) {
        return DateUtils.format(new Date(), "yyyy/MM/dd") + "/" + imageName;
    }

    static {
        accessKeyId = AliyunPropUtil.readStringValue("aliyun.accessKeyId");
        accessKeySecret = AliyunPropUtil.readStringValue("aliyun.accessKeySecret");
        ossEndPoint = AliyunPropUtil.readStringValue("oss.endpoint");
        ossBucketName = AliyunPropUtil.readStringValue("oss.bucketName");
        accessUrl = AliyunPropUtil.readStringValue("oss.accessUrl");
    }
}

