/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.config;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.ovopark.training.enhancer.subject.tracing.TracingHelper;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;

@Configuration
@EnableAsync
public class MyThreadPoolConfig {
    private static final Logger log = LoggerFactory.getLogger(MyThreadPoolConfig.class);

    private Executor executorService(ThreadPoolExecutor poolExecutor) {
        return TracingHelper.executorService((ThreadPoolExecutor)poolExecutor);
    }

    @Bean(value={"export"})
    public Executor export() {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("export-%d").build();
        ThreadPoolExecutor poolExecutor = new ThreadPoolExecutor(2, 12, 10L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(12), threadFactory, new ThreadPoolExecutor.CallerRunsPolicy(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
                log.warn("\u7ebf\u7a0b\u4e0d\u591f\u4e86,\u8d70\u4e3b\u7ebf\u7a0b\u6267\u884c");
                super.rejectedExecution(r, e);
            }
        });
        poolExecutor.allowCoreThreadTimeOut(true);
        return this.executorService(poolExecutor);
    }
}

