/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.controller;

import com.ovopark.bo.Authenticator;
import com.ovopark.pojo.Users;
import com.ovopark.service.TrainingAnalysisService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/analysis"})
public class TriningAnalysisController {
    @Autowired
    private TrainingAnalysisService trainingAnalysisService;

    @PostMapping(value={"/getMaterialDetailExcel"})
    @ResponseBody
    public String getMaterialDetailExcel(@RequestParam(required=false) Integer status, @RequestParam Integer trainingId, @RequestParam Integer materialId, @RequestParam(required=false) String nameOrNumber, @RequestParam(required=false) String excelStr) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            return this.trainingAnalysisService.getMaterialDetailExcel(user.getId(), status, trainingId, user.getGroupId(), materialId, nameOrNumber, excelStr);
        }
        return "INVALID_TOKEN";
    }

    @PostMapping(value={"/getPaperDetailExcel"})
    @ResponseBody
    public String getPaperDetailExcel(@RequestParam(required=false) Integer status, @RequestParam Integer trainingId, @RequestParam Integer paperId, @RequestParam(required=false) String nameOrNumber, @RequestParam(required=false) String excelStr, @RequestParam(required=false) Integer exportStatus) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            return this.trainingAnalysisService.getPaperDetailExcel(user.getId(), status, user.getGroupId(), trainingId, paperId, nameOrNumber, excelStr, exportStatus);
        }
        return "INVALID_TOKEN";
    }

    @PostMapping(value={"/getLearnerExcel"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getLearnerExcel(@RequestParam(required=false) Integer status, @RequestParam Integer trainingId, @RequestParam String excelStr, @RequestParam(required=false) String organizeIds, @RequestParam(required=false) String depIds, @RequestParam(required=false) String nameOrNumber) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            return this.trainingAnalysisService.getLearnerExcel(user.getId(), status, trainingId, user.getGroupId(), organizeIds, depIds, nameOrNumber, excelStr);
        }
        return "INVALID_TOKEN";
    }

    @PostMapping(value={"/getCertificateDetailByExecl"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getCertificateDetailByExecl(@RequestParam(required=false) String userId, @RequestParam String userName, @RequestParam Integer status, @RequestParam(required=false) Integer certificateId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            return this.trainingAnalysisService.getCertificateDetailByExecl(userId, userName, status, certificateId, user);
        }
        return "INVALID_TOKEN";
    }

    @PostMapping(value={"/getDeptAnalysisExcel"})
    @ResponseBody
    public String getDeptAnalysisExcel(Integer trainingId, Integer enterpriseId, Integer organizeLevel, Integer parentId, String organizeIds) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            if (enterpriseId == null) {
                enterpriseId = user.getGroupId();
            }
            if (organizeLevel == null) {
                organizeLevel = 1;
            }
            return this.trainingAnalysisService.getDeptAnalysisExcel(trainingId, enterpriseId, user.getId(), parentId, organizeLevel, organizeIds);
        }
        return "INVALID_TOKEN";
    }

    @PostMapping(value={"/selectUserExamByExecl"})
    @ResponseBody
    public String selectUserExamByExecl(@RequestParam Integer paperId, @RequestParam Integer exportStatus, @RequestParam String userName, @RequestParam Integer status, @RequestParam Integer orderBy, @RequestParam Integer order, @RequestParam Integer userPaperType) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            return this.trainingAnalysisService.selectUserExamByExecl(paperId, exportStatus, userName, status, orderBy, order, userPaperType, user);
        }
        return "INVALID_TOKEN";
    }
}

