/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.controller.report;

import com.ovopark.bo.Authenticator;
import com.ovopark.model.TrainingReportParam;
import com.ovopark.model.UserReportParam;
import com.ovopark.pojo.Users;
import com.ovopark.service.reportExport.ReportService;
import com.ovopark.utils.DateUtils;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/report"})
public class ReportController {
    @Autowired
    private ReportService reportService;

    @PostMapping(value={"/getDepartmentTrainingReportByExport"})
    @ResponseBody
    public String getDepartmentTrainingReportByExport(@RequestBody TrainingReportParam trainingReportParam) {
        Users user = Authenticator.getInstance().getCurrentUser();
        trainingReportParam.setUserId(user.getId());
        trainingReportParam.setEnterpriseId(user.getGroupId());
        return this.reportService.getDepartmentTrainingReportByExport(trainingReportParam);
    }

    @PostMapping(value={"/getUserReportByExport"})
    @ResponseBody
    public String getUserReportByExport(@RequestBody UserReportParam param) {
        String sDate = DateUtils.format((Date)DateUtils.getStartTimeOfDay((Date)new Date()), (String)"yyyy-MM-dd HH:mm:ss");
        String eDate = DateUtils.format((Date)DateUtils.getEndTimeOfDay((Date)new Date()), (String)"yyyy-MM-dd HH:mm:ss");
        if (!StringUtils.isEmpty((String)param.getStartDate())) {
            sDate = DateUtils.format((Date)DateUtils.getStartTimeOfDay((Date)DateUtils.parse((String)param.getStartDate(), (String)"yyyy-MM-dd")), (String)"yyyy-MM-dd HH:mm:ss");
        }
        if (!StringUtils.isEmpty((String)param.getEndDate())) {
            eDate = DateUtils.format((Date)DateUtils.getEndTimeOfDay((Date)DateUtils.parse((String)param.getEndDate(), (String)"yyyy-MM-dd")), (String)"yyyy-MM-dd HH:mm:ss");
        }
        Users user = Authenticator.getInstance().getCurrentUser();
        param.setUserId(user.getId());
        param.setEnterpriseId(user.getGroupId());
        param.setStartDate(sDate);
        param.setEndDate(eDate);
        return this.reportService.getUserReportByExport(param);
    }
}

