/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.service.export;

import com.ovopark.config.ExportConst;
import com.ovopark.model.ExportParam;
import com.ovopark.service.export.ExportService;
import com.ovopark.service.export.typeHandler.IExportTypeHandler;
import com.ovopark.training.enhancer.subject.resp.Result;
import com.ovopark.training.enhancer.subject.resp.ResultUtils;
import com.ovopark.training.enhancer.subject.strategyfactory.HandlerFactory;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExportServiceImpl
implements ExportService {
    private static final Logger log = LoggerFactory.getLogger(ExportServiceImpl.class);
    @Autowired
    private HandlerFactory<ExportConst.Type, IExportTypeHandler> factory;

    @Override
    public Result<Void> upload(ExportParam param) {
        ExportConst.Type exportType = param.getExportType();
        param.setSheet(StringUtils.defaultString((String)param.getSheet(), (String)"\u6570\u636e"));
        IExportTypeHandler handler = this.getHandlerByType(exportType);
        if (handler == null) {
            return ResultUtils.fail((String)"\u5bfc\u51fa\u7c7b\u578b\u9519\u8bef");
        }
        return handler.handle(param);
    }

    private IExportTypeHandler getHandlerByType(ExportConst.Type exportType) {
        return (IExportTypeHandler)this.factory.getStrategy((Object)exportType);
    }
}

