/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.service.impl;

import com.alibaba.fastjson.JSON;
import com.ovopark.api.TrainingApi;
import com.ovopark.bo.Authenticator;
import com.ovopark.bo.JsonResult;
import com.ovopark.enums.DeptStatisticsExportEnum;
import com.ovopark.organize.common.model.pojo.ExportTaskPojo;
import com.ovopark.pojo.DeptSummarizeExportRequest;
import com.ovopark.pojo.DeptSummarizeResponse;
import com.ovopark.service.IDeptStatisticExcelService;
import com.ovopark.utils.DateUtils;
import com.ovopark.utils.DownloadUtils;
import com.ovopark.utils.ExcelUtil;
import com.ovopark.utils.ExportInvokeFieldUtils;
import com.ovopark.utils.ThreadPoolUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;

@Service
public class DeptStatisticsExportServiceImpl
implements IDeptStatisticExcelService {
    @Resource
    private MessageSource messageSource;
    @Resource
    private TrainingApi trainingApi;

    @Override
    public String exportStudySummarizeExcel(final DeptSummarizeExportRequest request) {
        final List selectedColumns = Stream.of(request.getSelectedColumn().split(",")).collect(Collectors.toList());
        final Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        String deptStatistics = this.messageSource.getMessage("training.dept.statistics", null, locale);
        String studyStatistics = this.messageSource.getMessage("training.dept.study.statistics", null, locale);
        String fileName = deptStatistics + "-" + studyStatistics + DateUtils.format((Date)new Date(), (String)"yyyyMMdd");
        fileName = ExcelUtil.getFileName(fileName) + ".xlsx";
        ArrayList<ExportTaskPojo> taskList = new ArrayList<ExportTaskPojo>();
        final ExportTaskPojo exportTaskPojo = DownloadUtils.saveExportTask(fileName, JSON.toJSONString((Object)request), 35);
        ThreadPoolUtil.getThreadPoolExecutor().execute(new Runnable(){

            @Override
            public void run() {
                List<DeptSummarizeResponse> list = DeptStatisticsExportServiceImpl.this.trainingApi.queryStudySummarizeExcelList(request);
                XSSFWorkbook wb = new XSSFWorkbook();
                int dataCount = list.size();
                XSSFSheet sheet = wb.createSheet();
                XSSFCellStyle titleSty = wb.createCellStyle();
                XSSFDataFormat dataFormat = wb.createDataFormat();
                titleSty.setDataFormat(dataFormat.getFormat("@"));
                sheet.setDefaultColumnStyle(0, (CellStyle)titleSty);
                sheet.setColumnWidth(0, 3000);
                for (int i = 0; i <= dataCount; ++i) {
                    XSSFRow row = sheet.createRow(i);
                    int currentNum = 0;
                    for (String columnNames : DeptStatisticsExportEnum.getNames()) {
                        if (!selectedColumns.contains(columnNames)) continue;
                        if (row.getRowNum() == 0) {
                            String messageSourceMessage = DeptStatisticsExportServiceImpl.this.messageSource.getMessage(DeptStatisticsExportEnum.getMessageNameByName(columnNames), null, locale);
                            row.createCell(currentNum).setCellValue(messageSourceMessage);
                        } else {
                            DeptSummarizeResponse deptStudySummarizeExcelResponse = list.get(i - 1);
                            row.createCell(currentNum).setCellValue(ExportInvokeFieldUtils.getFieldByString(deptStudySummarizeExcelResponse, DeptStatisticsExportEnum.getFieldNameByName(columnNames)));
                        }
                        ++currentNum;
                    }
                }
                try {
                    DownloadUtils.successExportTask((Workbook)wb, exportTaskPojo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DownloadUtils.errorExportTask(exportTaskPojo);
                }
            }
        });
        taskList.add(exportTaskPojo);
        return JsonResult.success(taskList);
    }
}

