/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ovopark.api.TrainingApi;
import com.ovopark.bo.Authenticator;
import com.ovopark.bo.JsonResult;
import com.ovopark.organize.common.model.mo.UsersAndOrgsMo;
import com.ovopark.organize.common.model.pojo.ExportTaskPojo;
import com.ovopark.organize.common.model.pojo.UsersPojo;
import com.ovopark.organize.sdk.api.UserOrganizeApi;
import com.ovopark.pojo.LearnerExcelVo;
import com.ovopark.pojo.MaterialDetailExcelVo;
import com.ovopark.pojo.PaperDetailExcelVo;
import com.ovopark.pojo.PaperUserDetailVo;
import com.ovopark.pojo.Training;
import com.ovopark.pojo.TrainingCertificateDetailVo;
import com.ovopark.pojo.TrainingLearnerAnalysisVo;
import com.ovopark.pojo.TrainingLearnerMaterialDetailVo;
import com.ovopark.pojo.TrainingLearnerPaperDetailVo;
import com.ovopark.pojo.TrainingPaper;
import com.ovopark.pojo.Users;
import com.ovopark.privilege.api.RoleApi;
import com.ovopark.privilege.pojo.RolePojo;
import com.ovopark.privilege.response.BaseResult;
import com.ovopark.service.TrainingAnalysisService;
import com.ovopark.service.UserUtilService;
import com.ovopark.utils.DateUtils;
import com.ovopark.utils.DownloadUtils;
import com.ovopark.utils.ExcelUtil;
import com.ovopark.utils.ThreadPoolUtil;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class TrainingAnalysisServiceImpl
implements TrainingAnalysisService {
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private TrainingApi trainingApi;
    @Autowired
    private RoleApi roleApi;
    @Autowired
    private UserUtilService userUtilService;
    @Autowired
    private UserOrganizeApi userOrganizeApi;

    @Override
    public String getMaterialDetailExcel(final Integer userId, final Integer status, final Integer trainingId, final Integer groupId, final Integer materialId, final String nameOrNumber, final String excelStr) {
        final Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        String fileName = MessageFormat.format("{0}_{1}.xlsx", this.messageSource.getMessage("training.material.new.training", null, locale), DateUtils.format((Date)new Date(), (String)"yyyyMMdd_HHmmss"));
        MaterialDetailExcelVo vo = new MaterialDetailExcelVo();
        vo.setUserId(userId);
        vo.setStatus(status);
        vo.setTrainingId(trainingId);
        vo.setGroupId(groupId);
        vo.setMaterialId(materialId);
        vo.setNameOrNumber(nameOrNumber);
        vo.setExcelStr(excelStr);
        ArrayList<ExportTaskPojo> taskList = new ArrayList<ExportTaskPojo>();
        final ExportTaskPojo exportTaskPojo = DownloadUtils.saveExportTask(fileName, JSON.toJSONString((Object)vo), 10);
        ThreadPoolUtil.getThreadPoolExecutor().execute(new Runnable(){

            @Override
            public void run() {
                List<TrainingLearnerMaterialDetailVo> list = TrainingAnalysisServiceImpl.this.trainingApi.getMaterialDetailExcelList(userId, status, trainingId, groupId, materialId, nameOrNumber);
                ArrayList<Integer> userIdList = new ArrayList();
                String userStr = "";
                if (!CollectionUtils.isEmpty(list) && !CollectionUtils.isEmpty(userIdList = list.stream().map(TrainingLearnerMaterialDetailVo::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                    userStr = StringUtils.join(userIdList, (String)",");
                }
                Object[] str = new String[10];
                if (org.springframework.util.StringUtils.isEmpty((Object)excelStr)) {
                    Arrays.fill(str, "0");
                } else {
                    str = excelStr.split(",");
                }
                XSSFWorkbook wb = new XSSFWorkbook();
                String studentDetails = TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.material.student.details", null, locale);
                XSSFSheet sheet = wb.createSheet(studentDetails);
                XSSFCellStyle titleSty = wb.createCellStyle();
                titleSty.setWrapText(true);
                XSSFRow row = sheet.createRow(0);
                int currentNum = -1;
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[0]) && ((String)str[0]).equals("1")) {
                    row.createCell(++currentNum).setCellValue("id");
                    sheet.setColumnWidth(currentNum, 3072);
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[1]) && ((String)str[1]).equals("1")) {
                    String username = TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.user.details.username", null, locale);
                    row.createCell(++currentNum).setCellValue(username);
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[2]) && ((String)str[2]).equals("1")) {
                    String analysisName = TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.trainee.name", null, locale);
                    row.createCell(++currentNum).setCellValue(analysisName);
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[3]) && ((String)str[3]).equals("1")) {
                    String jobnumber = TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.analysis.jobnumber", null, locale);
                    row.createCell(++currentNum).setCellValue(jobnumber);
                }
                Map roleMap = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[4]) && ((String)str[4]).equals("1")) {
                    String role = TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.analysis.role", null, locale);
                    row.createCell(++currentNum).setCellValue(role);
                    sheet.setColumnWidth(currentNum, 7680);
                    if (!org.springframework.util.StringUtils.isEmpty((Object)userStr)) {
                        HashMap<String, Object> parameter = new HashMap<String, Object>();
                        parameter.put("userIds", userStr);
                        parameter.put("groupId", groupId);
                        BaseResult base = TrainingAnalysisServiceImpl.this.roleApi.getUserRoleList(parameter);
                        if (base != null) {
                            roleMap = (Map)base.getData();
                        }
                    }
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[5]) && ((String)str[5]).equals("1")) {
                    String superior = TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.job.post.name", null, locale);
                    row.createCell(++currentNum).setCellValue(superior);
                }
                Map<Object, Object> parentMap = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[6]) && ((String)str[6]).equals("1")) {
                    String superior = TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.analysis.superior", null, locale);
                    row.createCell(++currentNum).setCellValue(superior);
                    parentMap = TrainingAnalysisServiceImpl.this.userUtilService.selectParentMap(userIdList, groupId);
                }
                Map<Object, Object> organizeMap = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[7]) && ((String)str[7]).equals("1")) {
                    String department = TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.learn.department", null, locale);
                    row.createCell(++currentNum).setCellValue(department);
                    sheet.setColumnWidth(currentNum, 20480);
                    organizeMap = TrainingAnalysisServiceImpl.this.userUtilService.selectOrganizeMap(userIdList, groupId);
                }
                Map organMap1 = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[8]) && ((String)str[8]).equals("1")) {
                    String firstOrg = TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.analysis.first.organize", null, locale);
                    row.createCell(++currentNum).setCellValue(firstOrg);
                    if (!CollectionUtils.isEmpty(userIdList)) {
                        UsersAndOrgsMo mo = new UsersAndOrgsMo();
                        mo.setGroupId(groupId);
                        mo.setLevelList(Collections.singletonList(1));
                        mo.setUserIdList(userIdList);
                        mo.setShowDepartment(Boolean.valueOf(false));
                        com.ovopark.organize.common.base.BaseResult base = TrainingAnalysisServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                        if (base != null) {
                            organMap1 = (Map)base.getData();
                        }
                    }
                }
                Map organMap2 = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[9]) && ((String)str[9]).equals("1")) {
                    String secondOrg = TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.analysis.second.organize", null, locale);
                    row.createCell(++currentNum).setCellValue(secondOrg);
                    if (!CollectionUtils.isEmpty(userIdList)) {
                        UsersAndOrgsMo mo = new UsersAndOrgsMo();
                        mo.setGroupId(groupId);
                        mo.setLevelList(Collections.singletonList(2));
                        mo.setUserIdList(userIdList);
                        mo.setShowDepartment(Boolean.valueOf(false));
                        com.ovopark.organize.common.base.BaseResult base = TrainingAnalysisServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                        if (base != null) {
                            organMap2 = (Map)base.getData();
                        }
                    }
                }
                Map organMap3 = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[10]) && ((String)str[10]).equals("1")) {
                    String thirdOrg = TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.analysis.third.organize", null, locale);
                    row.createCell(++currentNum).setCellValue(thirdOrg);
                    if (!CollectionUtils.isEmpty(userIdList)) {
                        UsersAndOrgsMo mo = new UsersAndOrgsMo();
                        mo.setGroupId(groupId);
                        mo.setLevelList(Collections.singletonList(3));
                        mo.setUserIdList(userIdList);
                        mo.setShowDepartment(Boolean.valueOf(false));
                        com.ovopark.organize.common.base.BaseResult base = TrainingAnalysisServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                        if (base != null) {
                            organMap3 = (Map)base.getData();
                        }
                    }
                }
                Map organMap4 = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[11]) && ((String)str[11]).equals("1")) {
                    String fourthOrg = TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.analysis.fourth.organize", null, locale);
                    row.createCell(++currentNum).setCellValue(fourthOrg);
                    if (!CollectionUtils.isEmpty(userIdList)) {
                        UsersAndOrgsMo mo = new UsersAndOrgsMo();
                        mo.setGroupId(groupId);
                        mo.setLevelList(Collections.singletonList(4));
                        mo.setUserIdList(userIdList);
                        mo.setShowDepartment(Boolean.valueOf(false));
                        com.ovopark.organize.common.base.BaseResult base = TrainingAnalysisServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                        if (base != null) {
                            organMap4 = (Map)base.getData();
                        }
                    }
                }
                Map organMap5 = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[12]) && ((String)str[12]).equals("1")) {
                    String fifthOrg = TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.analysis.fifth.organize", null, locale);
                    row.createCell(++currentNum).setCellValue(fifthOrg);
                    if (!CollectionUtils.isEmpty(userIdList)) {
                        UsersAndOrgsMo mo = new UsersAndOrgsMo();
                        mo.setGroupId(groupId);
                        mo.setLevelList(Collections.singletonList(5));
                        mo.setUserIdList(userIdList);
                        mo.setShowDepartment(Boolean.valueOf(false));
                        com.ovopark.organize.common.base.BaseResult base = TrainingAnalysisServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                        if (base != null) {
                            organMap5 = (Map)base.getData();
                        }
                    }
                }
                Map shopMap = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[13]) && ((String)str[13]).equals("1")) {
                    String dep = TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.analysis.dep", null, locale);
                    row.createCell(++currentNum).setCellValue(dep);
                    sheet.setColumnWidth(currentNum, 12800);
                    if (!CollectionUtils.isEmpty(userIdList)) {
                        UsersAndOrgsMo mo = new UsersAndOrgsMo();
                        mo.setGroupId(groupId);
                        mo.setUserIdList(userIdList);
                        mo.setShowDepartment(Boolean.valueOf(true));
                        com.ovopark.organize.common.base.BaseResult base = TrainingAnalysisServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                        if (base != null) {
                            shopMap = (Map)base.getData();
                        }
                    }
                }
                String starttime = TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.analysis.starttime", null, locale);
                row.createCell(++currentNum).setCellValue(starttime);
                sheet.setColumnWidth(currentNum, 4608);
                String endtime = TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.analysis.endtime", null, locale);
                row.createCell(++currentNum).setCellValue(endtime);
                sheet.setColumnWidth(currentNum, 4608);
                String lastStudyTime = TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.analysis.last.studytime", null, locale);
                row.createCell(++currentNum).setCellValue(lastStudyTime);
                sheet.setColumnWidth(currentNum, 4608);
                String studyTime = TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.analysis.study.time", null, locale);
                row.createCell(++currentNum).setCellValue(studyTime);
                String studyProgress = TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.analysis.study.progress", null, locale);
                row.createCell(++currentNum).setCellValue(studyProgress);
                String analysisStatus = TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.analysis.study.status", null, locale);
                row.createCell(++currentNum).setCellValue(analysisStatus);
                for (int i = 0; i < list.size(); ++i) {
                    List pojoList;
                    currentNum = -1;
                    row = sheet.createRow(i + 1);
                    TrainingLearnerMaterialDetailVo vo = list.get(i);
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[0]) && ((String)str[0]).equals("1")) {
                        row.createCell(++currentNum).setCellValue((double)vo.getUserId().intValue());
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[1]) && ((String)str[1]).equals("1")) {
                        row.createCell(++currentNum).setCellValue(vo.getUserName());
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[2]) && ((String)str[2]).equals("1")) {
                        row.createCell(++currentNum).setCellValue(vo.getShowName());
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[3]) && ((String)str[3]).equals("1")) {
                        row.createCell(++currentNum).setCellValue(TrainingAnalysisServiceImpl.this.userUtilService.selectUser(vo.getUserId()).getEmployeeNumber());
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[4]) && ((String)str[4]).equals("1")) {
                        String roleName = "";
                        pojoList = (List)roleMap.get(vo.getUserId());
                        if (!CollectionUtils.isEmpty((Collection)pojoList)) {
                            List listStr = pojoList.stream().map(RolePojo::getRoleName).filter(Objects::nonNull).collect(Collectors.toList());
                            roleName = StringUtils.join(listStr, (String)",");
                        }
                        row.createCell(++currentNum).setCellValue(roleName);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[5]) && ((String)str[5]).equals("1")) {
                        row.createCell(++currentNum).setCellValue(vo.getPost());
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[6]) && ((String)str[6]).equals("1")) {
                        row.createCell(++currentNum).setCellValue((String)parentMap.get(vo.getUserId()));
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[7]) && ((String)str[7]).equals("1")) {
                        String departName = "";
                        List nameList = (List)organizeMap.get(vo.getUserId());
                        if (!CollectionUtils.isEmpty((Collection)nameList)) {
                            departName = String.join((CharSequence)";\n", nameList);
                        }
                        XSSFCell cell = row.createCell(++currentNum);
                        cell.setCellValue(departName);
                        cell.setCellStyle((CellStyle)titleSty);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[8]) && ((String)str[8]).equals("1")) {
                        String organName1 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap1) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)organMap1.get(vo.getUserId())))) {
                            pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                            organName1 = StringUtils.join((Collection)pojoList, (String)",");
                        }
                        row.createCell(++currentNum).setCellValue(organName1);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[9]) && ((String)str[9]).equals("1")) {
                        String organName2 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap2) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)organMap2.get(vo.getUserId())))) {
                            pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                            organName2 = StringUtils.join((Collection)pojoList, (String)",");
                        }
                        row.createCell(++currentNum).setCellValue(organName2);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[10]) && ((String)str[10]).equals("1")) {
                        String organName3 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap3) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)organMap3.get(vo.getUserId())))) {
                            pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                            organName3 = StringUtils.join((Collection)pojoList, (String)",");
                        }
                        row.createCell(++currentNum).setCellValue(organName3);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[11]) && ((String)str[11]).equals("1")) {
                        String organName4 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap4) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)organMap4.get(vo.getUserId())))) {
                            pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                            organName4 = StringUtils.join((Collection)pojoList, (String)",");
                        }
                        row.createCell(++currentNum).setCellValue(organName4);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[12]) && ((String)str[12]).equals("1")) {
                        String organName5 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap5) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)organMap5.get(vo.getUserId())))) {
                            pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                            organName5 = StringUtils.join(pojoList, (String)",");
                        }
                        row.createCell(++currentNum).setCellValue(organName5);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[13]) && ((String)str[13]).equals("1")) {
                        String shopName = "";
                        if (!org.springframework.util.StringUtils.isEmpty(shopMap) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)shopMap.get(vo.getUserId())))) {
                            pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                            shopName = StringUtils.join(pojoList, (String)",");
                        }
                        row.createCell(++currentNum).setCellValue(shopName);
                    }
                    row.createCell(++currentNum).setCellValue(vo.getStartTimeStr());
                    row.createCell(++currentNum).setCellValue(vo.getFinishTimeStr());
                    row.createCell(++currentNum).setCellValue(vo.getLastTimeStr());
                    row.createCell(++currentNum).setCellValue(vo.getStudyTimeStr());
                    row.createCell(++currentNum).setCellValue(vo.getStudyPercent());
                    row.createCell(++currentNum).setCellValue(vo.getStudyStatusStr());
                    sheet.autoSizeColumn(i + 1);
                }
                try {
                    DownloadUtils.successExportTask((Workbook)wb, exportTaskPojo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DownloadUtils.errorExportTask(exportTaskPojo);
                }
            }
        });
        taskList.add(exportTaskPojo);
        return JsonResult.success(taskList);
    }

    @Override
    public String getPaperDetailExcel(final Integer userId, final Integer status, final Integer groupId, final Integer trainingId, final Integer paperId, final String nameOrNumber, final String excelStr, final Integer exportStatus) {
        final Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        PaperDetailExcelVo excelVo = new PaperDetailExcelVo();
        excelVo.setUserId(userId);
        excelVo.setStatus(status);
        excelVo.setGroupId(groupId);
        excelVo.setTrainingId(trainingId);
        excelVo.setPaperId(paperId);
        excelVo.setNameOrNumber(nameOrNumber);
        excelVo.setExcelStr(excelStr);
        excelVo.setExportStatus(exportStatus);
        String fileName = MessageFormat.format("{0}_{1}.xlsx", this.messageSource.getMessage("training.paper.new.training", null, locale), DateUtils.format((Date)new Date(), (String)"yyyyMMdd_HHmmss"));
        ArrayList<ExportTaskPojo> taskList = new ArrayList<ExportTaskPojo>();
        final ExportTaskPojo exportTaskPojo = DownloadUtils.saveExportTask(fileName, JSON.toJSONString((Object)excelVo), 11);
        ThreadPoolUtil.getThreadPoolExecutor().execute(new Runnable(){

            @Override
            public void run() {
                List<TrainingLearnerPaperDetailVo> list = TrainingAnalysisServiceImpl.this.trainingApi.getPaperDetailExcelList(userId, status, groupId, trainingId, paperId, nameOrNumber, excelStr, exportStatus);
                Object[] str = new String[10];
                if (org.springframework.util.StringUtils.isEmpty((Object)excelStr)) {
                    Arrays.fill(str, "0");
                } else {
                    str = excelStr.split(",");
                }
                ArrayList<Integer> userIdList = new ArrayList();
                String userStr = "";
                if (!CollectionUtils.isEmpty(list) && !CollectionUtils.isEmpty(userIdList = list.stream().map(TrainingLearnerPaperDetailVo::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                    userStr = StringUtils.join(userIdList, (String)",");
                }
                XSSFWorkbook wb = new XSSFWorkbook();
                XSSFSheet sheet = wb.createSheet(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.material.student.details", null, locale));
                XSSFCellStyle titleSty = wb.createCellStyle();
                titleSty.setWrapText(true);
                XSSFRow row = sheet.createRow(0);
                sheet.setColumnWidth(0, 3000);
                int currentNum = -1;
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[0]) && ((String)str[0]).equals("1")) {
                    row.createCell(++currentNum).setCellValue("id");
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[1]) && ((String)str[1]).equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.job.account.number", null, locale));
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[2]) && ((String)str[2]).equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.trainee.name", null, locale));
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[3]) && ((String)str[3]).equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.analysis.jobnumber", null, locale));
                }
                Map roleMap = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[4]) && ((String)str[4]).equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.analysis.role", null, locale));
                    if (!org.springframework.util.StringUtils.isEmpty((Object)userStr)) {
                        HashMap<String, Object> parameter = new HashMap<String, Object>();
                        parameter.put("userIds", userStr);
                        parameter.put("groupId", groupId);
                        BaseResult base = TrainingAnalysisServiceImpl.this.roleApi.getUserRoleList(parameter);
                        if (base != null) {
                            roleMap = (Map)base.getData();
                        }
                    }
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[5]) && ((String)str[5]).equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.job.post.name", null, locale));
                }
                Map<Object, Object> parentMap = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[6]) && ((String)str[6]).equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.analysis.superior", null, locale));
                    parentMap = TrainingAnalysisServiceImpl.this.userUtilService.selectParentMap(userIdList, groupId);
                }
                Map<Object, Object> organizeMap = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[7]) && ((String)str[7]).equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.learn.department", null, locale));
                    organizeMap = TrainingAnalysisServiceImpl.this.userUtilService.selectOrganizeMap(userIdList, groupId);
                }
                Map organMap1 = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[8]) && ((String)str[8]).equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.analysis.first.organize", null, locale));
                    if (!CollectionUtils.isEmpty(userIdList)) {
                        UsersAndOrgsMo mo = new UsersAndOrgsMo();
                        mo.setGroupId(groupId);
                        mo.setLevelList(Collections.singletonList(1));
                        mo.setUserIdList(userIdList);
                        mo.setShowDepartment(Boolean.valueOf(false));
                        com.ovopark.organize.common.base.BaseResult base = TrainingAnalysisServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                        if (base != null) {
                            organMap1 = (Map)base.getData();
                        }
                    }
                }
                Map organMap2 = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[9]) && ((String)str[9]).equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.analysis.second.organize", null, locale));
                    if (!CollectionUtils.isEmpty(userIdList)) {
                        UsersAndOrgsMo mo = new UsersAndOrgsMo();
                        mo.setGroupId(groupId);
                        mo.setLevelList(Collections.singletonList(2));
                        mo.setUserIdList(userIdList);
                        mo.setShowDepartment(Boolean.valueOf(false));
                        com.ovopark.organize.common.base.BaseResult base = TrainingAnalysisServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                        if (base != null) {
                            organMap2 = (Map)base.getData();
                        }
                    }
                }
                Map organMap3 = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[10]) && ((String)str[10]).equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.analysis.third.organize", null, locale));
                    if (!CollectionUtils.isEmpty(userIdList)) {
                        UsersAndOrgsMo mo = new UsersAndOrgsMo();
                        mo.setGroupId(groupId);
                        mo.setLevelList(Collections.singletonList(3));
                        mo.setUserIdList(userIdList);
                        mo.setShowDepartment(Boolean.valueOf(false));
                        com.ovopark.organize.common.base.BaseResult base = TrainingAnalysisServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                        if (base != null) {
                            organMap3 = (Map)base.getData();
                        }
                    }
                }
                Map organMap4 = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[11]) && ((String)str[11]).equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.analysis.fourth.organize", null, locale));
                    if (!CollectionUtils.isEmpty(userIdList)) {
                        UsersAndOrgsMo mo = new UsersAndOrgsMo();
                        mo.setGroupId(groupId);
                        mo.setLevelList(Collections.singletonList(4));
                        mo.setUserIdList(userIdList);
                        mo.setShowDepartment(Boolean.valueOf(false));
                        com.ovopark.organize.common.base.BaseResult base = TrainingAnalysisServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                        if (base != null) {
                            organMap4 = (Map)base.getData();
                        }
                    }
                }
                Map organMap5 = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[12]) && ((String)str[12]).equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.analysis.fifth.organize", null, locale));
                    if (!CollectionUtils.isEmpty(userIdList)) {
                        UsersAndOrgsMo mo = new UsersAndOrgsMo();
                        mo.setGroupId(groupId);
                        mo.setLevelList(Collections.singletonList(5));
                        mo.setUserIdList(userIdList);
                        mo.setShowDepartment(Boolean.valueOf(false));
                        com.ovopark.organize.common.base.BaseResult base = TrainingAnalysisServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                        if (base != null) {
                            organMap5 = (Map)base.getData();
                        }
                    }
                }
                Map shopMap = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[13]) && ((String)str[13]).equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.analysis.dep", null, locale));
                    if (!CollectionUtils.isEmpty(userIdList)) {
                        UsersAndOrgsMo mo = new UsersAndOrgsMo();
                        mo.setGroupId(groupId);
                        mo.setUserIdList(userIdList);
                        mo.setShowDepartment(Boolean.valueOf(true));
                        com.ovopark.organize.common.base.BaseResult base = TrainingAnalysisServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                        if (base != null) {
                            shopMap = (Map)base.getData();
                        }
                    }
                }
                if (exportStatus == null || exportStatus == 1) {
                    row.createCell(++currentNum).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.paper.finish.time", null, locale));
                    row.createCell(++currentNum).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.paper.num", null, locale));
                    row.createCell(++currentNum).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.paper.time", null, locale));
                    row.createCell(++currentNum).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.paper.score", null, locale));
                    row.createCell(++currentNum).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.paper.status", null, locale));
                } else if (exportStatus == 2) {
                    row.createCell(++currentNum).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.paper.handtime", null, locale));
                    row.createCell(++currentNum).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.operate.usetime", null, locale));
                    row.createCell(++currentNum).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.paper.score", null, locale));
                    row.createCell(++currentNum).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.paper.status", null, locale));
                }
                for (int i = 0; i < list.size(); ++i) {
                    List pojoList;
                    currentNum = -1;
                    row = sheet.createRow(i + 1);
                    TrainingLearnerPaperDetailVo vo = list.get(i);
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[0]) && ((String)str[0]).equals("1")) {
                        row.createCell(++currentNum).setCellValue((double)vo.getUserId().intValue());
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[1]) && ((String)str[1]).equals("1")) {
                        row.createCell(++currentNum).setCellValue(vo.getUserName());
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[2]) && ((String)str[2]).equals("1")) {
                        row.createCell(++currentNum).setCellValue(vo.getShowName());
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[3]) && ((String)str[3]).equals("1")) {
                        row.createCell(++currentNum).setCellValue(TrainingAnalysisServiceImpl.this.userUtilService.selectUser(vo.getUserId()).getEmployeeNumber());
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[4]) && ((String)str[4]).equals("1")) {
                        String roleName = "";
                        pojoList = (List)roleMap.get(vo.getUserId());
                        if (!CollectionUtils.isEmpty((Collection)pojoList)) {
                            List listStr = pojoList.stream().map(RolePojo::getRoleName).filter(Objects::nonNull).collect(Collectors.toList());
                            roleName = StringUtils.join(listStr, (String)",");
                        }
                        row.createCell(++currentNum).setCellValue(roleName);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[5]) && ((String)str[5]).equals("1")) {
                        row.createCell(++currentNum).setCellValue(vo.getPost());
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[6]) && ((String)str[6]).equals("1")) {
                        row.createCell(++currentNum).setCellValue((String)parentMap.get(vo.getUserId()));
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[7]) && ((String)str[7]).equals("1")) {
                        String departName = "";
                        List nameList = (List)organizeMap.get(vo.getUserId());
                        if (!CollectionUtils.isEmpty((Collection)nameList)) {
                            departName = String.join((CharSequence)";\n", nameList);
                        }
                        XSSFCell cell = row.createCell(++currentNum);
                        cell.setCellValue(departName);
                        cell.setCellStyle((CellStyle)titleSty);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[8]) && ((String)str[8]).equals("1")) {
                        String organName1 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap1) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)organMap1.get(vo.getUserId())))) {
                            pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                            organName1 = StringUtils.join((Collection)pojoList, (String)",");
                        }
                        row.createCell(++currentNum).setCellValue(organName1);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[9]) && ((String)str[9]).equals("1")) {
                        String organName2 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap2) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)organMap2.get(vo.getUserId())))) {
                            pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                            organName2 = StringUtils.join((Collection)pojoList, (String)",");
                        }
                        row.createCell(++currentNum).setCellValue(organName2);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[10]) && ((String)str[10]).equals("1")) {
                        String organName3 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap3) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)organMap3.get(vo.getUserId())))) {
                            pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                            organName3 = StringUtils.join((Collection)pojoList, (String)",");
                        }
                        row.createCell(++currentNum).setCellValue(organName3);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[11]) && ((String)str[11]).equals("1")) {
                        String organName4 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap4) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)organMap4.get(vo.getUserId())))) {
                            pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                            organName4 = StringUtils.join((Collection)pojoList, (String)",");
                        }
                        row.createCell(++currentNum).setCellValue(organName4);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[12]) && ((String)str[12]).equals("1")) {
                        String organName5 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap5) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)organMap5.get(vo.getUserId())))) {
                            pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                            organName5 = StringUtils.join(pojoList, (String)",");
                        }
                        row.createCell(++currentNum).setCellValue(organName5);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[13]) && ((String)str[13]).equals("1")) {
                        String shopName = "";
                        if (!org.springframework.util.StringUtils.isEmpty(shopMap) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)shopMap.get(vo.getUserId())))) {
                            pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                            shopName = StringUtils.join(pojoList, (String)",");
                        }
                        row.createCell(++currentNum).setCellValue(shopName);
                    }
                    if (exportStatus == null || exportStatus == 1) {
                        row.createCell(++currentNum).setCellValue(vo.getPaperTimeStr());
                        row.createCell(++currentNum).setCellValue((double)vo.getPaperNum().intValue());
                        row.createCell(++currentNum).setCellValue(vo.getAverageTime());
                        ++currentNum;
                        if (vo.getScore() != null) {
                            row.createCell(currentNum).setCellValue(vo.getScore().equals(-1.0) ? "-" : vo.getScore().toString());
                        }
                        row.createCell(++currentNum).setCellValue(vo.getStatusStr());
                    } else if (exportStatus == 2) {
                        row.createCell(++currentNum).setCellValue(vo.getPaperTimeStr());
                        row.createCell(++currentNum).setCellValue(vo.getAverageTime());
                        ++currentNum;
                        if (vo.getScore() != null) {
                            row.createCell(currentNum).setCellValue(vo.getScore().equals(-1.0) ? "-" : vo.getScore().toString());
                        }
                        row.createCell(++currentNum).setCellValue(vo.getStatusStr());
                    }
                    sheet.autoSizeColumn(i + 1);
                }
                try {
                    DownloadUtils.successExportTask((Workbook)wb, exportTaskPojo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DownloadUtils.errorExportTask(exportTaskPojo);
                }
            }
        });
        taskList.add(exportTaskPojo);
        return JsonResult.success(taskList);
    }

    @Override
    public String getLearnerExcel(final Integer userId, final Integer status, final Integer trainingId, final Integer groupId, final String organizeIds, final String depIds, final String nameOrNumber, final String excelStr) {
        final Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        LearnerExcelVo excelVo = new LearnerExcelVo();
        excelVo.setUserId(userId);
        excelVo.setStatus(status);
        excelVo.setTrainingId(trainingId);
        excelVo.setGroupId(groupId);
        excelVo.setOrganizeIds(organizeIds);
        excelVo.setDepIds(depIds);
        excelVo.setNameOrNumber(nameOrNumber);
        excelVo.setExcelStr(excelStr);
        Training training = this.trainingApi.getTrainingById(trainingId);
        String inexistence = this.messageSource.getMessage("training.course.inexistence", null, locale);
        Assert.notNull((Object)training, (String)inexistence);
        final String studentAnalysis = this.messageSource.getMessage("training.course.student.analysis", null, locale);
        String fileName = MessageFormat.format("{0}_{1}_{2}", training.getTitle(), studentAnalysis, DateUtils.format((Date)new Date(), (String)"yyyyMMdd_HHmmss"));
        fileName = ExcelUtil.getFileName(fileName) + ".xlsx";
        ArrayList<ExportTaskPojo> taskList = new ArrayList<ExportTaskPojo>();
        final ExportTaskPojo exportTaskPojo = DownloadUtils.saveExportTask(fileName, JSON.toJSONString((Object)excelVo), 20);
        ThreadPoolUtil.getThreadPoolExecutor().execute(new Runnable(){

            @Override
            public void run() {
                String superior;
                List<TrainingLearnerAnalysisVo> list = TrainingAnalysisServiceImpl.this.trainingApi.getLearnerExcelList(userId, groupId, status, trainingId, excelStr, organizeIds, depIds, nameOrNumber, locale);
                String[] str = excelStr.split(",");
                List<Object> userIdList = new ArrayList();
                String userStr = "";
                if (!CollectionUtils.isEmpty(list)) {
                    Map<Object, Object> parentMap = new HashMap();
                    Map<Object, Object> usersPojoMap = new HashMap();
                    Map<Object, Object> organizeMap = new HashMap();
                    userIdList = list.stream().map(TrainingLearnerAnalysisVo::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(userIdList)) {
                        userStr = StringUtils.join(userIdList, (String)",");
                        parentMap = TrainingAnalysisServiceImpl.this.userUtilService.selectParentMap(userIdList, groupId);
                        usersPojoMap = TrainingAnalysisServiceImpl.this.userUtilService.selectUserMap(userIdList);
                        organizeMap = TrainingAnalysisServiceImpl.this.userUtilService.selectOrganizeMap(userIdList, groupId);
                    }
                    for (TrainingLearnerAnalysisVo analysisVo : list) {
                        UsersPojo usersPojo = (UsersPojo)usersPojoMap.get(analysisVo.getUserId());
                        if (Objects.nonNull(usersPojo)) {
                            analysisVo.setShowName(usersPojo.getShowName());
                            analysisVo.setUserName(usersPojo.getUserName());
                            if (!org.springframework.util.StringUtils.isEmpty((Object)usersPojo.getEmployeeNumber())) {
                                analysisVo.setJobNumber(usersPojo.getEmployeeNumber());
                            }
                        }
                        analysisVo.setParentName((String)parentMap.get(analysisVo.getUserId()));
                        List nameList = (List)organizeMap.get(analysisVo.getUserId());
                        if (CollectionUtils.isEmpty((Collection)nameList)) continue;
                        analysisVo.setOrganizeName(String.join((CharSequence)";", nameList));
                    }
                }
                XSSFWorkbook wb = new XSSFWorkbook();
                XSSFSheet sheet = wb.createSheet(studentAnalysis);
                XSSFCellStyle titleSty = wb.createCellStyle();
                XSSFDataFormat dataFormat = wb.createDataFormat();
                titleSty.setDataFormat(dataFormat.getFormat("@"));
                sheet.setDefaultColumnStyle(0, (CellStyle)titleSty);
                sheet.setColumnWidth(0, 3000);
                XSSFRow row = sheet.createRow(0);
                row.createCell(0).setCellValue("id");
                int currentNum = 0;
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[1]) && str[1].equals("1")) {
                    String userName = TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.job.account.number", null, locale);
                    row.createCell(++currentNum).setCellValue(userName);
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[2]) && str[2].equals("1")) {
                    String showName = TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.trainee.name", null, locale);
                    row.createCell(++currentNum).setCellValue(showName);
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[3]) && str[3].equals("1")) {
                    String jobnumber = TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.analysis.jobnumber", null, locale);
                    row.createCell(++currentNum).setCellValue(jobnumber);
                }
                Map roleMap = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[4]) && str[4].equals("1")) {
                    String role = TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.analysis.role", null, locale);
                    row.createCell(++currentNum).setCellValue(role);
                    if (!org.springframework.util.StringUtils.isEmpty((Object)userStr)) {
                        HashMap<String, Object> parameter = new HashMap<String, Object>();
                        parameter.put("userIds", userStr);
                        parameter.put("groupId", groupId);
                        BaseResult base = TrainingAnalysisServiceImpl.this.roleApi.getUserRoleList(parameter);
                        if (base != null) {
                            roleMap = (Map)base.getData();
                        }
                    }
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[5]) && str[5].equals("1")) {
                    superior = TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.job.post.name", null, locale);
                    row.createCell(++currentNum).setCellValue(superior);
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[6]) && str[6].equals("1")) {
                    superior = TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.analysis.superior", null, locale);
                    row.createCell(++currentNum).setCellValue(superior);
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[7]) && str[7].equals("1")) {
                    String department = TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.learn.department", null, locale);
                    row.createCell(++currentNum).setCellValue(department);
                }
                Map organMap1 = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[8]) && str[8].equals("1")) {
                    String firstOrganize = TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.analysis.first.organize", null, locale);
                    row.createCell(++currentNum).setCellValue(firstOrganize);
                    if (!CollectionUtils.isEmpty(userIdList)) {
                        UsersAndOrgsMo mo = new UsersAndOrgsMo();
                        mo.setGroupId(groupId);
                        mo.setLevelList(Collections.singletonList(1));
                        mo.setUserIdList(userIdList);
                        mo.setShowDepartment(Boolean.valueOf(false));
                        com.ovopark.organize.common.base.BaseResult base = TrainingAnalysisServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                        if (base != null) {
                            organMap1 = (Map)base.getData();
                        }
                    }
                }
                Map organMap2 = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[9]) && str[9].equals("1")) {
                    String secondOrganize = TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.analysis.second.organize", null, locale);
                    row.createCell(++currentNum).setCellValue(secondOrganize);
                    if (!CollectionUtils.isEmpty(userIdList)) {
                        UsersAndOrgsMo mo = new UsersAndOrgsMo();
                        mo.setGroupId(groupId);
                        mo.setLevelList(Collections.singletonList(2));
                        mo.setUserIdList(userIdList);
                        mo.setShowDepartment(Boolean.valueOf(false));
                        com.ovopark.organize.common.base.BaseResult base = TrainingAnalysisServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                        if (base != null) {
                            organMap2 = (Map)base.getData();
                        }
                    }
                }
                Map organMap3 = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[10]) && str[10].equals("1")) {
                    String thirdOrganize = TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.analysis.third.organize", null, locale);
                    row.createCell(++currentNum).setCellValue(thirdOrganize);
                    if (!CollectionUtils.isEmpty(userIdList)) {
                        UsersAndOrgsMo mo = new UsersAndOrgsMo();
                        mo.setGroupId(groupId);
                        mo.setLevelList(Collections.singletonList(3));
                        mo.setUserIdList(userIdList);
                        mo.setShowDepartment(Boolean.valueOf(false));
                        com.ovopark.organize.common.base.BaseResult base = TrainingAnalysisServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                        if (base != null) {
                            organMap3 = (Map)base.getData();
                        }
                    }
                }
                Map organMap4 = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[11]) && str[11].equals("1")) {
                    String fourthOrganize = TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.analysis.fourth.organize", null, locale);
                    row.createCell(++currentNum).setCellValue(fourthOrganize);
                    if (!CollectionUtils.isEmpty(userIdList)) {
                        UsersAndOrgsMo mo = new UsersAndOrgsMo();
                        mo.setGroupId(groupId);
                        mo.setLevelList(Collections.singletonList(4));
                        mo.setUserIdList(userIdList);
                        mo.setShowDepartment(Boolean.valueOf(false));
                        com.ovopark.organize.common.base.BaseResult base = TrainingAnalysisServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                        if (base != null) {
                            organMap4 = (Map)base.getData();
                        }
                    }
                }
                Map organMap5 = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[12]) && str[12].equals("1")) {
                    String fifthOrganize = TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.analysis.fifth.organize", null, locale);
                    row.createCell(++currentNum).setCellValue(fifthOrganize);
                    if (!CollectionUtils.isEmpty(userIdList)) {
                        UsersAndOrgsMo mo = new UsersAndOrgsMo();
                        mo.setGroupId(groupId);
                        mo.setLevelList(Collections.singletonList(5));
                        mo.setUserIdList(userIdList);
                        mo.setShowDepartment(Boolean.valueOf(false));
                        com.ovopark.organize.common.base.BaseResult base = TrainingAnalysisServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                        if (base != null) {
                            organMap5 = (Map)base.getData();
                        }
                    }
                }
                Map shopMap = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[13]) && str[13].equals("1")) {
                    String analysisDep = TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.analysis.dep", null, locale);
                    row.createCell(++currentNum).setCellValue(analysisDep);
                    if (!CollectionUtils.isEmpty(userIdList)) {
                        UsersAndOrgsMo mo = new UsersAndOrgsMo();
                        mo.setGroupId(groupId);
                        mo.setUserIdList(userIdList);
                        mo.setShowDepartment(Boolean.valueOf(true));
                        com.ovopark.organize.common.base.BaseResult base = TrainingAnalysisServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                        if (base != null) {
                            shopMap = (Map)base.getData();
                        }
                    }
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[14]) && str[14].equals("1")) {
                    String startTime = TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.analysis.starttime", null, locale);
                    row.createCell(++currentNum).setCellValue(startTime);
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[15]) && str[15].equals("1")) {
                    String endtime = TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.analysis.endtime", null, locale);
                    row.createCell(++currentNum).setCellValue(endtime);
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[16]) && str[16].equals("1")) {
                    String lastStudyTime = TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.analysis.last.studytime", null, locale);
                    row.createCell(++currentNum).setCellValue(lastStudyTime);
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[17]) && str[17].equals("1")) {
                    String studyTime = TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.analysis.study.time", null, locale);
                    row.createCell(++currentNum).setCellValue(studyTime);
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[18]) && str[18].equals("1")) {
                    String studyProcess = TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.analysis.study.progress", null, locale);
                    row.createCell(++currentNum).setCellValue(studyProcess);
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[19]) && str[19].equals("1")) {
                    String studyStatus = TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.analysis.study.status", null, locale);
                    row.createCell(++currentNum).setCellValue(studyStatus);
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[20]) && str[20].equals("1")) {
                    String examNum = TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.analysis.exam.num", null, locale);
                    row.createCell(++currentNum).setCellValue(examNum);
                }
                for (int i = 0; i < list.size(); ++i) {
                    List pojoList;
                    currentNum = 0;
                    row = sheet.createRow(i + 1);
                    TrainingLearnerAnalysisVo vo = list.get(i);
                    row.createCell(0).setCellValue((double)vo.getUserId().intValue());
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[1]) && str[1].equals("1")) {
                        row.createCell(++currentNum).setCellValue(vo.getUserName());
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[2]) && str[2].equals("1")) {
                        row.createCell(++currentNum).setCellValue(vo.getShowName());
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[3]) && str[3].equals("1")) {
                        row.createCell(++currentNum).setCellValue(vo.getJobNumber());
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[4]) && str[4].equals("1")) {
                        String roleName = "";
                        if (!org.springframework.util.StringUtils.isEmpty(roleMap) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)roleMap.get(vo.getUserId())))) {
                            List listStr = pojoList.stream().map(RolePojo::getRoleName).filter(Objects::nonNull).collect(Collectors.toList());
                            roleName = StringUtils.join(listStr, (String)";\n");
                        }
                        row.createCell(++currentNum).setCellValue(roleName);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[5]) && str[5].equals("1")) {
                        row.createCell(++currentNum).setCellValue(vo.getPost());
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[6]) && str[6].equals("1")) {
                        row.createCell(++currentNum).setCellValue(vo.getParentName());
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[7]) && str[7].equals("1")) {
                        row.createCell(++currentNum).setCellValue(vo.getOrganizeName());
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[8]) && str[8].equals("1")) {
                        String organName1 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap1) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)organMap1.get(vo.getUserId())))) {
                            pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                            organName1 = StringUtils.join((Collection)pojoList, (String)";\n");
                        }
                        row.createCell(++currentNum).setCellValue(organName1);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[9]) && str[9].equals("1")) {
                        String organName2 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap2) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)organMap2.get(vo.getUserId())))) {
                            pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                            organName2 = StringUtils.join((Collection)pojoList, (String)";\n");
                        }
                        row.createCell(++currentNum).setCellValue(organName2);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[10]) && str[10].equals("1")) {
                        String organName3 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap3) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)organMap3.get(vo.getUserId())))) {
                            pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                            organName3 = StringUtils.join((Collection)pojoList, (String)";\n");
                        }
                        row.createCell(++currentNum).setCellValue(organName3);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[11]) && str[11].equals("1")) {
                        String organName4 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap4) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)organMap4.get(vo.getUserId())))) {
                            pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                            organName4 = StringUtils.join((Collection)pojoList, (String)";\n");
                        }
                        row.createCell(++currentNum).setCellValue(organName4);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[12]) && str[12].equals("1")) {
                        String organName5 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap5) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)organMap5.get(vo.getUserId())))) {
                            pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                            organName5 = StringUtils.join(pojoList, (String)";\n");
                        }
                        row.createCell(++currentNum).setCellValue(organName5);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[13]) && str[13].equals("1")) {
                        String shopName = "";
                        if (!org.springframework.util.StringUtils.isEmpty(shopMap) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)shopMap.get(vo.getUserId())))) {
                            pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                            shopName = StringUtils.join(pojoList, (String)";\n");
                        }
                        row.createCell(++currentNum).setCellValue(shopName);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[14]) && str[14].equals("1")) {
                        row.createCell(++currentNum).setCellValue(vo.getStartTimeStr());
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[15]) && str[15].equals("1")) {
                        row.createCell(++currentNum).setCellValue(vo.getFinishTimeStr());
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[16]) && str[16].equals("1")) {
                        row.createCell(++currentNum).setCellValue(vo.getLastTimeStr());
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[17]) && str[17].equals("1")) {
                        row.createCell(++currentNum).setCellValue(vo.getStudyTimeStr());
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[18]) && str[18].equals("1")) {
                        row.createCell(++currentNum).setCellValue(vo.getStudyPercent());
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[19]) && str[19].equals("1")) {
                        row.createCell(++currentNum).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage(vo.getStudyStatusStr(), null, locale));
                    }
                    if (org.springframework.util.StringUtils.isEmpty((Object)str[20]) || !str[20].equals("1")) continue;
                    row.createCell(++currentNum).setCellValue(vo.getPaperStatus());
                }
                try {
                    DownloadUtils.successExportTask((Workbook)wb, exportTaskPojo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DownloadUtils.errorExportTask(exportTaskPojo);
                }
            }
        });
        taskList.add(exportTaskPojo);
        return JsonResult.success(taskList);
    }

    @Override
    public String getDeptAnalysisExcel(Integer trainingId, Integer enterpriseId, Integer id, Integer parentId, Integer organizeLevel, String organizeIds) {
        return null;
    }

    @Override
    public String getCertificateDetailByExecl(final String userId, final String userName, final Integer status, final Integer certificateId, final Users users) {
        final Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        JSONObject param = new JSONObject();
        param.fluentPut("userId", (Object)userId).fluentPut("userName", (Object)userName).fluentPut("status", (Object)status).fluentPut("certificateId", (Object)certificateId).fluentPut("users", (Object)users);
        String fileName = MessageFormat.format("{0}_{1}.xlsx", this.messageSource.getMessage("training.honor.certificate.details", null, locale), DateUtils.format((Date)new Date(), (String)"yyyyMMdd"));
        final String details = this.messageSource.getMessage("training.certificate.detail", null, locale);
        ArrayList<ExportTaskPojo> taskList = new ArrayList<ExportTaskPojo>();
        final ExportTaskPojo exportTaskPojo = DownloadUtils.saveExportTask(fileName, param.toJSONString(), 21);
        ThreadPoolUtil.getThreadPoolExecutor().execute(new Runnable(){

            @Override
            public void run() {
                List userIds = null;
                if (!org.springframework.util.StringUtils.isEmpty((Object)userId)) {
                    String[] str = userId.split(",");
                    List<String> s = Arrays.asList(str);
                    userIds = s.stream().map(Integer::parseInt).collect(Collectors.toList());
                }
                List<TrainingCertificateDetailVo> list = TrainingAnalysisServiceImpl.this.trainingApi.getCertificateDetailList(users.getGroupId(), userIds, userName, status, certificateId);
                XSSFWorkbook wb = new XSSFWorkbook();
                XSSFSheet sheet = wb.createSheet(details);
                XSSFCellStyle titleSty = wb.createCellStyle();
                XSSFFont font = wb.createFont();
                font.setFontHeightInPoints((short)16);
                titleSty.setFont((Font)font);
                XSSFRow row = sheet.createRow(0);
                row.createCell(0).setCellValue("id");
                row.createCell(1).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.certificate.holder", null, locale));
                row.createCell(2).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.user.details.employeeNumber", null, locale));
                row.createCell(3).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.analysis.role", null, locale));
                row.createCell(4).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.job.post.name", null, locale));
                row.createCell(5).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.analysis.superior", null, locale));
                row.createCell(6).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.analysis.department", null, locale));
                row.createCell(7).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.certificate.number", null, locale));
                row.createCell(8).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.shift.orgin", null, locale));
                row.createCell(9).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.job.excel.task.name", null, locale));
                row.createCell(10).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.certificate.issuer", null, locale));
                row.createCell(11).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.certificate.issue.time", null, locale));
                row.createCell(12).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.certificate.validity", null, locale));
                row.createCell(13).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.paper.status", null, locale));
                SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd");
                for (int i = 0; i < list.size(); ++i) {
                    row = sheet.createRow(i + 1);
                    TrainingCertificateDetailVo vo = list.get(i);
                    row.createCell(0).setCellValue((double)vo.getId().intValue());
                    row.createCell(1).setCellValue(vo.getUserName());
                    row.createCell(2).setCellValue(vo.getEmployeeNumber());
                    row.createCell(3).setCellValue(vo.getRole());
                    row.createCell(4).setCellValue(vo.getPost());
                    row.createCell(5).setCellValue(vo.getParentName());
                    row.createCell(6).setCellValue(vo.getOrganizeName());
                    row.createCell(7).setCellValue(vo.getCertificateNumber());
                    String originName = "";
                    if (vo.getOrigin() == 1) {
                        originName = TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.certificate.auto", null, locale);
                    } else if (vo.getOrigin() == 2) {
                        originName = "\u624b\u52a8";
                    } else if (vo.getOrigin() == 3) {
                        originName = TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.learn.title", null, locale);
                    } else if (vo.getOrigin() == 4) {
                        originName = TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.job.job.name", null, locale);
                    } else if (vo.getOrigin() == 5) {
                        originName = TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.job.course.name", null, locale);
                    }
                    row.createCell(8).setCellValue(originName);
                    row.createCell(9).setCellValue(vo.getTaskName());
                    row.createCell(10).setCellValue(vo.getCreateName());
                    row.createCell(11).setCellValue(format.format(vo.getCreateTime()));
                    String validity = "";
                    if (vo.getIsAlways() == 1) {
                        validity = TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.certificate.perpetual", null, locale);
                    } else {
                        Calendar cal = Calendar.getInstance();
                        cal.setTime(vo.getCreateTime());
                        cal.add(2, vo.getValidity());
                        validity = format.format(cal.getTime());
                    }
                    row.createCell(12).setCellValue(validity);
                    String statusName = "";
                    if (vo.getStatus() == 1) {
                        statusName = TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.certificate.effective", null, locale);
                    } else if (vo.getStatus() == 2) {
                        statusName = TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.certificate.expired", null, locale);
                    } else if (vo.getStatus() == 3) {
                        statusName = TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.certificate.recovered", null, locale);
                    }
                    row.createCell(13).setCellValue(statusName);
                }
                try {
                    DownloadUtils.successExportTask((Workbook)wb, exportTaskPojo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DownloadUtils.errorExportTask(exportTaskPojo);
                }
            }
        });
        taskList.add(exportTaskPojo);
        return JsonResult.success(taskList);
    }

    @Override
    public String selectUserExamByExecl(Integer paperId, Integer exportStatus, String userName, Integer status, Integer orderBy, Integer order, Integer userPaperType, Users user) {
        final Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        final PaperDetailExcelVo excelVo = new PaperDetailExcelVo();
        excelVo.setPaperId(paperId);
        excelVo.setExportStatus(exportStatus);
        excelVo.setUserName(userName);
        excelVo.setStatus(status);
        excelVo.setOrderBy(orderBy);
        excelVo.setOrder(order);
        excelVo.setUserPaperType(userPaperType);
        excelVo.setUsers(user);
        final TrainingPaper trainingPaper = this.trainingApi.trainingPaperSelectById(excelVo.getPaperId());
        final Integer groupId = trainingPaper.getEnterpriseId();
        String fileName = "";
        String fileName2 = "";
        if (excelVo.getExportStatus() == 1) {
            fileName = MessageFormat.format("{0}_{1}_{2}", trainingPaper.getTitle(), this.messageSource.getMessage("training.exam.student.score", null, locale), DateUtils.format((Date)new Date(), (String)"yyyyMMdd"));
            fileName2 = this.messageSource.getMessage("training.exam.student.score", null, locale);
        } else if (excelVo.getExportStatus() == 2) {
            fileName = MessageFormat.format("{0}_{1}_{2}", trainingPaper.getTitle(), this.messageSource.getMessage("training.exam.student.detail", null, locale), DateUtils.format((Date)new Date(), (String)"yyyyMMdd"));
            fileName2 = this.messageSource.getMessage("training.exam.student.detail", null, locale);
        }
        fileName = ExcelUtil.getFileName(fileName) + ".xlsx";
        ArrayList<ExportTaskPojo> taskList = new ArrayList<ExportTaskPojo>();
        final ExportTaskPojo exportTaskPojo = DownloadUtils.saveExportTask(fileName, JSON.toJSONString((Object)excelVo), 22);
        final String finalFileName = fileName2;
        ThreadPoolUtil.getThreadPoolExecutor().execute(new Runnable(){

            @Override
            public void run() {
                List pojoList;
                String shopName;
                List pojoList2;
                String organName5;
                List pojoList3;
                String organName4;
                List pojoList4;
                String organName3;
                List pojoList5;
                String organName2;
                List pojoList6;
                String organName1;
                String parentName;
                List listStr;
                List pojoList7;
                String roleName;
                PaperUserDetailVo vo;
                int i;
                XSSFWorkbook wb = new XSSFWorkbook();
                XSSFSheet sheet = wb.createSheet(finalFileName);
                XSSFCellStyle titleSty = wb.createCellStyle();
                XSSFFont font = wb.createFont();
                font.setFontHeightInPoints((short)16);
                titleSty.setFont((Font)font);
                XSSFRow row = sheet.createRow(0);
                String unPassName = TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.learn.unpass", null, locale);
                String passName = TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.learn.pass", null, locale);
                String waitRead = TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.learn.wait.read", null, locale);
                Map<Object, Object> roleMap = new HashMap();
                Map<Object, Object> organizeMap = new HashMap();
                Map<Object, Object> parentMap = new HashMap();
                Map organMap1 = new HashMap();
                Map organMap2 = new HashMap();
                Map organMap3 = new HashMap();
                Map organMap4 = new HashMap();
                Map organMap5 = new HashMap();
                Map shopMap = new HashMap();
                Map shopDetailMap = new HashMap();
                List<Object> list = new ArrayList();
                if (excelVo.getExportStatus() == 1) {
                    list = TrainingAnalysisServiceImpl.this.trainingApi.selectPaperUserDetailsByList(excelVo);
                } else if (excelVo.getExportStatus() == 2) {
                    list = TrainingAnalysisServiceImpl.this.trainingApi.selectPaperUserDetailsByList2(excelVo);
                }
                List<Integer> userIdList = new ArrayList<Integer>();
                if (!CollectionUtils.isEmpty(list)) {
                    userIdList = list.stream().filter(e -> e.getIsVisitor() == 0).map(PaperUserDetailVo::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                }
                SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                if (!CollectionUtils.isEmpty(userIdList)) {
                    organizeMap = TrainingAnalysisServiceImpl.this.userUtilService.selectOrganizeMap(userIdList, groupId);
                    roleMap = TrainingAnalysisServiceImpl.this.userUtilService.selectRolesByUsers(userIdList, groupId);
                    parentMap = TrainingAnalysisServiceImpl.this.userUtilService.selectParentMap(userIdList, groupId);
                    UsersAndOrgsMo mo = new UsersAndOrgsMo();
                    mo.setGroupId(groupId);
                    mo.setLevelList(Collections.singletonList(1));
                    mo.setUserIdList(userIdList);
                    mo.setShowDepartment(Boolean.valueOf(false));
                    com.ovopark.organize.common.base.BaseResult base1 = TrainingAnalysisServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                    if (base1 != null) {
                        organMap1 = (Map)base1.getData();
                    }
                    mo.setLevelList(Collections.singletonList(2));
                    com.ovopark.organize.common.base.BaseResult base2 = TrainingAnalysisServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                    if (base2 != null) {
                        organMap2 = (Map)base2.getData();
                    }
                    mo.setLevelList(Collections.singletonList(3));
                    com.ovopark.organize.common.base.BaseResult base3 = TrainingAnalysisServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                    if (base3 != null) {
                        organMap3 = (Map)base3.getData();
                    }
                    mo.setLevelList(Collections.singletonList(4));
                    com.ovopark.organize.common.base.BaseResult base4 = TrainingAnalysisServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                    if (base4 != null) {
                        organMap4 = (Map)base4.getData();
                    }
                    mo.setLevelList(Collections.singletonList(5));
                    com.ovopark.organize.common.base.BaseResult base5 = TrainingAnalysisServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                    if (base5 != null) {
                        organMap5 = (Map)base5.getData();
                    }
                    UsersAndOrgsMo mo1 = new UsersAndOrgsMo();
                    mo1.setGroupId(groupId);
                    mo1.setUserIdList(userIdList);
                    mo1.setShowDepartment(Boolean.valueOf(true));
                    com.ovopark.organize.common.base.BaseResult base = TrainingAnalysisServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo1);
                    if (base != null && base.getData() != null) {
                        shopMap = (Map)base.getData();
                    }
                    mo1.setShowAllPath(Boolean.valueOf(true));
                    com.ovopark.organize.common.base.BaseResult bases = TrainingAnalysisServiceImpl.this.userOrganizeApi.getUserOrganizePathtByUserIds(mo1);
                    if (bases != null && bases.getData() != null) {
                        shopDetailMap = (Map)bases.getData();
                    }
                }
                row.createCell(0).setCellValue("id");
                row.createCell(1).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.job.account.number", null, locale));
                row.createCell(2).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.user.details.name", null, locale));
                row.createCell(3).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.user.details.employeeNumber", null, locale));
                row.createCell(4).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.analysis.role", null, locale));
                row.createCell(5).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.job.post.name", null, locale));
                row.createCell(6).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.analysis.superior", null, locale));
                row.createCell(7).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.analysis.department", null, locale));
                row.createCell(8).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.analysis.first.organize", null, locale));
                row.createCell(9).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.analysis.second.organize", null, locale));
                row.createCell(10).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.analysis.third.organize", null, locale));
                row.createCell(11).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.analysis.fourth.organize", null, locale));
                row.createCell(12).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.analysis.fifth.organize", null, locale));
                row.createCell(13).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.analysis.dep", null, locale));
                for (i = 0; i < list.size(); ++i) {
                    row = sheet.createRow(i + 1);
                    vo = (PaperUserDetailVo)list.get(i);
                    row.createCell(0).setCellValue(String.valueOf(vo.getUserId()));
                    row.createCell(1).setCellValue(vo.getUserAccount());
                    row.createCell(2).setCellValue(vo.getUserName());
                    row.createCell(3).setCellValue(vo.getUserNumber());
                    roleName = "";
                    if (!org.springframework.util.StringUtils.isEmpty(roleMap) && !CollectionUtils.isEmpty((Collection)(pojoList7 = (List)roleMap.get(vo.getUserId())))) {
                        listStr = pojoList7.stream().map(RolePojo::getRoleName).filter(Objects::nonNull).collect(Collectors.toList());
                        roleName = StringUtils.join(listStr, (String)",");
                    }
                    row.createCell(4).setCellValue(roleName);
                    parentName = "";
                    if (!org.springframework.util.StringUtils.isEmpty(parentMap)) {
                        parentName = (String)parentMap.get(vo.getUserId());
                    }
                    row.createCell(5).setCellValue(vo.getPost());
                    row.createCell(6).setCellValue(parentName);
                    organName1 = "";
                    if (!CollectionUtils.isEmpty(organMap1) && !CollectionUtils.isEmpty((Collection)(pojoList6 = (List)organMap1.get(vo.getUserId())))) {
                        pojoList6 = pojoList6.stream().distinct().collect(Collectors.toList());
                        organName1 = StringUtils.join(pojoList6, (String)",");
                    }
                    row.createCell(7).setCellValue(vo.getDeptName());
                    row.createCell(8).setCellValue(organName1);
                    organName2 = "";
                    if (!CollectionUtils.isEmpty(organMap2) && !CollectionUtils.isEmpty((Collection)(pojoList5 = (List)organMap2.get(vo.getUserId())))) {
                        pojoList5 = pojoList5.stream().distinct().collect(Collectors.toList());
                        organName2 = StringUtils.join(pojoList5, (String)",");
                    }
                    row.createCell(9).setCellValue(organName2);
                    organName3 = "";
                    if (!CollectionUtils.isEmpty(organMap3) && !CollectionUtils.isEmpty((Collection)(pojoList4 = (List)organMap3.get(vo.getUserId())))) {
                        pojoList4 = pojoList4.stream().distinct().collect(Collectors.toList());
                        organName3 = StringUtils.join(pojoList4, (String)",");
                    }
                    row.createCell(10).setCellValue(organName3);
                    organName4 = "";
                    if (!CollectionUtils.isEmpty(organMap4) && !CollectionUtils.isEmpty((Collection)(pojoList3 = (List)organMap4.get(vo.getUserId())))) {
                        pojoList3 = pojoList3.stream().distinct().collect(Collectors.toList());
                        organName4 = StringUtils.join(pojoList3, (String)",");
                    }
                    row.createCell(11).setCellValue(organName4);
                    organName5 = "";
                    if (!CollectionUtils.isEmpty(organMap5) && !CollectionUtils.isEmpty((Collection)(pojoList2 = (List)organMap5.get(vo.getUserId())))) {
                        pojoList2 = pojoList2.stream().distinct().collect(Collectors.toList());
                        organName5 = StringUtils.join(pojoList2, (String)",");
                    }
                    row.createCell(12).setCellValue(organName5);
                    shopName = "";
                    if (!org.springframework.util.StringUtils.isEmpty(shopMap) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)shopMap.get(vo.getUserId())))) {
                        pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                        shopName = StringUtils.join(pojoList, (String)",");
                    }
                    row.createCell(13).setCellValue(shopName);
                }
                if (excelVo.getExportStatus() == 1) {
                    String fileName = MessageFormat.format("{0}_{1}_{2}", trainingPaper.getTitle(), TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.exam.student.score", null, locale), DateUtils.format((Date)new Date(), (String)"yyyyMMdd"));
                    fileName = ExcelUtil.getFileName(fileName) + ".xlsx";
                    row = sheet.getRow(0);
                    row.createCell(14).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.paper.finish.time", null, locale));
                    row.createCell(15).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.paper.num", null, locale));
                    row.createCell(16).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.course.average.time", null, locale));
                    row.createCell(17).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.paper.score", null, locale));
                    row.createCell(18).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.paper.status", null, locale));
                    for (int i2 = 0; i2 < list.size(); ++i2) {
                        List pojoList8;
                        List pojoList9;
                        List pojoList10;
                        List pojoList11;
                        row = sheet.getRow(i2 + 1);
                        PaperUserDetailVo vo2 = (PaperUserDetailVo)list.get(i2);
                        row.createCell(0).setCellValue(String.valueOf(vo2.getUserId()));
                        row.createCell(1).setCellValue(vo2.getUserAccount());
                        row.createCell(2).setCellValue(vo2.getUserName());
                        row.createCell(3).setCellValue(vo2.getUserNumber());
                        String roleName2 = "";
                        if (!CollectionUtils.isEmpty(roleMap) && !CollectionUtils.isEmpty((Collection)(pojoList11 = (List)roleMap.get(vo2.getUserId())))) {
                            List listStr2 = pojoList11.stream().map(RolePojo::getRoleName).filter(Objects::nonNull).collect(Collectors.toList());
                            roleName2 = StringUtils.join(listStr2, (String)",");
                        }
                        row.createCell(4).setCellValue(roleName2);
                        String parentName2 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(parentMap)) {
                            parentName2 = (String)parentMap.get(vo2.getUserId());
                        }
                        row.createCell(5).setCellValue(vo2.getPost());
                        row.createCell(6).setCellValue(parentName2);
                        String organName12 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap1) && !CollectionUtils.isEmpty((Collection)(pojoList5 = (List)organMap1.get(vo2.getUserId())))) {
                            pojoList5 = pojoList5.stream().distinct().collect(Collectors.toList());
                            organName12 = StringUtils.join(pojoList5, (String)",");
                        }
                        String departName = vo2.getDeptName();
                        List nameList = (List)organizeMap.get(vo2.getUserId());
                        if (!CollectionUtils.isEmpty((Collection)nameList)) {
                            departName = String.join((CharSequence)";\n", nameList);
                        }
                        row.createCell(7).setCellValue(departName);
                        row.createCell(8).setCellValue(organName12);
                        String organName22 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap2) && !CollectionUtils.isEmpty((Collection)(pojoList2 = (List)organMap2.get(vo2.getUserId())))) {
                            pojoList2 = pojoList2.stream().distinct().collect(Collectors.toList());
                            organName22 = StringUtils.join(pojoList2, (String)",");
                        }
                        row.createCell(9).setCellValue(organName22);
                        String organName32 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap3) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)organMap3.get(vo2.getUserId())))) {
                            pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                            organName32 = StringUtils.join(pojoList, (String)",");
                        }
                        row.createCell(10).setCellValue(organName32);
                        String organName42 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap4) && !CollectionUtils.isEmpty((Collection)(pojoList10 = (List)organMap4.get(vo2.getUserId())))) {
                            pojoList10 = pojoList10.stream().distinct().collect(Collectors.toList());
                            organName42 = StringUtils.join(pojoList10, (String)",");
                        }
                        row.createCell(11).setCellValue(organName42);
                        String organName52 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap5) && !CollectionUtils.isEmpty((Collection)(pojoList9 = (List)organMap5.get(vo2.getUserId())))) {
                            pojoList9 = pojoList9.stream().distinct().collect(Collectors.toList());
                            organName52 = StringUtils.join(pojoList9, (String)",");
                        }
                        row.createCell(12).setCellValue(organName52);
                        String shopName2 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(shopMap) && !CollectionUtils.isEmpty((Collection)(pojoList8 = (List)shopMap.get(vo2.getUserId())))) {
                            pojoList8 = pojoList8.stream().distinct().collect(Collectors.toList());
                            shopName2 = StringUtils.join(pojoList8, (String)",");
                        }
                        row.createCell(13).setCellValue(shopName2);
                        List shopDeatailPathList = (List)shopDetailMap.get(vo2.getUserId());
                        String shopPathName = "";
                        if (!CollectionUtils.isEmpty((Collection)shopDeatailPathList) && (shopPathName = String.join((CharSequence)";", shopDeatailPathList)).length() > 1000) {
                            shopPathName = shopPathName.substring(0, 1000);
                        }
                        row.createCell(14).setCellValue(Objects.nonNull(vo2.getFinishTime()) ? format.format(vo2.getFinishTime()) : "");
                        row.createCell(15).setCellValue(vo2.getPaperCount() == -1 ? "-" : String.valueOf(vo2.getPaperCount()));
                        row.createCell(16).setCellValue(vo2.getUseTime());
                        String statusName = "";
                        String score = "";
                        if (vo2.getStatus() == 1) {
                            String unexam;
                            statusName = unexam = TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.paper.unexam", null, locale);
                            score = "-";
                        } else if (vo2.getStatus() == 2) {
                            statusName = TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.paper.ing", null, locale);
                            score = "-";
                        } else if (vo2.getStatus() == 3) {
                            statusName = passName;
                            score = String.valueOf(vo2.getScore());
                        } else if (vo2.getStatus() == 4) {
                            statusName = unPassName;
                            score = String.valueOf(vo2.getScore());
                        } else if (vo2.getStatus() == 5) {
                            statusName = waitRead;
                            score = "-";
                        }
                        row.createCell(17).setCellValue(score);
                        row.createCell(18).setCellValue(statusName);
                    }
                } else if (excelVo.getExportStatus() == 2) {
                    row = sheet.getRow(0);
                    row.createCell(14).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.paper.handtime", null, locale));
                    row.createCell(15).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.operate.usetime", null, locale));
                    row.createCell(16).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.paper.score", null, locale));
                    row.createCell(17).setCellValue(TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.paper.status", null, locale));
                    for (i = 0; i < list.size(); ++i) {
                        row = sheet.getRow(i + 1);
                        vo = (PaperUserDetailVo)list.get(i);
                        row.createCell(0).setCellValue(String.valueOf(vo.getUserId()));
                        row.createCell(1).setCellValue(vo.getUserAccount());
                        row.createCell(2).setCellValue(vo.getUserName());
                        row.createCell(3).setCellValue(vo.getUserNumber());
                        roleName = "";
                        if (!org.springframework.util.StringUtils.isEmpty(roleMap) && !CollectionUtils.isEmpty((Collection)(pojoList7 = (List)roleMap.get(vo.getUserId())))) {
                            listStr = pojoList7.stream().map(RolePojo::getRoleName).filter(Objects::nonNull).collect(Collectors.toList());
                            roleName = StringUtils.join(listStr, (String)",");
                        }
                        row.createCell(4).setCellValue(roleName);
                        parentName = "";
                        if (!org.springframework.util.StringUtils.isEmpty(parentMap)) {
                            parentName = (String)parentMap.get(vo.getUserId());
                        }
                        row.createCell(5).setCellValue(vo.getPost());
                        row.createCell(6).setCellValue(parentName);
                        organName1 = "";
                        if (!CollectionUtils.isEmpty(organMap1) && !CollectionUtils.isEmpty((Collection)(pojoList6 = (List)organMap1.get(vo.getUserId())))) {
                            pojoList6 = pojoList6.stream().distinct().collect(Collectors.toList());
                            organName1 = StringUtils.join(pojoList6, (String)",");
                        }
                        row.createCell(7).setCellValue(vo.getDeptName());
                        row.createCell(8).setCellValue(organName1);
                        organName2 = "";
                        if (!CollectionUtils.isEmpty(organMap2) && !CollectionUtils.isEmpty((Collection)(pojoList5 = (List)organMap2.get(vo.getUserId())))) {
                            pojoList5 = pojoList5.stream().distinct().collect(Collectors.toList());
                            organName2 = StringUtils.join(pojoList5, (String)",");
                        }
                        row.createCell(9).setCellValue(organName2);
                        organName3 = "";
                        if (!CollectionUtils.isEmpty(organMap3) && !CollectionUtils.isEmpty((Collection)(pojoList4 = (List)organMap3.get(vo.getUserId())))) {
                            pojoList4 = pojoList4.stream().distinct().collect(Collectors.toList());
                            organName3 = StringUtils.join(pojoList4, (String)",");
                        }
                        row.createCell(10).setCellValue(organName3);
                        organName4 = "";
                        if (!CollectionUtils.isEmpty(organMap4) && !CollectionUtils.isEmpty((Collection)(pojoList3 = (List)organMap4.get(vo.getUserId())))) {
                            pojoList3 = pojoList3.stream().distinct().collect(Collectors.toList());
                            organName4 = StringUtils.join(pojoList3, (String)",");
                        }
                        row.createCell(11).setCellValue(organName4);
                        organName5 = "";
                        if (!CollectionUtils.isEmpty(organMap5) && !CollectionUtils.isEmpty((Collection)(pojoList2 = (List)organMap5.get(vo.getUserId())))) {
                            pojoList2 = pojoList2.stream().distinct().collect(Collectors.toList());
                            organName5 = StringUtils.join(pojoList2, (String)",");
                        }
                        row.createCell(12).setCellValue(organName5);
                        shopName = "";
                        if (!org.springframework.util.StringUtils.isEmpty(shopMap) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)shopMap.get(vo.getUserId())))) {
                            pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                            shopName = StringUtils.join(pojoList, (String)",");
                        }
                        row.createCell(13).setCellValue(shopName);
                        List shopDeatailPathList = (List)shopDetailMap.get(vo.getUserId());
                        String shopPathName = "";
                        if (!CollectionUtils.isEmpty((Collection)shopDeatailPathList) && (shopPathName = String.join((CharSequence)";", shopDeatailPathList)).length() > 1000) {
                            shopPathName = shopPathName.substring(0, 1000);
                        }
                        row.createCell(14).setCellValue(Objects.nonNull(vo.getFinishTime()) ? format.format(vo.getFinishTime()) : "");
                        row.createCell(15).setCellValue(vo.getUseTime());
                        String statusName = "";
                        String score = "";
                        if (vo.getStatus() == 1) {
                            String unexam;
                            statusName = unexam = TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.paper.unexam", null, locale);
                            score = "-";
                        } else if (vo.getStatus() == 2) {
                            statusName = TrainingAnalysisServiceImpl.this.messageSource.getMessage("training.paper.ing", null, locale);
                            score = "-";
                        } else if (vo.getStatus() == 3) {
                            statusName = passName;
                            score = String.valueOf(vo.getScore());
                        } else if (vo.getStatus() == 4) {
                            statusName = unPassName;
                            score = String.valueOf(vo.getScore());
                        } else if (vo.getStatus() == 5) {
                            statusName = waitRead;
                            score = "-";
                        }
                        row.createCell(16).setCellValue(score);
                        row.createCell(17).setCellValue(statusName);
                    }
                }
                try {
                    DownloadUtils.successExportTask((Workbook)wb, exportTaskPojo);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    DownloadUtils.errorExportTask(exportTaskPojo);
                }
            }
        });
        taskList.add(exportTaskPojo);
        return JsonResult.success(taskList);
    }
}

