/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ovopark.api.TrainingApi;
import com.ovopark.bo.Authenticator;
import com.ovopark.bo.JsonResult;
import com.ovopark.organize.common.model.pojo.ExportTaskPojo;
import com.ovopark.organize.sdk.api.UserOrganizeApi;
import com.ovopark.pojo.Users;
import com.ovopark.pojo.UsersDutiesPojo;
import com.ovopark.service.TrainingJobStudentService;
import com.ovopark.service.UserUtilService;
import com.ovopark.utils.DateUtils;
import com.ovopark.utils.DownloadUtils;
import com.ovopark.utils.ExcelUtil;
import com.ovopark.utils.ThreadPoolUtil;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TrainingJobStudentServiceImpl
implements TrainingJobStudentService {
    private static final Logger log = LoggerFactory.getLogger(TrainingJobStudentServiceImpl.class);
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private TrainingApi trainingApi;
    @Autowired
    private UserUtilService userUtilService;
    @Autowired
    private UserOrganizeApi userOrganizeApi;

    @Override
    public String studenTanalyseExport(final Integer groupId, final Integer jobId, final String deptIdStr, final String jobOrName, final Integer learnStatus, final Integer passStatus, final Integer isFrozen, String taskName, final Users user) {
        final Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        JSONObject param = new JSONObject();
        param.fluentPut("groupId", (Object)groupId).fluentPut("jobId", (Object)jobId).fluentPut("deptIdStr", (Object)deptIdStr).fluentPut("jobOrName", (Object)jobOrName).fluentPut("learnStatus", (Object)learnStatus).fluentPut("passStatus", (Object)passStatus).fluentPut("isFrozen", (Object)isFrozen).fluentPut("user", (Object)user);
        taskName = ExcelUtil.getFileName(taskName);
        String fileName = MessageFormat.format("{0}_{1}_{2}.xlsx", taskName, this.messageSource.getMessage("training.course.student.analysis", null, locale), DateUtils.format((Date)new Date(), (String)"yyyyMMdd"));
        ArrayList<ExportTaskPojo> taskList = new ArrayList<ExportTaskPojo>();
        final ExportTaskPojo exportTaskPojo = DownloadUtils.saveExportTask(fileName, param.toJSONString(), 30);
        final String finalTaskName = taskName;
        ThreadPoolUtil.getThreadPoolExecutor().execute(new Runnable(){

            @Override
            public void run() {
                List<UsersDutiesPojo> voList = TrainingJobStudentServiceImpl.this.trainingApi.getStudentAnalyseList(groupId, jobId, deptIdStr, jobOrName, learnStatus, passStatus, isFrozen, user);
                XSSFWorkbook wb = new XSSFWorkbook();
                XSSFSheet sheet = wb.createSheet(finalTaskName);
                XSSFRow row = sheet.createRow(0);
                row.createCell(0).setCellValue("id");
                sheet.setColumnWidth(0, 3000);
                row.createCell(1).setCellValue(TrainingJobStudentServiceImpl.this.messageSource.getMessage("training.user.details.username", null, locale));
                row.createCell(2).setCellValue(TrainingJobStudentServiceImpl.this.messageSource.getMessage("training.user.details.name", null, locale));
                row.createCell(3).setCellValue(TrainingJobStudentServiceImpl.this.messageSource.getMessage("training.user.details.employeeNumber", null, locale));
                sheet.setColumnWidth(3, 4024);
                row.createCell(4).setCellValue(TrainingJobStudentServiceImpl.this.messageSource.getMessage("training.course.analysis.role", null, locale));
                row.createCell(5).setCellValue(TrainingJobStudentServiceImpl.this.messageSource.getMessage("training.job.post.name", null, locale));
                sheet.setColumnWidth(5, 4024);
                row.createCell(6).setCellValue(TrainingJobStudentServiceImpl.this.messageSource.getMessage("training.course.analysis.superior", null, locale));
                row.createCell(7).setCellValue(TrainingJobStudentServiceImpl.this.messageSource.getMessage("training.course.analysis.department", null, locale));
                row.createCell(8).setCellValue(TrainingJobStudentServiceImpl.this.messageSource.getMessage("training.course.analysis.starttime", null, locale));
                row.createCell(9).setCellValue(TrainingJobStudentServiceImpl.this.messageSource.getMessage("training.course.analysis.endtime", null, locale));
                row.createCell(10).setCellValue(TrainingJobStudentServiceImpl.this.messageSource.getMessage("training.course.analysis.study.status", null, locale));
                row.createCell(11).setCellValue(TrainingJobStudentServiceImpl.this.messageSource.getMessage("training.shift.pass.status", null, locale));
                row.createCell(12).setCellValue(TrainingJobStudentServiceImpl.this.messageSource.getMessage("training.job.certificate", null, locale));
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                int i = 1;
                if (!CollectionUtils.isEmpty(voList)) {
                    for (UsersDutiesPojo usersDutiesPojo : voList) {
                        row = sheet.createRow(i++);
                        row.createCell(0).setCellValue((double)usersDutiesPojo.getId().intValue());
                        row.createCell(1).setCellValue(usersDutiesPojo.getUserName());
                        row.createCell(2).setCellValue(usersDutiesPojo.getShowName());
                        row.createCell(3).setCellValue(usersDutiesPojo.getEmployeeNumber());
                        row.createCell(4).setCellValue(usersDutiesPojo.getRole());
                        row.createCell(5).setCellValue(usersDutiesPojo.getDutiesName());
                        row.createCell(6).setCellValue(usersDutiesPojo.getParentName());
                        row.createCell(7).setCellValue(usersDutiesPojo.getOrganizeName());
                        if (usersDutiesPojo.getStartTime() == null) {
                            row.createCell(8).setCellValue("- -");
                        } else {
                            String format2 = format.format(usersDutiesPojo.getStartTime());
                            row.createCell(8).setCellValue(format2);
                        }
                        if (usersDutiesPojo.getEndTime() == null) {
                            row.createCell(9).setCellValue("- -");
                        } else {
                            String format3 = format.format(usersDutiesPojo.getEndTime());
                            row.createCell(9).setCellValue(format3);
                        }
                        String s = "";
                        Integer state = usersDutiesPojo.getState();
                        if (state == null || state == 1) {
                            s = s + TrainingJobStudentServiceImpl.this.messageSource.getMessage("training.course.status.unstart", null, locale) + "\uff1a";
                        } else if (state == 2) {
                            s = s + TrainingJobStudentServiceImpl.this.messageSource.getMessage("training.job.status.going", null, locale) + "\uff1a";
                        } else if (state == 3) {
                            s = s + TrainingJobStudentServiceImpl.this.messageSource.getMessage("training.job.status.completed", null, locale) + "\uff1a";
                        }
                        s = s + usersDutiesPojo.getCompleteNumber() + "/" + usersDutiesPojo.getTotalNumber();
                        row.createCell(10).setCellValue(s);
                        Integer passStatus1 = usersDutiesPojo.getPassStatus();
                        if (passStatus1 == null || passStatus1 == 0) {
                            row.createCell(11).setCellValue("- -");
                        } else if (passStatus1 == 1) {
                            row.createCell(11).setCellValue(TrainingJobStudentServiceImpl.this.messageSource.getMessage("training.job.unapprove", null, locale));
                        } else if (passStatus1 == 2) {
                            row.createCell(11).setCellValue(TrainingJobStudentServiceImpl.this.messageSource.getMessage("training.learn.unpass", null, locale));
                        } else if (passStatus1 == 3) {
                            row.createCell(11).setCellValue(TrainingJobStudentServiceImpl.this.messageSource.getMessage("training.learn.pass", null, locale));
                        }
                        String url = usersDutiesPojo.getUrl();
                        if (url == null) {
                            row.createCell(12).setCellValue("- -");
                            continue;
                        }
                        row.createCell(12).setCellValue(url);
                    }
                }
                try {
                    DownloadUtils.successExportTask((Workbook)wb, exportTaskPojo);
                }
                catch (Exception e) {
                    log.error("getUserTrainTaskExcel", (Throwable)e);
                    DownloadUtils.errorExportTask(exportTaskPojo);
                }
            }
        });
        taskList.add(exportTaskPojo);
        return JsonResult.success(taskList);
    }
}

