/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.service.impl;

import com.alibaba.fastjson.JSON;
import com.ovopark.api.TrainingApi;
import com.ovopark.bo.Authenticator;
import com.ovopark.bo.JsonResult;
import com.ovopark.organize.common.model.pojo.ExportTaskPojo;
import com.ovopark.pojo.PaperManagementBaseInfoVo;
import com.ovopark.pojo.PaperManagementExamineeDetailVo;
import com.ovopark.pojo.PaperManagementRequest;
import com.ovopark.pojo.Users;
import com.ovopark.service.TrainingPaperService;
import com.ovopark.utils.DateUtils;
import com.ovopark.utils.DownloadUtils;
import com.ovopark.utils.ExcelUtil;
import com.ovopark.utils.ThreadPoolUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.annotation.Resource;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;

@Service
public class TrainingPaperServiceImpl
implements TrainingPaperService {
    private static final Logger log = LoggerFactory.getLogger(TrainingPaperServiceImpl.class);
    @Resource
    private MessageSource messageSource;
    @Resource
    private TrainingApi trainingApi;

    @Override
    public String selectExamineeDetailsByExecl(PaperManagementRequest request, Users user) {
        request.setUser(user);
        final Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        String deptStatistics = this.messageSource.getMessage("training.user.paper.examinee.details", null, locale);
        PaperManagementBaseInfoVo paperManagementBaseInfoVo = this.trainingApi.getPaperManagementBaseInfo(request);
        String paperName = paperManagementBaseInfoVo.getPaperName();
        String fileName = deptStatistics + "-" + paperName + DateUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss");
        fileName = ExcelUtil.getFileName(fileName) + ".xlsx";
        ArrayList<ExportTaskPojo> taskList = new ArrayList<ExportTaskPojo>();
        final ExportTaskPojo exportTaskPojo = DownloadUtils.saveExportTask(fileName, JSON.toJSONString((Object)request), 36);
        final List<PaperManagementExamineeDetailVo> voList = this.trainingApi.selectExamineeDetails(request);
        ThreadPoolUtil.getThreadPoolExecutor().execute(new Runnable(){

            @Override
            public void run() {
                XSSFWorkbook wb = new XSSFWorkbook();
                XSSFSheet sheet = wb.createSheet();
                sheet.setColumnWidth(0, 3000);
                XSSFRow row = sheet.createRow(0);
                row.createCell(0).setCellValue("id");
                row.createCell(1).setCellValue(TrainingPaperServiceImpl.this.messageSource.getMessage("training.job.account.number", null, locale));
                row.createCell(2).setCellValue(TrainingPaperServiceImpl.this.messageSource.getMessage("training.user.details.name", null, locale));
                row.createCell(3).setCellValue(TrainingPaperServiceImpl.this.messageSource.getMessage("training.user.paper.examinee.type", null, locale));
                row.createCell(4).setCellValue(TrainingPaperServiceImpl.this.messageSource.getMessage("training.user.details.employeeNumber", null, locale));
                row.createCell(5).setCellValue(TrainingPaperServiceImpl.this.messageSource.getMessage("training.course.analysis.role", null, locale));
                row.createCell(6).setCellValue(TrainingPaperServiceImpl.this.messageSource.getMessage("training.course.analysis.department", null, locale));
                row.createCell(7).setCellValue(TrainingPaperServiceImpl.this.messageSource.getMessage("training.course.analysis.superior", null, locale));
                row.createCell(8).setCellValue(TrainingPaperServiceImpl.this.messageSource.getMessage("training.user.paper.shift.name", null, locale));
                row.createCell(9).setCellValue(TrainingPaperServiceImpl.this.messageSource.getMessage("training.user.paper.examinee.paper.state", null, locale));
                row.createCell(10).setCellValue(TrainingPaperServiceImpl.this.messageSource.getMessage("training.user.paper.starttime", null, locale));
                row.createCell(11).setCellValue(TrainingPaperServiceImpl.this.messageSource.getMessage("training.user.paper.submittime", null, locale));
                row.createCell(12).setCellValue(TrainingPaperServiceImpl.this.messageSource.getMessage("training.user.paper.joinpapertime", null, locale));
                row.createCell(13).setCellValue(TrainingPaperServiceImpl.this.messageSource.getMessage("training.user.paper.ip", null, locale));
                row.createCell(14).setCellValue(TrainingPaperServiceImpl.this.messageSource.getMessage("training.user.paper.answertime", null, locale));
                row.createCell(15).setCellValue(TrainingPaperServiceImpl.this.messageSource.getMessage("training.user.paper.score", null, locale));
                row.createCell(16).setCellValue(TrainingPaperServiceImpl.this.messageSource.getMessage("training.user.paper.passstate", null, locale));
                row.createCell(17).setCellValue(TrainingPaperServiceImpl.this.messageSource.getMessage("training.user.paper.cutscreencount", null, locale));
                row.createCell(18).setCellValue(TrainingPaperServiceImpl.this.messageSource.getMessage("training.user.paper.testnum", null, locale));
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                for (int i = 0; i < voList.size(); ++i) {
                    row = sheet.createRow(i + 1);
                    PaperManagementExamineeDetailVo vo = (PaperManagementExamineeDetailVo)voList.get(i);
                    row.createCell(0).setCellValue((double)vo.getUserId().intValue());
                    row.createCell(1).setCellValue(vo.getUserAccount());
                    row.createCell(2).setCellValue(vo.getUserName());
                    String userTypeDesc = "";
                    userTypeDesc = vo.getUserType() == 0 ? TrainingPaperServiceImpl.this.messageSource.getMessage("training.user.paper.enterpriseuser", null, locale) : TrainingPaperServiceImpl.this.messageSource.getMessage("training.user.paper.visitor", null, locale);
                    row.createCell(3).setCellValue(userTypeDesc);
                    row.createCell(4).setCellValue(vo.getUserNumber());
                    row.createCell(5).setCellValue(vo.getRole());
                    row.createCell(6).setCellValue(vo.getDeptName());
                    row.createCell(7).setCellValue(vo.getParentName());
                    row.createCell(8).setCellValue(vo.getShiftName());
                    String userPaperStateDesc = "";
                    if (vo.getUserPaperState() == 0) {
                        userPaperStateDesc = TrainingPaperServiceImpl.this.messageSource.getMessage("training.user.paper.nostart", null, locale);
                    } else if (vo.getUserPaperState() == 1) {
                        userPaperStateDesc = TrainingPaperServiceImpl.this.messageSource.getMessage("training.user.paper.papering", null, locale);
                    } else if (vo.getUserPaperState() == 2) {
                        userPaperStateDesc = TrainingPaperServiceImpl.this.messageSource.getMessage("training.user.paper.waitread", null, locale);
                    } else if (vo.getUserPaperState() == 3) {
                        userPaperStateDesc = TrainingPaperServiceImpl.this.messageSource.getMessage("training.user.paper.paperend", null, locale);
                    }
                    row.createCell(9).setCellValue(userPaperStateDesc);
                    row.createCell(10).setCellValue(vo.getStartTime() == null ? "-" : format.format(vo.getStartTime()));
                    row.createCell(11).setCellValue(vo.getSubmitTime() == null ? "-" : format.format(vo.getSubmitTime()));
                    row.createCell(12).setCellValue(vo.getJoinPaperTime() == null ? "-" : format.format(vo.getSubmitTime()));
                    row.createCell(13).setCellValue(vo.getIp() == null ? "-" : vo.getIp());
                    row.createCell(14).setCellValue(vo.getAnswerTime() == null ? "-" : vo.getAnswerTime());
                    row.createCell(15).setCellValue(vo.getScore().doubleValue());
                    String userPassStateDesc = "";
                    userPassStateDesc = vo.getUserPassState() == 0 ? TrainingPaperServiceImpl.this.messageSource.getMessage("training.user.paper.nopass", null, locale) : TrainingPaperServiceImpl.this.messageSource.getMessage("training.user.paper.pass", null, locale);
                    row.createCell(16).setCellValue(userPassStateDesc);
                    row.createCell(17).setCellValue((double)vo.getCutScreenCount().intValue());
                    row.createCell(18).setCellValue((double)vo.getTakePaperNum().intValue());
                }
                try {
                    DownloadUtils.successExportTask((Workbook)wb, exportTaskPojo);
                }
                catch (Exception e) {
                    log.error("getExamineeDetailsExcel", (Throwable)e);
                    DownloadUtils.errorExportTask(exportTaskPojo);
                }
            }
        });
        taskList.add(exportTaskPojo);
        return JsonResult.success(taskList);
    }
}

