/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.service.impl;

import com.ovopark.organize.common.model.mo.SimpleSuperUserMo;
import com.ovopark.organize.common.model.mo.UserAndParentNameMo;
import com.ovopark.organize.common.model.mo.UserDutiesMo;
import com.ovopark.organize.common.model.mo.UserTagMo;
import com.ovopark.organize.common.model.mo.UsersAndOrgsMo;
import com.ovopark.organize.common.model.pojo.DepAndTagsPojo;
import com.ovopark.organize.common.model.pojo.SimplePojo;
import com.ovopark.organize.sdk.api.TagApi;
import com.ovopark.organize.sdk.api.UserApi;
import com.ovopark.organize.sdk.api.UserOrganizeApi;
import com.ovopark.pojo.Users;
import com.ovopark.privilege.api.RoleApi;
import com.ovopark.privilege.pojo.RolePojo;
import com.ovopark.privilege.pojo.UsersPojo;
import com.ovopark.privilege.response.BaseResult;
import com.ovopark.service.UserUtilService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class UserUtilServiceImpl
implements UserUtilService {
    @Autowired
    private UserOrganizeApi userOrganizeApi;
    @Autowired
    private UserApi userApi;
    @Autowired
    private com.ovopark.privilege.api.UserApi useApi;
    @Autowired
    private TagApi tagApi;
    @Autowired
    private RoleApi roleApi;

    @Override
    public com.ovopark.organize.common.model.pojo.UsersPojo selectUser(Integer userId) {
        com.ovopark.organize.common.model.pojo.UsersPojo pojo = new com.ovopark.organize.common.model.pojo.UsersPojo();
        com.ovopark.organize.common.base.BaseResult userPojo = this.userApi.getUserById(userId);
        if (userPojo != null) {
            pojo = (com.ovopark.organize.common.model.pojo.UsersPojo)userPojo.getData();
        }
        return pojo;
    }

    @Override
    public Map<Integer, com.ovopark.organize.common.model.pojo.UsersPojo> selectUserMap(List<Integer> userIds) {
        List pojoList;
        com.ovopark.organize.common.base.BaseResult base;
        Map<Integer, Object> pojoMap = new HashMap<Integer, com.ovopark.organize.common.model.pojo.UsersPojo>();
        if (!CollectionUtils.isEmpty(userIds) && (base = this.userApi.getUserByIdList(userIds)) != null && !CollectionUtils.isEmpty((Collection)(pojoList = (List)base.getData()))) {
            pojoMap = pojoList.stream().collect(Collectors.toMap(com.ovopark.organize.common.model.pojo.UsersPojo::getId, Function.identity()));
        }
        return pojoMap;
    }

    @Override
    public Map<Integer, List<String>> selectOrganizeMap(List<Integer> userIds, Integer groupId) {
        com.ovopark.organize.common.base.BaseResult base;
        Map<Integer, List<String>> pojoMap = new HashMap<Integer, List<String>>();
        if (!CollectionUtils.isEmpty(userIds) && (base = this.userOrganizeApi.getUserOrganizeFirstByUserIds(groupId, userIds, null)) != null && !ObjectUtils.isEmpty((Object)base.getData())) {
            pojoMap = (Map)base.getData();
        }
        return pojoMap;
    }

    @Override
    public Map<Integer, String> selectParentMap(List<Integer> userIds, Integer groupId) {
        HashMap<Integer, String> parentMap = new HashMap<Integer, String>();
        if (!CollectionUtils.isEmpty(userIds)) {
            List parentList;
            SimpleSuperUserMo mo = new SimpleSuperUserMo();
            mo.setGroupId(groupId);
            mo.setUserList(userIds);
            mo.setFilterClose(Boolean.valueOf(true));
            com.ovopark.organize.common.base.BaseResult baseParent = this.userApi.getParentUsersByUserIds(mo);
            if (baseParent != null && !CollectionUtils.isEmpty((Collection)(parentList = (List)baseParent.getData()))) {
                Integer idValue = null;
                String parentName = "";
                for (Map map : parentList) {
                    idValue = null;
                    for (String key : map.keySet()) {
                        if ("id".equals(key)) {
                            idValue = Integer.valueOf(map.get(key).toString());
                            continue;
                        }
                        if (!"parentShowName".equals(key) || StringUtils.isEmpty(map.get(key))) continue;
                        parentName = map.get(key).toString();
                    }
                    if (idValue == null) continue;
                    parentMap.put(idValue, parentName);
                }
            }
        }
        return parentMap;
    }

    @Override
    public Map<Integer, Integer> selectParentIdMap(List<Integer> userIds, Integer groupId) {
        HashMap<Integer, Integer> parentMap = new HashMap<Integer, Integer>();
        if (!CollectionUtils.isEmpty(userIds)) {
            List parentList;
            SimpleSuperUserMo mo = new SimpleSuperUserMo();
            mo.setGroupId(groupId);
            mo.setUserList(userIds);
            mo.setFilterClose(Boolean.valueOf(true));
            com.ovopark.organize.common.base.BaseResult baseParent = this.userApi.getParentUsersByUserIds(mo);
            if (baseParent != null && !CollectionUtils.isEmpty((Collection)(parentList = (List)baseParent.getData()))) {
                Integer idValue = null;
                Integer parentId = null;
                for (Map map : parentList) {
                    idValue = null;
                    for (String key : map.keySet()) {
                        if ("id".equals(key)) {
                            idValue = Integer.valueOf(map.get(key).toString());
                            continue;
                        }
                        if (!"parentId".equals(key) || StringUtils.isEmpty(map.get(key))) continue;
                        parentId = Integer.valueOf(map.get(key).toString());
                    }
                    if (idValue == null) continue;
                    parentMap.put(idValue, parentId);
                }
            }
        }
        return parentMap;
    }

    @Override
    public Map<String, Object> getCheckParameters(String userName, Integer dutiesId, List<String> organizeIds, Users user) {
        int isEffect = 0;
        ArrayList userList = new ArrayList();
        if (!StringUtils.isEmpty((Object)userName) || !StringUtils.isEmpty((Object)dutiesId)) {
            com.ovopark.organize.common.base.BaseResult base = this.userApi.getSimpleUserByKeyWord(user.getGroupId(), userName, dutiesId);
            if (base != null) {
                List pojoList = ((List)base.getData()).stream().map(SimplePojo::getId).distinct().collect(Collectors.toList());
                userList.addAll(pojoList);
            }
            isEffect = 1;
        }
        if (!CollectionUtils.isEmpty(organizeIds)) {
            UsersAndOrgsMo mo = new UsersAndOrgsMo();
            mo.setGroupId(user.getGroupId());
            mo.setOrganizeIds(organizeIds);
            com.ovopark.organize.common.base.BaseResult base = this.userOrganizeApi.getUserByOrganizeIdsOrDepId(mo);
            if (base != null && !CollectionUtils.isEmpty((Collection)((Collection)base.getData()))) {
                List pojoList = ((List)base.getData()).stream().map(UserAndParentNameMo::getUserId).distinct().collect(Collectors.toList());
                if (isEffect == 1) {
                    userList.retainAll(pojoList);
                } else {
                    userList.addAll(pojoList);
                }
            } else {
                userList = new ArrayList();
            }
            isEffect = 1;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("isEffect", isEffect);
        map.put("userList", userList);
        return map;
    }

    @Override
    public List<Integer> selectUserRoleList(Users user) {
        BaseResult base = this.roleApi.getRoleIdsByUser(user.getId(), user.getGroupId());
        List<Integer> roleList = new ArrayList<Integer>();
        if (base != null && !CollectionUtils.isEmpty((Collection)((Collection)base.getData()))) {
            roleList = (List)base.getData();
        }
        return roleList;
    }

    @Override
    public List<Integer> selectUserTagList(Users user) {
        com.ovopark.organize.common.base.BaseResult base = this.tagApi.getUsersTagByUserId(user.getId());
        List<Integer> tagList = new ArrayList<Integer>();
        if (!base.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)base.getData()))) {
            List moList = (List)base.getData();
            tagList = moList.stream().map(UserTagMo::getId).collect(Collectors.toList());
        }
        return tagList;
    }

    @Override
    public List<String> selectUserOrganizeList(Users user) {
        ArrayList<String> orgIds = new ArrayList<String>();
        UsersAndOrgsMo mo = new UsersAndOrgsMo();
        mo.setGroupId(user.getGroupId());
        mo.setUserId(user.getId());
        mo.setRetainAll(Boolean.valueOf(false));
        mo.setShowAllPath(Boolean.valueOf(true));
        com.ovopark.organize.common.base.BaseResult orgResult = this.userOrganizeApi.getUserOrganizeByUserIdAndOrg(mo);
        if (!orgResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Map)((Map)orgResult.getData()))) {
            List list;
            Map map = (Map)orgResult.getData();
            if (!CollectionUtils.isEmpty((Collection)((Collection)map.get("O_")))) {
                list = (List)map.get("O_");
                for (Integer id : list) {
                    orgIds.add("O_" + id);
                }
            }
            if (!CollectionUtils.isEmpty((Collection)((Collection)map.get("S_")))) {
                list = (List)map.get("S_");
                for (Integer id : list) {
                    orgIds.add("S_" + id);
                }
            }
        }
        return orgIds;
    }

    @Override
    public List<Integer> selectUsersByRoles(List<Integer> roleList, Integer groupId) {
        String roleIdStr;
        BaseResult baseResult;
        List<Integer> pojoList = new ArrayList<Integer>();
        if (!CollectionUtils.isEmpty(roleList) && (baseResult = this.useApi.getUserByRoleIds(roleIdStr = org.apache.commons.lang.StringUtils.join(roleList, (String)","), groupId)) != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
            pojoList = ((List)baseResult.getData()).stream().map(UsersPojo::getId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        }
        return pojoList;
    }

    @Override
    public Map<Integer, List<RolePojo>> selectRolesByUsers(List<Integer> userIdList, Integer groupId) {
        Map<Integer, List<Object>> roleMap = new HashMap<Integer, List<RolePojo>>();
        if (!CollectionUtils.isEmpty(userIdList)) {
            String userStr = org.apache.commons.lang.StringUtils.join(userIdList, (String)",");
            HashMap<String, Object> parameter = new HashMap<String, Object>();
            parameter.put("userIds", userStr);
            parameter.put("groupId", groupId);
            BaseResult base = this.roleApi.getUserRoleList(parameter);
            if (base != null) {
                roleMap = (Map)base.getData();
            }
        }
        return roleMap;
    }

    @Override
    public List<Integer> selectUserIdsByOrganizeIds(List<String> organizeIdList, Integer groupId) {
        List<Integer> userIds = new ArrayList<Integer>();
        if (!CollectionUtils.isEmpty(organizeIdList)) {
            UsersAndOrgsMo mo = new UsersAndOrgsMo();
            mo.setGroupId(groupId);
            mo.setOrganizeIds(organizeIdList);
            com.ovopark.organize.common.base.BaseResult baseResult = this.userOrganizeApi.getUserByOrganizeIdsOrDepId(mo);
            if (!Objects.isNull(baseResult) && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
                userIds = ((List)baseResult.getData()).stream().map(UserAndParentNameMo::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            }
        }
        return userIds;
    }

    @Override
    public List<Integer> selectUserIdsByTagIds(List<Integer> tagIdList, Integer groupId, Integer userId) {
        ArrayList<Integer> userIds = new ArrayList<Integer>();
        if (!CollectionUtils.isEmpty(tagIdList)) {
            DepAndTagsPojo pojo = new DepAndTagsPojo();
            pojo.setGroupId(groupId);
            pojo.setTagIds(tagIdList);
            pojo.setUserId(userId);
            com.ovopark.organize.common.base.BaseResult baseResult = this.tagApi.getUsersByTags(pojo);
            if (!Objects.isNull(baseResult) && !Objects.isNull(baseResult.getData())) {
                for (Map map : (List)baseResult.getData()) {
                    Integer id = (Integer)map.get("id");
                    userIds.add(id);
                }
            }
        }
        return userIds;
    }

    @Override
    public List<Integer> selectUserTageByUserId(Integer userId) {
        com.ovopark.organize.common.base.BaseResult baseResult;
        List<Integer> tagIds = new ArrayList<Integer>();
        if (!(Objects.isNull(userId) || Objects.isNull(baseResult = this.tagApi.getUsersTagByUserId(userId)) || CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData())))) {
            tagIds = ((List)baseResult.getData()).stream().map(UserTagMo::getId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        }
        return tagIds;
    }

    @Override
    public Map<Integer, String> selectUserOrganizeName(Integer groupId, List<Integer> userIdList) {
        HashMap<Integer, String> userOrganizeMap = new HashMap<Integer, String>();
        com.ovopark.organize.common.base.BaseResult base = this.userOrganizeApi.getUserOrganizeFirstByUserIds(groupId, userIdList, null);
        if (base != null && !ObjectUtils.isEmpty((Object)base.getData())) {
            Map map = (Map)base.getData();
            for (Integer userId : map.keySet()) {
                StringBuilder organizeName = new StringBuilder();
                List strList = (List)map.get(userId);
                if (!CollectionUtils.isEmpty((Collection)strList)) {
                    for (String name : strList) {
                        String[] datas = name.split("/");
                        organizeName.append(datas[datas.length - 1]).append(";");
                    }
                }
                userOrganizeMap.put(userId, organizeName.toString());
            }
        }
        return userOrganizeMap;
    }

    @Override
    public List<Integer> selectOverGroupTime(Integer groupId, Date dateTime) {
        List<Integer> userRemoveList = new ArrayList<Integer>();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        com.ovopark.organize.common.base.BaseResult base = this.userApi.getUserGtCreateTime(groupId, format.format(dateTime));
        if (base != null && !CollectionUtils.isEmpty((Collection)((Collection)base.getData()))) {
            userRemoveList = (List)base.getData();
        }
        return userRemoveList;
    }

    @Override
    public Map<Integer, String> selectShopPath(Integer groupId) {
        HashMap<Integer, String> userOrganizeMap = new HashMap<Integer, String>();
        return userOrganizeMap;
    }

    @Override
    public List<Integer> getUserListByGroupId(Integer groupId) {
        com.ovopark.organize.common.base.BaseResult baseResult = this.userApi.getSimpleUserByKeyWord(groupId, null, null);
        if (!baseResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
            return ((List)baseResult.getData()).stream().map(SimplePojo::getId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public Map<Integer, UserDutiesMo> selectDutiesMap(List<Integer> userIds, Integer groupId) {
        if (!CollectionUtils.isEmpty(userIds)) {
            List pojoList;
            SimpleSuperUserMo mo = new SimpleSuperUserMo();
            mo.setUserList(userIds);
            mo.setGroupId(groupId);
            com.ovopark.organize.common.base.BaseResult base = this.userApi.getUserDutiesByUserIds(mo);
            if (base != null && !CollectionUtils.isEmpty((Collection)(pojoList = (List)base.getData()))) {
                return pojoList.stream().collect(Collectors.toMap(UserDutiesMo::getUserId, Function.identity()));
            }
        }
        return null;
    }
}

