/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.utils;

import cn.hutool.core.date.DateUtil;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.auth.DefaultCredentialProvider;
import com.aliyun.oss.model.ObjectMetadata;
import com.ovopark.bo.JsonResult;
import com.ovopark.model.ExportParam;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.util.Date;
import javax.annotation.PostConstruct;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class OssHelper {
    private static final Logger log = LoggerFactory.getLogger(OssHelper.class);
    String accessKeyId = "LTAI5tMLFREG949yfYizrA7k";
    String accessKeySecret = "4bwneiEvNRSq2DcRl0ujEny4GVoqUO";
    String endpoint = "http://oss-cn-hangzhou.aliyuncs.com";
    String ossBucketName = "ovopark";
    String accessUrl = "http://ovopark.oss-cn-hangzhou.aliyuncs.com";
    private OSS oss;

    public static void main(String[] args) throws Exception {
        OssHelper helper = new OssHelper();
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet("123");
        HSSFRow row = sheet.createRow(0);
        row.createCell(0).setCellValue("id");
        String url = helper.uploadExcel((Workbook)wb, helper.getFilePath("test.xls"));
        System.out.println(url);
    }

    @PostConstruct
    public void init() {
        DefaultCredentialProvider credentialsProvider = new DefaultCredentialProvider(this.accessKeyId, this.accessKeySecret);
        this.oss = new OSSClientBuilder().build(this.endpoint, (CredentialsProvider)credentialsProvider);
    }

    public String getFilePath(String imageName) {
        return "oa/" + DateUtil.format((Date)new Date(), (String)"yyyy/MM/dd") + "/" + imageName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String uploadExcel(Workbook workbook, String fileName) {
        DefaultCredentialProvider credentialsProvider = new DefaultCredentialProvider(this.accessKeyId, this.accessKeySecret);
        OSS ossClient = new OSSClientBuilder().build(this.endpoint, (CredentialsProvider)credentialsProvider);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            workbook.write((OutputStream)bos);
            byte[] brray = bos.toByteArray();
            String imagePath = this.getFilePath(fileName);
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentType(OssHelper.contentType(fileName.substring(fileName.lastIndexOf(".") + 1)));
            meta.setCacheControl("no-cache");
            ossClient.putObject(this.ossBucketName, imagePath, (InputStream)new ByteArrayInputStream(brray));
            String string = this.accessUrl + "/" + imagePath;
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
            try {
                bos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return JsonResult.error();
    }

    public String uploadByteOutputStream(ByteArrayOutputStream bos, ExportParam param) {
        OSS client = this.getOssClient();
        String path = param.getPath();
        String contentType = param.getContentType();
        byte[] byteArray = bos.toByteArray();
        PipedInputStream pipedInputStream = new PipedInputStream();
        String filePath = this.getFilePath(path);
        ObjectMetadata meta = new ObjectMetadata();
        meta.setContentType(OssHelper.contentType(contentType));
        meta.setCacheControl("no-cache");
        client.putObject(this.ossBucketName, filePath, (InputStream)new ByteArrayInputStream(byteArray));
        try {
            pipedInputStream.close();
        }
        catch (IOException e) {
            log.error("uploadOutputStream error", (Throwable)e);
            throw new RuntimeException(e);
        }
        return this.accessUrl + "/" + filePath;
    }

    private OSS getOssClient() {
        return this.oss;
    }

    private static String contentType(String fileType) {
        fileType = fileType.toLowerCase();
        String contentType = "";
        switch (fileType) {
            case "bmp": {
                contentType = "image/bmp";
                break;
            }
            case "gif": {
                contentType = "image/gif";
                break;
            }
            case "png": 
            case "jpeg": 
            case "jpg": {
                contentType = "image/jpeg";
                break;
            }
            case "html": {
                contentType = "text/html";
                break;
            }
            case "txt": {
                contentType = "text/plain";
                break;
            }
            case "vsd": {
                contentType = "application/vnd.visio";
                break;
            }
            case "ppt": 
            case "pptx": {
                contentType = "application/vnd.ms-powerpoint";
                break;
            }
            case "doc": 
            case "docx": {
                contentType = "application/msword";
                break;
            }
            case "xml": {
                contentType = "text/xml";
                break;
            }
            case "mp4": {
                contentType = "video/mp4";
                break;
            }
            case "xlsx": {
                contentType = "application/vnd.ms-excel; charset=utf-8";
                break;
            }
            default: {
                contentType = "application/octet-stream";
            }
        }
        return contentType;
    }
}

