/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.controller;

import com.ovopark.bo.Authenticator;
import com.ovopark.bo.JsonResult;
import com.ovopark.pojo.OpenShiftExcelVo;
import com.ovopark.pojo.StudentReportVo;
import com.ovopark.pojo.Users;
import com.ovopark.service.TrainingShiftExeclService;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/shiftExecl"})
public class ShiftExeclController {
    @Autowired
    private TrainingShiftExeclService trainingShiftExeclService;

    @PostMapping(value={"/selectOpenShiftByExecl"})
    @ResponseBody
    public String selectOpenShiftByExecl(@RequestBody OpenShiftExcelVo vo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getGroupId() != null) {
            vo.setUser(user);
            List<Integer> createrList = null;
            if (!StringUtils.isEmpty((Object)vo.getCreaters())) {
                String[] createrStr = vo.getCreaters().split(",");
                List<String> createrS = Arrays.asList(createrStr);
                createrList = createrS.stream().map(Integer::parseInt).collect(Collectors.toList());
                vo.setCreaterList(createrList);
            }
            return this.trainingShiftExeclService.selectOpenShiftByExecl(vo);
        }
        return JsonResult.error();
    }

    @PostMapping(value={"/selectStudentReportByExecl"})
    @ResponseBody
    public String selectStudentReportByExecl(@RequestBody StudentReportVo vo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getGroupId() != null) {
            vo.setUser(user);
            return this.trainingShiftExeclService.selectStudentReportByExecl(vo);
        }
        return JsonResult.error();
    }
}

