/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.interceptor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ovopark.bo.Authenticator;
import com.ovopark.bo.ClientInfo;
import com.ovopark.module.shared.BaseResult;
import com.ovopark.module.shared.Session;
import com.ovopark.module.shared.jdk8.JavaxServletRequest;
import com.ovopark.module.shared.spring.SharedRequest;
import com.ovopark.module.shared.spring.rbac.SessionClient;
import com.ovopark.module.shared.spring.rbac.TokenInvalidException;
import com.ovopark.module.shared.spring.rbac.TokenRefreshException;
import com.ovopark.module.shared.spring.rbac.TokenRefreshExpiredException;
import com.ovopark.pojo.Users;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.web.servlet.HandlerInterceptor;

public class AuthenticatorInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AuthenticatorInterceptor.class);
    private SessionClient sessionClient;

    public AuthenticatorInterceptor(SessionClient sessionClient) {
        this.sessionClient = sessionClient;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object object) throws Exception {
        String userAgent = request.getHeader("User-Agent");
        String requestURL = request.getRequestURL() != null ? request.getRequestURL().toString() : "";
        Session session = null;
        try {
            session = this.sessionClient.session((SharedRequest)new JavaxServletRequest(request));
        }
        catch (TokenInvalidException e) {
            log.info("Token\u4e0d\u5408\u6cd5", (Throwable)e);
            response.getWriter().append(JSONObject.toJSONString((Object)BaseResult.error((Object)"INVALID_TOKEN", (String)"500", (String)"INVALID_TOKEN")));
            return false;
        }
        catch (TokenRefreshException e) {
            log.info("Token\u5237\u65b0", (Throwable)e);
            response.getWriter().append(JSONObject.toJSONString((Object)BaseResult.error((Object)"INVALID_TOKEN", (String)"500", (String)"INVALID_TOKEN")));
            return false;
        }
        catch (TokenRefreshExpiredException e) {
            log.info("Token\u8fc7\u671f\u5237\u65b0", (Throwable)e);
            response.getWriter().append(JSONObject.toJSONString((Object)BaseResult.error((Object)"INVALID_TOKEN", (String)"500", (String)"INVALID_TOKEN")));
            return false;
        }
        if (session == null || session.getUserId() == null) {
            log.info("Token\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{} ;\u8bf7\u6c42\u53c2\u6570\uff1a{}; User-Agent\uff1a{}", new Object[]{requestURL, MDC.get((String)"params"), userAgent});
            response.getWriter().append(JSONObject.toJSONString((Object)BaseResult.error((Object)"INVALID_TOKEN", (String)"500", (String)"INVALID_TOKEN")));
            return false;
        }
        MDC.put((String)"userId", (String)session.getUserId().toString());
        log.info("session = {}", (Object)JSON.toJSONString((Object)session));
        boolean innerRequest = requestURL.contains("/feign/");
        if (!innerRequest) {
            log.info("\u8bf7\u6c42\u5730\u5740\uff1a{} ;\u8bf7\u6c42\u53c2\u6570\uff1a{}; User-Agent\uff1a{}", new Object[]{requestURL, MDC.get((String)"params"), userAgent});
        }
        com.ovopark.module.shared.ClientInfo sessionClientInfo = session.clientInfo();
        ClientInfo clientInfo = new ClientInfo();
        clientInfo.setAccessTime(System.currentTimeMillis());
        clientInfo.setLocale(sessionClientInfo.getLocale());
        clientInfo.setClient(sessionClientInfo.getClient());
        clientInfo.setVersion(sessionClientInfo.getVersion());
        clientInfo.setLang(sessionClientInfo.getLang());
        Users user = new Users();
        user.setId(session.getUserId());
        user.setUserName(session.getUserName());
        user.setGroupId(session.getGroupId());
        Authenticator.getInstance().setCurrentClient(clientInfo);
        clientInfo.setUser(user);
        clientInfo.setUserId(session.getUserId());
        Authenticator.getInstance().setCurrentUser(user);
        return true;
    }
}

