/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.service.export.typeHandler;

import com.alibaba.excel.EasyExcel;
import com.alibaba.fastjson.JSON;
import com.ovopark.config.ExportConst;
import com.ovopark.model.ExportParam;
import com.ovopark.organize.common.model.pojo.ExportTaskPojo;
import com.ovopark.service.export.typeHandler.IExportTypeHandler;
import com.ovopark.training.enhancer.subject.resp.Result;
import com.ovopark.training.enhancer.subject.resp.ResultUtils;
import com.ovopark.utils.DownloadUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ConstClazzHandler
implements IExportTypeHandler {
    private static final Logger log = LoggerFactory.getLogger(ConstClazzHandler.class);

    @Override
    public ExportConst.Type getType() {
        return ExportConst.Type.ConstClazz;
    }

    @Override
    public Result<Void> handle(ExportParam param) {
        ExportConst.ClazzType exportClazz = param.getExportClazz();
        if (exportClazz == null) {
            return ResultUtils.fail((String)"\u5bfc\u51fa\u7c7b\u578b\u9519\u8bef");
        }
        ExportTaskPojo task = param.getTask();
        String collectionJson = param.getCollectionJson();
        List objects = JSON.parseArray((String)collectionJson, exportClazz.getClazz());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        EasyExcel.write((OutputStream)bos, exportClazz.getClazz()).sheet(param.getSheet()).doWrite((Collection)objects);
        try {
            DownloadUtils.successExportTask(bos, task, param);
        }
        catch (Exception e) {
            log.error("\u5bfc\u51fa\u5931\u8d25", (Throwable)e);
            DownloadUtils.errorExportTask(task);
        }
        return ResultUtils.success();
    }
}

