/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.service.export.typeHandler;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.ovopark.config.ExportConst;
import com.ovopark.model.ExportParam;
import com.ovopark.organize.common.model.pojo.ExportTaskPojo;
import com.ovopark.service.export.typeHandler.IExportTypeHandler;
import com.ovopark.training.enhancer.subject.resp.Result;
import com.ovopark.training.enhancer.subject.resp.ResultUtils;
import com.ovopark.utils.DownloadUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DynamicHeadHandler
implements IExportTypeHandler {
    private static final Logger log = LoggerFactory.getLogger(DynamicHeadHandler.class);

    @Override
    public ExportConst.Type getType() {
        return ExportConst.Type.DynamicHead;
    }

    @Override
    public Result<Void> handle(ExportParam param) {
        ExportConst.ClazzType exportClazz = param.getExportClazz();
        if (exportClazz == null) {
            return ResultUtils.fail((String)"\u5bfc\u51fa\u7c7b\u578b\u9519\u8bef");
        }
        ExportTaskPojo task = param.getTask();
        List<List<Object>> items = param.getItems();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ((ExcelWriterBuilder)EasyExcel.write((OutputStream)bos).head(param.getHead())).sheet(param.getSheet()).doWrite(items);
        try {
            DownloadUtils.successExportTask(bos, task, param);
        }
        catch (Exception e) {
            log.error("\u5bfc\u51fa\u5931\u8d25", (Throwable)e);
            DownloadUtils.errorExportTask(task);
        }
        return ResultUtils.success();
    }
}

