/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ovopark.api.TrainingApi;
import com.ovopark.bo.Authenticator;
import com.ovopark.bo.JsonResult;
import com.ovopark.organize.common.model.mo.UsersAndOrgsMo;
import com.ovopark.organize.common.model.pojo.ExportTaskPojo;
import com.ovopark.organize.sdk.api.UserOrganizeApi;
import com.ovopark.pojo.TrainingCourse;
import com.ovopark.pojo.TrainingCourseStageTask;
import com.ovopark.pojo.TrainingCourseUserTask;
import com.ovopark.pojo.TrainingCourseUserTaskVo;
import com.ovopark.pojo.Users;
import com.ovopark.privilege.api.RoleApi;
import com.ovopark.privilege.pojo.RolePojo;
import com.ovopark.privilege.response.BaseResult;
import com.ovopark.service.TrainingCourseService;
import com.ovopark.service.UserUtilService;
import com.ovopark.utils.DateUtils;
import com.ovopark.utils.DownloadUtils;
import com.ovopark.utils.ExcelUtil;
import com.ovopark.utils.ThreadPoolUtil;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TrainingCourseServiceImpl
implements TrainingCourseService {
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private UserUtilService userUtilService;
    @Autowired
    private RoleApi roleApi;
    @Autowired
    private UserOrganizeApi userOrganizeApi;
    @Autowired
    private TrainingApi trainingApi;

    @Override
    public String selectCourseUserAnalysisByExecl(final Integer courseId, final String name, final Integer status, final String organizeIds, final Integer turns, final String roles, final String excelStr, final Users user) {
        final Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        JSONObject param = new JSONObject();
        param.fluentPut("courseId", (Object)courseId).fluentPut("name", (Object)name).fluentPut("status", (Object)status).fluentPut("organizeIds", (Object)organizeIds).fluentPut("turns", (Object)turns).fluentPut("roles", (Object)roles).fluentPut("user", (Object)user);
        TrainingCourse course = this.trainingApi.getCourseById(courseId);
        String fileName = MessageFormat.format("{0}_{1}_{2}", course.getCourseName(), this.messageSource.getMessage("training.course.student.analysis", null, locale), DateUtils.format((Date)new Date(), (String)"yyyyMMdd_HHmmss"));
        fileName = ExcelUtil.getFileName(fileName) + ".xlsx";
        ArrayList<ExportTaskPojo> taskList = new ArrayList<ExportTaskPojo>();
        final ExportTaskPojo exportTaskPojo = DownloadUtils.saveExportTask(fileName, param.toJSONString(), 23);
        final String finalFileName = this.messageSource.getMessage("training.course.student.analysis", null, locale);
        ThreadPoolUtil.getThreadPoolExecutor().execute(new Runnable(){

            @Override
            public void run() {
                XSSFWorkbook wb = new XSSFWorkbook();
                XSSFSheet sheet = wb.createSheet(finalFileName);
                List<TrainingCourseUserTaskVo> list = TrainingCourseServiceImpl.this.trainingApi.getCourseUserAnalysisList(courseId, name, status, organizeIds, turns, roles, user.getGroupId(), user.getId());
                String[] str = excelStr.split(",");
                List<Integer> userIdList = new ArrayList<Integer>();
                String userStr = "";
                Integer groupId = user.getGroupId();
                if (!CollectionUtils.isEmpty(list) && !CollectionUtils.isEmpty(userIdList = list.stream().map(TrainingCourseUserTask::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                    userStr = StringUtils.join(userIdList, (String)",");
                }
                Map<Integer, List<String>> organizeMap = TrainingCourseServiceImpl.this.userUtilService.selectOrganizeMap(userIdList, groupId);
                XSSFCellStyle titleSty = wb.createCellStyle();
                titleSty.setWrapText(true);
                XSSFRow row = sheet.createRow(0);
                sheet.setColumnWidth(0, 3000);
                sheet.setColumnWidth(7, 6000);
                row.createCell(0).setCellValue("id");
                int currentNum = 0;
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[1]) && str[1].equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.job.account.number", null, locale));
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[2]) && str[2].equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.analysis.showname", null, locale));
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[3]) && str[3].equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.user.details.employeeNumber", null, locale));
                }
                Map roleMap = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[4]) && str[4].equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.analysis.role", null, locale));
                    if (!org.springframework.util.StringUtils.isEmpty((Object)userStr)) {
                        HashMap<String, Object> parameter = new HashMap<String, Object>();
                        parameter.put("userIds", userStr);
                        parameter.put("groupId", groupId);
                        BaseResult base = TrainingCourseServiceImpl.this.roleApi.getUserRoleList(parameter);
                        if (base != null) {
                            roleMap = (Map)base.getData();
                        }
                    }
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[5]) && str[5].equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.job.post.name", null, locale));
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[6]) && str[6].equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.analysis.superior", null, locale));
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[7]) && str[7].equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.learn.department", null, locale));
                }
                Map organMap1 = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[8]) && str[8].equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.analysis.first.organize", null, locale));
                    if (!CollectionUtils.isEmpty(userIdList)) {
                        UsersAndOrgsMo mo = new UsersAndOrgsMo();
                        mo.setGroupId(groupId);
                        mo.setLevelList(Arrays.asList(1));
                        mo.setUserIdList(userIdList);
                        mo.setShowDepartment(Boolean.valueOf(false));
                        com.ovopark.organize.common.base.BaseResult base = TrainingCourseServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                        if (base != null) {
                            organMap1 = (Map)base.getData();
                        }
                    }
                }
                Map organMap2 = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[9]) && str[9].equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.analysis.second.organize", null, locale));
                    if (!CollectionUtils.isEmpty(userIdList)) {
                        UsersAndOrgsMo mo = new UsersAndOrgsMo();
                        mo.setGroupId(groupId);
                        mo.setLevelList(Arrays.asList(2));
                        mo.setUserIdList(userIdList);
                        mo.setShowDepartment(Boolean.valueOf(false));
                        com.ovopark.organize.common.base.BaseResult base = TrainingCourseServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                        if (base != null) {
                            organMap2 = (Map)base.getData();
                        }
                    }
                }
                Map organMap3 = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[10]) && str[10].equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.analysis.third.organize", null, locale));
                    if (!CollectionUtils.isEmpty(userIdList)) {
                        UsersAndOrgsMo mo = new UsersAndOrgsMo();
                        mo.setGroupId(groupId);
                        mo.setLevelList(Arrays.asList(3));
                        mo.setUserIdList(userIdList);
                        mo.setShowDepartment(Boolean.valueOf(false));
                        com.ovopark.organize.common.base.BaseResult base = TrainingCourseServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                        if (base != null) {
                            organMap3 = (Map)base.getData();
                        }
                    }
                }
                Map organMap4 = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[11]) && str[11].equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.analysis.fourth.organize", null, locale));
                    if (!CollectionUtils.isEmpty(userIdList)) {
                        UsersAndOrgsMo mo = new UsersAndOrgsMo();
                        mo.setGroupId(groupId);
                        mo.setLevelList(Arrays.asList(4));
                        mo.setUserIdList(userIdList);
                        mo.setShowDepartment(Boolean.valueOf(false));
                        com.ovopark.organize.common.base.BaseResult base = TrainingCourseServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                        if (base != null) {
                            organMap4 = (Map)base.getData();
                        }
                    }
                }
                Map organMap5 = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[12]) && str[12].equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.analysis.fifth.organize", null, locale));
                    if (!CollectionUtils.isEmpty(userIdList)) {
                        UsersAndOrgsMo mo = new UsersAndOrgsMo();
                        mo.setGroupId(groupId);
                        mo.setLevelList(Arrays.asList(5));
                        mo.setUserIdList(userIdList);
                        mo.setShowDepartment(Boolean.valueOf(false));
                        com.ovopark.organize.common.base.BaseResult base = TrainingCourseServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                        if (base != null) {
                            organMap5 = (Map)base.getData();
                        }
                    }
                }
                Map shopMap = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[13]) && str[13].equals("1")) {
                    String shopName = TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.analysis.dep", null, locale);
                    row.createCell(++currentNum).setCellValue(shopName);
                    if (!CollectionUtils.isEmpty(userIdList)) {
                        UsersAndOrgsMo mo = new UsersAndOrgsMo();
                        mo.setGroupId(groupId);
                        mo.setUserIdList(userIdList);
                        mo.setShowDepartment(Boolean.valueOf(true));
                        com.ovopark.organize.common.base.BaseResult base = TrainingCourseServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                        if (base != null) {
                            shopMap = (Map)base.getData();
                        }
                    }
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[14]) && str[14].equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.assign.time", null, locale));
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[15]) && str[15].equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.analysis.starttime", null, locale));
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[16]) && str[16].equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.analysis.endtime", null, locale));
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[17]) && str[17].equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.analysis.study.status", null, locale));
                }
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String unStart = TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.status.unstart", null, locale);
                String going = TrainingCourseServiceImpl.this.messageSource.getMessage("training.job.status.going", null, locale);
                String completed = TrainingCourseServiceImpl.this.messageSource.getMessage("training.job.status.completed", null, locale);
                String timeOut = TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.time.out", null, locale);
                String timeIn = TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.time.in", null, locale);
                for (int i = 0; i < list.size(); ++i) {
                    List pojoList;
                    currentNum = 0;
                    row = sheet.createRow(i + 1);
                    TrainingCourseUserTaskVo vo = list.get(i);
                    row.createCell(0).setCellValue((double)vo.getUserId().intValue());
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[1]) && str[1].equals("1")) {
                        row.createCell(++currentNum).setCellValue(vo.getShowName());
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[2]) && str[2].equals("1")) {
                        row.createCell(++currentNum).setCellValue(vo.getUserName());
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[3]) && str[3].equals("1")) {
                        row.createCell(++currentNum).setCellValue(vo.getEmployeeNumber());
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[4]) && str[4].equals("1")) {
                        String roleName = "";
                        if (!org.springframework.util.StringUtils.isEmpty(roleMap) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)roleMap.get(vo.getUserId())))) {
                            List listStr = pojoList.stream().map(RolePojo::getRoleName).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                            roleName = StringUtils.join(listStr, (String)",");
                        }
                        row.createCell(++currentNum).setCellValue(roleName);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[5]) && str[5].equals("1")) {
                        row.createCell(++currentNum).setCellValue(vo.getPost());
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[6]) && str[6].equals("1")) {
                        row.createCell(++currentNum).setCellValue(vo.getParentName());
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[7]) && str[7].equals("1")) {
                        String organizeName = "";
                        List<String> nameList = organizeMap.get(vo.getUserId());
                        if (!CollectionUtils.isEmpty(nameList)) {
                            organizeName = String.join((CharSequence)";\n", nameList);
                        }
                        XSSFCell cell = row.createCell(++currentNum);
                        cell.setCellValue(organizeName);
                        cell.setCellStyle((CellStyle)titleSty);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[8]) && str[8].equals("1")) {
                        String organName1 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap1) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)organMap1.get(vo.getUserId())))) {
                            pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                            organName1 = StringUtils.join((Collection)pojoList, (String)",");
                        }
                        row.createCell(++currentNum).setCellValue(organName1);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[9]) && str[9].equals("1")) {
                        String organName2 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap2) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)organMap2.get(vo.getUserId())))) {
                            pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                            organName2 = StringUtils.join((Collection)pojoList, (String)",");
                        }
                        row.createCell(++currentNum).setCellValue(organName2);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[10]) && str[10].equals("1")) {
                        String organName3 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap3) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)organMap3.get(vo.getUserId())))) {
                            pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                            organName3 = StringUtils.join((Collection)pojoList, (String)",");
                        }
                        row.createCell(++currentNum).setCellValue(organName3);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[11]) && str[11].equals("1")) {
                        String organName4 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap4) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)organMap4.get(vo.getUserId())))) {
                            pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                            organName4 = StringUtils.join((Collection)pojoList, (String)",");
                        }
                        row.createCell(++currentNum).setCellValue(organName4);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[12]) && str[12].equals("1")) {
                        String organName5 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap5) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)organMap5.get(vo.getUserId())))) {
                            pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                            organName5 = StringUtils.join(pojoList, (String)",");
                        }
                        row.createCell(++currentNum).setCellValue(organName5);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[13]) && str[13].equals("1")) {
                        String shopName = "";
                        if (!org.springframework.util.StringUtils.isEmpty(shopMap) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)shopMap.get(vo.getUserId())))) {
                            pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                            shopName = StringUtils.join(pojoList, (String)",");
                        }
                        row.createCell(++currentNum).setCellValue(shopName);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[14]) && str[14].equals("1")) {
                        row.createCell(++currentNum).setCellValue(vo.getAppointTime() == null ? "-" : format.format(vo.getAppointTime()));
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[15]) && str[15].equals("1")) {
                        row.createCell(++currentNum).setCellValue(vo.getTaskStatus() == 2 || vo.getTaskStatus() == 3 || vo.getTaskStatus() == 4 ? (vo.getStartTime() == null ? "-" : format.format(vo.getStartTime())) : "-");
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[16]) && str[16].equals("1")) {
                        row.createCell(++currentNum).setCellValue(vo.getTaskStatus() == 3 || vo.getTaskStatus() == 4 ? (vo.getEndTime() == null ? "-" : format.format(vo.getEndTime())) : "-");
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[17]) && str[17].equals("1")) {
                        String statusName = "";
                        if (vo.getTaskStatus() == 1) {
                            statusName = unStart + " " + vo.getFinishNum() + "/" + vo.getTaskNum();
                        } else if (vo.getTaskStatus() == 2) {
                            statusName = going + " " + vo.getFinishNum() + "/" + vo.getTaskNum();
                        } else if (vo.getTaskStatus() == 3) {
                            statusName = completed + "(" + timeIn + ") " + vo.getFinishNum() + "/" + vo.getTaskNum();
                        } else if (vo.getTaskStatus() == 4) {
                            statusName = completed + "(" + timeOut + ") " + vo.getFinishNum() + "/" + vo.getTaskNum();
                        }
                        row.createCell(++currentNum).setCellValue(statusName);
                    }
                    sheet.autoSizeColumn(i + 1);
                }
                try {
                    DownloadUtils.successExportTask((Workbook)wb, exportTaskPojo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DownloadUtils.errorExportTask(exportTaskPojo);
                }
            }
        });
        taskList.add(exportTaskPojo);
        return JsonResult.success(taskList);
    }

    @Override
    public String selectCourseMaterialByExecl(final Integer taskId, final String name, final Integer status, String excelStr, final Users user) {
        final Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        JSONObject param = new JSONObject();
        param.fluentPut("courseId", (Object)taskId).fluentPut("name", (Object)name).fluentPut("status", (Object)status).fluentPut("user", (Object)user);
        TrainingCourseStageTask task = this.trainingApi.getTrainingCourseStageTaskById(taskId);
        String fileName = MessageFormat.format("{0}_{1}_{2}", task.getTaskName(), this.messageSource.getMessage("training.course.student.details", null, locale), DateUtils.format((Date)new Date(), (String)"yyyyMMdd"));
        fileName = ExcelUtil.getFileName(fileName) + ".xlsx";
        ArrayList<ExportTaskPojo> taskList = new ArrayList<ExportTaskPojo>();
        final ExportTaskPojo exportTaskPojo = DownloadUtils.saveExportTask(fileName, param.toJSONString(), 24);
        final String finalFileName = this.messageSource.getMessage("training.course.student.details", null, locale);
        ThreadPoolUtil.getThreadPoolExecutor().execute(new Runnable(){

            @Override
            public void run() {
                XSSFWorkbook wb = new XSSFWorkbook();
                XSSFSheet sheet = wb.createSheet(finalFileName);
                List<TrainingCourseUserTaskVo> list = TrainingCourseServiceImpl.this.trainingApi.getCourseTrainingList(taskId, name, status, user.getGroupId(), user.getId());
                XSSFCellStyle titleSty = wb.createCellStyle();
                XSSFFont font = wb.createFont();
                font.setFontHeightInPoints((short)16);
                titleSty.setFont((Font)font);
                sheet.setColumnWidth(0, 3000);
                XSSFRow row = sheet.createRow(0);
                row.createCell(0).setCellValue("id");
                row.createCell(1).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.job.account.number", null, locale));
                row.createCell(2).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.user.details.name", null, locale));
                row.createCell(3).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.user.details.employeeNumber", null, locale));
                row.createCell(4).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.analysis.role", null, locale));
                row.createCell(5).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.job.post.name", null, locale));
                row.createCell(6).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.analysis.superior", null, locale));
                row.createCell(7).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.analysis.department", null, locale));
                row.createCell(8).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.analysis.starttime", null, locale));
                row.createCell(9).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.analysis.endtime", null, locale));
                row.createCell(10).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.job.course.learnCount", null, locale));
                row.createCell(11).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.analysis.study.time", null, locale));
                row.createCell(12).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.paper.status", null, locale));
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                for (int i = 0; i < list.size(); ++i) {
                    row = sheet.createRow(i + 1);
                    TrainingCourseUserTaskVo vo = list.get(i);
                    row.createCell(0).setCellValue((double)vo.getUserId().intValue());
                    row.createCell(1).setCellValue(vo.getUserAccount());
                    row.createCell(2).setCellValue(vo.getUserName());
                    row.createCell(3).setCellValue(vo.getEmployeeNumber());
                    row.createCell(4).setCellValue(vo.getRole());
                    row.createCell(5).setCellValue(vo.getPost());
                    row.createCell(6).setCellValue(vo.getParentName());
                    row.createCell(7).setCellValue(vo.getOrganizeName());
                    row.createCell(8).setCellValue(vo.getTaskStatus() != 1 ? (vo.getStartTime() == null ? "-" : format.format(vo.getStartTime())) : "-");
                    row.createCell(9).setCellValue(vo.getTaskStatus() == 3 || vo.getTaskStatus() == 4 ? (vo.getEndTime() == null ? "-" : format.format(vo.getEndTime())) : "-");
                    row.createCell(10).setCellValue(vo.getLearnCount() == null ? 0.0 : (double)vo.getLearnCount().intValue());
                    row.createCell(11).setCellValue(vo.getTimeStr());
                    String statusName = TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.status.ing", null, locale);
                    if (vo.getTaskStatus() == 1) {
                        statusName = TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.status.unstart", null, locale);
                    } else if (vo.getTaskStatus() == 3 || vo.getTaskStatus() == 4) {
                        statusName = TrainingCourseServiceImpl.this.messageSource.getMessage("training.job.status.completed", null, locale);
                    }
                    row.createCell(12).setCellValue(statusName);
                }
                try {
                    DownloadUtils.successExportTask((Workbook)wb, exportTaskPojo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DownloadUtils.errorExportTask(exportTaskPojo);
                }
            }
        });
        taskList.add(exportTaskPojo);
        return JsonResult.success(taskList);
    }

    @Override
    public String selectCourseTrainingByExecl(final Integer taskId, final String name, final Integer status, String excelStr, final Integer exportStatus, final Users user) {
        final Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        JSONObject param = new JSONObject();
        param.fluentPut("courseId", (Object)taskId).fluentPut("name", (Object)name).fluentPut("status", (Object)status).fluentPut("user", (Object)user);
        TrainingCourseStageTask task = this.trainingApi.getTrainingCourseStageTaskById(taskId);
        String fileName = MessageFormat.format("{0}_{1}_{2}", task.getTaskName(), this.messageSource.getMessage("training.course.student.details", null, locale), DateUtils.format((Date)new Date(), (String)"yyyyMMdd"));
        fileName = ExcelUtil.getFileName(fileName) + ".xlsx";
        ArrayList<ExportTaskPojo> taskList = new ArrayList<ExportTaskPojo>();
        final ExportTaskPojo exportTaskPojo = DownloadUtils.saveExportTask(fileName, param.toJSONString(), 25);
        final String finalFileName = this.messageSource.getMessage("training.course.student.details", null, locale);
        ThreadPoolUtil.getThreadPoolExecutor().execute(new Runnable(){

            @Override
            public void run() {
                XSSFWorkbook wb = new XSSFWorkbook();
                XSSFSheet sheet = wb.createSheet(finalFileName);
                List<TrainingCourseUserTaskVo> list = TrainingCourseServiceImpl.this.trainingApi.getCourseTrainingList(taskId, name, status, user.getGroupId(), user.getId());
                XSSFCellStyle titleSty = wb.createCellStyle();
                XSSFFont font = wb.createFont();
                font.setFontHeightInPoints((short)16);
                titleSty.setFont((Font)font);
                sheet.setColumnWidth(0, 3000);
                if (exportStatus == null || exportStatus == 1) {
                    HashMap organMap1 = new HashMap();
                    HashMap organMap2 = new HashMap();
                    HashMap organMap3 = new HashMap();
                    HashMap organMap4 = new HashMap();
                    HashMap organMap5 = new HashMap();
                    HashMap shopMap = new HashMap();
                    font.setFontHeightInPoints((short)16);
                    titleSty.setFont((Font)font);
                    XSSFRow row = sheet.createRow(0);
                    row.createCell(0).setCellValue("id");
                    row.createCell(1).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.job.account.number", null, locale));
                    row.createCell(2).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.user.details.name", null, locale));
                    row.createCell(3).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.user.details.employeeNumber", null, locale));
                    row.createCell(4).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.analysis.role", null, locale));
                    row.createCell(5).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.job.post.name", null, locale));
                    row.createCell(6).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.analysis.superior", null, locale));
                    row.createCell(7).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.analysis.department", null, locale));
                    row.createCell(8).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.analysis.first.organize", null, locale));
                    row.createCell(9).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.analysis.second.organize", null, locale));
                    row.createCell(10).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.analysis.third.organize", null, locale));
                    row.createCell(11).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.analysis.fourth.organize", null, locale));
                    row.createCell(12).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.analysis.fifth.organize", null, locale));
                    row.createCell(13).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.analysis.dep", null, locale));
                    row.createCell(14).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.analysis.starttime", null, locale));
                    row.createCell(15).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.analysis.endtime", null, locale));
                    row.createCell(16).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.job.course.learnCount", null, locale));
                    row.createCell(17).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.analysis.study.time", null, locale));
                    row.createCell(18).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.paper.status", null, locale));
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    for (int i = 0; i < list.size(); ++i) {
                        List pojoList;
                        List pojoList2;
                        List pojoList3;
                        List pojoList4;
                        List pojoList5;
                        List pojoList6;
                        row = sheet.createRow(i + 1);
                        TrainingCourseUserTaskVo vo = list.get(i);
                        row.createCell(0).setCellValue((double)vo.getUserId().intValue());
                        row.createCell(1).setCellValue(vo.getUserAccount());
                        row.createCell(2).setCellValue(vo.getUserName());
                        row.createCell(3).setCellValue(vo.getEmployeeNumber());
                        row.createCell(4).setCellValue(vo.getRole());
                        row.createCell(5).setCellValue(vo.getPost());
                        ArrayList<Integer> userIdList = new ArrayList<Integer>();
                        userIdList.add(vo.getUserId());
                        String parentName = "";
                        if (!org.springframework.util.StringUtils.isEmpty(TrainingCourseServiceImpl.this.userUtilService.selectParentMap(userIdList, vo.getEnterpriseId()))) {
                            parentName = TrainingCourseServiceImpl.this.userUtilService.selectParentMap(userIdList, vo.getEnterpriseId()).get(vo.getUserId());
                        }
                        row.createCell(6).setCellValue(parentName);
                        String organName1 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap1) && !CollectionUtils.isEmpty((Collection)(pojoList6 = (List)organMap1.get(vo.getUserId())))) {
                            pojoList6 = pojoList6.stream().distinct().collect(Collectors.toList());
                            organName1 = StringUtils.join(pojoList6, (String)",");
                        }
                        Map<Integer, List<String>> userOrganizeMap = TrainingCourseServiceImpl.this.userUtilService.selectOrganizeMap(userIdList, vo.getEnterpriseId());
                        List<String> userStr = userOrganizeMap.get(vo.getUserId());
                        row.createCell(7).setCellValue(CollectionUtils.isEmpty(userStr) ? "" : userStr.get(0));
                        row.createCell(8).setCellValue(organName1);
                        String organName2 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap2) && !CollectionUtils.isEmpty((Collection)(pojoList5 = (List)organMap2.get(vo.getUserId())))) {
                            pojoList5 = pojoList5.stream().distinct().collect(Collectors.toList());
                            organName2 = StringUtils.join(pojoList5, (String)",");
                        }
                        row.createCell(9).setCellValue(organName2);
                        String organName3 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap3) && !CollectionUtils.isEmpty((Collection)(pojoList4 = (List)organMap3.get(vo.getUserId())))) {
                            pojoList4 = pojoList4.stream().distinct().collect(Collectors.toList());
                            organName3 = StringUtils.join(pojoList4, (String)",");
                        }
                        row.createCell(10).setCellValue(organName3);
                        String organName4 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap4) && !CollectionUtils.isEmpty((Collection)(pojoList3 = (List)organMap4.get(vo.getUserId())))) {
                            pojoList3 = pojoList3.stream().distinct().collect(Collectors.toList());
                            organName4 = StringUtils.join(pojoList3, (String)",");
                        }
                        row.createCell(11).setCellValue(organName4);
                        String organName5 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap5) && !CollectionUtils.isEmpty((Collection)(pojoList2 = (List)organMap5.get(vo.getUserId())))) {
                            pojoList2 = pojoList2.stream().distinct().collect(Collectors.toList());
                            organName5 = StringUtils.join(pojoList2, (String)",");
                        }
                        row.createCell(12).setCellValue(organName5);
                        String shopName = "";
                        if (!org.springframework.util.StringUtils.isEmpty(shopMap) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)shopMap.get(vo.getUserId())))) {
                            pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                            shopName = StringUtils.join(pojoList, (String)",");
                        }
                        row.createCell(13).setCellValue(shopName);
                        row.createCell(14).setCellValue(vo.getTaskStatus() != 1 ? (vo.getStartTime() == null ? "-" : format.format(vo.getStartTime())) : "-");
                        row.createCell(15).setCellValue(vo.getTaskStatus() == 3 || vo.getTaskStatus() == 4 ? (vo.getEndTime() == null ? "-" : format.format(vo.getEndTime())) : "-");
                        row.createCell(16).setCellValue(vo.getLearnCount() == null ? 0.0 : (double)vo.getLearnCount().intValue());
                        row.createCell(17).setCellValue(vo.getTimeStr());
                        String statusName = TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.status.ing", null, locale);
                        if (vo.getTaskStatus() == 1) {
                            statusName = TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.status.unstart", null, locale);
                        } else if (vo.getTaskStatus() == 3 || vo.getTaskStatus() == 4) {
                            statusName = TrainingCourseServiceImpl.this.messageSource.getMessage("training.job.status.completed", null, locale);
                        }
                        row.createCell(18).setCellValue(statusName);
                    }
                } else if (exportStatus == 2) {
                    // empty if block
                }
                try {
                    DownloadUtils.successExportTask((Workbook)wb, exportTaskPojo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DownloadUtils.errorExportTask(exportTaskPojo);
                }
            }
        });
        taskList.add(exportTaskPojo);
        return JsonResult.success(taskList);
    }

    @Override
    public String selectCoursePaperByExecl(final Integer taskId, final String name, final Integer status, String excelStr, final Integer exportStatus, final Users user) {
        final Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        JSONObject param = new JSONObject();
        param.fluentPut("courseId", (Object)taskId).fluentPut("name", (Object)name).fluentPut("status", (Object)status).fluentPut("user", (Object)user);
        TrainingCourseStageTask task = this.trainingApi.getTrainingCourseStageTaskById(taskId);
        String fileName = "";
        String fileName2 = "";
        if (exportStatus == null || exportStatus == 1) {
            fileName = MessageFormat.format("{0}_{1}_{2}", task.getTaskName(), this.messageSource.getMessage("training.paper.result", null, locale), DateUtils.format((Date)new Date(), (String)"yyyyMMdd"));
            fileName2 = this.messageSource.getMessage("training.paper.result", null, locale);
        } else if (exportStatus == 2) {
            fileName = MessageFormat.format("{0}_{1}_{2}", task.getTaskName(), this.messageSource.getMessage("training.paper.result.details", null, locale), DateUtils.format((Date)new Date(), (String)"yyyyMMdd"));
            fileName2 = this.messageSource.getMessage("training.paper.result.details", null, locale);
        }
        fileName = ExcelUtil.getFileName(fileName) + ".xlsx";
        ArrayList<ExportTaskPojo> taskList = new ArrayList<ExportTaskPojo>();
        final ExportTaskPojo exportTaskPojo = DownloadUtils.saveExportTask(fileName, param.toJSONString(), 26);
        final String finalFileName = fileName2;
        ThreadPoolUtil.getThreadPoolExecutor().execute(new Runnable(){

            @Override
            public void run() {
                String statusName;
                TrainingCourseUserTaskVo vo;
                XSSFWorkbook wb = new XSSFWorkbook();
                XSSFSheet sheet = wb.createSheet(finalFileName);
                XSSFCellStyle titleSty = wb.createCellStyle();
                XSSFFont font = wb.createFont();
                font.setFontHeightInPoints((short)16);
                titleSty.setFont((Font)font);
                sheet.setColumnWidth(0, 3000);
                List<Object> list = new ArrayList();
                if (exportStatus == null || exportStatus == 1) {
                    list = TrainingCourseServiceImpl.this.trainingApi.getCourseTrainingList(taskId, name, status, user.getGroupId(), user.getId());
                } else if (exportStatus == 2) {
                    list = TrainingCourseServiceImpl.this.trainingApi.getCourseTrainingList2(taskId, name, status, user.getGroupId(), user.getId());
                }
                List<Integer> userIdList = list.stream().map(TrainingCourseUserTask::getUserId).distinct().collect(Collectors.toList());
                Map<Integer, List<String>> organizeMap = TrainingCourseServiceImpl.this.userUtilService.selectOrganizeMap(userIdList, user.getGroupId());
                HashMap roleMap = new HashMap();
                Map organMap1 = new HashMap();
                Map organMap2 = new HashMap();
                Map organMap3 = new HashMap();
                Map organMap4 = new HashMap();
                Map organMap5 = new HashMap();
                Map shopMap = new HashMap();
                Map shopDetailMap = new HashMap();
                if (!CollectionUtils.isEmpty(userIdList)) {
                    UsersAndOrgsMo mo = new UsersAndOrgsMo();
                    mo.setGroupId(((TrainingCourseUserTaskVo)list.get(0)).getEnterpriseId());
                    mo.setLevelList(Collections.singletonList(1));
                    mo.setUserIdList(userIdList);
                    mo.setShowDepartment(Boolean.valueOf(false));
                    com.ovopark.organize.common.base.BaseResult base1 = TrainingCourseServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                    if (base1 != null) {
                        organMap1 = (Map)base1.getData();
                    }
                    mo.setLevelList(Collections.singletonList(2));
                    com.ovopark.organize.common.base.BaseResult base2 = TrainingCourseServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                    if (base2 != null) {
                        organMap2 = (Map)base2.getData();
                    }
                    mo.setLevelList(Collections.singletonList(3));
                    com.ovopark.organize.common.base.BaseResult base3 = TrainingCourseServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                    if (base3 != null) {
                        organMap3 = (Map)base3.getData();
                    }
                    mo.setLevelList(Collections.singletonList(4));
                    com.ovopark.organize.common.base.BaseResult base4 = TrainingCourseServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                    if (base4 != null) {
                        organMap4 = (Map)base4.getData();
                    }
                    mo.setLevelList(Collections.singletonList(5));
                    com.ovopark.organize.common.base.BaseResult base5 = TrainingCourseServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                    if (base5 != null) {
                        organMap5 = (Map)base5.getData();
                    }
                    UsersAndOrgsMo mo1 = new UsersAndOrgsMo();
                    mo1.setGroupId(((TrainingCourseUserTaskVo)list.get(0)).getEnterpriseId());
                    mo1.setUserIdList(userIdList);
                    mo1.setShowDepartment(Boolean.valueOf(true));
                    com.ovopark.organize.common.base.BaseResult base = TrainingCourseServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo1);
                    if (base != null && base.getData() != null) {
                        shopMap = (Map)base.getData();
                    }
                    mo1.setShowAllPath(Boolean.valueOf(true));
                    com.ovopark.organize.common.base.BaseResult bases = TrainingCourseServiceImpl.this.userOrganizeApi.getUserOrganizePathtByUserIds(mo1);
                    if (bases != null && bases.getData() != null) {
                        shopDetailMap = (Map)bases.getData();
                    }
                }
                XSSFRow row = sheet.createRow(0);
                row.createCell(0).setCellValue("id");
                row.createCell(1).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.job.account.number", null, locale));
                row.createCell(2).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.user.details.name", null, locale));
                row.createCell(3).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.user.details.employeeNumber", null, locale));
                row.createCell(4).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.analysis.role", null, locale));
                row.createCell(5).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.job.post.name", null, locale));
                row.createCell(6).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.analysis.superior", null, locale));
                row.createCell(7).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.analysis.department", null, locale));
                row.createCell(8).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.analysis.first.organize", null, locale));
                row.createCell(9).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.analysis.second.organize", null, locale));
                row.createCell(10).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.analysis.third.organize", null, locale));
                row.createCell(11).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.analysis.fourth.organize", null, locale));
                row.createCell(12).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.analysis.fifth.organize", null, locale));
                row.createCell(13).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.analysis.dep", null, locale));
                for (int i = 0; i < list.size(); ++i) {
                    List pojoList;
                    List pojoList2;
                    List pojoList3;
                    List pojoList4;
                    List pojoList5;
                    List pojoList6;
                    row = sheet.createRow(i + 1);
                    TrainingCourseUserTaskVo vo2 = (TrainingCourseUserTaskVo)list.get(i);
                    row.createCell(0).setCellValue(String.valueOf(vo2.getUserId()));
                    row.createCell(1).setCellValue(vo2.getUserAccount());
                    row.createCell(2).setCellValue(vo2.getUserName());
                    row.createCell(3).setCellValue(vo2.getEmployeeNumber());
                    row.createCell(4).setCellValue(vo2.getRole());
                    row.createCell(5).setCellValue(vo2.getPost());
                    row.createCell(6).setCellValue(vo2.getParentName());
                    String organName1 = "";
                    if (!org.springframework.util.StringUtils.isEmpty(organMap1) && !CollectionUtils.isEmpty((Collection)(pojoList6 = (List)organMap1.get(vo2.getUserId())))) {
                        pojoList6 = pojoList6.stream().distinct().collect(Collectors.toList());
                        organName1 = StringUtils.join(pojoList6, (String)",");
                    }
                    String departName = "";
                    List<String> nameList = organizeMap.get(vo2.getUserId());
                    if (!CollectionUtils.isEmpty(nameList)) {
                        departName = String.join((CharSequence)";\n", nameList);
                    }
                    row.createCell(7).setCellValue(departName);
                    row.createCell(8).setCellValue(organName1);
                    String organName2 = "";
                    if (!org.springframework.util.StringUtils.isEmpty(organMap2) && !CollectionUtils.isEmpty((Collection)(pojoList5 = (List)organMap2.get(vo2.getUserId())))) {
                        pojoList5 = pojoList5.stream().distinct().collect(Collectors.toList());
                        organName2 = StringUtils.join(pojoList5, (String)",");
                    }
                    row.createCell(9).setCellValue(organName2);
                    String organName3 = "";
                    if (!org.springframework.util.StringUtils.isEmpty(organMap3) && !CollectionUtils.isEmpty((Collection)(pojoList4 = (List)organMap3.get(vo2.getUserId())))) {
                        pojoList4 = pojoList4.stream().distinct().collect(Collectors.toList());
                        organName3 = StringUtils.join(pojoList4, (String)",");
                    }
                    row.createCell(10).setCellValue(organName3);
                    String organName4 = "";
                    if (!org.springframework.util.StringUtils.isEmpty(organMap4) && !CollectionUtils.isEmpty((Collection)(pojoList3 = (List)organMap4.get(vo2.getUserId())))) {
                        pojoList3 = pojoList3.stream().distinct().collect(Collectors.toList());
                        organName4 = StringUtils.join(pojoList3, (String)",");
                    }
                    row.createCell(11).setCellValue(organName4);
                    String organName5 = "";
                    if (!org.springframework.util.StringUtils.isEmpty(organMap5) && !CollectionUtils.isEmpty((Collection)(pojoList2 = (List)organMap5.get(vo2.getUserId())))) {
                        pojoList2 = pojoList2.stream().distinct().collect(Collectors.toList());
                        organName5 = StringUtils.join(pojoList2, (String)",");
                    }
                    row.createCell(12).setCellValue(organName5);
                    String shopName = "";
                    if (!org.springframework.util.StringUtils.isEmpty(shopMap) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)shopMap.get(vo2.getUserId())))) {
                        pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                        shopName = StringUtils.join(pojoList, (String)",");
                    }
                    row.createCell(13).setCellValue(shopName);
                }
                if (exportStatus == null || exportStatus == 1) {
                    row = sheet.getRow(0);
                    row.createCell(14).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.paper.finish.time", null, locale));
                    row.createCell(15).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.paper.num", null, locale));
                    row.createCell(16).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.average.time", null, locale));
                    row.createCell(17).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.paper.score", null, locale));
                    row.createCell(18).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.paper.status", null, locale));
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    for (int i = 0; i < list.size(); ++i) {
                        row = sheet.getRow(i + 1);
                        vo = (TrainingCourseUserTaskVo)list.get(i);
                        row.createCell(14).setCellValue(vo.getTaskStatus() == 3 || vo.getTaskStatus() == 4 || vo.getTaskStatus() == 5 || vo.getTaskStatus() == 6 ? (vo.getEndTime() == null ? "-" : format.format(vo.getEndTime())) : "-");
                        row.createCell(15).setCellValue((vo.getTaskStatus() == 3 || vo.getTaskStatus() == 4 || vo.getTaskStatus() == 5 || vo.getTaskStatus() == 6) && vo.getPaperCount() != null ? vo.getPaperCount().toString() : "-");
                        row.createCell(16).setCellValue(vo.getTaskStatus() == 3 || vo.getTaskStatus() == 4 || vo.getTaskStatus() == 5 || vo.getTaskStatus() == 6 ? vo.getTimeStr() : "-");
                        row.createCell(17).setCellValue((vo.getTaskStatus() == 3 || vo.getTaskStatus() == 4 || vo.getTaskStatus() == 5 || vo.getTaskStatus() == 6) && vo.getScore() != null && vo.getScore().compareTo(new BigDecimal(-1)) > 0 ? vo.getScore().toString() : "-");
                        statusName = TrainingCourseServiceImpl.this.messageSource.getMessage("training.paper.ing", null, locale);
                        if (vo.getTaskStatus() == 1) {
                            statusName = TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.status.unexam", null, locale);
                        } else if (vo.getTaskStatus() == 3 || vo.getTaskStatus() == 4) {
                            statusName = TrainingCourseServiceImpl.this.messageSource.getMessage("training.learn.pass", null, locale);
                        } else if (vo.getTaskStatus() == 5) {
                            statusName = TrainingCourseServiceImpl.this.messageSource.getMessage("training.learn.unpass", null, locale);
                        } else if (vo.getTaskStatus() == 6) {
                            statusName = TrainingCourseServiceImpl.this.messageSource.getMessage("training.learn.wait.read", null, locale);
                        }
                        row.createCell(18).setCellValue(statusName);
                    }
                } else if (exportStatus == 2) {
                    row = sheet.getRow(0);
                    row.createCell(14).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.paper.handtime", null, locale));
                    row.createCell(15).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.operate.usetime", null, locale));
                    row.createCell(16).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.paper.score", null, locale));
                    row.createCell(17).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.paper.status", null, locale));
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    for (int i = 0; i < list.size(); ++i) {
                        row = sheet.getRow(i + 1);
                        vo = (TrainingCourseUserTaskVo)list.get(i);
                        row.createCell(14).setCellValue(vo.getCommitTime() == null ? "-" : format.format(vo.getCommitTime()));
                        row.createCell(15).setCellValue(vo.getTimeStr() == null ? "-" : vo.getTimeStr());
                        statusName = "";
                        String score = "";
                        if (vo.getTaskStatus() == 1) {
                            String unexam;
                            statusName = unexam = TrainingCourseServiceImpl.this.messageSource.getMessage("training.paper.unexam", null, locale);
                            score = "-";
                        } else if (vo.getTaskStatus() == 2) {
                            statusName = TrainingCourseServiceImpl.this.messageSource.getMessage("training.paper.ing", null, locale);
                            score = "-";
                        } else if (vo.getTaskStatus() == 3) {
                            statusName = TrainingCourseServiceImpl.this.messageSource.getMessage("training.learn.pass", null, locale);
                            score = String.valueOf(vo.getScore());
                        } else if (vo.getTaskStatus() == 4) {
                            statusName = TrainingCourseServiceImpl.this.messageSource.getMessage("training.learn.unpass", null, locale);
                            score = String.valueOf(vo.getScore());
                        } else if (vo.getTaskStatus() == 5) {
                            statusName = TrainingCourseServiceImpl.this.messageSource.getMessage("training.learn.wait.read", null, locale);
                            score = "-";
                        }
                        row.createCell(16).setCellValue(score);
                        row.createCell(17).setCellValue(statusName);
                    }
                }
                try {
                    DownloadUtils.successExportTask((Workbook)wb, exportTaskPojo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DownloadUtils.errorExportTask(exportTaskPojo);
                }
            }
        });
        taskList.add(exportTaskPojo);
        return JsonResult.success(taskList);
    }

    @Override
    public String selectCourseWorkByExecl(final Integer taskId, final String name, final Integer status, final Users user) {
        final Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        JSONObject param = new JSONObject();
        param.fluentPut("courseId", (Object)taskId).fluentPut("name", (Object)name).fluentPut("status", (Object)status).fluentPut("user", (Object)user);
        TrainingCourseStageTask task = this.trainingApi.getTrainingCourseStageTaskById(taskId);
        String fileName = MessageFormat.format("{0}_{1}_{2}", task.getTaskName(), this.messageSource.getMessage("training.paper.answer.result", null, locale), DateUtils.format((Date)new Date(), (String)"yyyyMMdd"));
        fileName = ExcelUtil.getFileName(fileName) + ".xlsx";
        ArrayList<ExportTaskPojo> taskList = new ArrayList<ExportTaskPojo>();
        final ExportTaskPojo exportTaskPojo = DownloadUtils.saveExportTask(fileName, param.toJSONString(), 27);
        final String finalFileName = this.messageSource.getMessage("training.paper.answer.result", null, locale);
        ThreadPoolUtil.getThreadPoolExecutor().execute(new Runnable(){

            @Override
            public void run() {
                List<Integer> userIdList;
                XSSFWorkbook wb = new XSSFWorkbook();
                XSSFSheet sheet = wb.createSheet(finalFileName);
                List<TrainingCourseUserTaskVo> list = TrainingCourseServiceImpl.this.trainingApi.getCourseTrainingList(taskId, name, status, user.getGroupId(), user.getId());
                XSSFCellStyle titleSty = wb.createCellStyle();
                XSSFFont font = wb.createFont();
                font.setFontHeightInPoints((short)16);
                titleSty.setFont((Font)font);
                sheet.setColumnWidth(0, 3000);
                Map<Object, Object> roleMap = new HashMap();
                Map<Object, Object> parentMap = new HashMap();
                Map organMap1 = new HashMap();
                Map organMap2 = new HashMap();
                Map organMap3 = new HashMap();
                Map organMap4 = new HashMap();
                Map organMap5 = new HashMap();
                Map shopMap = new HashMap();
                if (!CollectionUtils.isEmpty(list) && !CollectionUtils.isEmpty(userIdList = list.stream().map(TrainingCourseUserTask::getUserId).distinct().collect(Collectors.toList()))) {
                    roleMap = TrainingCourseServiceImpl.this.userUtilService.selectRolesByUsers(userIdList, user.getGroupId());
                    parentMap = TrainingCourseServiceImpl.this.userUtilService.selectParentMap(userIdList, user.getGroupId());
                    UsersAndOrgsMo mo = new UsersAndOrgsMo();
                    mo.setGroupId(user.getGroupId());
                    mo.setLevelList(Collections.singletonList(1));
                    mo.setUserIdList(userIdList);
                    mo.setShowDepartment(Boolean.valueOf(false));
                    com.ovopark.organize.common.base.BaseResult base1 = TrainingCourseServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                    if (base1 != null) {
                        organMap1 = (Map)base1.getData();
                    }
                    mo.setLevelList(Collections.singletonList(2));
                    com.ovopark.organize.common.base.BaseResult base2 = TrainingCourseServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                    if (base2 != null) {
                        organMap2 = (Map)base2.getData();
                    }
                    mo.setLevelList(Collections.singletonList(3));
                    com.ovopark.organize.common.base.BaseResult base3 = TrainingCourseServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                    if (base3 != null) {
                        organMap3 = (Map)base3.getData();
                    }
                    mo.setLevelList(Collections.singletonList(4));
                    com.ovopark.organize.common.base.BaseResult base4 = TrainingCourseServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                    if (base4 != null) {
                        organMap4 = (Map)base4.getData();
                    }
                    mo.setLevelList(Collections.singletonList(5));
                    com.ovopark.organize.common.base.BaseResult base5 = TrainingCourseServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                    if (base5 != null) {
                        organMap5 = (Map)base5.getData();
                    }
                    UsersAndOrgsMo mo1 = new UsersAndOrgsMo();
                    mo1.setGroupId(user.getGroupId());
                    mo1.setUserIdList(userIdList);
                    mo1.setShowDepartment(Boolean.valueOf(true));
                    com.ovopark.organize.common.base.BaseResult base = TrainingCourseServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo1);
                    if (base != null) {
                        shopMap = (Map)base.getData();
                    }
                }
                XSSFRow row = sheet.createRow(0);
                row.createCell(0).setCellValue("id");
                row.createCell(1).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.job.account.number", null, locale));
                row.createCell(2).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.trainee.name", null, locale));
                row.createCell(3).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.user.details.employeeNumber", null, locale));
                row.createCell(4).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.analysis.role", null, locale));
                row.createCell(5).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.job.post.name", null, locale));
                row.createCell(6).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.analysis.superior", null, locale));
                row.createCell(7).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.learn.department", null, locale));
                row.createCell(8).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.analysis.first.organize", null, locale));
                row.createCell(9).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.analysis.second.organize", null, locale));
                row.createCell(10).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.analysis.third.organize", null, locale));
                row.createCell(11).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.analysis.fourth.organize", null, locale));
                row.createCell(12).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.analysis.fifth.organize", null, locale));
                row.createCell(13).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.analysis.dep", null, locale));
                row.createCell(14).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.submit.time", null, locale));
                row.createCell(15).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.reply.num", null, locale));
                row.createCell(16).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.paper.score", null, locale));
                row.createCell(17).setCellValue(TrainingCourseServiceImpl.this.messageSource.getMessage("training.paper.status", null, locale));
                if (!CollectionUtils.isEmpty(list)) {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    for (int i = 0; i < list.size(); ++i) {
                        List pojoList;
                        List pojoList2;
                        List pojoList3;
                        List pojoList4;
                        List pojoList5;
                        List pojoList6;
                        row = sheet.createRow(i + 1);
                        TrainingCourseUserTaskVo vo = list.get(i);
                        row.createCell(0).setCellValue((double)vo.getUserId().intValue());
                        row.createCell(1).setCellValue(vo.getUserAccount());
                        row.createCell(2).setCellValue(vo.getUserName());
                        row.createCell(3).setCellValue(vo.getEmployeeNumber());
                        row.createCell(4).setCellValue(vo.getRole());
                        row.createCell(5).setCellValue(vo.getPost());
                        row.createCell(6).setCellValue(vo.getParentName());
                        String organName1 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap1) && !CollectionUtils.isEmpty((Collection)(pojoList6 = (List)organMap1.get(vo.getUserId())))) {
                            pojoList6 = pojoList6.stream().distinct().collect(Collectors.toList());
                            organName1 = StringUtils.join(pojoList6, (String)",");
                        }
                        row.createCell(7).setCellValue(vo.getOrganizeName());
                        row.createCell(8).setCellValue(organName1);
                        String organName2 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap2) && !CollectionUtils.isEmpty((Collection)(pojoList5 = (List)organMap2.get(vo.getUserId())))) {
                            pojoList5 = pojoList5.stream().distinct().collect(Collectors.toList());
                            organName2 = StringUtils.join(pojoList5, (String)",");
                        }
                        row.createCell(9).setCellValue(organName2);
                        String organName3 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap3) && !CollectionUtils.isEmpty((Collection)(pojoList4 = (List)organMap3.get(vo.getUserId())))) {
                            pojoList4 = pojoList4.stream().distinct().collect(Collectors.toList());
                            organName3 = StringUtils.join(pojoList4, (String)",");
                        }
                        row.createCell(10).setCellValue(organName3);
                        String organName4 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap4) && !CollectionUtils.isEmpty((Collection)(pojoList3 = (List)organMap4.get(vo.getUserId())))) {
                            pojoList3 = pojoList3.stream().distinct().collect(Collectors.toList());
                            organName4 = StringUtils.join(pojoList3, (String)",");
                        }
                        row.createCell(11).setCellValue(organName4);
                        String organName5 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap5) && !CollectionUtils.isEmpty((Collection)(pojoList2 = (List)organMap5.get(vo.getUserId())))) {
                            pojoList2 = pojoList2.stream().distinct().collect(Collectors.toList());
                            organName5 = StringUtils.join(pojoList2, (String)",");
                        }
                        row.createCell(12).setCellValue(organName5);
                        String shopName = "";
                        if (!org.springframework.util.StringUtils.isEmpty(shopMap) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)shopMap.get(vo.getUserId())))) {
                            pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                            shopName = StringUtils.join(pojoList, (String)",");
                        }
                        row.createCell(13).setCellValue(shopName);
                        row.createCell(14).setCellValue(vo.getCommitTime() == null ? "-" : format.format(vo.getCommitTime()));
                        row.createCell(15).setCellValue((double)vo.getAnswerCount().intValue());
                        row.createCell(16).setCellValue(vo.getScore() == null ? "" : vo.getScore().toString());
                        String statusName = TrainingCourseServiceImpl.this.messageSource.getMessage("training.job.status.pass", null, locale);
                        if (vo.getTaskStatus() == 6) {
                            statusName = TrainingCourseServiceImpl.this.messageSource.getMessage("training.learn.wait.read", null, locale);
                        } else if (vo.getTaskStatus() == 5) {
                            statusName = TrainingCourseServiceImpl.this.messageSource.getMessage("training.job.status.not.pass", null, locale);
                        } else if (vo.getTaskStatus() == 1) {
                            statusName = TrainingCourseServiceImpl.this.messageSource.getMessage("training.course.unsubmit", null, locale);
                        }
                        row.createCell(17).setCellValue(statusName);
                    }
                }
                try {
                    DownloadUtils.successExportTask((Workbook)wb, exportTaskPojo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DownloadUtils.errorExportTask(exportTaskPojo);
                }
            }
        });
        taskList.add(exportTaskPojo);
        return JsonResult.success(taskList);
    }
}

