/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ovopark.api.TrainingApi;
import com.ovopark.bo.Authenticator;
import com.ovopark.bo.JsonResult;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.common.model.mo.UsersAndOrgsMo;
import com.ovopark.organize.common.model.pojo.ExportTaskPojo;
import com.ovopark.organize.sdk.api.UserOrganizeApi;
import com.ovopark.pojo.TrainingJobUserTask;
import com.ovopark.pojo.TrainingJobUserTaskVo;
import com.ovopark.pojo.Users;
import com.ovopark.service.TrainingJobCertificationService;
import com.ovopark.service.UserUtilService;
import com.ovopark.utils.DateUtils;
import com.ovopark.utils.DownloadUtils;
import com.ovopark.utils.ExcelUtil;
import com.ovopark.utils.ThreadPoolUtil;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TrainingJobCertificationServiceImpl
implements TrainingJobCertificationService {
    private static final Logger log = LoggerFactory.getLogger(TrainingJobCertificationServiceImpl.class);
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private TrainingApi trainingApi;
    @Autowired
    private UserUtilService userUtilService;
    @Autowired
    private UserOrganizeApi userOrganizeApi;

    @Override
    public String selectUserJobDetailByExcel(final Integer stageTaskId, final Integer taskStatus, String taskName, final String userName, final Users user) {
        final Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        JSONObject param = new JSONObject();
        param.fluentPut("stageTaskId", (Object)stageTaskId).fluentPut("taskStatus", (Object)taskStatus).fluentPut("taskName", (Object)taskName).fluentPut("userName", (Object)userName).fluentPut("user", (Object)user);
        taskName = ExcelUtil.getFileName(taskName);
        String fileName = MessageFormat.format("{0}_{1}_{2}.xlsx", taskName, this.messageSource.getMessage("training.course.student.details", null, locale), DateUtils.format((Date)new Date(), (String)"yyyyMMdd"));
        ArrayList<ExportTaskPojo> taskList = new ArrayList<ExportTaskPojo>();
        final ExportTaskPojo exportTaskPojo = DownloadUtils.saveExportTask(fileName, param.toJSONString(), 31);
        final String finalTaskName = taskName;
        ThreadPoolUtil.getThreadPoolExecutor().execute(new Runnable(){

            @Override
            public void run() {
                List<TrainingJobUserTaskVo> voList = TrainingJobCertificationServiceImpl.this.trainingApi.getJobUserTaskList(stageTaskId, taskStatus, userName, user);
                XSSFWorkbook wb = new XSSFWorkbook();
                XSSFSheet sheet = wb.createSheet(finalTaskName);
                sheet.setColumnWidth(0, 3000);
                XSSFRow row = sheet.createRow(0);
                row.createCell(0).setCellValue("id");
                row.createCell(1).setCellValue(TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.job.account.number", null, locale));
                row.createCell(2).setCellValue(TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.user.details.name", null, locale));
                row.createCell(3).setCellValue(TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.user.details.employeeNumber", null, locale));
                row.createCell(4).setCellValue(TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.course.analysis.role", null, locale));
                row.createCell(5).setCellValue(TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.job.post.name", null, locale));
                row.createCell(6).setCellValue(TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.course.analysis.superior", null, locale));
                row.createCell(7).setCellValue(TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.course.analysis.department", null, locale));
                row.createCell(8).setCellValue(TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.course.analysis.starttime", null, locale));
                row.createCell(9).setCellValue(TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.course.analysis.endtime", null, locale));
                row.createCell(10).setCellValue(TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.course.analysis.study.time", null, locale));
                row.createCell(11).setCellValue(TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.paper.status", null, locale));
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                for (int i = 0; i < voList.size(); ++i) {
                    row = sheet.createRow(i + 1);
                    TrainingJobUserTaskVo vo = voList.get(i);
                    row.createCell(0).setCellValue((double)vo.getUserId().intValue());
                    row.createCell(1).setCellValue(vo.getUserAccount());
                    row.createCell(2).setCellValue(vo.getUserName());
                    row.createCell(3).setCellValue(vo.getEmployeeNumber());
                    row.createCell(4).setCellValue(vo.getRole());
                    row.createCell(5).setCellValue(vo.getPost());
                    row.createCell(6).setCellValue(vo.getParentName());
                    row.createCell(7).setCellValue(vo.getOrganizeName());
                    row.createCell(8).setCellValue(vo.getStartTime() == null ? "-" : format.format(vo.getStartTime()));
                    row.createCell(9).setCellValue(vo.getEndTime() == null ? "-" : format.format(vo.getEndTime()));
                    row.createCell(10).setCellValue(vo.getUseTimeFormal() == null ? "-" : vo.getUseTimeFormal());
                    String statusName = "";
                    if (vo.getTaskStatus() == 0) {
                        statusName = TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.course.status.unstart", null, locale);
                    } else if (vo.getTaskStatus() == 1) {
                        statusName = TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.job.status.going", null, locale);
                    } else if (vo.getTaskStatus() == 2) {
                        statusName = TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.learn.wait.read", null, locale);
                    } else if (vo.getTaskStatus() == 3) {
                        statusName = TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.learn.unpass", null, locale);
                    } else if (vo.getTaskStatus() == 4) {
                        statusName = TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.job.status.completed", null, locale);
                    }
                    row.createCell(11).setCellValue(statusName);
                }
                try {
                    DownloadUtils.successExportTask((Workbook)wb, exportTaskPojo);
                }
                catch (Exception e) {
                    log.error("getUserTrainTaskExcel", (Throwable)e);
                    DownloadUtils.errorExportTask(exportTaskPojo);
                }
            }
        });
        taskList.add(exportTaskPojo);
        return JsonResult.success(taskList);
    }

    @Override
    public String selectUserPaperByExecl(final Integer stageTaskId, final Integer taskStatus, String taskName, final String userName, final Integer exportStatus, final Users user) {
        final Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        JSONObject param = new JSONObject();
        param.fluentPut("stageTaskId", (Object)stageTaskId).fluentPut("taskStatus", (Object)taskStatus).fluentPut("taskName", (Object)taskName).fluentPut("userName", (Object)userName).fluentPut("user", (Object)user);
        String fileName = "";
        taskName = ExcelUtil.getFileName(taskName);
        if (exportStatus == null || exportStatus == 1) {
            fileName = MessageFormat.format("{0}_{1}_{2}.xlsx", taskName, this.messageSource.getMessage("training.paper.result", null, locale), DateUtils.format((Date)new Date(), (String)"yyyyMMdd"));
        } else if (exportStatus == 2) {
            fileName = MessageFormat.format("{0}_{1}_{2}.xlsx", taskName, this.messageSource.getMessage("training.paper.result.details", null, locale), DateUtils.format((Date)new Date(), (String)"yyyyMMdd"));
        }
        ArrayList<ExportTaskPojo> taskList = new ArrayList<ExportTaskPojo>();
        final ExportTaskPojo exportTaskPojo = DownloadUtils.saveExportTask(fileName, param.toJSONString(), 12);
        final String finalTaskName = taskName;
        ThreadPoolUtil.getThreadPoolExecutor().execute(new Runnable(){

            @Override
            public void run() {
                String statusName;
                TrainingJobUserTaskVo vo;
                List<Object> voList = new ArrayList();
                if (exportStatus == null || exportStatus == 1) {
                    voList = TrainingJobCertificationServiceImpl.this.trainingApi.getJobUserPaperList(stageTaskId, taskStatus, userName, user);
                } else if (exportStatus == 2) {
                    voList = TrainingJobCertificationServiceImpl.this.trainingApi.getJobUserPaperList2(stageTaskId, taskStatus, userName, user);
                }
                List<Integer> userIdList = voList.stream().map(TrainingJobUserTask::getUserId).distinct().collect(Collectors.toList());
                XSSFWorkbook wb = new XSSFWorkbook();
                XSSFSheet sheet = wb.createSheet(finalTaskName);
                sheet.setColumnWidth(0, 3000);
                Map<Integer, List<String>> organizeMap = TrainingJobCertificationServiceImpl.this.userUtilService.selectOrganizeMap(userIdList, user.getGroupId());
                Map<Object, Object> roleMap = new HashMap();
                Map<Object, Object> parentMap = new HashMap();
                Map organMap1 = new HashMap();
                Map organMap2 = new HashMap();
                Map organMap3 = new HashMap();
                Map organMap4 = new HashMap();
                Map organMap5 = new HashMap();
                Map shopMap = new HashMap();
                Map shopDetailMap = new HashMap();
                if (!CollectionUtils.isEmpty(userIdList)) {
                    roleMap = TrainingJobCertificationServiceImpl.this.userUtilService.selectRolesByUsers(userIdList, ((TrainingJobUserTaskVo)voList.get(0)).getEnterpriseId());
                    parentMap = TrainingJobCertificationServiceImpl.this.userUtilService.selectParentMap(userIdList, ((TrainingJobUserTaskVo)voList.get(0)).getEnterpriseId());
                    UsersAndOrgsMo mo = new UsersAndOrgsMo();
                    mo.setGroupId(((TrainingJobUserTaskVo)voList.get(0)).getEnterpriseId());
                    mo.setLevelList(Collections.singletonList(1));
                    mo.setUserIdList(userIdList);
                    mo.setShowDepartment(Boolean.valueOf(false));
                    BaseResult base1 = TrainingJobCertificationServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                    if (base1 != null) {
                        organMap1 = (Map)base1.getData();
                    }
                    mo.setLevelList(Collections.singletonList(2));
                    BaseResult base2 = TrainingJobCertificationServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                    if (base2 != null) {
                        organMap2 = (Map)base2.getData();
                    }
                    mo.setLevelList(Collections.singletonList(3));
                    BaseResult base3 = TrainingJobCertificationServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                    if (base3 != null) {
                        organMap3 = (Map)base3.getData();
                    }
                    mo.setLevelList(Collections.singletonList(4));
                    BaseResult base4 = TrainingJobCertificationServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                    if (base4 != null) {
                        organMap4 = (Map)base4.getData();
                    }
                    mo.setLevelList(Collections.singletonList(5));
                    BaseResult base5 = TrainingJobCertificationServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                    if (base5 != null) {
                        organMap5 = (Map)base5.getData();
                    }
                    UsersAndOrgsMo mo1 = new UsersAndOrgsMo();
                    mo1.setGroupId(((TrainingJobUserTaskVo)voList.get(0)).getEnterpriseId());
                    mo1.setUserIdList(userIdList);
                    mo1.setShowDepartment(Boolean.valueOf(true));
                    BaseResult base = TrainingJobCertificationServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo1);
                    if (base != null && base.getData() != null) {
                        shopMap = (Map)base.getData();
                    }
                    mo1.setShowAllPath(Boolean.valueOf(true));
                    BaseResult bases = TrainingJobCertificationServiceImpl.this.userOrganizeApi.getUserOrganizePathtByUserIds(mo1);
                    if (bases != null && bases.getData() != null) {
                        shopDetailMap = (Map)bases.getData();
                    }
                }
                String unExam = TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.course.status.unexam", null, locale);
                String waitRead = TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.learn.wait.read", null, locale);
                String unPassName = TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.learn.unpass", null, locale);
                String passName = TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.paper.pass", null, locale);
                XSSFRow row = sheet.createRow(0);
                row.createCell(0).setCellValue("id");
                row.createCell(1).setCellValue(TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.user.details.username", null, locale));
                row.createCell(2).setCellValue(TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.user.details.name", null, locale));
                row.createCell(3).setCellValue(TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.user.details.employeeNumber", null, locale));
                row.createCell(4).setCellValue(TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.course.analysis.role", null, locale));
                row.createCell(5).setCellValue(TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.job.post.name", null, locale));
                row.createCell(6).setCellValue(TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.course.analysis.superior", null, locale));
                row.createCell(7).setCellValue(TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.course.analysis.department", null, locale));
                row.createCell(8).setCellValue(TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.course.analysis.first.organize", null, locale));
                row.createCell(9).setCellValue(TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.course.analysis.second.organize", null, locale));
                row.createCell(10).setCellValue(TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.course.analysis.third.organize", null, locale));
                row.createCell(11).setCellValue(TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.course.analysis.fourth.organize", null, locale));
                row.createCell(12).setCellValue(TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.course.analysis.fifth.organize", null, locale));
                row.createCell(13).setCellValue(TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.course.analysis.dep", null, locale));
                for (int i = 0; i < voList.size(); ++i) {
                    List pojoList;
                    List pojoList2;
                    List pojoList3;
                    List pojoList4;
                    List pojoList5;
                    List pojoList6;
                    row = sheet.createRow(i + 1);
                    TrainingJobUserTaskVo vo2 = (TrainingJobUserTaskVo)voList.get(i);
                    row.createCell(0).setCellValue(String.valueOf(vo2.getUserId()));
                    row.createCell(1).setCellValue(vo2.getUserAccount());
                    row.createCell(2).setCellValue(vo2.getUserName());
                    row.createCell(3).setCellValue(vo2.getEmployeeNumber());
                    row.createCell(4).setCellValue(vo2.getRole());
                    row.createCell(5).setCellValue(vo2.getPost());
                    row.createCell(6).setCellValue(vo2.getParentName());
                    String organName1 = "";
                    if (!org.springframework.util.StringUtils.isEmpty(organMap1) && !CollectionUtils.isEmpty((Collection)(pojoList6 = (List)organMap1.get(vo2.getUserId())))) {
                        pojoList6 = pojoList6.stream().distinct().collect(Collectors.toList());
                        organName1 = StringUtils.join(pojoList6, (String)",");
                    }
                    String departName = "";
                    List<String> nameList = organizeMap.get(vo2.getUserId());
                    if (!CollectionUtils.isEmpty(nameList)) {
                        departName = String.join((CharSequence)";\n", nameList);
                    }
                    row.createCell(7).setCellValue(departName);
                    row.createCell(8).setCellValue(organName1);
                    String organName2 = "";
                    if (!org.springframework.util.StringUtils.isEmpty(organMap2) && !CollectionUtils.isEmpty((Collection)(pojoList5 = (List)organMap2.get(vo2.getUserId())))) {
                        pojoList5 = pojoList5.stream().distinct().collect(Collectors.toList());
                        organName2 = StringUtils.join(pojoList5, (String)",");
                    }
                    row.createCell(9).setCellValue(organName2);
                    String organName3 = "";
                    if (!org.springframework.util.StringUtils.isEmpty(organMap3) && !CollectionUtils.isEmpty((Collection)(pojoList4 = (List)organMap3.get(vo2.getUserId())))) {
                        pojoList4 = pojoList4.stream().distinct().collect(Collectors.toList());
                        organName3 = StringUtils.join(pojoList4, (String)",");
                    }
                    row.createCell(10).setCellValue(organName3);
                    String organName4 = "";
                    if (!org.springframework.util.StringUtils.isEmpty(organMap4) && !CollectionUtils.isEmpty((Collection)(pojoList3 = (List)organMap4.get(vo2.getUserId())))) {
                        pojoList3 = pojoList3.stream().distinct().collect(Collectors.toList());
                        organName4 = StringUtils.join(pojoList3, (String)",");
                    }
                    row.createCell(11).setCellValue(organName4);
                    String organName5 = "";
                    if (!org.springframework.util.StringUtils.isEmpty(organMap5) && !CollectionUtils.isEmpty((Collection)(pojoList2 = (List)organMap5.get(vo2.getUserId())))) {
                        pojoList2 = pojoList2.stream().distinct().collect(Collectors.toList());
                        organName5 = StringUtils.join(pojoList2, (String)",");
                    }
                    row.createCell(12).setCellValue(organName5);
                    String shopName = "";
                    if (!org.springframework.util.StringUtils.isEmpty(shopMap) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)shopMap.get(vo2.getUserId())))) {
                        pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                        shopName = StringUtils.join(pojoList, (String)",");
                    }
                    row.createCell(13).setCellValue(shopName);
                }
                if (exportStatus == null || exportStatus == 1) {
                    row = sheet.getRow(0);
                    row.createCell(14).setCellValue(TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.paper.finish.time", null, locale));
                    row.createCell(15).setCellValue(TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.paper.num", null, locale));
                    row.createCell(16).setCellValue(TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.course.average.time", null, locale));
                    row.createCell(17).setCellValue(TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.certificate.paper.score", null, locale));
                    row.createCell(18).setCellValue(TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.paper.status", null, locale));
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    for (int i = 0; i < voList.size(); ++i) {
                        row = sheet.getRow(i + 1);
                        vo = (TrainingJobUserTaskVo)voList.get(i);
                        row.createCell(14).setCellValue(vo.getEndTime() == null ? "-" : format.format(vo.getEndTime()));
                        row.createCell(15).setCellValue(vo.getPaperCount() == null ? "-" : vo.getPaperCount().toString());
                        row.createCell(16).setCellValue(vo.getUseTimeFormal() == null ? "-" : vo.getUseTimeFormal());
                        row.createCell(17).setCellValue(vo.getScore() == null ? "-" : vo.getScore().toString());
                        statusName = "";
                        if (vo.getTaskStatus() == 0) {
                            statusName = unExam;
                        } else if (vo.getTaskStatus() == 1) {
                            statusName = TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.paper.ing", null, locale);
                        } else if (vo.getTaskStatus() == 2) {
                            statusName = waitRead;
                        } else if (vo.getTaskStatus() == 3) {
                            statusName = unPassName;
                        } else if (vo.getTaskStatus() == 4) {
                            statusName = passName;
                        }
                        row.createCell(18).setCellValue(statusName);
                    }
                } else if (exportStatus == 2) {
                    row = sheet.getRow(0);
                    row.createCell(14).setCellValue(TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.paper.handtime", null, locale));
                    row.createCell(15).setCellValue(TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.operate.usetime", null, locale));
                    row.createCell(16).setCellValue(TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.paper.score", null, locale));
                    row.createCell(17).setCellValue(TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.paper.status", null, locale));
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    for (int i = 0; i < voList.size(); ++i) {
                        row = sheet.getRow(i + 1);
                        vo = (TrainingJobUserTaskVo)voList.get(i);
                        if (vo.getSubmitTime() != null) {
                            row.createCell(14).setCellValue(format.format(vo.getSubmitTime()));
                        }
                        row.createCell(15).setCellValue(vo.getUseTimeFormal() == null ? "-" : vo.getUseTimeFormal());
                        statusName = "";
                        String score = "";
                        if (vo.getTaskStatus() == 1 || vo.getTaskStatus() == 0) {
                            String unexam;
                            statusName = unexam = TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.paper.unexam", null, locale);
                            score = "-";
                        } else if (vo.getTaskStatus() == 2) {
                            statusName = TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.paper.ing", null, locale);
                            score = "-";
                        } else if (vo.getTaskStatus() == 3) {
                            statusName = passName;
                            score = String.valueOf(vo.getScore());
                        } else if (vo.getTaskStatus() == 4) {
                            statusName = unPassName;
                            score = String.valueOf(vo.getScore());
                        } else if (vo.getTaskStatus() == 5) {
                            statusName = waitRead;
                            score = "-";
                        }
                        row.createCell(16).setCellValue(score);
                        row.createCell(17).setCellValue(statusName);
                    }
                }
                try {
                    DownloadUtils.successExportTask((Workbook)wb, exportTaskPojo);
                }
                catch (Exception e) {
                    log.error("getUserTrainTaskExcel", (Throwable)e);
                    DownloadUtils.errorExportTask(exportTaskPojo);
                }
            }
        });
        taskList.add(exportTaskPojo);
        return JsonResult.success(taskList);
    }

    @Override
    public String selectUserOfflineByExecl(final Integer stageTaskId, final Integer shiftTaskId, String taskName, final String userName, final Users user) {
        final Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        JSONObject param = new JSONObject();
        param.fluentPut("stageTaskId", (Object)stageTaskId).fluentPut("shiftTaskId", (Object)shiftTaskId).fluentPut("taskName", (Object)taskName).fluentPut("userName", (Object)userName).fluentPut("user", (Object)user);
        taskName = ExcelUtil.getFileName(taskName);
        String fileName = MessageFormat.format("{0}_{1}_{2}.xlsx", taskName, this.messageSource.getMessage("training.course.student.details", null, locale), DateUtils.format((Date)new Date(), (String)"yyyyMMdd"));
        ArrayList<ExportTaskPojo> taskList = new ArrayList<ExportTaskPojo>();
        final ExportTaskPojo exportTaskPojo = DownloadUtils.saveExportTask(fileName, param.toJSONString(), 32);
        final String finalTaskName = taskName;
        ThreadPoolUtil.getThreadPoolExecutor().execute(new Runnable(){

            @Override
            public void run() {
                List<TrainingJobUserTaskVo> voList = TrainingJobCertificationServiceImpl.this.trainingApi.getUserOfflineList(stageTaskId, shiftTaskId, userName, user);
                XSSFWorkbook wb = new XSSFWorkbook();
                XSSFSheet sheet = wb.createSheet(finalTaskName);
                sheet.setColumnWidth(1, 3000);
                XSSFRow row = sheet.createRow(0);
                row.createCell(0).setCellValue(TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.certificate.offline.class", null, locale));
                row.createCell(1).setCellValue(TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.user.details.id", null, locale));
                row.createCell(2).setCellValue(TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.job.account.number", null, locale));
                row.createCell(3).setCellValue(TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.user.details.name", null, locale));
                row.createCell(4).setCellValue(TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.user.details.employeeNumber", null, locale));
                row.createCell(5).setCellValue(TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.course.analysis.role", null, locale));
                row.createCell(6).setCellValue(TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.job.post.name", null, locale));
                row.createCell(7).setCellValue(TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.course.analysis.superior", null, locale));
                row.createCell(8).setCellValue(TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.course.analysis.department", null, locale));
                row.createCell(9).setCellValue(TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.certificate.activity.validity", null, locale));
                row.createCell(10).setCellValue(TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.certificate.activity.time", null, locale) + TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.material.hours", null, locale));
                row.createCell(11).setCellValue(TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.certificate.sign.time", null, locale));
                row.createCell(12).setCellValue(TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.certificate.signout.time", null, locale));
                row.createCell(13).setCellValue(TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.job.participation.number", null, locale) + TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.material.hours", null, locale));
                row.createCell(14).setCellValue(TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.absences.number", null, locale) + TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.material.hours", null, locale));
                row.createCell(15).setCellValue(TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.course.attendance", null, locale));
                row.createCell(16).setCellValue(TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.certificate.mark", null, locale));
                row.createCell(17).setCellValue(TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.shift.pass.status", null, locale));
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                for (int i = 0; i < voList.size(); ++i) {
                    row = sheet.createRow(i + 1);
                    TrainingJobUserTaskVo vo = voList.get(i);
                    row.createCell(0).setCellValue(vo.getShiftName());
                    row.createCell(1).setCellValue((double)vo.getUserId().intValue());
                    row.createCell(2).setCellValue(vo.getUserAccount());
                    row.createCell(3).setCellValue(vo.getUserName());
                    row.createCell(4).setCellValue(vo.getEmployeeNumber());
                    row.createCell(5).setCellValue(vo.getRole());
                    row.createCell(6).setCellValue(vo.getPost());
                    row.createCell(7).setCellValue(vo.getParentName());
                    row.createCell(8).setCellValue(vo.getOrganizeName());
                    row.createCell(9).setCellValue((vo.getTaskStartTime() == null ? "" : format.format(vo.getTaskStartTime())) + " - " + (vo.getTaskEndTime() == null ? "" : format.format(vo.getTaskEndTime())));
                    row.createCell(10).setCellValue(vo.getActTime() == null ? "" : vo.getActTime().toString());
                    row.createCell(11).setCellValue(vo.getStartTime() == null ? "-" : format.format(vo.getStartTime()));
                    row.createCell(12).setCellValue(vo.getEndTime() == null ? "-" : format.format(vo.getEndTime()));
                    int allTime = vo.getIsAllTime();
                    String useTimeVo = "";
                    String cutTimeVo = "";
                    String outRate = "";
                    if (allTime == 0) {
                        useTimeVo = vo.getUseTimeVo() == null ? "" : vo.getUseTimeVo().toString();
                        cutTimeVo = vo.getCutTimeVo() == null ? "" : vo.getCutTimeVo().toString();
                        outRate = vo.getOutRate() == null ? "" : vo.getOutRate().toString() + "%";
                    } else if (allTime == 1) {
                        useTimeVo = "-";
                        cutTimeVo = "-";
                        outRate = "-";
                    } else if (allTime == 2) {
                        if (vo.getTaskEndTime() == null || vo.getTaskEndTime().compareTo(new Date()) >= 0) {
                            useTimeVo = "-";
                            cutTimeVo = "-";
                            outRate = "-";
                        } else {
                            useTimeVo = "0";
                            cutTimeVo = vo.getCutTimeVo() == null ? "" : vo.getCutTimeVo().toString();
                            outRate = "0%";
                        }
                    }
                    row.createCell(13).setCellValue(useTimeVo);
                    row.createCell(14).setCellValue(cutTimeVo);
                    row.createCell(15).setCellValue(outRate);
                    row.createCell(16).setCellValue(vo.getScore() == null ? "-" : vo.getScore().toString());
                    String statusName = "";
                    statusName = vo.getTaskStatus() != null && vo.getTaskStatus() == 3 ? TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.learn.pass", null, locale) : (vo.getTaskStatus() != null && vo.getTaskStatus() == 4 ? TrainingJobCertificationServiceImpl.this.messageSource.getMessage("training.learn.unpass", null, locale) : "-");
                    row.createCell(17).setCellValue(statusName);
                }
                try {
                    DownloadUtils.successExportTask((Workbook)wb, exportTaskPojo);
                }
                catch (Exception e) {
                    log.error("getUserTrainTaskExcel", (Throwable)e);
                    DownloadUtils.errorExportTask(exportTaskPojo);
                }
            }
        });
        taskList.add(exportTaskPojo);
        return JsonResult.success(taskList);
    }
}

