/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.ovopark.api.TrainingApi;
import com.ovopark.bo.Authenticator;
import com.ovopark.bo.JsonResult;
import com.ovopark.organize.common.model.pojo.ExportTaskPojo;
import com.ovopark.pojo.TrainingJobStudentAnalyseVo;
import com.ovopark.pojo.Users;
import com.ovopark.service.TrainingJobExcelService;
import com.ovopark.utils.DateUtils;
import com.ovopark.utils.DownloadUtils;
import com.ovopark.utils.ThreadPoolUtil;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class TrainingJobExcelServiceImpl
implements TrainingJobExcelService {
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private TrainingApi trainingApi;

    @Override
    public String selectUserJobDetailByExcel(final TrainingJobStudentAnalyseVo jobUserTaskVo, Users user) {
        final Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        final String name = this.messageSource.getMessage("training.job.excel.detail.name", null, locale);
        String fileName = MessageFormat.format("{0}_{1}.xlsx", name, DateUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss"));
        jobUserTaskVo.setUserId(user.getId());
        jobUserTaskVo.setEnterpriseId(user.getGroupId());
        ArrayList<ExportTaskPojo> taskList = new ArrayList<ExportTaskPojo>();
        final ExportTaskPojo exportTaskPojo = DownloadUtils.saveExportTask(fileName, JSON.toJSONString((Object)jobUserTaskVo), 34);
        ThreadPoolUtil.getThreadPoolExecutor().execute(new Runnable(){

            @Override
            public void run() {
                List<TrainingJobStudentAnalyseVo> list = TrainingJobExcelServiceImpl.this.trainingApi.selectUserJobsDetailByExcel(jobUserTaskVo);
                XSSFWorkbook wb = new XSSFWorkbook();
                XSSFSheet sheet = wb.createSheet(name);
                XSSFCellStyle titleSty = wb.createCellStyle();
                titleSty.setWrapText(true);
                XSSFRow row = sheet.createRow(0);
                row.createCell(0).setCellValue("id");
                sheet.setColumnWidth(0, 3000);
                row.createCell(1).setCellValue(TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.user.details.username", null, locale));
                String jobName = TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.job.excel.job.name", null, locale);
                row.createCell(2).setCellValue(jobName);
                String userName = TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.ranking.name", null, locale);
                row.createCell(3).setCellValue(userName);
                sheet.setColumnWidth(3, 5000);
                String number = TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.course.analysis.jobnumber", null, locale);
                row.createCell(4).setCellValue(number);
                sheet.setColumnWidth(4, 5000);
                String department = TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.course.analysis.department", null, locale);
                row.createCell(5).setCellValue(department);
                String postName = TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.job.post.name", null, locale);
                row.createCell(6).setCellValue(postName);
                sheet.setColumnWidth(6, 7500);
                row.createCell(7).setCellValue(TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.course.analysis.role", null, locale));
                row.createCell(8).setCellValue(TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.course.analysis.superior", null, locale));
                sheet.setColumnWidth(8, 7500);
                String jobProgress = TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.job.excel.job.progress", null, locale);
                row.createCell(9).setCellValue(jobProgress);
                String taskName = TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.job.excel.task.name", null, locale);
                row.createCell(10).setCellValue(taskName);
                String taskType = TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.job.excel.task.type", null, locale);
                row.createCell(11).setCellValue(taskType);
                String progress = TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.learn.job.progress", null, locale);
                row.createCell(12).setCellValue(progress);
                String learnStatus = TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.learn.task.status", null, locale);
                row.createCell(13).setCellValue(learnStatus);
                String startTime = TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.job.excel.start.time", null, locale);
                row.createCell(14).setCellValue(startTime);
                String endTime = TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.job.excel.end.time", null, locale);
                row.createCell(15).setCellValue(endTime);
                String taskTime = TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.job.excel.task.time", null, locale);
                row.createCell(16).setCellValue(taskTime);
                String taskStartTime = TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.job.excel.task.start.time", null, locale);
                row.createCell(17).setCellValue(taskStartTime);
                String taskEndTime = TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.job.excel.task.end.time", null, locale);
                row.createCell(18).setCellValue(taskEndTime);
                String useTime = TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.job.excel.use.time", null, locale);
                row.createCell(19).setCellValue(useTime);
                String totalScore = TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.job.excel.total.score", null, locale);
                row.createCell(20).setCellValue(totalScore);
                String passScore = TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.job.excel.pass.score", null, locale);
                row.createCell(21).setCellValue(passScore);
                String score = TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.job.excel.score", null, locale);
                row.createCell(22).setCellValue(score);
                String useCount = TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.job.excel.use.count", null, locale);
                row.createCell(23).setCellValue(useCount);
                String avgTime = TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.job.excel.avg.time", null, locale);
                row.createCell(24).setCellValue(avgTime);
                String passStatus = TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.job.excel.pass.status", null, locale);
                row.createCell(25).setCellValue(passStatus);
                String train = TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.job.train.name", null, locale);
                String paper = TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.paper.exam", null, locale);
                String shift = TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.job.excel.shift.activity", null, locale);
                String operate = TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.operate.name", null, locale);
                String material = TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.job.excel.material", null, locale);
                String unStart = TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.course.status.unstart", null, locale);
                String going = TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.job.status.going", null, locale);
                String completed = TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.job.status.completed", null, locale);
                String wait = TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.job.unapprove", null, locale);
                String read = TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.learn.wait.read", null, locale);
                String pass = TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.learn.pass", null, locale);
                String unPass = TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.learn.unpass", null, locale);
                for (int i = 0; i < list.size(); ++i) {
                    row = sheet.createRow(i + 1);
                    TrainingJobStudentAnalyseVo vo = list.get(i);
                    row.createCell(0).setCellValue((double)vo.getUserId().intValue());
                    row.createCell(1).setCellValue(vo.getUserAccount());
                    row.createCell(2).setCellValue(vo.getCertificationName());
                    row.createCell(3).setCellValue(vo.getUserName());
                    row.createCell(4).setCellValue(vo.getEmployeeNumber());
                    row.createCell(5).setCellValue(vo.getOrganizeName());
                    row.createCell(6).setCellValue(vo.getDutiesName());
                    row.createCell(7).setCellValue(vo.getRole());
                    row.createCell(8).setCellValue(vo.getParentName());
                    row.createCell(9).setCellValue(vo.getJobRate().multiply(new BigDecimal("100")).setScale(2, 4) + "%");
                    row.createCell(10).setCellValue(vo.getTaskName());
                    String typeName = "--";
                    if (vo.getTaskType() != null) {
                        if (vo.getTaskType() == 1) {
                            typeName = train;
                        } else if (vo.getTaskType() == 2) {
                            typeName = paper;
                        } else if (vo.getTaskType() == 3) {
                            typeName = shift;
                        } else if (vo.getTaskType() == 4) {
                            typeName = operate;
                        } else if (vo.getTaskType() == 5) {
                            typeName = material;
                        }
                    }
                    row.createCell(11).setCellValue(typeName);
                    row.createCell(12).setCellValue(vo.getTaskRate() != null ? vo.getTaskRate().multiply(new BigDecimal("100")).setScale(2, 4) + "%" : "--");
                    String learnName = "--";
                    if (vo.getLearnStatus() != null) {
                        if (vo.getLearnStatus() == 4) {
                            learnName = vo.getTaskType() == 2 ? read : wait;
                        } else if (vo.getLearnStatus() == 3) {
                            learnName = completed;
                        } else if (vo.getLearnStatus() == 2) {
                            learnName = going;
                        } else if (vo.getLearnStatus() == 1) {
                            learnName = unStart;
                        }
                    }
                    row.createCell(13).setCellValue(learnName);
                    row.createCell(14).setCellValue(vo.getStartTime() == null ? "--" : DateUtil.format((Date)vo.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                    row.createCell(15).setCellValue(vo.getEndTime() == null ? "--" : DateUtil.format((Date)vo.getEndTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                    row.createCell(16).setCellValue(vo.getTaskTime() == null ? "--" : vo.getTaskTime());
                    row.createCell(17).setCellValue(vo.getTaskStartTime() == null ? "--" : DateUtil.format((Date)vo.getTaskStartTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                    row.createCell(18).setCellValue(vo.getTaskEndTime() == null ? "--" : DateUtil.format((Date)vo.getTaskEndTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                    row.createCell(19).setCellValue(vo.getUseTime() == null || vo.getTaskType() == 2 || vo.getTaskType() == 4 ? "--" : vo.getUseTime());
                    row.createCell(20).setCellValue(ObjectUtils.isEmpty((Object)vo.getTotalScore()) ? "--" : vo.getTotalScore().toString());
                    row.createCell(21).setCellValue(ObjectUtils.isEmpty((Object)vo.getPassScore()) ? "--" : vo.getPassScore().toString());
                    row.createCell(22).setCellValue(ObjectUtils.isEmpty((Object)vo.getScore()) ? "--" : vo.getScore().toString());
                    row.createCell(23).setCellValue(vo.getUseCount() != null ? vo.getUseCount().toString() : "--");
                    row.createCell(24).setCellValue(vo.getUseTime() == null || vo.getTaskType() == 1 || vo.getTaskType() == 3 || vo.getTaskType() == 5 ? "--" : vo.getUseTime());
                    String passName = "--";
                    if (vo.getPassStatus() != null && vo.getPassStatus() == 3) {
                        passName = pass;
                    } else if (vo.getPassStatus() != null && vo.getPassStatus() == 2) {
                        passName = unPass;
                    }
                    row.createCell(25).setCellValue(passName);
                    sheet.autoSizeColumn(i + 1);
                }
                try {
                    DownloadUtils.successExportTask((Workbook)wb, exportTaskPojo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DownloadUtils.errorExportTask(exportTaskPojo);
                }
            }
        });
        taskList.add(exportTaskPojo);
        return JsonResult.success(taskList);
    }

    @Override
    public String selectJobStudentDetailByExecl(final TrainingJobStudentAnalyseVo jobUserTaskVo, final Users user) {
        final Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        final String studentDetail = this.messageSource.getMessage("training.job.student.detail", null, locale);
        String fileName = MessageFormat.format("{0}_{1}", studentDetail, DateUtils.format((Date)new Date(), (String)"yyyyMMdd"));
        jobUserTaskVo.setUserId(user.getId());
        jobUserTaskVo.setEnterpriseId(user.getGroupId());
        ArrayList<ExportTaskPojo> taskList = new ArrayList<ExportTaskPojo>();
        final ExportTaskPojo exportTaskPojo = DownloadUtils.saveExportTask(fileName, JSON.toJSONString((Object)jobUserTaskVo), 18);
        ThreadPoolUtil.getThreadPoolExecutor().execute(new Runnable(){

            @Override
            public void run() {
                jobUserTaskVo.setUser(user);
                List<TrainingJobStudentAnalyseVo> list = TrainingJobExcelServiceImpl.this.trainingApi.selectJobStudentDetail(jobUserTaskVo);
                XSSFWorkbook wb = new XSSFWorkbook();
                XSSFSheet sheet = wb.createSheet(studentDetail);
                XSSFCellStyle titleSty = wb.createCellStyle();
                titleSty.setWrapText(true);
                String unStart = TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.course.status.unstart", null, locale);
                String going = TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.job.status.going", null, locale);
                String completed = TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.job.status.completed", null, locale);
                String unapproveName = TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.job.unapprove", null, locale);
                XSSFRow row = sheet.createRow(0);
                row.createCell(0).setCellValue("id");
                sheet.setColumnWidth(0, 3000);
                row.createCell(1).setCellValue(TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.job.account.number", null, locale));
                row.createCell(2).setCellValue(TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.course.trainee.name", null, locale));
                row.createCell(3).setCellValue(TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.user.details.employeeNumber", null, locale));
                row.createCell(4).setCellValue(TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.course.analysis.role", null, locale));
                row.createCell(5).setCellValue(TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.job.post.name", null, locale));
                row.createCell(6).setCellValue(TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.course.analysis.superior", null, locale));
                row.createCell(7).setCellValue(TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.course.analysis.department", null, locale));
                row.createCell(8).setCellValue(TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.course.analysis.starttime", null, locale));
                row.createCell(9).setCellValue(TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.course.analysis.endtime", null, locale));
                row.createCell(10).setCellValue(TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.course.analysis.study.status", null, locale));
                row.createCell(11).setCellValue(TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.job.online.paper.avgscore", null, locale));
                row.createCell(12).setCellValue(TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.job.offline.paper.avgscore", null, locale));
                row.createCell(13).setCellValue(TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.shift.pass.status", null, locale));
                row.createCell(14).setCellValue(TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.job.auth.name", null, locale));
                row.createCell(15).setCellValue(TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.job.map", null, locale));
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                for (int i = 0; i < list.size(); ++i) {
                    row = sheet.createRow(i + 1);
                    TrainingJobStudentAnalyseVo vos = list.get(i);
                    row.createCell(0).setCellValue((double)vos.getUserId().intValue());
                    row.createCell(1).setCellValue(vos.getUserAccount());
                    row.createCell(2).setCellValue(vos.getUserName());
                    row.createCell(3).setCellValue(vos.getEmployeeNumber());
                    row.createCell(4).setCellValue(vos.getRole());
                    row.createCell(5).setCellValue(vos.getDutiesName());
                    row.createCell(6).setCellValue(vos.getParentName());
                    row.createCell(7).setCellValue(vos.getOrganizeName());
                    row.createCell(8).setCellValue(vos.getStartTime() == null ? "" : format.format(vos.getStartTime()));
                    row.createCell(9).setCellValue(vos.getEndTime() == null ? "-" : format.format(vos.getEndTime()));
                    String learnStatusName = "-";
                    if (!StringUtils.isEmpty((Object)vos.getLearnStatus())) {
                        if (vos.getLearnStatus() == 1) {
                            learnStatusName = unStart + vos.getFinishTask() + "/" + vos.getLearnTask();
                        } else if (vos.getLearnStatus() == 2) {
                            learnStatusName = going + " " + vos.getFinishTask() + "/" + vos.getLearnTask();
                        } else if (vos.getLearnStatus() == 3) {
                            learnStatusName = completed + " " + vos.getFinishTask() + "/" + vos.getLearnTask();
                        } else if (vos.getLearnStatus() == 4) {
                            learnStatusName = unapproveName + " " + vos.getFinishTask() + "/" + vos.getLearnTask();
                        }
                    }
                    row.createCell(10).setCellValue(learnStatusName);
                    row.createCell(11).setCellValue(vos.getXsScore() == null ? "-" : vos.getXsScore().toString());
                    row.createCell(12).setCellValue(vos.getXxScore() == null ? "-" : vos.getXxScore().toString());
                    String passStatusName = "-";
                    if (!StringUtils.isEmpty((Object)vos.getPassStatus())) {
                        passStatusName = vos.getPassStatus() == 1 ? TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.job.unapprove", null, locale) : (vos.getPassStatus() == 2 ? TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.learn.unpass", null, locale) : (vos.getPassStatus() == 3 ? TrainingJobExcelServiceImpl.this.messageSource.getMessage("training.learn.pass", null, locale) + " " : "-"));
                    }
                    row.createCell(13).setCellValue(passStatusName);
                    row.createCell(14).setCellValue(vos.getCertificationName());
                    row.createCell(15).setCellValue(StringUtils.isEmpty((Object)vos.getMapName()) ? "-" : vos.getMapName());
                }
                try {
                    DownloadUtils.successExportTask((Workbook)wb, exportTaskPojo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DownloadUtils.errorExportTask(exportTaskPojo);
                }
            }
        });
        taskList.add(exportTaskPojo);
        return JsonResult.success(taskList);
    }
}

