/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ovopark.api.TrainingApi;
import com.ovopark.bo.Authenticator;
import com.ovopark.bo.JsonResult;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.common.model.mo.UsersAndOrgsMo;
import com.ovopark.organize.common.model.pojo.ExportTaskPojo;
import com.ovopark.organize.sdk.api.UserOrganizeApi;
import com.ovopark.pojo.TrainingLearnTaskUser;
import com.ovopark.pojo.TrainingLearnTaskUserVo;
import com.ovopark.pojo.TrainingLearnUserVo;
import com.ovopark.pojo.TrainingWorkDocument;
import com.ovopark.pojo.TrainingWorkUserAnswerVo;
import com.ovopark.pojo.Users;
import com.ovopark.privilege.pojo.RolePojo;
import com.ovopark.service.TrainingLearnService;
import com.ovopark.service.UserUtilService;
import com.ovopark.utils.DateUtils;
import com.ovopark.utils.DownloadUtils;
import com.ovopark.utils.ExcelUtil;
import com.ovopark.utils.ThreadPoolUtil;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TrainingLearnServiceImpl
implements TrainingLearnService {
    private static final Logger log = LoggerFactory.getLogger(TrainingLearnServiceImpl.class);
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private TrainingApi trainingApi;
    @Autowired
    private UserUtilService userUtilService;
    @Autowired
    private UserOrganizeApi userOrganizeApi;

    @Override
    public String getUserTrainTaskExcel(String taskName, final Integer taskId, final Integer shiftId, final Integer taskStatus, final String creater, final Users user) {
        final Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        JSONObject param = new JSONObject();
        param.fluentPut("taskName", (Object)taskName).fluentPut("taskId", (Object)taskId).fluentPut("shiftId", (Object)shiftId).fluentPut("taskStatus", (Object)taskStatus).fluentPut("creater", (Object)creater);
        taskName = ExcelUtil.getFileName(taskName);
        String fileName = MessageFormat.format("{0}_{1}_{2}.xlsx", taskName, this.messageSource.getMessage("training.course.student.details", null, locale), DateUtils.format((Date)new Date(), (String)"yyyyMMdd"));
        ArrayList<ExportTaskPojo> taskList = new ArrayList<ExportTaskPojo>();
        final ExportTaskPojo exportTaskPojo = DownloadUtils.saveExportTask(fileName, param.toJSONString(), 13);
        final String finalTaskName = taskName;
        ThreadPoolUtil.getThreadPoolExecutor().execute(new Runnable(){

            @Override
            public void run() {
                HashMap<String, Object> project = new HashMap<String, Object>();
                project.put("taskId", taskId);
                project.put("shiftId", shiftId);
                project.put("taskStatus", taskStatus);
                project.put("creater", creater);
                project.put("user", user);
                List<TrainingLearnTaskUserVo> voList = TrainingLearnServiceImpl.this.trainingApi.getUserTrainTaskExcel(project);
                XSSFWorkbook wb = new XSSFWorkbook();
                XSSFSheet sheet = wb.createSheet(finalTaskName);
                XSSFCellStyle titleSty = wb.createCellStyle();
                XSSFDataFormat dataFormat = wb.createDataFormat();
                titleSty.setDataFormat(dataFormat.getFormat("@"));
                sheet.setDefaultColumnStyle(1, (CellStyle)titleSty);
                sheet.setColumnWidth(1, 3000);
                XSSFRow row = sheet.createRow(0);
                row.createCell(0).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.learn.shift.classes.name", null, locale));
                row.createCell(1).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.user.details.id", null, locale));
                row.createCell(2).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.user.details.username", null, locale));
                row.createCell(3).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.course.trainee.name", null, locale));
                row.createCell(4).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.user.details.employeeNumber", null, locale));
                row.createCell(5).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.course.analysis.role", null, locale));
                row.createCell(6).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.job.post.name", null, locale));
                row.createCell(7).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.course.analysis.superior", null, locale));
                row.createCell(8).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.course.analysis.department", null, locale));
                row.createCell(9).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.learn.course.validity", null, locale));
                row.createCell(10).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.course.analysis.starttime", null, locale));
                row.createCell(11).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.course.analysis.endtime", null, locale));
                row.createCell(12).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.course.analysis.study.time", null, locale));
                row.createCell(13).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.paper.status", null, locale));
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                for (int i = 0; i < voList.size(); ++i) {
                    row = sheet.createRow(i + 1);
                    TrainingLearnTaskUserVo vo = voList.get(i);
                    row.createCell(0).setCellValue(vo.getShiftName() + "-" + vo.getGroupName() + "-" + vo.getSupplemenName());
                    row.createCell(1).setCellValue((double)vo.getUserId().intValue());
                    row.createCell(2).setCellValue(vo.getUserAccount());
                    row.createCell(3).setCellValue(vo.getUserName());
                    row.createCell(4).setCellValue(vo.getEmployeeNumber());
                    row.createCell(5).setCellValue(vo.getRole());
                    row.createCell(6).setCellValue(vo.getPost());
                    row.createCell(7).setCellValue(vo.getParentName());
                    row.createCell(8).setCellValue(vo.getOrganizeName());
                    row.createCell(9).setCellValue((vo.getTaskStartTime() == null ? "" : format.format(vo.getTaskStartTime())) + " - " + (vo.getTaskEndTime() == null ? "" : format.format(vo.getTaskEndTime())));
                    row.createCell(10).setCellValue(vo.getStartTime() == null ? "-" : format.format(vo.getStartTime()));
                    row.createCell(11).setCellValue(vo.getEndTime() == null ? "-" : format.format(vo.getEndTime()));
                    row.createCell(12).setCellValue(vo.getUseTimeFormal() == null ? "-" : vo.getUseTimeFormal());
                    String statusName = "";
                    if (vo.getTaskStatus() == 0) {
                        statusName = TrainingLearnServiceImpl.this.messageSource.getMessage("training.course.status.unstart", null, locale);
                    } else if (vo.getTaskStatus() == 1) {
                        statusName = TrainingLearnServiceImpl.this.messageSource.getMessage("training.job.status.going", null, locale);
                    } else if (vo.getTaskStatus() == 2) {
                        statusName = TrainingLearnServiceImpl.this.messageSource.getMessage("training.learn.wait.read", null, locale);
                    } else if (vo.getTaskStatus() == 3) {
                        statusName = TrainingLearnServiceImpl.this.messageSource.getMessage("training.learn.unpass", null, locale);
                    } else if (vo.getTaskStatus() == 4) {
                        statusName = TrainingLearnServiceImpl.this.messageSource.getMessage("training.job.status.completed", null, locale);
                    }
                    row.createCell(13).setCellValue(statusName);
                }
                try {
                    DownloadUtils.successExportTask((Workbook)wb, exportTaskPojo);
                }
                catch (Exception e) {
                    log.error("getUserTrainTaskExcel", (Throwable)e);
                    DownloadUtils.errorExportTask(exportTaskPojo);
                }
            }
        });
        taskList.add(exportTaskPojo);
        return JsonResult.success(taskList);
    }

    @Override
    public String getUserWorkTask(String taskName, final Integer taskId, final Integer shiftId, final Integer taskStatus, final String creater, final Users user) {
        final Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        JSONObject param = new JSONObject();
        param.fluentPut("taskName", (Object)taskName).fluentPut("taskId", (Object)taskId).fluentPut("shiftId", (Object)shiftId).fluentPut("taskStatus", (Object)taskStatus).fluentPut("creater", (Object)creater);
        taskName = ExcelUtil.getFileName(taskName);
        String fileName = MessageFormat.format("{0}_{1}_{2}.xlsx", taskName, this.messageSource.getMessage("training.course.student.details", null, locale), DateUtils.format((Date)new Date(), (String)"yyyyMMdd"));
        ArrayList<ExportTaskPojo> taskList = new ArrayList<ExportTaskPojo>();
        final ExportTaskPojo exportTaskPojo = DownloadUtils.saveExportTask(fileName, param.toJSONString(), 14);
        final String finalTaskName = taskName;
        ThreadPoolUtil.getThreadPoolExecutor().execute(new Runnable(){

            @Override
            public void run() {
                HashMap<String, Object> project = new HashMap<String, Object>();
                project.put("taskId", taskId);
                project.put("shiftId", shiftId);
                project.put("taskStatus", taskStatus);
                project.put("creater", creater);
                project.put("user", user);
                List<TrainingLearnTaskUserVo> voList = TrainingLearnServiceImpl.this.trainingApi.getUserWorkTaskExcel(project);
                XSSFWorkbook wb = new XSSFWorkbook();
                XSSFSheet sheet = wb.createSheet(finalTaskName);
                XSSFCellStyle titleSty = wb.createCellStyle();
                XSSFDataFormat dataFormat = wb.createDataFormat();
                titleSty.setDataFormat(dataFormat.getFormat("@"));
                sheet.setDefaultColumnStyle(1, (CellStyle)titleSty);
                sheet.setColumnWidth(1, 3000);
                XSSFRow row = sheet.createRow(0);
                row.createCell(0).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.learn.shift.classes.name", null, locale));
                row.createCell(1).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.user.details.id", null, locale));
                row.createCell(2).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.user.details.username", null, locale));
                row.createCell(3).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.course.trainee.name", null, locale));
                row.createCell(4).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.user.details.employeeNumber", null, locale));
                row.createCell(5).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.course.analysis.role", null, locale));
                row.createCell(6).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.job.post.name", null, locale));
                row.createCell(7).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.course.analysis.superior", null, locale));
                row.createCell(8).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.course.analysis.department", null, locale));
                row.createCell(9).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.learn.job.validity", null, locale));
                row.createCell(10).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.course.submit.time", null, locale));
                row.createCell(11).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.learn.respond.content", null, locale));
                row.createCell(12).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.learn.attach", null, locale));
                row.createCell(13).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.paper.status", null, locale));
                row.createCell(14).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.paper.score", null, locale));
                row.createCell(15).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.job.reviewer", null, locale));
                row.createCell(16).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.learn.comment.content", null, locale));
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                if (!CollectionUtils.isEmpty(voList)) {
                    for (int i = 0; i < voList.size(); ++i) {
                        List pathList;
                        row = sheet.createRow(i + 1);
                        TrainingLearnTaskUserVo vo = voList.get(i);
                        row.createCell(0).setCellValue(vo.getShiftName() + "-" + vo.getGroupName() + "-" + vo.getSupplemenName());
                        row.createCell(1).setCellValue((double)vo.getUserId().intValue());
                        row.createCell(2).setCellValue(vo.getUserAccount());
                        row.createCell(3).setCellValue(vo.getUserName());
                        row.createCell(4).setCellValue(vo.getEmployeeNumber());
                        row.createCell(5).setCellValue(vo.getRole());
                        row.createCell(6).setCellValue(vo.getPost());
                        row.createCell(7).setCellValue(vo.getParentName());
                        row.createCell(8).setCellValue(vo.getOrganizeName());
                        row.createCell(9).setCellValue(vo.getStartTime() == null ? "" : format.format(vo.getStartTime()) + " -> " + format.format(vo.getEndTime()));
                        TrainingWorkUserAnswerVo userAnswerVo = vo.getWorkUserAnswerVo();
                        row.createCell(10).setCellValue(!org.springframework.util.StringUtils.isEmpty((Object)userAnswerVo) && !org.springframework.util.StringUtils.isEmpty((Object)userAnswerVo.getCommitTime()) ? format.format(userAnswerVo.getCommitTime()) : "");
                        row.createCell(11).setCellValue(!org.springframework.util.StringUtils.isEmpty((Object)userAnswerVo) ? userAnswerVo.getAnswer() : "");
                        String url = "";
                        if (!(org.springframework.util.StringUtils.isEmpty((Object)userAnswerVo) || CollectionUtils.isEmpty(userAnswerVo.getWorkDocumentList()) || CollectionUtils.isEmpty(pathList = userAnswerVo.getWorkDocumentList().stream().map(TrainingWorkDocument::getPath).filter(Objects::nonNull).distinct().collect(Collectors.toList())))) {
                            url = String.join((CharSequence)";", pathList);
                        }
                        row.createCell(12).setCellValue(url);
                        String statusName = "";
                        statusName = vo.getTaskStatus() != null && vo.getTaskStatus() == 2 ? TrainingLearnServiceImpl.this.messageSource.getMessage("training.learn.wait.read", null, locale) : (vo.getTaskStatus() != null && vo.getTaskStatus() == 3 ? TrainingLearnServiceImpl.this.messageSource.getMessage("training.job.status.not.pass", null, locale) : (vo.getTaskStatus() != null && vo.getTaskStatus() == 4 ? TrainingLearnServiceImpl.this.messageSource.getMessage("training.job.status.pass", null, locale) : TrainingLearnServiceImpl.this.messageSource.getMessage("training.course.unsubmit", null, locale)));
                        row.createCell(13).setCellValue(statusName);
                        row.createCell(14).setCellValue(vo.getScore() == null ? "" : vo.getScore().toString());
                        row.createCell(15).setCellValue(!org.springframework.util.StringUtils.isEmpty((Object)userAnswerVo) ? userAnswerVo.getRemarkerName() : "");
                        row.createCell(16).setCellValue(!org.springframework.util.StringUtils.isEmpty((Object)userAnswerVo) ? userAnswerVo.getComment() : "");
                    }
                }
                try {
                    DownloadUtils.successExportTask((Workbook)wb, exportTaskPojo);
                }
                catch (Exception e) {
                    log.error("getUserWorkTask", (Throwable)e);
                    DownloadUtils.errorExportTask(exportTaskPojo);
                }
            }
        });
        taskList.add(exportTaskPojo);
        return JsonResult.success(taskList);
    }

    @Override
    public String getUserPaperTaskExcel(String taskName, final Integer taskId, final Integer shiftId, final Integer taskStatus, final String creater, final Integer exportStatus, final Users user) {
        final Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        JSONObject param = new JSONObject();
        param.fluentPut("taskName", (Object)taskName).fluentPut("taskId", (Object)taskId).fluentPut("shiftId", (Object)shiftId).fluentPut("taskStatus", (Object)taskStatus).fluentPut("creater", (Object)creater);
        taskName = ExcelUtil.getFileName(taskName);
        String fileName = MessageFormat.format("{0}_{1}.xlsx", this.messageSource.getMessage("training.task.detail", null, locale), taskName);
        ArrayList<ExportTaskPojo> taskList = new ArrayList<ExportTaskPojo>();
        final ExportTaskPojo exportTaskPojo = DownloadUtils.saveExportTask(fileName, param.toJSONString(), 15);
        final String finalTaskName = taskName;
        ThreadPoolUtil.getThreadPoolExecutor().execute(new Runnable(){

            @Override
            public void run() {
                String statusName;
                TrainingLearnTaskUserVo vo;
                HashMap<String, Object> project = new HashMap<String, Object>();
                project.put("taskId", taskId);
                project.put("shiftId", shiftId);
                project.put("taskStatus", taskStatus);
                project.put("creater", creater);
                project.put("user", user);
                XSSFWorkbook wb = new XSSFWorkbook();
                XSSFSheet sheet = wb.createSheet(finalTaskName);
                XSSFCellStyle titleSty = wb.createCellStyle();
                XSSFFont font = wb.createFont();
                font.setFontHeightInPoints((short)16);
                titleSty.setFont((Font)font);
                Map<Object, Object> roleMap = new HashMap();
                Map<Object, Object> parentMap = new HashMap();
                Map organMap1 = new HashMap();
                Map organMap2 = new HashMap();
                Map organMap3 = new HashMap();
                Map organMap4 = new HashMap();
                Map organMap5 = new HashMap();
                Map shopMap = new HashMap();
                List<Object> voList = new ArrayList();
                if (exportStatus == null || exportStatus == 1) {
                    voList = TrainingLearnServiceImpl.this.trainingApi.getUserPaperTaskExcel(project);
                } else if (exportStatus == 2) {
                    voList = TrainingLearnServiceImpl.this.trainingApi.getUserAllPaperTaskExcel(project);
                }
                List<Integer> userIdList = voList.stream().map(TrainingLearnTaskUser::getUserId).distinct().collect(Collectors.toList());
                Map<Integer, List<String>> organizeMap = TrainingLearnServiceImpl.this.userUtilService.selectOrganizeMap(userIdList, user.getGroupId());
                if (!CollectionUtils.isEmpty(userIdList)) {
                    roleMap = TrainingLearnServiceImpl.this.userUtilService.selectRolesByUsers(userIdList, ((TrainingLearnTaskUserVo)voList.get(0)).getEnterpriseId());
                    parentMap = TrainingLearnServiceImpl.this.userUtilService.selectParentMap(userIdList, ((TrainingLearnTaskUserVo)voList.get(0)).getEnterpriseId());
                    UsersAndOrgsMo mo = new UsersAndOrgsMo();
                    mo.setGroupId(((TrainingLearnTaskUserVo)voList.get(0)).getEnterpriseId());
                    mo.setLevelList(Collections.singletonList(1));
                    mo.setUserIdList(userIdList);
                    mo.setShowDepartment(Boolean.valueOf(false));
                    BaseResult base1 = TrainingLearnServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                    if (base1 != null) {
                        organMap1 = (Map)base1.getData();
                    }
                    mo.setLevelList(Collections.singletonList(2));
                    BaseResult base2 = TrainingLearnServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                    if (base2 != null) {
                        organMap2 = (Map)base2.getData();
                    }
                    mo.setLevelList(Collections.singletonList(3));
                    BaseResult base3 = TrainingLearnServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                    if (base3 != null) {
                        organMap3 = (Map)base3.getData();
                    }
                    mo.setLevelList(Collections.singletonList(4));
                    BaseResult base4 = TrainingLearnServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                    if (base4 != null) {
                        organMap4 = (Map)base4.getData();
                    }
                    mo.setLevelList(Collections.singletonList(5));
                    BaseResult base5 = TrainingLearnServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                    if (base5 != null) {
                        organMap5 = (Map)base5.getData();
                    }
                    UsersAndOrgsMo mo1 = new UsersAndOrgsMo();
                    mo1.setGroupId(((TrainingLearnTaskUserVo)voList.get(0)).getEnterpriseId());
                    mo1.setUserIdList(userIdList);
                    mo1.setShowDepartment(Boolean.valueOf(true));
                    BaseResult base = TrainingLearnServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo1);
                    if (base != null && base.getData() != null) {
                        shopMap = (Map)base.getData();
                    }
                }
                XSSFRow row = sheet.createRow(0);
                row.createCell(0).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.learn.classes.name", null, locale));
                row.createCell(1).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.user.details.id", null, locale));
                row.createCell(2).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.user.details.username", null, locale));
                row.createCell(3).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.course.trainee.name", null, locale));
                row.createCell(4).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.user.details.employeeNumber", null, locale));
                row.createCell(5).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.course.analysis.role", null, locale));
                row.createCell(6).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.job.post.name", null, locale));
                row.createCell(7).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.course.analysis.superior", null, locale));
                row.createCell(8).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.course.analysis.department", null, locale));
                row.createCell(9).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.course.analysis.first.organize", null, locale));
                row.createCell(10).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.course.analysis.second.organize", null, locale));
                row.createCell(11).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.course.analysis.third.organize", null, locale));
                row.createCell(12).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.course.analysis.fourth.organize", null, locale));
                row.createCell(13).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.course.analysis.fifth.organize", null, locale));
                row.createCell(14).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.course.analysis.dep", null, locale));
                row.createCell(15).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.learn.paper.validity", null, locale));
                for (int i = 0; i < voList.size(); ++i) {
                    List pojoList;
                    List pojoList2;
                    List pojoList3;
                    List pojoList4;
                    List pojoList5;
                    List pojoList6;
                    List pojoList7;
                    row = sheet.createRow(i + 1);
                    TrainingLearnTaskUserVo vo2 = (TrainingLearnTaskUserVo)voList.get(i);
                    row.createCell(0).setCellValue(vo2.getShiftName() + "-" + vo2.getGroupName() + "-" + vo2.getSupplemenName());
                    row.createCell(1).setCellValue(String.valueOf(vo2.getUserId()));
                    row.createCell(2).setCellValue(vo2.getUserAccount());
                    row.createCell(3).setCellValue(vo2.getUserName());
                    row.createCell(4).setCellValue(vo2.getEmployeeNumber());
                    String roleName = "";
                    if (!CollectionUtils.isEmpty(roleMap) && !CollectionUtils.isEmpty((Collection)(pojoList7 = (List)roleMap.get(vo2.getUserId())))) {
                        List listStr = pojoList7.stream().map(RolePojo::getRoleName).filter(Objects::nonNull).collect(Collectors.toList());
                        roleName = StringUtils.join(listStr, (String)",");
                    }
                    row.createCell(5).setCellValue(roleName);
                    row.createCell(6).setCellValue(vo2.getPost());
                    String parentName = "";
                    if (!org.springframework.util.StringUtils.isEmpty(parentMap)) {
                        parentName = (String)parentMap.get(vo2.getUserId());
                    }
                    row.createCell(7).setCellValue(parentName);
                    String organName1 = "";
                    if (!org.springframework.util.StringUtils.isEmpty(organMap1) && !CollectionUtils.isEmpty((Collection)(pojoList6 = (List)organMap1.get(vo2.getUserId())))) {
                        pojoList6 = pojoList6.stream().distinct().collect(Collectors.toList());
                        organName1 = StringUtils.join(pojoList6, (String)",");
                    }
                    String departName = "";
                    List<String> nameList = organizeMap.get(vo2.getUserId());
                    if (!CollectionUtils.isEmpty(nameList)) {
                        departName = String.join((CharSequence)";\n", nameList);
                    }
                    row.createCell(8).setCellValue(departName);
                    row.createCell(9).setCellValue(organName1);
                    String organName2 = "";
                    if (!org.springframework.util.StringUtils.isEmpty(organMap2) && !CollectionUtils.isEmpty((Collection)(pojoList5 = (List)organMap2.get(vo2.getUserId())))) {
                        pojoList5 = pojoList5.stream().distinct().collect(Collectors.toList());
                        organName2 = StringUtils.join(pojoList5, (String)",");
                    }
                    row.createCell(10).setCellValue(organName2);
                    String organName3 = "";
                    if (!org.springframework.util.StringUtils.isEmpty(organMap3) && !CollectionUtils.isEmpty((Collection)(pojoList4 = (List)organMap3.get(vo2.getUserId())))) {
                        pojoList4 = pojoList4.stream().distinct().collect(Collectors.toList());
                        organName3 = StringUtils.join(pojoList4, (String)",");
                    }
                    row.createCell(11).setCellValue(organName3);
                    String organName4 = "";
                    if (!org.springframework.util.StringUtils.isEmpty(organMap4) && !CollectionUtils.isEmpty((Collection)(pojoList3 = (List)organMap4.get(vo2.getUserId())))) {
                        pojoList3 = pojoList3.stream().distinct().collect(Collectors.toList());
                        organName4 = StringUtils.join(pojoList3, (String)",");
                    }
                    row.createCell(12).setCellValue(organName4);
                    String organName5 = "";
                    if (!org.springframework.util.StringUtils.isEmpty(organMap5) && !CollectionUtils.isEmpty((Collection)(pojoList2 = (List)organMap5.get(vo2.getUserId())))) {
                        pojoList2 = pojoList2.stream().distinct().collect(Collectors.toList());
                        organName5 = StringUtils.join(pojoList2, (String)",");
                    }
                    row.createCell(13).setCellValue(organName5);
                    String shopName = "";
                    if (!org.springframework.util.StringUtils.isEmpty(shopMap) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)shopMap.get(vo2.getUserId())))) {
                        pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                        shopName = StringUtils.join(pojoList, (String)",");
                    }
                    row.createCell(14).setCellValue(shopName);
                    if (org.springframework.util.StringUtils.isEmpty((Object)vo2.getTaskEndTime())) {
                        row.createCell(15).setCellValue(DateUtils.format((Date)vo2.getTaskStartTime()) + "-" + DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
                        continue;
                    }
                    row.createCell(15).setCellValue(DateUtils.format((Date)vo2.getTaskStartTime()) + "-" + vo2.getTaskEndTime());
                }
                if (exportStatus == null || exportStatus == 1) {
                    row = sheet.getRow(0);
                    row.createCell(16).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.paper.finish.time", null, locale));
                    row.createCell(17).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.paper.num", null, locale));
                    row.createCell(18).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.course.average.time", null, locale));
                    row.createCell(19).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.certificate.paper.score", null, locale));
                    row.createCell(20).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.paper.status", null, locale));
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    for (int i = 0; i < voList.size(); ++i) {
                        row = sheet.getRow(i + 1);
                        vo = (TrainingLearnTaskUserVo)voList.get(i);
                        row.createCell(16).setCellValue(vo.getEndTime() == null ? "-" : format.format(vo.getEndTime()));
                        row.createCell(17).setCellValue(vo.getPaperCount() == null ? "-" : vo.getPaperCount().toString());
                        row.createCell(18).setCellValue(vo.getUseTimeFormal() == null ? "-" : vo.getUseTimeFormal());
                        row.createCell(19).setCellValue(vo.getScore() == null ? "-" : vo.getScore().toString());
                        statusName = "";
                        if (vo.getTaskStatus() == 0) {
                            statusName = TrainingLearnServiceImpl.this.messageSource.getMessage("training.course.status.unstart", null, locale);
                        } else if (vo.getTaskStatus() == 1) {
                            statusName = TrainingLearnServiceImpl.this.messageSource.getMessage("training.course.status.ing", null, locale);
                        } else if (vo.getTaskStatus() == 2) {
                            statusName = TrainingLearnServiceImpl.this.messageSource.getMessage("training.learn.wait.read", null, locale);
                        } else if (vo.getTaskStatus() == 3) {
                            statusName = TrainingLearnServiceImpl.this.messageSource.getMessage("training.learn.unpass", null, locale);
                        } else if (vo.getTaskStatus() == 4) {
                            statusName = TrainingLearnServiceImpl.this.messageSource.getMessage("training.paper.pass", null, locale);
                        }
                        row.createCell(20).setCellValue(statusName);
                    }
                }
                if (exportStatus == 2) {
                    row = sheet.getRow(0);
                    row.createCell(16).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.paper.handtime", null, locale));
                    row.createCell(17).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.operate.usetime", null, locale));
                    row.createCell(18).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.paper.score", null, locale));
                    row.createCell(19).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.paper.status", null, locale));
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    for (int i = 0; i < voList.size(); ++i) {
                        row = sheet.getRow(i + 1);
                        vo = (TrainingLearnTaskUserVo)voList.get(i);
                        row.createCell(16).setCellValue(vo.getCommitTime() == null ? "-" : format.format(vo.getCommitTime()));
                        row.createCell(17).setCellValue(vo.getUseTimeFormal() == null ? "-" : vo.getUseTimeFormal());
                        statusName = "";
                        String score = "";
                        if (vo.getTaskStatus() == 1 || vo.getTaskStatus() == 0) {
                            statusName = TrainingLearnServiceImpl.this.messageSource.getMessage("training.paper.unexam", null, locale);
                            score = "-";
                        } else if (vo.getTaskStatus() == 2) {
                            statusName = TrainingLearnServiceImpl.this.messageSource.getMessage("training.paper.ing", null, locale);
                            score = "-";
                        } else if (vo.getTaskStatus() == 3) {
                            statusName = TrainingLearnServiceImpl.this.messageSource.getMessage("training.paper.pass", null, locale);
                            score = String.valueOf(vo.getScore());
                        } else if (vo.getTaskStatus() == 4) {
                            statusName = TrainingLearnServiceImpl.this.messageSource.getMessage("training.learn.unpass", null, locale);
                            score = String.valueOf(vo.getScore());
                        } else if (vo.getTaskStatus() == 5) {
                            statusName = TrainingLearnServiceImpl.this.messageSource.getMessage("training.learn.wait.read", null, locale);
                            score = "-";
                        }
                        row.createCell(18).setCellValue(score);
                        row.createCell(19).setCellValue(statusName);
                    }
                }
                try {
                    DownloadUtils.successExportTask((Workbook)wb, exportTaskPojo);
                }
                catch (Exception e) {
                    log.error("getUserPaperTaskExcel", (Throwable)e);
                    DownloadUtils.errorExportTask(exportTaskPojo);
                }
            }
        });
        taskList.add(exportTaskPojo);
        return JsonResult.success(taskList);
    }

    @Override
    public String getUserOfflineTaskExcel(String taskName, final Integer taskId, final Integer shiftId, final String creater, final Users user) {
        final Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        JSONObject param = new JSONObject();
        param.fluentPut("taskName", (Object)taskName).fluentPut("taskId", (Object)taskId).fluentPut("shiftId", (Object)shiftId).fluentPut("creater", (Object)creater);
        String fileName = MessageFormat.format("{0}_{1}_{2}", taskName.split("\\.")[0], this.messageSource.getMessage("training.course.student.details", null, locale), DateUtils.format((Date)new Date(), (String)"yyyyMMdd"));
        fileName = ExcelUtil.getFileName(fileName) + ".xlsx";
        ArrayList<ExportTaskPojo> taskList = new ArrayList<ExportTaskPojo>();
        final ExportTaskPojo exportTaskPojo = DownloadUtils.saveExportTask(fileName, param.toJSONString(), 16);
        final String sheetName = this.messageSource.getMessage("training.course.student.details", null, locale);
        ThreadPoolUtil.getThreadPoolExecutor().execute(new Runnable(){

            @Override
            public void run() {
                HashMap<String, Object> project = new HashMap<String, Object>();
                project.put("taskId", taskId);
                project.put("shiftId", shiftId);
                project.put("creater", creater);
                project.put("user", user);
                List<TrainingLearnTaskUserVo> voList = TrainingLearnServiceImpl.this.trainingApi.getUserOfflineTaskExcel(project);
                String employeeNumber = TrainingLearnServiceImpl.this.messageSource.getMessage("training.user.details.employeeNumber", null, locale);
                String department = TrainingLearnServiceImpl.this.messageSource.getMessage("training.course.analysis.department", null, locale);
                String passStatusName = TrainingLearnServiceImpl.this.messageSource.getMessage("training.shift.pass.status", null, locale);
                String passName = TrainingLearnServiceImpl.this.messageSource.getMessage("training.learn.pass", null, locale);
                String unPassName = TrainingLearnServiceImpl.this.messageSource.getMessage("training.learn.unpass", null, locale);
                XSSFWorkbook wb = new XSSFWorkbook();
                XSSFSheet sheet = wb.createSheet(sheetName);
                XSSFCellStyle titleSty = wb.createCellStyle();
                XSSFDataFormat dataFormat = wb.createDataFormat();
                titleSty.setDataFormat(dataFormat.getFormat("@"));
                sheet.setDefaultColumnStyle(1, (CellStyle)titleSty);
                sheet.setColumnWidth(1, 3000);
                XSSFRow row = sheet.createRow(0);
                row.createCell(0).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.learn.shift.classes.name", null, locale));
                row.createCell(1).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.user.details.id", null, locale));
                row.createCell(2).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.user.details.username", null, locale));
                row.createCell(3).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.course.trainee.name", null, locale));
                row.createCell(4).setCellValue(employeeNumber);
                row.createCell(5).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.course.analysis.role", null, locale));
                row.createCell(6).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.job.post.name", null, locale));
                row.createCell(7).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.course.analysis.superior", null, locale));
                row.createCell(8).setCellValue(department);
                row.createCell(9).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.certificate.activity.validity", null, locale));
                row.createCell(10).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.certificate.activity.time", null, locale) + TrainingLearnServiceImpl.this.messageSource.getMessage("training.material.hours", null, locale));
                row.createCell(11).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.certificate.sign.time", null, locale));
                row.createCell(12).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.certificate.signout.time", null, locale));
                row.createCell(13).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.job.participation.number", null, locale) + TrainingLearnServiceImpl.this.messageSource.getMessage("training.material.hours", null, locale));
                row.createCell(14).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.absences.number", null, locale) + TrainingLearnServiceImpl.this.messageSource.getMessage("training.material.hours", null, locale));
                row.createCell(15).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.course.attendance", null, locale));
                row.createCell(16).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.certificate.mark", null, locale));
                row.createCell(17).setCellValue(passStatusName);
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                for (int i = 0; i < voList.size(); ++i) {
                    row = sheet.createRow(i + 1);
                    TrainingLearnTaskUserVo vo = voList.get(i);
                    row.createCell(0).setCellValue(vo.getShiftName() + "-" + vo.getGroupName() + "-" + vo.getSupplemenName());
                    row.createCell(1).setCellValue((double)vo.getUserId().intValue());
                    row.createCell(2).setCellValue(vo.getUserAccount());
                    row.createCell(3).setCellValue(vo.getUserName());
                    row.createCell(4).setCellValue(vo.getEmployeeNumber());
                    row.createCell(5).setCellValue(vo.getRole());
                    row.createCell(6).setCellValue(vo.getPost());
                    row.createCell(7).setCellValue(vo.getParentName());
                    row.createCell(8).setCellValue(vo.getOrganizeName());
                    row.createCell(9).setCellValue((vo.getTaskStartTime() == null ? "" : format.format(vo.getTaskStartTime())) + " - " + (vo.getTaskEndTime() == null ? "" : format.format(vo.getTaskEndTime())));
                    row.createCell(10).setCellValue(vo.getActTime() == null ? "" : vo.getActTime().toString());
                    row.createCell(11).setCellValue(vo.getStartTime() == null ? "-" : format.format(vo.getStartTime()));
                    row.createCell(12).setCellValue(vo.getEndTime() == null ? "-" : format.format(vo.getEndTime()));
                    int allTime = vo.getIsAllTime();
                    String useTimeVo = "";
                    String cutTimeVo = "";
                    String outRate = "";
                    if (allTime == 0) {
                        useTimeVo = vo.getUseTimeVo() == null ? "" : vo.getUseTimeVo().toString();
                        cutTimeVo = vo.getCutTimeVo() == null ? "" : vo.getCutTimeVo().toString();
                        outRate = vo.getOutRate() == null ? "" : vo.getOutRate().toString() + "%";
                    } else if (allTime == 1) {
                        useTimeVo = "-";
                        cutTimeVo = "-";
                        outRate = "-";
                    } else if (allTime == 2) {
                        if (vo.getTaskEndTime() == null || vo.getTaskEndTime().compareTo(new Date()) >= 0) {
                            useTimeVo = "-";
                            cutTimeVo = "-";
                            outRate = "-";
                        } else {
                            useTimeVo = "0";
                            cutTimeVo = vo.getCutTimeVo() == null ? "" : vo.getCutTimeVo().toString();
                            outRate = "0%";
                        }
                    }
                    row.createCell(13).setCellValue(useTimeVo);
                    row.createCell(14).setCellValue(cutTimeVo);
                    row.createCell(15).setCellValue(outRate);
                    row.createCell(16).setCellValue(vo.getScore() == null ? "-" : vo.getScore().toString());
                    String statusName = "";
                    statusName = vo.getTaskStatus() != null && vo.getTaskStatus() == 3 ? unPassName : (vo.getTaskStatus() != null && vo.getTaskStatus() == 4 ? passName : "-");
                    row.createCell(17).setCellValue(statusName);
                }
                try {
                    DownloadUtils.successExportTask((Workbook)wb, exportTaskPojo);
                }
                catch (Exception e) {
                    log.error("getUserOfflineTaskExcel", (Throwable)e);
                    DownloadUtils.errorExportTask(exportTaskPojo);
                }
            }
        });
        taskList.add(exportTaskPojo);
        return JsonResult.success(taskList);
    }

    @Override
    public String getUserTaskExcel(String projectName, final Integer projectId, final Integer id, final String groupName, final Integer creatorId, final String userName, final Users user) {
        final Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        JSONObject param = new JSONObject();
        param.fluentPut("projectId", (Object)projectId).fluentPut("id", (Object)id).fluentPut("groupName", (Object)groupName).fluentPut("creatorId", (Object)creatorId).fluentPut("userName", (Object)userName);
        String studentAnalysis = this.messageSource.getMessage("training.course.student.analysis", null, locale);
        String fileName = MessageFormat.format("{0}_{1}_{2}", projectName, studentAnalysis, DateUtils.format((Date)new Date(), (String)"yyyyMMdd"));
        fileName = ExcelUtil.getFileName(fileName) + ".xlsx";
        ArrayList<ExportTaskPojo> taskList = new ArrayList<ExportTaskPojo>();
        final ExportTaskPojo exportTaskPojo = DownloadUtils.saveExportTask(fileName, param.toJSONString(), 17);
        ThreadPoolUtil.getThreadPoolExecutor().execute(new Runnable(){

            @Override
            public void run() {
                HashMap<String, Object> project = new HashMap<String, Object>();
                project.put("projectId", projectId);
                project.put("id", id);
                project.put("groupName", groupName);
                project.put("creatorId", creatorId);
                project.put("userName", userName);
                project.put("user", user);
                List<TrainingLearnUserVo> voList = TrainingLearnServiceImpl.this.trainingApi.getUserTaskExcel(project);
                XSSFWorkbook wb = new XSSFWorkbook();
                XSSFSheet sheet = wb.createSheet(TrainingLearnServiceImpl.this.messageSource.getMessage("training.course.student.analysis", null, locale));
                XSSFCellStyle titleSty = wb.createCellStyle();
                XSSFDataFormat dataFormat = wb.createDataFormat();
                titleSty.setDataFormat(dataFormat.getFormat("@"));
                sheet.setDefaultColumnStyle(1, (CellStyle)titleSty);
                sheet.setColumnWidth(1, 3000);
                XSSFRow row = sheet.createRow(0);
                row.createCell(0).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.learn.shift.classes.name", null, locale));
                row.createCell(1).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.user.details.id", null, locale));
                row.createCell(2).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.user.details.username", null, locale));
                row.createCell(3).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.course.trainee.name", null, locale));
                row.createCell(4).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.user.details.employeeNumber", null, locale));
                row.createCell(5).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.course.analysis.role", null, locale));
                row.createCell(6).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.job.post.name", null, locale));
                row.createCell(7).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.course.analysis.superior", null, locale));
                row.createCell(8).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.course.analysis.department", null, locale));
                row.createCell(9).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.learn.arrival.time", null, locale));
                row.createCell(10).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.course.analysis.starttime", null, locale));
                row.createCell(11).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.course.analysis.endtime", null, locale));
                row.createCell(12).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.course.analysis.study.status", null, locale));
                row.createCell(13).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.paper.total.score", null, locale));
                row.createCell(14).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.shift.pass.status", null, locale));
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                for (int i = 0; i < voList.size(); ++i) {
                    row = sheet.createRow(i + 1);
                    TrainingLearnUserVo vo = voList.get(i);
                    row.createCell(0).setCellValue(vo.getShiftName() + "-" + vo.getGroupName() + "-" + vo.getSupplemenName());
                    row.createCell(1).setCellValue((double)vo.getUserId().intValue());
                    row.createCell(2).setCellValue(vo.getUserAccount());
                    row.createCell(3).setCellValue(vo.getUserName());
                    row.createCell(4).setCellValue(vo.getJobNumber());
                    row.createCell(5).setCellValue(vo.getRole());
                    row.createCell(6).setCellValue(vo.getPost());
                    row.createCell(7).setCellValue(vo.getParentName());
                    row.createCell(8).setCellValue(vo.getDepartment());
                    row.createCell(9).setCellValue(vo.getCreateTime() == null ? "-" : format.format(vo.getCreateTime()));
                    row.createCell(10).setCellValue(vo.getStartTime() == null ? "-" : format.format(vo.getStartTime()));
                    row.createCell(11).setCellValue(vo.getEndTime() == null ? "-" : format.format(vo.getEndTime()));
                    String unStart = TrainingLearnServiceImpl.this.messageSource.getMessage("training.course.status.unstart", null, locale);
                    String going = TrainingLearnServiceImpl.this.messageSource.getMessage("training.job.status.going", null, locale);
                    String completed = TrainingLearnServiceImpl.this.messageSource.getMessage("training.job.status.completed", null, locale);
                    if (vo.getLearnStatus() != null) {
                        if (vo.getLearnStatus() == 0) {
                            row.createCell(12).setCellValue(unStart + " " + vo.getFinishTask() + "/" + vo.getLearnTask());
                        } else if (vo.getLearnStatus() == 1) {
                            row.createCell(12).setCellValue(unStart + " " + vo.getFinishTask() + "/" + vo.getLearnTask());
                        } else if (vo.getLearnStatus() == 2) {
                            row.createCell(12).setCellValue(going + " " + vo.getFinishTask() + "/" + vo.getLearnTask());
                        } else if (vo.getLearnStatus() == 3) {
                            row.createCell(12).setCellValue(completed + " " + vo.getFinishTask() + "/" + vo.getLearnTask());
                        }
                    } else {
                        row.createCell(12).setCellValue("-");
                    }
                    if (vo.getScore() != null) {
                        row.createCell(13).setCellValue(vo.getScore().setScale(1, 4).toString());
                    } else {
                        row.createCell(13).setCellValue("-");
                    }
                    if (vo.getPassStatus() != null) {
                        if (vo.getPassStatus() == 1) {
                            row.createCell(14).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.paper.pass", null, locale));
                            continue;
                        }
                        row.createCell(14).setCellValue(TrainingLearnServiceImpl.this.messageSource.getMessage("training.learn.unpass", null, locale));
                        continue;
                    }
                    row.createCell(14).setCellValue("-");
                }
                try {
                    DownloadUtils.successExportTask((Workbook)wb, exportTaskPojo);
                }
                catch (Exception e) {
                    log.error("getUserTaskExcel", (Throwable)e);
                    DownloadUtils.errorExportTask(exportTaskPojo);
                }
            }
        });
        taskList.add(exportTaskPojo);
        return JsonResult.success(taskList);
    }
}

