/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ovopark.api.TrainingApi;
import com.ovopark.bo.Authenticator;
import com.ovopark.bo.JsonResult;
import com.ovopark.organize.common.model.pojo.ExportTaskPojo;
import com.ovopark.pojo.TrainingMaterialDownloadsVo;
import com.ovopark.pojo.Users;
import com.ovopark.service.TrainingMaterialService;
import com.ovopark.utils.DownloadUtils;
import com.ovopark.utils.ThreadPoolUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Executor;
import javax.annotation.Resource;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TrainingMaterialServiceImpl
implements TrainingMaterialService {
    private static final Logger log = LoggerFactory.getLogger(TrainingMaterialServiceImpl.class);
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private TrainingApi trainingApi;
    @Resource(name="export")
    private Executor exportExecutor;

    @Override
    public String getMaterialDownloadsByExcel(final Integer materialId, final String materialName, final Users user) {
        final Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        JSONObject param = new JSONObject();
        param.fluentPut("materialId", (Object)materialId);
        final String fileName = this.messageSource.getMessage("training.material.downloads", null, locale);
        ArrayList<ExportTaskPojo> taskList = new ArrayList<ExportTaskPojo>();
        final ExportTaskPojo exportTaskPojo = DownloadUtils.saveExportTask(fileName + ".xlsx", param.toJSONString(), 38);
        ThreadPoolUtil.getThreadPoolExecutor().execute(new Runnable(){

            @Override
            public void run() {
                List<TrainingMaterialDownloadsVo> voList = TrainingMaterialServiceImpl.this.trainingApi.getMaterialDownloadsByExcel(materialId, user);
                XSSFWorkbook wb = new XSSFWorkbook();
                XSSFSheet sheet = wb.createSheet(fileName);
                XSSFCellStyle titleSty = wb.createCellStyle();
                XSSFFont font = wb.createFont();
                font.setFontHeightInPoints((short)16);
                titleSty.setFont((Font)font);
                XSSFRow row = sheet.createRow(0);
                row.createCell(0).setCellValue(TrainingMaterialServiceImpl.this.messageSource.getMessage("training.material.downloads.file.name", new Object[]{materialName}, locale));
                sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 2));
                row = sheet.createRow(1);
                row.createCell(0).setCellValue(TrainingMaterialServiceImpl.this.messageSource.getMessage("training.material.downloads.time", null, locale));
                row.createCell(1).setCellValue(TrainingMaterialServiceImpl.this.messageSource.getMessage("training.course.analysis.showname", null, locale));
                row.createCell(2).setCellValue(TrainingMaterialServiceImpl.this.messageSource.getMessage("training.course.analysis.username", null, locale));
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                if (!CollectionUtils.isEmpty(voList)) {
                    for (int i = 0; i < voList.size(); ++i) {
                        row = sheet.createRow(i + 2);
                        TrainingMaterialDownloadsVo vo = voList.get(i);
                        row.createCell(0).setCellValue(vo.getCreateTime() == null ? "-" : format.format(vo.getCreateTime()));
                        row.createCell(1).setCellValue(vo.getShowName());
                        row.createCell(2).setCellValue(vo.getUserName());
                    }
                }
                try {
                    DownloadUtils.successExportTask((Workbook)wb, exportTaskPojo);
                }
                catch (Exception e) {
                    log.error("getMaterialDownloadsByExcel", (Throwable)e);
                    DownloadUtils.errorExportTask(exportTaskPojo);
                }
            }
        });
        taskList.add(exportTaskPojo);
        return JsonResult.success(taskList);
    }
}

