/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ovopark.api.TrainingApi;
import com.ovopark.bo.Authenticator;
import com.ovopark.bo.JsonResult;
import com.ovopark.organize.common.model.mo.UserDutiesMo;
import com.ovopark.organize.common.model.mo.UsersAndOrgsMo;
import com.ovopark.organize.common.model.pojo.ExportTaskPojo;
import com.ovopark.organize.sdk.api.UserOrganizeApi;
import com.ovopark.pojo.ExaminerAnalysisReq;
import com.ovopark.pojo.ExaminerAnalysisUserVo;
import com.ovopark.pojo.ExaminerAnalysisVo;
import com.ovopark.pojo.OperateCheck;
import com.ovopark.pojo.TraineeAnalysisReq;
import com.ovopark.pojo.TraineeAnalysisUserVo;
import com.ovopark.pojo.TraineeAnalysisVo;
import com.ovopark.pojo.TrainingActivity;
import com.ovopark.pojo.TrainingActivityUserVo;
import com.ovopark.pojo.TrainingExeclVo;
import com.ovopark.pojo.Users;
import com.ovopark.privilege.api.RoleApi;
import com.ovopark.privilege.pojo.RolePojo;
import com.ovopark.privilege.response.BaseResult;
import com.ovopark.service.TrainingService;
import com.ovopark.service.UserUtilService;
import com.ovopark.utils.DateUtils;
import com.ovopark.utils.DownloadUtils;
import com.ovopark.utils.ExcelUtil;
import com.ovopark.utils.ThreadPoolUtil;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TrainingServiceImpl
implements TrainingService {
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private RoleApi roleApi;
    @Autowired
    private UserOrganizeApi userOrganizeApi;
    @Autowired
    private UserUtilService userUtilService;
    @Autowired
    private TrainingApi trainingApi;

    @Override
    public String selectExeclVoByUserByExecl(final TrainingExeclVo trainingExeclVo) {
        final String[] str = trainingExeclVo.getExcelStr().split(",");
        final Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        final String accountNumber = this.messageSource.getMessage("training.job.account.number", null, locale);
        final String trainingCount = this.messageSource.getMessage("training.shift.training.count", null, locale);
        String student = this.messageSource.getMessage("training.shift.student", null, locale);
        String fileName = MessageFormat.format("{0}_{1}_{2}.xlsx", trainingCount, student, DateUtils.format((Date)new Date(), (String)"yyyyMMdd_HHmmss"));
        ArrayList<ExportTaskPojo> taskList = new ArrayList<ExportTaskPojo>();
        final ExportTaskPojo exportTaskPojo = DownloadUtils.saveExportTask(fileName, JSON.toJSONString((Object)trainingExeclVo), 1);
        ThreadPoolUtil.getThreadPoolExecutor().execute(new Runnable(){

            @Override
            public void run() {
                List<TrainingExeclVo> list = TrainingServiceImpl.this.trainingApi.selectExeclVoByUser(trainingExeclVo);
                ArrayList<Integer> userIdList = new ArrayList();
                String userStr = "";
                if (!CollectionUtils.isEmpty(list) && !CollectionUtils.isEmpty(userIdList = list.stream().map(TrainingExeclVo::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                    userStr = StringUtils.join(userIdList, (String)",");
                }
                XSSFWorkbook wb = new XSSFWorkbook();
                XSSFSheet sheet = wb.createSheet(trainingCount);
                XSSFCellStyle titleSty = wb.createCellStyle();
                titleSty.setWrapText(true);
                XSSFRow row = sheet.createRow(0);
                row.createCell(0).setCellValue("id");
                int currentNum = 0;
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[1]) && str[1].equals("1")) {
                    row.createCell(++currentNum).setCellValue(accountNumber);
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[2]) && str[2].equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.course.trainee.name", null, locale));
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[3]) && str[3].equals("1")) {
                    String employeeNumber = TrainingServiceImpl.this.messageSource.getMessage("training.user.details.employeeNumber", null, locale);
                    row.createCell(++currentNum).setCellValue(employeeNumber);
                }
                Map roleMap = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[4]) && str[4].equals("1")) {
                    String role = TrainingServiceImpl.this.messageSource.getMessage("training.course.analysis.role", null, locale);
                    row.createCell(++currentNum).setCellValue(role);
                    if (!org.springframework.util.StringUtils.isEmpty((Object)userStr)) {
                        HashMap<String, Object> parameter = new HashMap<String, Object>();
                        parameter.put("userIds", userStr);
                        parameter.put("groupId", trainingExeclVo.getUser().getGroupId());
                        BaseResult base = TrainingServiceImpl.this.roleApi.getUserRoleList(parameter);
                        if (base != null) {
                            roleMap = (Map)base.getData();
                        }
                    }
                }
                Map<Object, Object> dutiesMap = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[5]) && str[5].equals("1")) {
                    String post = TrainingServiceImpl.this.messageSource.getMessage("training.job.post.name", null, locale);
                    row.createCell(++currentNum).setCellValue(post);
                    dutiesMap = TrainingServiceImpl.this.userUtilService.selectDutiesMap(userIdList, trainingExeclVo.getUser().getGroupId());
                }
                Map<Object, Object> parentMap = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[6]) && str[6].equals("1")) {
                    String leader = TrainingServiceImpl.this.messageSource.getMessage("training.course.analysis.superior", null, locale);
                    row.createCell(++currentNum).setCellValue(leader);
                    parentMap = TrainingServiceImpl.this.userUtilService.selectParentMap(userIdList, trainingExeclVo.getUser().getGroupId());
                }
                Map<Object, Object> organizeMap = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[7]) && str[7].equals("1")) {
                    String leader = TrainingServiceImpl.this.messageSource.getMessage("training.learn.department", null, locale);
                    row.createCell(++currentNum).setCellValue(leader);
                    organizeMap = TrainingServiceImpl.this.userUtilService.selectOrganizeMap(userIdList, trainingExeclVo.getUser().getGroupId());
                }
                Map organMap1 = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[8]) && str[8].equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.course.analysis.first.organize", null, locale));
                    if (!CollectionUtils.isEmpty(userIdList)) {
                        UsersAndOrgsMo mo = new UsersAndOrgsMo();
                        mo.setGroupId(trainingExeclVo.getUser().getGroupId());
                        mo.setLevelList(Arrays.asList(1));
                        mo.setUserIdList(userIdList);
                        mo.setShowDepartment(Boolean.valueOf(false));
                        com.ovopark.organize.common.base.BaseResult base = TrainingServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                        if (base != null) {
                            organMap1 = (Map)base.getData();
                        }
                    }
                }
                Map organMap2 = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[9]) && str[9].equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.course.analysis.second.organize", null, locale));
                    if (!CollectionUtils.isEmpty(userIdList)) {
                        UsersAndOrgsMo mo = new UsersAndOrgsMo();
                        mo.setGroupId(trainingExeclVo.getUser().getGroupId());
                        mo.setLevelList(Arrays.asList(2));
                        mo.setUserIdList(userIdList);
                        mo.setShowDepartment(Boolean.valueOf(false));
                        com.ovopark.organize.common.base.BaseResult base = TrainingServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                        if (base != null) {
                            organMap2 = (Map)base.getData();
                        }
                    }
                }
                Map organMap3 = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[10]) && str[10].equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.course.analysis.third.organize", null, locale));
                    if (!CollectionUtils.isEmpty(userIdList)) {
                        UsersAndOrgsMo mo = new UsersAndOrgsMo();
                        mo.setGroupId(trainingExeclVo.getUser().getGroupId());
                        mo.setLevelList(Arrays.asList(3));
                        mo.setUserIdList(userIdList);
                        mo.setShowDepartment(Boolean.valueOf(false));
                        com.ovopark.organize.common.base.BaseResult base = TrainingServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                        if (base != null) {
                            organMap3 = (Map)base.getData();
                        }
                    }
                }
                Map organMap4 = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[11]) && str[11].equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.course.analysis.fourth.organize", null, locale));
                    if (!CollectionUtils.isEmpty(userIdList)) {
                        UsersAndOrgsMo mo = new UsersAndOrgsMo();
                        mo.setGroupId(trainingExeclVo.getUser().getGroupId());
                        mo.setLevelList(Arrays.asList(4));
                        mo.setUserIdList(userIdList);
                        mo.setShowDepartment(Boolean.valueOf(false));
                        com.ovopark.organize.common.base.BaseResult base = TrainingServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                        if (base != null) {
                            organMap4 = (Map)base.getData();
                        }
                    }
                }
                Map organMap5 = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[12]) && str[12].equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.course.analysis.fifth.organize", null, locale));
                    if (!CollectionUtils.isEmpty(userIdList)) {
                        UsersAndOrgsMo mo = new UsersAndOrgsMo();
                        mo.setGroupId(trainingExeclVo.getUser().getGroupId());
                        mo.setLevelList(Arrays.asList(5));
                        mo.setUserIdList(userIdList);
                        mo.setShowDepartment(Boolean.valueOf(false));
                        com.ovopark.organize.common.base.BaseResult base = TrainingServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                        if (base != null) {
                            organMap5 = (Map)base.getData();
                        }
                    }
                }
                Map shopMap = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[13]) && str[13].equals("1")) {
                    String shopNames = TrainingServiceImpl.this.messageSource.getMessage("training.course.analysis.dep", null, locale);
                    row.createCell(++currentNum).setCellValue(shopNames);
                    if (!CollectionUtils.isEmpty(userIdList)) {
                        UsersAndOrgsMo mo = new UsersAndOrgsMo();
                        mo.setGroupId(trainingExeclVo.getUser().getGroupId());
                        mo.setUserIdList(userIdList);
                        mo.setShowDepartment(Boolean.valueOf(true));
                        com.ovopark.organize.common.base.BaseResult base = TrainingServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                        if (base != null) {
                            shopMap = (Map)base.getData();
                        }
                    }
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[14]) && str[14].equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.learn.join.training.count", null, locale));
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[15]) && str[15].equals("1")) {
                    String studyCount = TrainingServiceImpl.this.messageSource.getMessage("training.shift.study.training.count", null, locale);
                    row.createCell(++currentNum).setCellValue(studyCount);
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[16]) && str[16].equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.learn.training.count", null, locale));
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[17]) && str[17].equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.shift.study.rate", null, locale));
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[18]) && str[18].equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.learn.end.rate", null, locale));
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[19]) && str[19].equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.shift.study.time", null, locale));
                }
                for (int i = 0; i < list.size(); ++i) {
                    List pojoList;
                    currentNum = 0;
                    row = sheet.createRow(i + 1);
                    TrainingExeclVo vo = list.get(i);
                    row.createCell(0).setCellValue((double)vo.getUserId().intValue());
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[1]) && str[1].equals("1")) {
                        row.createCell(++currentNum).setCellValue(vo.getUserName());
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[2]) && str[2].equals("1")) {
                        row.createCell(++currentNum).setCellValue(vo.getShowName());
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[3]) && str[3].equals("1")) {
                        row.createCell(++currentNum).setCellValue(vo.getEmployeeNumber());
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[4]) && str[4].equals("1")) {
                        String roleName = "";
                        if (!org.springframework.util.StringUtils.isEmpty(roleMap) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)roleMap.get(vo.getUserId())))) {
                            List listStr = pojoList.stream().map(RolePojo::getRoleName).filter(Objects::nonNull).collect(Collectors.toList());
                            roleName = StringUtils.join(listStr, (String)";\n");
                        }
                        row.createCell(++currentNum).setCellValue(roleName);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[5]) && str[5].equals("1")) {
                        String postName = "";
                        if (!org.springframework.util.StringUtils.isEmpty(dutiesMap) && !org.springframework.util.StringUtils.isEmpty((Object)dutiesMap.get(vo.getUserId()))) {
                            postName = ((UserDutiesMo)dutiesMap.get(vo.getUserId())).getDutieName();
                        }
                        row.createCell(++currentNum).setCellValue(postName);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[6]) && str[6].equals("1")) {
                        String parentName = "";
                        if (!org.springframework.util.StringUtils.isEmpty(parentMap)) {
                            parentName = (String)parentMap.get(vo.getUserId());
                        }
                        row.createCell(++currentNum).setCellValue(parentName);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[7]) && str[7].equals("1")) {
                        String departName = "";
                        List nameList = (List)organizeMap.get(vo.getUserId());
                        if (!CollectionUtils.isEmpty((Collection)nameList)) {
                            departName = String.join((CharSequence)";\n", nameList);
                        }
                        XSSFCell cell = row.createCell(++currentNum);
                        cell.setCellValue(departName);
                        cell.setCellStyle((CellStyle)titleSty);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[8]) && str[8].equals("1")) {
                        String organName1 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap1) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)organMap1.get(vo.getUserId())))) {
                            pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                            organName1 = StringUtils.join((Collection)pojoList, (String)",");
                        }
                        row.createCell(++currentNum).setCellValue(organName1);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[9]) && str[9].equals("1")) {
                        String organName2 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap2) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)organMap2.get(vo.getUserId())))) {
                            pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                            organName2 = StringUtils.join((Collection)pojoList, (String)",");
                        }
                        row.createCell(++currentNum).setCellValue(organName2);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[10]) && str[10].equals("1")) {
                        String organName3 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap3) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)organMap3.get(vo.getUserId())))) {
                            pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                            organName3 = StringUtils.join((Collection)pojoList, (String)",");
                        }
                        row.createCell(++currentNum).setCellValue(organName3);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[11]) && str[11].equals("1")) {
                        String organName4 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap4) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)organMap4.get(vo.getUserId())))) {
                            pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                            organName4 = StringUtils.join((Collection)pojoList, (String)",");
                        }
                        row.createCell(++currentNum).setCellValue(organName4);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[12]) && str[12].equals("1")) {
                        String organName5 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap5) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)organMap5.get(vo.getUserId())))) {
                            pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                            organName5 = StringUtils.join(pojoList, (String)",");
                        }
                        row.createCell(++currentNum).setCellValue(organName5);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[13]) && str[13].equals("1")) {
                        String shopName = "";
                        if (!org.springframework.util.StringUtils.isEmpty(shopMap) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)shopMap.get(vo.getUserId())))) {
                            pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                            shopName = StringUtils.join(pojoList, (String)",");
                        }
                        row.createCell(++currentNum).setCellValue(shopName);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[14]) && str[14].equals("1")) {
                        row.createCell(++currentNum).setCellValue((double)vo.getShowNum().intValue());
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[15]) && str[15].equals("1")) {
                        row.createCell(++currentNum).setCellValue((double)vo.getStudyNum().intValue());
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[16]) && str[16].equals("1")) {
                        row.createCell(++currentNum).setCellValue((double)vo.getFinishNum().intValue());
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[17]) && str[17].equals("1")) {
                        row.createCell(++currentNum).setCellValue(vo.getStudyRate() + "%");
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[18]) && str[18].equals("1")) {
                        row.createCell(++currentNum).setCellValue(vo.getFinishRate() + "%");
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[19]) && str[19].equals("1")) {
                        row.createCell(++currentNum).setCellValue(vo.getStudyTimeStr());
                    }
                    sheet.autoSizeColumn(i + 1);
                }
                try {
                    DownloadUtils.successExportTask((Workbook)wb, exportTaskPojo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DownloadUtils.errorExportTask(exportTaskPojo);
                }
            }
        });
        taskList.add(exportTaskPojo);
        return JsonResult.success(taskList);
    }

    @Override
    public String selectUserTrainingByExecl(final TrainingExeclVo trainingExeclVo) {
        final String[] str = trainingExeclVo.getExcelStr().split(",");
        final Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        final String accountNumber = this.messageSource.getMessage("training.job.account.number", null, locale);
        String trainingCount = this.messageSource.getMessage("training.shift.training.count", null, locale);
        final String studyDetail = this.messageSource.getMessage("training.study.detail", null, locale);
        final String statusUn = this.messageSource.getMessage("training.course.status.un", null, locale);
        final String statusIng = this.messageSource.getMessage("training.course.status.ing", null, locale);
        final String statusEnd = this.messageSource.getMessage("training.course.status.end", null, locale);
        String fileName = MessageFormat.format("{0}_{1}_{2}.xlsx", trainingCount, studyDetail, DateUtils.format((Date)new Date(), (String)"yyyyMMdd_HHmmss"));
        ArrayList<ExportTaskPojo> taskList = new ArrayList<ExportTaskPojo>();
        final ExportTaskPojo exportTaskPojo = DownloadUtils.saveExportTask(fileName, JSON.toJSONString((Object)trainingExeclVo), 2);
        ThreadPoolUtil.getThreadPoolExecutor().execute(new Runnable(){

            @Override
            public void run() {
                List<TrainingExeclVo> list = TrainingServiceImpl.this.trainingApi.selectUserTraining(trainingExeclVo);
                ArrayList<Integer> userIdList = new ArrayList();
                String userStr = "";
                if (!CollectionUtils.isEmpty(list) && !CollectionUtils.isEmpty(userIdList = list.stream().map(TrainingExeclVo::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                    userStr = StringUtils.join(userIdList, (String)",");
                }
                XSSFWorkbook wb = new XSSFWorkbook();
                XSSFSheet sheet = wb.createSheet(studyDetail);
                XSSFCellStyle titleSty = wb.createCellStyle();
                titleSty.setWrapText(true);
                XSSFRow row = sheet.createRow(0);
                row.createCell(0).setCellValue("id");
                int currentNum = 0;
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[1]) && str[1].equals("1")) {
                    row.createCell(++currentNum).setCellValue(accountNumber);
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[2]) && str[2].equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.course.trainee.name", null, locale));
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[3]) && str[3].equals("1")) {
                    String employeeNumber = TrainingServiceImpl.this.messageSource.getMessage("training.user.details.employeeNumber", null, locale);
                    row.createCell(++currentNum).setCellValue(employeeNumber);
                }
                Map roleMap = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[4]) && str[4].equals("1")) {
                    String role = TrainingServiceImpl.this.messageSource.getMessage("training.course.analysis.role", null, locale);
                    row.createCell(++currentNum).setCellValue(role);
                    if (!org.springframework.util.StringUtils.isEmpty((Object)userStr)) {
                        HashMap<String, Object> parameter = new HashMap<String, Object>();
                        parameter.put("userIds", userStr);
                        parameter.put("groupId", trainingExeclVo.getUser().getGroupId());
                        BaseResult base = TrainingServiceImpl.this.roleApi.getUserRoleList(parameter);
                        if (base != null) {
                            roleMap = (Map)base.getData();
                        }
                    }
                }
                Map<Object, Object> dutiesMap = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[5]) && str[5].equals("1")) {
                    String post = TrainingServiceImpl.this.messageSource.getMessage("training.job.post.name", null, locale);
                    row.createCell(++currentNum).setCellValue(post);
                    dutiesMap = TrainingServiceImpl.this.userUtilService.selectDutiesMap(userIdList, trainingExeclVo.getUser().getGroupId());
                }
                Map<Object, Object> parentMap = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[6]) && str[6].equals("1")) {
                    String leader = TrainingServiceImpl.this.messageSource.getMessage("training.course.analysis.superior", null, locale);
                    row.createCell(++currentNum).setCellValue(leader);
                    parentMap = TrainingServiceImpl.this.userUtilService.selectParentMap(userIdList, trainingExeclVo.getUser().getGroupId());
                }
                Map<Object, Object> organizeMap = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[7]) && str[7].equals("1")) {
                    String leader = TrainingServiceImpl.this.messageSource.getMessage("training.learn.department", null, locale);
                    row.createCell(++currentNum).setCellValue(leader);
                    organizeMap = TrainingServiceImpl.this.userUtilService.selectOrganizeMap(userIdList, trainingExeclVo.getUser().getGroupId());
                }
                Map organMap1 = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[8]) && str[8].equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.course.analysis.first.organize", null, locale));
                    if (!CollectionUtils.isEmpty(userIdList)) {
                        UsersAndOrgsMo mo = new UsersAndOrgsMo();
                        mo.setGroupId(trainingExeclVo.getUser().getGroupId());
                        mo.setLevelList(Arrays.asList(1));
                        mo.setUserIdList(userIdList);
                        mo.setShowDepartment(Boolean.valueOf(false));
                        com.ovopark.organize.common.base.BaseResult base = TrainingServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                        if (base != null) {
                            organMap1 = (Map)base.getData();
                        }
                    }
                }
                Map organMap2 = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[9]) && str[9].equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.course.analysis.second.organize", null, locale));
                    if (!CollectionUtils.isEmpty(userIdList)) {
                        UsersAndOrgsMo mo = new UsersAndOrgsMo();
                        mo.setGroupId(trainingExeclVo.getUser().getGroupId());
                        mo.setLevelList(Arrays.asList(2));
                        mo.setUserIdList(userIdList);
                        mo.setShowDepartment(Boolean.valueOf(false));
                        com.ovopark.organize.common.base.BaseResult base = TrainingServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                        if (base != null) {
                            organMap2 = (Map)base.getData();
                        }
                    }
                }
                Map organMap3 = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[10]) && str[10].equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.course.analysis.third.organize", null, locale));
                    if (!CollectionUtils.isEmpty(userIdList)) {
                        UsersAndOrgsMo mo = new UsersAndOrgsMo();
                        mo.setGroupId(trainingExeclVo.getUser().getGroupId());
                        mo.setLevelList(Arrays.asList(3));
                        mo.setUserIdList(userIdList);
                        mo.setShowDepartment(Boolean.valueOf(false));
                        com.ovopark.organize.common.base.BaseResult base = TrainingServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                        if (base != null) {
                            organMap3 = (Map)base.getData();
                        }
                    }
                }
                Map organMap4 = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[11]) && str[11].equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.course.analysis.fourth.organize", null, locale));
                    if (!CollectionUtils.isEmpty(userIdList)) {
                        UsersAndOrgsMo mo = new UsersAndOrgsMo();
                        mo.setGroupId(trainingExeclVo.getUser().getGroupId());
                        mo.setLevelList(Arrays.asList(4));
                        mo.setUserIdList(userIdList);
                        mo.setShowDepartment(Boolean.valueOf(false));
                        com.ovopark.organize.common.base.BaseResult base = TrainingServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                        if (base != null) {
                            organMap4 = (Map)base.getData();
                        }
                    }
                }
                Map organMap5 = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[12]) && str[12].equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.course.analysis.fifth.organize", null, locale));
                    if (!CollectionUtils.isEmpty(userIdList)) {
                        UsersAndOrgsMo mo = new UsersAndOrgsMo();
                        mo.setGroupId(trainingExeclVo.getUser().getGroupId());
                        mo.setLevelList(Arrays.asList(5));
                        mo.setUserIdList(userIdList);
                        mo.setShowDepartment(Boolean.valueOf(false));
                        com.ovopark.organize.common.base.BaseResult base = TrainingServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                        if (base != null) {
                            organMap5 = (Map)base.getData();
                        }
                    }
                }
                Map shopMap = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[13]) && str[13].equals("1")) {
                    String shopNames = TrainingServiceImpl.this.messageSource.getMessage("training.course.analysis.dep", null, locale);
                    row.createCell(++currentNum).setCellValue(shopNames);
                    if (!CollectionUtils.isEmpty(userIdList)) {
                        UsersAndOrgsMo mo = new UsersAndOrgsMo();
                        mo.setGroupId(trainingExeclVo.getUser().getGroupId());
                        mo.setUserIdList(userIdList);
                        mo.setShowDepartment(Boolean.valueOf(true));
                        com.ovopark.organize.common.base.BaseResult base = TrainingServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                        if (base != null) {
                            shopMap = (Map)base.getData();
                        }
                    }
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[14]) && str[14].equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.study.training.name", null, locale));
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[15]) && str[15].equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.user.fraction.createTime", null, locale));
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[16]) && str[16].equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.shift.study.start.time", null, locale));
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[17]) && str[17].equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.study.finish.time", null, locale));
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[18]) && str[18].equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.course.analysis.last.studytime", null, locale));
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[19]) && str[19].equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.shift.study.time", null, locale));
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[20]) && str[20].equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.course.analysis.study.status", null, locale));
                }
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                for (int i = 0; i < list.size(); ++i) {
                    List pojoList;
                    currentNum = 0;
                    row = sheet.createRow(i + 1);
                    TrainingExeclVo vo = list.get(i);
                    row.createCell(0).setCellValue((double)vo.getUserId().intValue());
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[1]) && str[1].equals("1")) {
                        row.createCell(++currentNum).setCellValue(vo.getUserName());
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[2]) && str[2].equals("1")) {
                        row.createCell(++currentNum).setCellValue(vo.getShowName());
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[3]) && str[3].equals("1")) {
                        row.createCell(++currentNum).setCellValue(vo.getEmployeeNumber());
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[4]) && str[4].equals("1")) {
                        String roleName = "";
                        if (!org.springframework.util.StringUtils.isEmpty(roleMap) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)roleMap.get(vo.getUserId())))) {
                            List listStr = pojoList.stream().map(RolePojo::getRoleName).filter(Objects::nonNull).collect(Collectors.toList());
                            roleName = StringUtils.join(listStr, (String)";\n");
                        }
                        row.createCell(++currentNum).setCellValue(roleName);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[5]) && str[5].equals("1")) {
                        String postName = "";
                        if (!org.springframework.util.StringUtils.isEmpty(dutiesMap) && !org.springframework.util.StringUtils.isEmpty((Object)dutiesMap.get(vo.getUserId()))) {
                            postName = ((UserDutiesMo)dutiesMap.get(vo.getUserId())).getDutieName();
                        }
                        row.createCell(++currentNum).setCellValue(postName);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[6]) && str[6].equals("1")) {
                        String parentName = "";
                        if (!org.springframework.util.StringUtils.isEmpty(parentMap)) {
                            parentName = (String)parentMap.get(vo.getUserId());
                        }
                        row.createCell(++currentNum).setCellValue(parentName);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[7]) && str[7].equals("1")) {
                        String departName = "";
                        List nameList = (List)organizeMap.get(vo.getUserId());
                        if (!CollectionUtils.isEmpty((Collection)nameList)) {
                            departName = String.join((CharSequence)";\n", nameList);
                        }
                        XSSFCell cell = row.createCell(++currentNum);
                        cell.setCellValue(departName);
                        cell.setCellStyle((CellStyle)titleSty);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[8]) && str[8].equals("1")) {
                        String organName1 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap1) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)organMap1.get(vo.getUserId())))) {
                            pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                            organName1 = StringUtils.join((Collection)pojoList, (String)",");
                        }
                        row.createCell(++currentNum).setCellValue(organName1);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[9]) && str[9].equals("1")) {
                        String organName2 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap2) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)organMap2.get(vo.getUserId())))) {
                            pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                            organName2 = StringUtils.join((Collection)pojoList, (String)",");
                        }
                        row.createCell(++currentNum).setCellValue(organName2);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[10]) && str[10].equals("1")) {
                        String organName3 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap3) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)organMap3.get(vo.getUserId())))) {
                            pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                            organName3 = StringUtils.join((Collection)pojoList, (String)",");
                        }
                        row.createCell(++currentNum).setCellValue(organName3);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[11]) && str[11].equals("1")) {
                        String organName4 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap4) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)organMap4.get(vo.getUserId())))) {
                            pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                            organName4 = StringUtils.join((Collection)pojoList, (String)",");
                        }
                        row.createCell(++currentNum).setCellValue(organName4);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[12]) && str[12].equals("1")) {
                        String organName5 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap5) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)organMap5.get(vo.getUserId())))) {
                            pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                            organName5 = StringUtils.join(pojoList, (String)",");
                        }
                        row.createCell(++currentNum).setCellValue(organName5);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[13]) && str[13].equals("1")) {
                        String shopName = "";
                        if (!org.springframework.util.StringUtils.isEmpty(shopMap) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)shopMap.get(vo.getUserId())))) {
                            pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                            shopName = StringUtils.join(pojoList, (String)",");
                        }
                        row.createCell(++currentNum).setCellValue(shopName);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[14]) && str[14].equals("1")) {
                        row.createCell(++currentNum).setCellValue(vo.getTitle());
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[15]) && str[15].equals("1")) {
                        row.createCell(++currentNum).setCellValue(vo.getStartTime() != null ? simpleDateFormat.format(vo.getStartTime()) : "");
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[16]) && str[16].equals("1")) {
                        row.createCell(++currentNum).setCellValue(vo.getStartDate() != null ? simpleDateFormat.format(vo.getStartDate()) : "");
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[17]) && str[17].equals("1")) {
                        row.createCell(++currentNum).setCellValue(vo.getEndDate() != null ? simpleDateFormat.format(vo.getEndDate()) : "");
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[18]) && str[18].equals("1")) {
                        row.createCell(++currentNum).setCellValue(vo.getLastDate() != null ? simpleDateFormat.format(vo.getLastDate()) : "");
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[19]) && str[19].equals("1")) {
                        row.createCell(++currentNum).setCellValue(vo.getStudyTimeStr());
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[20]) && str[20].equals("1")) {
                        Integer status = vo.getStatus();
                        String statusName = "";
                        if (status == 0) {
                            statusName = statusUn;
                        } else if (status == 1) {
                            statusName = statusIng;
                        } else if (status == 2) {
                            statusName = statusEnd;
                        }
                        row.createCell(++currentNum).setCellValue(statusName);
                    }
                    sheet.autoSizeColumn(i + 1);
                }
                try {
                    DownloadUtils.successExportTask((Workbook)wb, exportTaskPojo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DownloadUtils.errorExportTask(exportTaskPojo);
                }
            }
        });
        taskList.add(exportTaskPojo);
        return JsonResult.success(taskList);
    }

    @Override
    public String selectTrainingByUserByExecl(final TrainingExeclVo trainingExeclVo) {
        final Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        final String trainingCount = this.messageSource.getMessage("training.shift.training.count", null, locale);
        final String studyStatus = this.messageSource.getMessage("training.course.analysis.study.status", null, locale);
        final String statusUn = this.messageSource.getMessage("training.course.status.un", null, locale);
        final String statusEnd = this.messageSource.getMessage("training.course.status.end", null, locale);
        String fileName = MessageFormat.format("{0}_{1}{2}_{3}", trainingCount, trainingExeclVo.getExcelShowName(), this.messageSource.getMessage("training.learn.detail.name", null, locale), DateUtils.format((Date)new Date(), (String)"yyyyMMdd_HHmmss"));
        fileName = ExcelUtil.getFileName(fileName) + ".xlsx";
        ArrayList<ExportTaskPojo> taskList = new ArrayList<ExportTaskPojo>();
        final ExportTaskPojo exportTaskPojo = DownloadUtils.saveExportTask(fileName, JSON.toJSONString((Object)trainingExeclVo), 3);
        ThreadPoolUtil.getThreadPoolExecutor().execute(new Runnable(){

            @Override
            public void run() {
                List<TrainingExeclVo> list = TrainingServiceImpl.this.trainingApi.selectTrainingByUser(trainingExeclVo);
                XSSFWorkbook wb = new XSSFWorkbook();
                XSSFSheet sheet = wb.createSheet(trainingCount);
                XSSFCellStyle titleSty = wb.createCellStyle();
                XSSFFont font = wb.createFont();
                font.setFontHeightInPoints((short)16);
                titleSty.setFont((Font)font);
                XSSFRow row = sheet.createRow(0);
                row.createCell(0).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.learn.join.training.name", null, locale));
                row.createCell(1).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.user.fraction.createTime", null, locale));
                row.createCell(2).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.course.analysis.starttime", null, locale));
                row.createCell(3).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.course.analysis.endtime", null, locale));
                row.createCell(4).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.paper.last.study", null, locale));
                row.createCell(5).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.shift.study.time", null, locale));
                row.createCell(6).setCellValue(studyStatus);
                SimpleDateFormat format = new SimpleDateFormat("MM/dd HH:mm");
                for (int i = 0; i < list.size(); ++i) {
                    row = sheet.createRow(i + 1);
                    TrainingExeclVo vo = list.get(i);
                    row.createCell(0).setCellValue(vo.getTitle());
                    row.createCell(1).setCellValue(org.springframework.util.StringUtils.isEmpty((Object)vo.getStartTime()) ? "" : format.format(vo.getStartTime()));
                    row.createCell(2).setCellValue(org.springframework.util.StringUtils.isEmpty((Object)vo.getStartDate()) ? "" : format.format(vo.getStartDate()));
                    row.createCell(3).setCellValue(org.springframework.util.StringUtils.isEmpty((Object)vo.getEndDate()) ? "" : format.format(vo.getEndDate()));
                    row.createCell(4).setCellValue(org.springframework.util.StringUtils.isEmpty((Object)vo.getLastDate()) ? "" : format.format(vo.getLastDate()));
                    row.createCell(5).setCellValue(vo.getStudyTimeStr());
                    String statusName = "";
                    if (!org.springframework.util.StringUtils.isEmpty((Object)vo.getTrainingStatus())) {
                        if (vo.getTrainingStatus() == 0) {
                            statusName = statusUn;
                        } else if (vo.getTrainingStatus() == 1) {
                            statusName = TrainingServiceImpl.this.messageSource.getMessage("training.course.status.ing", null, locale);
                        } else if (vo.getTrainingStatus() == 2) {
                            statusName = statusEnd;
                        }
                    }
                    row.createCell(6).setCellValue(statusName + " " + vo.getStudyRate() + "%");
                }
                try {
                    DownloadUtils.successExportTask((Workbook)wb, exportTaskPojo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DownloadUtils.errorExportTask(exportTaskPojo);
                }
            }
        });
        taskList.add(exportTaskPojo);
        return JsonResult.success(taskList);
    }

    @Override
    public String selectExeclVoByDepByExecl(final TrainingExeclVo trainingExeclVo) {
        final Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        final String department = this.messageSource.getMessage("training.learn.department", null, locale);
        final String trainingCount = this.messageSource.getMessage("training.shift.training.count", null, locale);
        String dep = this.messageSource.getMessage("training.shift.department", null, locale);
        String fileName = MessageFormat.format("{0}_{1}_{2}.xlsx", trainingCount, dep, DateUtils.format((Date)new Date(), (String)"yyyyMMdd_HHmmss"));
        ArrayList<ExportTaskPojo> taskList = new ArrayList<ExportTaskPojo>();
        final ExportTaskPojo exportTaskPojo = DownloadUtils.saveExportTask(fileName, JSON.toJSONString((Object)trainingExeclVo), 4);
        ThreadPoolUtil.getThreadPoolExecutor().execute(new Runnable(){

            @Override
            public void run() {
                List<TrainingExeclVo> list = TrainingServiceImpl.this.trainingApi.selectExeclVoByDep(trainingExeclVo);
                XSSFWorkbook wb = new XSSFWorkbook();
                XSSFSheet sheet = wb.createSheet(trainingCount);
                XSSFCellStyle titleSty = wb.createCellStyle();
                XSSFFont font = wb.createFont();
                font.setFontHeightInPoints((short)16);
                titleSty.setFont((Font)font);
                XSSFRow row = sheet.createRow(0);
                row.createCell(0).setCellValue(department);
                row.createCell(1).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.learn.join.people.count", null, locale));
                row.createCell(2).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.shift.study.count", null, locale));
                row.createCell(3).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.learn.end.people.count", null, locale));
                row.createCell(4).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.shift.study.rate", null, locale));
                row.createCell(5).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.learn.end.rate", null, locale));
                row.createCell(6).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.shift.study.time", null, locale));
                row.createCell(7).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.learn.person.average.time", null, locale));
                for (int i = 0; i < list.size(); ++i) {
                    row = sheet.createRow(i + 1);
                    TrainingExeclVo vo = list.get(i);
                    row.createCell(0).setCellValue(vo.getShowName());
                    row.createCell(1).setCellValue((double)vo.getShowNum().intValue());
                    row.createCell(2).setCellValue((double)vo.getStudyNum().intValue());
                    row.createCell(3).setCellValue((double)vo.getFinishNum().intValue());
                    row.createCell(4).setCellValue(vo.getStudyRate() + "%");
                    row.createCell(5).setCellValue(vo.getFinishRate() + "%");
                    row.createCell(6).setCellValue(vo.getStudyTimeStr());
                    row.createCell(7).setCellValue(vo.getPerStudyTimeStr());
                }
                try {
                    DownloadUtils.successExportTask((Workbook)wb, exportTaskPojo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DownloadUtils.errorExportTask(exportTaskPojo);
                }
            }
        });
        taskList.add(exportTaskPojo);
        return JsonResult.success(taskList);
    }

    @Override
    public String selectExeclVoByRoleByExecl(final TrainingExeclVo trainingExeclVo) {
        final Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        String rolesName = this.messageSource.getMessage("training.shift.role", null, locale);
        String trainingCount = this.messageSource.getMessage("training.shift.training.count", null, locale);
        final String role = this.messageSource.getMessage("training.course.analysis.role", null, locale);
        final String fileName = MessageFormat.format("{0}_{1}_{2}.xlsx", trainingCount, rolesName, DateUtils.format((Date)new Date(), (String)"yyyyMMdd_HHmmss"));
        ArrayList<ExportTaskPojo> taskList = new ArrayList<ExportTaskPojo>();
        final ExportTaskPojo exportTaskPojo = DownloadUtils.saveExportTask(fileName, JSON.toJSONString((Object)trainingExeclVo), 5);
        ThreadPoolUtil.getThreadPoolExecutor().execute(new Runnable(){

            @Override
            public void run() {
                List<TrainingExeclVo> list = TrainingServiceImpl.this.trainingApi.selectExeclVoByRole(trainingExeclVo);
                XSSFWorkbook wb = new XSSFWorkbook();
                XSSFSheet sheet = wb.createSheet(fileName);
                XSSFCellStyle titleSty = wb.createCellStyle();
                XSSFFont font = wb.createFont();
                font.setFontHeightInPoints((short)16);
                titleSty.setFont((Font)font);
                XSSFRow row = sheet.createRow(0);
                row.createCell(0).setCellValue(role);
                row.createCell(1).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.learn.join.people.count", null, locale));
                row.createCell(2).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.shift.study.count", null, locale));
                row.createCell(3).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.learn.end.people.count", null, locale));
                row.createCell(4).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.shift.study.rate", null, locale));
                row.createCell(5).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.learn.end.rate", null, locale));
                row.createCell(6).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.shift.study.time", null, locale));
                row.createCell(7).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.learn.person.average.time", null, locale));
                for (int i = 0; i < list.size(); ++i) {
                    row = sheet.createRow(i + 1);
                    TrainingExeclVo vo = list.get(i);
                    row.createCell(0).setCellValue(vo.getShowName());
                    row.createCell(1).setCellValue((double)vo.getShowNum().intValue());
                    row.createCell(2).setCellValue((double)vo.getStudyNum().intValue());
                    row.createCell(3).setCellValue((double)vo.getFinishNum().intValue());
                    row.createCell(4).setCellValue(vo.getStudyRate() + "%");
                    row.createCell(5).setCellValue(vo.getFinishRate() + "%");
                    row.createCell(6).setCellValue(vo.getStudyTimeStr());
                    row.createCell(7).setCellValue(vo.getPerStudyTimeStr());
                }
                try {
                    DownloadUtils.successExportTask((Workbook)wb, exportTaskPojo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DownloadUtils.errorExportTask(exportTaskPojo);
                }
            }
        });
        taskList.add(exportTaskPojo);
        return JsonResult.success(taskList);
    }

    @Override
    public String selectExeclVoByTrainByExecl(final TrainingExeclVo trainingExeclVo) {
        final Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        String trainingsName = this.messageSource.getMessage("training.shift.training", null, locale);
        String trainingCount = this.messageSource.getMessage("training.shift.training.count", null, locale);
        final String fileName = MessageFormat.format("{0}_{1}_{2}.xlsx", trainingCount, trainingsName, DateUtils.format((Date)new Date(), (String)"yyyyMMdd_HHmmss"));
        ArrayList<ExportTaskPojo> taskList = new ArrayList<ExportTaskPojo>();
        final ExportTaskPojo exportTaskPojo = DownloadUtils.saveExportTask(fileName, JSON.toJSONString((Object)trainingExeclVo), 6);
        ThreadPoolUtil.getThreadPoolExecutor().execute(new Runnable(){

            @Override
            public void run() {
                List<TrainingExeclVo> list = TrainingServiceImpl.this.trainingApi.selectExeclVoByTrain(trainingExeclVo);
                XSSFWorkbook wb = new XSSFWorkbook();
                XSSFSheet sheet = wb.createSheet(fileName);
                XSSFCellStyle titleSty = wb.createCellStyle();
                XSSFFont font = wb.createFont();
                font.setFontHeightInPoints((short)16);
                titleSty.setFont((Font)font);
                XSSFRow row = sheet.createRow(0);
                row.createCell(0).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.job.train.name", null, locale));
                row.createCell(1).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.user.fraction.createTime", null, locale));
                row.createCell(2).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.shift.attach.count", null, locale));
                row.createCell(3).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.shift.training.time", null, locale));
                row.createCell(4).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.learn.join.people.count", null, locale));
                row.createCell(5).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.shift.study.count", null, locale));
                row.createCell(6).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.learn.end.people.count", null, locale));
                row.createCell(7).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.shift.study.rate", null, locale));
                row.createCell(8).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.learn.end.rate", null, locale));
                row.createCell(9).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.shift.study.time", null, locale));
                row.createCell(10).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.learn.person.average.time", null, locale));
                SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm");
                for (int i = 0; i < list.size(); ++i) {
                    row = sheet.createRow(i + 1);
                    TrainingExeclVo vo = list.get(i);
                    row.createCell(0).setCellValue(vo.getShowName());
                    row.createCell(1).setCellValue(!org.springframework.util.StringUtils.isEmpty((Object)vo.getStartTime()) ? format.format(vo.getStartTime()) : "");
                    row.createCell(2).setCellValue((double)vo.getMaterialNum().intValue());
                    row.createCell(3).setCellValue(vo.getFinishTimes());
                    row.createCell(4).setCellValue((double)vo.getShowNum().intValue());
                    row.createCell(5).setCellValue((double)vo.getStudyNum().intValue());
                    row.createCell(6).setCellValue((double)vo.getFinishNum().intValue());
                    row.createCell(7).setCellValue(vo.getStudyRate() + "%");
                    row.createCell(8).setCellValue(vo.getFinishRate() + "%");
                    row.createCell(9).setCellValue(vo.getStudyTimeStr());
                    row.createCell(10).setCellValue(vo.getPerStudyTimeStr());
                }
                try {
                    DownloadUtils.successExportTask((Workbook)wb, exportTaskPojo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DownloadUtils.errorExportTask(exportTaskPojo);
                }
            }
        });
        taskList.add(exportTaskPojo);
        return JsonResult.success(taskList);
    }

    @Override
    public String selectMainByStudentByExecl(final TrainingExeclVo trainingExeclVo) {
        final String[] str = trainingExeclVo.getExcelStr().split(",");
        final Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        String zName = this.messageSource.getMessage("training.paper.expire.to", null, locale);
        String jzName = this.messageSource.getMessage("training.paper.time.end.to", null, locale);
        String name = "";
        SimpleDateFormat formats = new SimpleDateFormat("yyyyMMdd");
        name = !org.springframework.util.StringUtils.isEmpty((Object)trainingExeclVo.getStartDate()) && !org.springframework.util.StringUtils.isEmpty((Object)trainingExeclVo.getEndDate()) ? formats.format(trainingExeclVo.getStartDate()) + zName + formats.format(trainingExeclVo.getEndDate()) : jzName + formats.format(new Date());
        final String fileName = MessageFormat.format("{0}_{1}.xlsx", name, this.messageSource.getMessage("training.learn.student.count", null, locale));
        ArrayList<ExportTaskPojo> taskList = new ArrayList<ExportTaskPojo>();
        final ExportTaskPojo exportTaskPojo = DownloadUtils.saveExportTask(fileName, JSON.toJSONString((Object)trainingExeclVo), 7);
        ThreadPoolUtil.getThreadPoolExecutor().execute(new Runnable(){

            @Override
            public void run() {
                String passCount;
                List<TrainingExeclVo> list = TrainingServiceImpl.this.trainingApi.selectMainByStudentByExecl(trainingExeclVo);
                ArrayList<Integer> userIdList = new ArrayList();
                if (!CollectionUtils.isEmpty(list)) {
                    userIdList = list.stream().map(TrainingExeclVo::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                }
                XSSFWorkbook wb = new XSSFWorkbook();
                XSSFSheet sheet = wb.createSheet(fileName);
                XSSFCellStyle titleSty = wb.createCellStyle();
                XSSFDataFormat dataFormat = wb.createDataFormat();
                titleSty.setDataFormat(dataFormat.getFormat("@"));
                sheet.setDefaultColumnStyle(0, (CellStyle)titleSty);
                titleSty.setWrapText(true);
                XSSFRow row = sheet.createRow(0);
                row.createCell(0).setCellValue("id");
                sheet.setColumnWidth(0, 3000);
                int currentNum = 0;
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[1]) && str[1].equals("1")) {
                    String accountNumber = TrainingServiceImpl.this.messageSource.getMessage("training.job.account.number", null, locale);
                    row.createCell(++currentNum).setCellValue(accountNumber);
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[2]) && str[2].equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.course.trainee.name", null, locale));
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[3]) && str[3].equals("1")) {
                    String employeeNumber = TrainingServiceImpl.this.messageSource.getMessage("training.user.details.employeeNumber", null, locale);
                    row.createCell(++currentNum).setCellValue(employeeNumber);
                }
                Map<Object, Object> roleMap = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[4]) && str[4].equals("1")) {
                    String role = TrainingServiceImpl.this.messageSource.getMessage("training.course.analysis.role", null, locale);
                    row.createCell(++currentNum).setCellValue(role);
                    if (!CollectionUtils.isEmpty(userIdList)) {
                        roleMap = TrainingServiceImpl.this.userUtilService.selectRolesByUsers(userIdList, trainingExeclVo.getUser().getGroupId());
                    }
                }
                Map<Object, Object> dutiesMap = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[5]) && str[5].equals("1")) {
                    String role = TrainingServiceImpl.this.messageSource.getMessage("training.job.post.name", null, locale);
                    row.createCell(++currentNum).setCellValue(role);
                    if (!CollectionUtils.isEmpty(userIdList)) {
                        dutiesMap = TrainingServiceImpl.this.userUtilService.selectDutiesMap(userIdList, trainingExeclVo.getUser().getGroupId());
                    }
                }
                Map<Object, Object> parentMap = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[6]) && str[6].equals("1")) {
                    String leader = TrainingServiceImpl.this.messageSource.getMessage("training.course.analysis.superior", null, locale);
                    row.createCell(++currentNum).setCellValue(leader);
                    if (!CollectionUtils.isEmpty(userIdList)) {
                        parentMap = TrainingServiceImpl.this.userUtilService.selectParentMap(userIdList, trainingExeclVo.getUser().getGroupId());
                    }
                }
                Map<Object, Object> organizeMap = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[7]) && str[7].equals("1")) {
                    String department = TrainingServiceImpl.this.messageSource.getMessage("training.learn.department", null, locale);
                    row.createCell(++currentNum).setCellValue(department);
                    organizeMap = TrainingServiceImpl.this.userUtilService.selectOrganizeMap(userIdList, trainingExeclVo.getUser().getGroupId());
                }
                Map organMap1 = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[8]) && str[8].equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.course.analysis.first.organize", null, locale));
                    if (!CollectionUtils.isEmpty(userIdList)) {
                        UsersAndOrgsMo mo = new UsersAndOrgsMo();
                        mo.setGroupId(trainingExeclVo.getUser().getGroupId());
                        mo.setLevelList(Collections.singletonList(1));
                        mo.setUserIdList(userIdList);
                        mo.setShowDepartment(Boolean.valueOf(false));
                        com.ovopark.organize.common.base.BaseResult base = TrainingServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                        if (base != null) {
                            organMap1 = (Map)base.getData();
                        }
                    }
                }
                Map organMap2 = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[9]) && str[9].equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.course.analysis.second.organize", null, locale));
                    if (!CollectionUtils.isEmpty(userIdList)) {
                        UsersAndOrgsMo mo = new UsersAndOrgsMo();
                        mo.setGroupId(trainingExeclVo.getUser().getGroupId());
                        mo.setLevelList(Collections.singletonList(2));
                        mo.setUserIdList(userIdList);
                        mo.setShowDepartment(Boolean.valueOf(false));
                        com.ovopark.organize.common.base.BaseResult base = TrainingServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                        if (base != null) {
                            organMap2 = (Map)base.getData();
                        }
                    }
                }
                Map organMap3 = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[10]) && str[10].equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.course.analysis.third.organize", null, locale));
                    if (!CollectionUtils.isEmpty(userIdList)) {
                        UsersAndOrgsMo mo = new UsersAndOrgsMo();
                        mo.setGroupId(trainingExeclVo.getUser().getGroupId());
                        mo.setLevelList(Collections.singletonList(3));
                        mo.setUserIdList(userIdList);
                        mo.setShowDepartment(Boolean.valueOf(false));
                        com.ovopark.organize.common.base.BaseResult base = TrainingServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                        if (base != null) {
                            organMap3 = (Map)base.getData();
                        }
                    }
                }
                Map organMap4 = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[11]) && str[11].equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.course.analysis.fourth.organize", null, locale));
                    if (!CollectionUtils.isEmpty(userIdList)) {
                        UsersAndOrgsMo mo = new UsersAndOrgsMo();
                        mo.setGroupId(trainingExeclVo.getUser().getGroupId());
                        mo.setLevelList(Collections.singletonList(4));
                        mo.setUserIdList(userIdList);
                        mo.setShowDepartment(Boolean.valueOf(false));
                        com.ovopark.organize.common.base.BaseResult base = TrainingServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                        if (base != null) {
                            organMap4 = (Map)base.getData();
                        }
                    }
                }
                Map organMap5 = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[12]) && str[12].equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.course.analysis.fifth.organize", null, locale));
                    if (!CollectionUtils.isEmpty(userIdList)) {
                        UsersAndOrgsMo mo = new UsersAndOrgsMo();
                        mo.setGroupId(trainingExeclVo.getUser().getGroupId());
                        mo.setLevelList(Collections.singletonList(5));
                        mo.setUserIdList(userIdList);
                        mo.setShowDepartment(Boolean.valueOf(false));
                        com.ovopark.organize.common.base.BaseResult base = TrainingServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                        if (base != null) {
                            organMap5 = (Map)base.getData();
                        }
                    }
                }
                Map shopMap = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[13]) && str[13].equals("1")) {
                    String shopNames = TrainingServiceImpl.this.messageSource.getMessage("training.course.analysis.dep", null, locale);
                    row.createCell(++currentNum).setCellValue(shopNames);
                    if (!CollectionUtils.isEmpty(userIdList)) {
                        UsersAndOrgsMo mo = new UsersAndOrgsMo();
                        mo.setGroupId(trainingExeclVo.getUser().getGroupId());
                        mo.setUserIdList(userIdList);
                        mo.setShowDepartment(Boolean.valueOf(true));
                        com.ovopark.organize.common.base.BaseResult base = TrainingServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                        if (base != null) {
                            shopMap = (Map)base.getData();
                        }
                    }
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[14]) && str[14].equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.course.analysis.study.time", null, locale));
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[15]) && str[15].equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.learn.study.training.count", null, locale));
                    row.createCell(++currentNum).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.learn.training.counts", null, locale));
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[16]) && str[16].equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.learn.join.paper.count", null, locale));
                    passCount = TrainingServiceImpl.this.messageSource.getMessage("training.shift.paper.pass.count", null, locale);
                    row.createCell(++currentNum).setCellValue(passCount);
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[17]) && str[17].equals("1")) {
                    row.createCell(++currentNum).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.learn.join.course.count", null, locale));
                    passCount = TrainingServiceImpl.this.messageSource.getMessage("training.shift.course.pass.count", null, locale);
                    row.createCell(++currentNum).setCellValue(passCount);
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[18]) && str[18].equals("1")) {
                    String operateCount = TrainingServiceImpl.this.messageSource.getMessage("training.operate.num", null, locale);
                    row.createCell(++currentNum).setCellValue(operateCount);
                    String operateFinishCount = TrainingServiceImpl.this.messageSource.getMessage("training.operate.finish.num", null, locale);
                    row.createCell(++currentNum).setCellValue(operateFinishCount);
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[19]) && str[19].equals("1")) {
                    String planCount = TrainingServiceImpl.this.messageSource.getMessage("training.plan.num", null, locale);
                    row.createCell(++currentNum).setCellValue(planCount);
                    String planFinishCount = TrainingServiceImpl.this.messageSource.getMessage("training.plan.finish.num", null, locale);
                    row.createCell(++currentNum).setCellValue(planFinishCount);
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[20]) && str[20].equals("1")) {
                    String learnShiftCount = TrainingServiceImpl.this.messageSource.getMessage("training.learn.shift.num", null, locale);
                    row.createCell(++currentNum).setCellValue(learnShiftCount);
                    String learnShiftFinishCount = TrainingServiceImpl.this.messageSource.getMessage("training.learn.shift.finish.num", null, locale);
                    row.createCell(++currentNum).setCellValue(learnShiftFinishCount);
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[21]) && str[21].equals("1")) {
                    String jobCertificationCount = TrainingServiceImpl.this.messageSource.getMessage("training.job.certification", null, locale);
                    row.createCell(++currentNum).setCellValue(jobCertificationCount);
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[22]) && str[22].equals("1")) {
                    String certificateCount = TrainingServiceImpl.this.messageSource.getMessage("training.shift.certificate.count", null, locale);
                    row.createCell(++currentNum).setCellValue(certificateCount);
                }
                if (!CollectionUtils.isEmpty(list)) {
                    for (int i = 0; i < list.size(); ++i) {
                        List pojoList;
                        currentNum = 0;
                        row = sheet.createRow(i + 1);
                        TrainingExeclVo vo = list.get(i);
                        row.createCell(0).setCellValue((double)vo.getUserId().intValue());
                        if (!org.springframework.util.StringUtils.isEmpty((Object)str[1]) && str[1].equals("1")) {
                            row.createCell(++currentNum).setCellValue(vo.getUserName());
                        }
                        if (!org.springframework.util.StringUtils.isEmpty((Object)str[2]) && str[2].equals("1")) {
                            row.createCell(++currentNum).setCellValue(vo.getShowName());
                        }
                        if (!org.springframework.util.StringUtils.isEmpty((Object)str[3]) && str[3].equals("1")) {
                            row.createCell(++currentNum).setCellValue(vo.getEmployeeNumber());
                        }
                        if (!org.springframework.util.StringUtils.isEmpty((Object)str[4]) && str[4].equals("1")) {
                            String roleName = "";
                            if (!org.springframework.util.StringUtils.isEmpty(roleMap) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)roleMap.get(vo.getUserId())))) {
                                List listStr = pojoList.stream().map(RolePojo::getRoleName).filter(Objects::nonNull).collect(Collectors.toList());
                                roleName = StringUtils.join(listStr, (String)";\n");
                            }
                            row.createCell(++currentNum).setCellValue(roleName);
                        }
                        if (!org.springframework.util.StringUtils.isEmpty((Object)str[5]) && str[5].equals("1")) {
                            ++currentNum;
                            if (!CollectionUtils.isEmpty(dutiesMap) && dutiesMap.get(vo.getUserId()) != null) {
                                row.createCell(currentNum).setCellValue(((UserDutiesMo)dutiesMap.get(vo.getUserId())).getDutieName());
                            }
                        }
                        if (!org.springframework.util.StringUtils.isEmpty((Object)str[6]) && str[6].equals("1")) {
                            String parentName = "";
                            if (!org.springframework.util.StringUtils.isEmpty(parentMap)) {
                                parentName = (String)parentMap.get(vo.getUserId());
                            }
                            row.createCell(++currentNum).setCellValue(parentName);
                        }
                        if (!org.springframework.util.StringUtils.isEmpty((Object)str[7]) && str[7].equals("1")) {
                            String departName = "";
                            List nameList = (List)organizeMap.get(vo.getUserId());
                            if (!CollectionUtils.isEmpty((Collection)nameList)) {
                                departName = String.join((CharSequence)";\n", nameList);
                            }
                            XSSFCell cell = row.createCell(++currentNum);
                            cell.setCellValue(departName);
                            cell.setCellStyle((CellStyle)titleSty);
                        }
                        if (!org.springframework.util.StringUtils.isEmpty((Object)str[8]) && str[8].equals("1")) {
                            String organName1 = "";
                            if (!org.springframework.util.StringUtils.isEmpty(organMap1) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)organMap1.get(vo.getUserId())))) {
                                pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                                organName1 = StringUtils.join((Collection)pojoList, (String)",");
                            }
                            row.createCell(++currentNum).setCellValue(organName1);
                        }
                        if (!org.springframework.util.StringUtils.isEmpty((Object)str[9]) && str[9].equals("1")) {
                            String organName2 = "";
                            if (!org.springframework.util.StringUtils.isEmpty(organMap2) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)organMap2.get(vo.getUserId())))) {
                                pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                                organName2 = StringUtils.join((Collection)pojoList, (String)",");
                            }
                            row.createCell(++currentNum).setCellValue(organName2);
                        }
                        if (!org.springframework.util.StringUtils.isEmpty((Object)str[10]) && str[10].equals("1")) {
                            String organName3 = "";
                            if (!org.springframework.util.StringUtils.isEmpty(organMap3) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)organMap3.get(vo.getUserId())))) {
                                pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                                organName3 = StringUtils.join((Collection)pojoList, (String)",");
                            }
                            row.createCell(++currentNum).setCellValue(organName3);
                        }
                        if (!org.springframework.util.StringUtils.isEmpty((Object)str[11]) && str[11].equals("1")) {
                            String organName4 = "";
                            if (!org.springframework.util.StringUtils.isEmpty(organMap4) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)organMap4.get(vo.getUserId())))) {
                                pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                                organName4 = StringUtils.join((Collection)pojoList, (String)",");
                            }
                            row.createCell(++currentNum).setCellValue(organName4);
                        }
                        if (!org.springframework.util.StringUtils.isEmpty((Object)str[12]) && str[12].equals("1")) {
                            String organName5 = "";
                            if (!org.springframework.util.StringUtils.isEmpty(organMap5) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)organMap5.get(vo.getUserId())))) {
                                pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                                organName5 = StringUtils.join(pojoList, (String)",");
                            }
                            row.createCell(++currentNum).setCellValue(organName5);
                        }
                        if (!org.springframework.util.StringUtils.isEmpty((Object)str[13]) && str[13].equals("1")) {
                            String shopName = "";
                            if (!org.springframework.util.StringUtils.isEmpty(shopMap) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)shopMap.get(vo.getUserId())))) {
                                pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                                shopName = StringUtils.join(pojoList, (String)",");
                            }
                            row.createCell(++currentNum).setCellValue(shopName);
                        }
                        if (!org.springframework.util.StringUtils.isEmpty((Object)str[14]) && str[14].equals("1")) {
                            row.createCell(++currentNum).setCellValue(vo.getStudyTimeStr());
                        }
                        if (!org.springframework.util.StringUtils.isEmpty((Object)str[15]) && str[15].equals("1")) {
                            row.createCell(++currentNum).setCellValue((double)vo.getTrainNum().intValue());
                            row.createCell(++currentNum).setCellValue((double)vo.getTrainFinishNum().intValue());
                        }
                        if (!org.springframework.util.StringUtils.isEmpty((Object)str[16]) && str[16].equals("1")) {
                            row.createCell(++currentNum).setCellValue((double)vo.getPaperNum().intValue());
                            row.createCell(++currentNum).setCellValue((double)vo.getPaperFinishNum().intValue());
                        }
                        if (!org.springframework.util.StringUtils.isEmpty((Object)str[17]) && str[17].equals("1")) {
                            row.createCell(++currentNum).setCellValue((double)vo.getProjectNum().intValue());
                            row.createCell(++currentNum).setCellValue((double)vo.getProjectFinishNum().intValue());
                        }
                        if (!org.springframework.util.StringUtils.isEmpty((Object)str[18]) && str[18].equals("1")) {
                            row.createCell(++currentNum).setCellValue((double)vo.getTrainingUserOperateNum().intValue());
                            row.createCell(++currentNum).setCellValue((double)vo.getTrainingUserOperateFinishNum().intValue());
                        }
                        if (!org.springframework.util.StringUtils.isEmpty((Object)str[19]) && str[19].equals("1")) {
                            row.createCell(++currentNum).setCellValue((double)vo.getTrainingPlanNum().intValue());
                            row.createCell(++currentNum).setCellValue((double)vo.getTrainingPlanFinishNum().intValue());
                        }
                        if (!org.springframework.util.StringUtils.isEmpty((Object)str[20]) && str[20].equals("1")) {
                            row.createCell(++currentNum).setCellValue((double)vo.getLearnShiftNum().intValue());
                            row.createCell(++currentNum).setCellValue((double)vo.getLearnShiftFinishNum().intValue());
                        }
                        if (!org.springframework.util.StringUtils.isEmpty((Object)str[21]) && str[21].equals("1")) {
                            row.createCell(++currentNum).setCellValue(vo.getJobInCertificating());
                        }
                        if (!org.springframework.util.StringUtils.isEmpty((Object)str[22]) && str[22].equals("1")) {
                            row.createCell(++currentNum).setCellValue((double)vo.getCertificateNum().intValue());
                        }
                        sheet.autoSizeColumn(i + 1);
                    }
                }
                try {
                    DownloadUtils.successExportTask((Workbook)wb, exportTaskPojo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DownloadUtils.errorExportTask(exportTaskPojo);
                }
            }
        });
        taskList.add(exportTaskPojo);
        return JsonResult.success(taskList);
    }

    @Override
    public String selectTrainingByDepByExecl(final TrainingExeclVo trainingExeclVo) {
        final String[] str = trainingExeclVo.getExcelStr().split(",");
        final Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        SimpleDateFormat formats = new SimpleDateFormat("yyyyMMdd_HHmmss");
        String trainingCount = this.messageSource.getMessage("training.shift.training.count", null, locale);
        String detail = this.messageSource.getMessage("training.shift.detail", null, locale);
        String excelShowName = ExcelUtil.getFileName(trainingExeclVo.getExcelShowName());
        String fileName = MessageFormat.format("{0}_{1}_{2}_{3}.xlsx", trainingCount, excelShowName, this.messageSource.getMessage("training.learn.detail.name", null, locale), DateUtils.format((Date)new Date(), (String)"yyyyMMdd"));
        final String fileShortName = excelShowName + detail + "_" + DateUtils.format((Date)new Date(), (String)"yyyyMMdd");
        ArrayList<ExportTaskPojo> taskList = new ArrayList<ExportTaskPojo>();
        final ExportTaskPojo exportTaskPojo = DownloadUtils.saveExportTask(fileName, JSON.toJSONString((Object)trainingExeclVo), 19);
        ThreadPoolUtil.getThreadPoolExecutor().execute(new Runnable(){

            @Override
            public void run() {
                ArrayList<Integer> trainingStatusList = new ArrayList<Integer>();
                if (str.length > 18 && !org.springframework.util.StringUtils.isEmpty((Object)str[18]) && str[18].equals("1")) {
                    trainingStatusList.add(2);
                }
                if (str.length > 19 && !org.springframework.util.StringUtils.isEmpty((Object)str[19]) && str[19].equals("1")) {
                    trainingStatusList.add(1);
                }
                if (str.length > 20 && !org.springframework.util.StringUtils.isEmpty((Object)str[20]) && str[20].equals("1")) {
                    trainingStatusList.add(0);
                }
                trainingExeclVo.setTrainingStatusList(trainingStatusList);
                List<TrainingExeclVo> list = TrainingServiceImpl.this.trainingApi.selectTrainingByDepExcel(trainingExeclVo);
                ArrayList<Integer> userIdList = new ArrayList();
                String userStr = "";
                if (!CollectionUtils.isEmpty(list) && !CollectionUtils.isEmpty(userIdList = list.stream().map(TrainingExeclVo::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                    userStr = StringUtils.join(userIdList, (String)",");
                }
                String accountNumber = TrainingServiceImpl.this.messageSource.getMessage("training.job.account.number", null, locale);
                String trainingCount = TrainingServiceImpl.this.messageSource.getMessage("training.shift.training.count", null, locale);
                String detail = TrainingServiceImpl.this.messageSource.getMessage("training.shift.detail", null, locale);
                String statusUn = TrainingServiceImpl.this.messageSource.getMessage("training.course.status.un", null, locale);
                String statusEnd = TrainingServiceImpl.this.messageSource.getMessage("training.course.status.end", null, locale);
                Map roleMap = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[4]) && str[4].equals("1") && !org.springframework.util.StringUtils.isEmpty((Object)userStr)) {
                    HashMap<String, Object> parameter = new HashMap<String, Object>();
                    parameter.put("userIds", userStr);
                    parameter.put("groupId", trainingExeclVo.getUser().getGroupId());
                    BaseResult base = TrainingServiceImpl.this.roleApi.getUserRoleList(parameter);
                    if (base != null) {
                        roleMap = (Map)base.getData();
                    }
                }
                Map<Object, Object> dutiesMap = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[5]) && str[5].equals("1") && !CollectionUtils.isEmpty(userIdList)) {
                    dutiesMap = TrainingServiceImpl.this.userUtilService.selectDutiesMap(userIdList, trainingExeclVo.getUser().getGroupId());
                }
                Map<Object, Object> parentMap = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[6]) && str[6].equals("1") && !CollectionUtils.isEmpty(userIdList)) {
                    parentMap = TrainingServiceImpl.this.userUtilService.selectParentMap(userIdList, trainingExeclVo.getUser().getGroupId());
                }
                Map<Object, Object> organizeMap = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[7]) && str[7].equals("1") && !CollectionUtils.isEmpty(userIdList)) {
                    organizeMap = TrainingServiceImpl.this.userUtilService.selectOrganizeMap(userIdList, trainingExeclVo.getUser().getGroupId());
                }
                Map organMap1 = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[8]) && str[8].equals("1") && !CollectionUtils.isEmpty(userIdList)) {
                    UsersAndOrgsMo mo = new UsersAndOrgsMo();
                    mo.setGroupId(trainingExeclVo.getUser().getGroupId());
                    mo.setLevelList(Collections.singletonList(1));
                    mo.setUserIdList(userIdList);
                    mo.setShowDepartment(Boolean.valueOf(false));
                    com.ovopark.organize.common.base.BaseResult base = TrainingServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                    if (base != null) {
                        organMap1 = (Map)base.getData();
                    }
                }
                Map organMap2 = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[9]) && str[9].equals("1") && !CollectionUtils.isEmpty(userIdList)) {
                    UsersAndOrgsMo mo = new UsersAndOrgsMo();
                    mo.setGroupId(trainingExeclVo.getUser().getGroupId());
                    mo.setLevelList(Collections.singletonList(2));
                    mo.setUserIdList(userIdList);
                    mo.setShowDepartment(Boolean.valueOf(false));
                    com.ovopark.organize.common.base.BaseResult base = TrainingServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                    if (base != null) {
                        organMap2 = (Map)base.getData();
                    }
                }
                Map organMap3 = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[10]) && str[10].equals("1") && !CollectionUtils.isEmpty(userIdList)) {
                    UsersAndOrgsMo mo = new UsersAndOrgsMo();
                    mo.setGroupId(trainingExeclVo.getUser().getGroupId());
                    mo.setLevelList(Collections.singletonList(3));
                    mo.setUserIdList(userIdList);
                    mo.setShowDepartment(Boolean.valueOf(false));
                    com.ovopark.organize.common.base.BaseResult base = TrainingServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                    if (base != null) {
                        organMap3 = (Map)base.getData();
                    }
                }
                Map organMap4 = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[11]) && str[11].equals("1") && !CollectionUtils.isEmpty(userIdList)) {
                    UsersAndOrgsMo mo = new UsersAndOrgsMo();
                    mo.setGroupId(trainingExeclVo.getUser().getGroupId());
                    mo.setLevelList(Collections.singletonList(4));
                    mo.setUserIdList(userIdList);
                    mo.setShowDepartment(Boolean.valueOf(false));
                    com.ovopark.organize.common.base.BaseResult base = TrainingServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                    if (base != null) {
                        organMap4 = (Map)base.getData();
                    }
                }
                Map organMap5 = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[12]) && str[12].equals("1") && !CollectionUtils.isEmpty(userIdList)) {
                    UsersAndOrgsMo mo = new UsersAndOrgsMo();
                    mo.setGroupId(trainingExeclVo.getUser().getGroupId());
                    mo.setLevelList(Collections.singletonList(5));
                    mo.setUserIdList(userIdList);
                    mo.setShowDepartment(Boolean.valueOf(false));
                    com.ovopark.organize.common.base.BaseResult base = TrainingServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                    if (base != null) {
                        organMap5 = (Map)base.getData();
                    }
                }
                Map shopMap = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[13]) && str[13].equals("1") && !CollectionUtils.isEmpty(userIdList)) {
                    UsersAndOrgsMo mo = new UsersAndOrgsMo();
                    mo.setGroupId(trainingExeclVo.getUser().getGroupId());
                    mo.setUserIdList(userIdList);
                    mo.setShowDepartment(Boolean.valueOf(true));
                    com.ovopark.organize.common.base.BaseResult base = TrainingServiceImpl.this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                    if (base != null) {
                        shopMap = (Map)base.getData();
                    }
                }
                XSSFWorkbook wb = new XSSFWorkbook();
                int dataCount = list.size();
                int page = dataCount % 50000;
                int pageNo = page == 0 ? dataCount / 50000 : dataCount / 50000 + 1;
                for (int m = 1; m <= pageNo; ++m) {
                    XSSFSheet sheet = wb.createSheet(fileShortName + "_" + m);
                    XSSFCellStyle titleSty = wb.createCellStyle();
                    XSSFDataFormat dataFormat = wb.createDataFormat();
                    titleSty.setDataFormat(dataFormat.getFormat("@"));
                    sheet.setDefaultColumnStyle(0, (CellStyle)titleSty);
                    sheet.setColumnWidth(0, 3000);
                    XSSFRow row = sheet.createRow(0);
                    row.createCell(0).setCellValue("id");
                    int currentNum = 0;
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[1]) && str[1].equals("1")) {
                        row.createCell(++currentNum).setCellValue(accountNumber);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[2]) && str[2].equals("1")) {
                        row.createCell(++currentNum).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.course.trainee.name", null, locale));
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[3]) && str[3].equals("1")) {
                        String employeeNumber = TrainingServiceImpl.this.messageSource.getMessage("training.user.details.employeeNumber", null, locale);
                        row.createCell(++currentNum).setCellValue(employeeNumber);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[4]) && str[4].equals("1")) {
                        String role = TrainingServiceImpl.this.messageSource.getMessage("training.course.analysis.role", null, locale);
                        row.createCell(++currentNum).setCellValue(role);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[5]) && str[5].equals("1")) {
                        String post = TrainingServiceImpl.this.messageSource.getMessage("training.job.post.name", null, locale);
                        row.createCell(++currentNum).setCellValue(post);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[6]) && str[6].equals("1")) {
                        String leader = TrainingServiceImpl.this.messageSource.getMessage("training.course.analysis.superior", null, locale);
                        row.createCell(++currentNum).setCellValue(leader);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[7]) && str[7].equals("1")) {
                        String department = TrainingServiceImpl.this.messageSource.getMessage("training.learn.department", null, locale);
                        row.createCell(++currentNum).setCellValue(department);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[8]) && str[8].equals("1")) {
                        row.createCell(++currentNum).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.course.analysis.first.organize", null, locale));
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[9]) && str[9].equals("1")) {
                        row.createCell(++currentNum).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.course.analysis.second.organize", null, locale));
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[10]) && str[10].equals("1")) {
                        row.createCell(++currentNum).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.course.analysis.third.organize", null, locale));
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[11]) && str[11].equals("1")) {
                        row.createCell(++currentNum).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.course.analysis.fourth.organize", null, locale));
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[12]) && str[12].equals("1")) {
                        row.createCell(++currentNum).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.course.analysis.fifth.organize", null, locale));
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[13]) && str[13].equals("1")) {
                        String shopNames = TrainingServiceImpl.this.messageSource.getMessage("training.course.analysis.dep", null, locale);
                        row.createCell(++currentNum).setCellValue(shopNames);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[14]) && str[14].equals("1")) {
                        String trainName = TrainingServiceImpl.this.messageSource.getMessage("training.job.train.name", null, locale);
                        row.createCell(++currentNum).setCellValue(trainName);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[15]) && str[15].equals("1")) {
                        row.createCell(++currentNum).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.course.analysis.starttime", null, locale));
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[16]) && str[16].equals("1")) {
                        row.createCell(++currentNum).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.course.analysis.endtime", null, locale));
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[17]) && str[17].equals("1")) {
                        row.createCell(++currentNum).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.shift.study.time", null, locale));
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[18]) && str[18].equals("1") || !org.springframework.util.StringUtils.isEmpty((Object)str[19]) && str[19].equals("1") || !org.springframework.util.StringUtils.isEmpty((Object)str[20]) && str[20].equals("1")) {
                        String studyStatus = TrainingServiceImpl.this.messageSource.getMessage("training.course.analysis.study.status", null, locale);
                        row.createCell(++currentNum).setCellValue(studyStatus);
                    }
                    SimpleDateFormat format = new SimpleDateFormat("MM/dd HH:mm");
                    for (int i = 50000 * m - 50000; i < 50000 * m - 1 && i < dataCount; ++i) {
                        List pojoList;
                        currentNum = 0;
                        row = sheet.createRow(i - 50000 * m + 50001);
                        TrainingExeclVo vo = list.get(i);
                        row.createCell(0).setCellValue((double)vo.getUserId().intValue());
                        if (!org.springframework.util.StringUtils.isEmpty((Object)str[1]) && str[1].equals("1")) {
                            row.createCell(++currentNum).setCellValue(vo.getUserName());
                        }
                        if (!org.springframework.util.StringUtils.isEmpty((Object)str[2]) && str[2].equals("1")) {
                            row.createCell(++currentNum).setCellValue(vo.getShowName());
                        }
                        if (!org.springframework.util.StringUtils.isEmpty((Object)str[3]) && str[3].equals("1")) {
                            row.createCell(++currentNum).setCellValue(vo.getEmployeeNumber());
                        }
                        if (!org.springframework.util.StringUtils.isEmpty((Object)str[4]) && str[4].equals("1")) {
                            ++currentNum;
                            String roleName = "";
                            if (!org.springframework.util.StringUtils.isEmpty(roleMap) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)roleMap.get(vo.getUserId())))) {
                                List listStr = pojoList.stream().map(RolePojo::getRoleName).filter(Objects::nonNull).collect(Collectors.toList());
                                roleName = StringUtils.join(listStr, (String)";\n");
                            }
                            row.createCell(currentNum).setCellValue(roleName);
                        }
                        if (!org.springframework.util.StringUtils.isEmpty((Object)str[5]) && str[5].equals("1")) {
                            ++currentNum;
                            if (!CollectionUtils.isEmpty(dutiesMap) && dutiesMap.get(vo.getUserId()) != null) {
                                row.createCell(currentNum).setCellValue(((UserDutiesMo)dutiesMap.get(vo.getUserId())).getDutieName());
                            }
                        }
                        if (!org.springframework.util.StringUtils.isEmpty((Object)str[6]) && str[6].equals("1")) {
                            ++currentNum;
                            String parentName = "";
                            if (!org.springframework.util.StringUtils.isEmpty(parentMap)) {
                                parentName = (String)parentMap.get(vo.getUserId());
                            }
                            row.createCell(currentNum).setCellValue(parentName);
                        }
                        if (!org.springframework.util.StringUtils.isEmpty((Object)str[7]) && str[7].equals("1")) {
                            ++currentNum;
                            String departName = "";
                            List nameList = (List)organizeMap.get(vo.getUserId());
                            if (!CollectionUtils.isEmpty((Collection)nameList)) {
                                departName = String.join((CharSequence)";\n", nameList);
                            }
                            row.createCell(currentNum).setCellValue(departName);
                        }
                        if (!org.springframework.util.StringUtils.isEmpty((Object)str[8]) && str[8].equals("1")) {
                            ++currentNum;
                            String organName1 = "";
                            if (!org.springframework.util.StringUtils.isEmpty(organMap1) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)organMap1.get(vo.getUserId())))) {
                                pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                                organName1 = StringUtils.join((Collection)pojoList, (String)",");
                            }
                            row.createCell(currentNum).setCellValue(organName1);
                        }
                        if (!org.springframework.util.StringUtils.isEmpty((Object)str[9]) && str[9].equals("1")) {
                            ++currentNum;
                            String organName2 = "";
                            if (!org.springframework.util.StringUtils.isEmpty(organMap2) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)organMap2.get(vo.getUserId())))) {
                                pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                                organName2 = StringUtils.join((Collection)pojoList, (String)",");
                            }
                            row.createCell(currentNum).setCellValue(organName2);
                        }
                        if (!org.springframework.util.StringUtils.isEmpty((Object)str[10]) && str[10].equals("1")) {
                            ++currentNum;
                            String organName3 = "";
                            if (!org.springframework.util.StringUtils.isEmpty(organMap3) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)organMap3.get(vo.getUserId())))) {
                                pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                                organName3 = StringUtils.join((Collection)pojoList, (String)",");
                            }
                            row.createCell(currentNum).setCellValue(organName3);
                        }
                        if (!org.springframework.util.StringUtils.isEmpty((Object)str[11]) && str[11].equals("1")) {
                            ++currentNum;
                            String organName4 = "";
                            if (!org.springframework.util.StringUtils.isEmpty(organMap4) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)organMap4.get(vo.getUserId())))) {
                                pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                                organName4 = StringUtils.join((Collection)pojoList, (String)",");
                            }
                            row.createCell(currentNum).setCellValue(organName4);
                        }
                        if (!org.springframework.util.StringUtils.isEmpty((Object)str[12]) && str[12].equals("1")) {
                            ++currentNum;
                            String organName5 = "";
                            if (!org.springframework.util.StringUtils.isEmpty(organMap5) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)organMap5.get(vo.getUserId())))) {
                                pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                                organName5 = StringUtils.join(pojoList, (String)",");
                            }
                            row.createCell(currentNum).setCellValue(organName5);
                        }
                        if (!org.springframework.util.StringUtils.isEmpty((Object)str[13]) && str[13].equals("1")) {
                            ++currentNum;
                            String shopName = "";
                            if (!org.springframework.util.StringUtils.isEmpty(shopMap) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)shopMap.get(vo.getUserId())))) {
                                pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                                shopName = StringUtils.join(pojoList, (String)",");
                            }
                            row.createCell(currentNum).setCellValue(shopName);
                        }
                        if (!org.springframework.util.StringUtils.isEmpty((Object)str[14]) && str[14].equals("1")) {
                            row.createCell(++currentNum).setCellValue(org.springframework.util.StringUtils.isEmpty((Object)vo.getTitle()) ? "" : vo.getTitle());
                        }
                        if (!org.springframework.util.StringUtils.isEmpty((Object)str[15]) && str[15].equals("1")) {
                            row.createCell(++currentNum).setCellValue(org.springframework.util.StringUtils.isEmpty((Object)vo.getStartDate()) ? "" : format.format(vo.getStartDate()));
                        }
                        if (!org.springframework.util.StringUtils.isEmpty((Object)str[16]) && str[16].equals("1")) {
                            row.createCell(++currentNum).setCellValue(org.springframework.util.StringUtils.isEmpty((Object)vo.getEndDate()) ? "" : format.format(vo.getEndDate()));
                        }
                        if (!org.springframework.util.StringUtils.isEmpty((Object)str[17]) && str[17].equals("1")) {
                            row.createCell(++currentNum).setCellValue(vo.getStudyTimeStr());
                        }
                        if (!(!org.springframework.util.StringUtils.isEmpty((Object)str[18]) && str[18].equals("1") || !org.springframework.util.StringUtils.isEmpty((Object)str[19]) && str[19].equals("1")) && (org.springframework.util.StringUtils.isEmpty((Object)str[20]) || !str[20].equals("1"))) continue;
                        String statusName = "";
                        if (!org.springframework.util.StringUtils.isEmpty((Object)vo.getTrainingStatus())) {
                            if (vo.getTrainingStatus() == 0) {
                                statusName = statusUn;
                            } else if (vo.getTrainingStatus() == 1) {
                                statusName = TrainingServiceImpl.this.messageSource.getMessage("training.course.status.ing", null, locale);
                            } else if (vo.getTrainingStatus() == 2) {
                                statusName = statusEnd;
                            }
                        }
                        row.createCell(++currentNum).setCellValue(statusName + " " + vo.getStudyRate() + "%");
                    }
                }
                try {
                    DownloadUtils.successExportTask((Workbook)wb, exportTaskPojo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DownloadUtils.errorExportTask(exportTaskPojo);
                }
            }
        });
        taskList.add(exportTaskPojo);
        return JsonResult.success(taskList);
    }

    @Override
    public String downTraineeAnalysis(final TraineeAnalysisReq req) {
        final Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        OperateCheck operateCheck = this.trainingApi.getOperateCheckById(req.getOperateCheckId());
        String fileName = MessageFormat.format("{0}_{1}_{2}", operateCheck.getCheckName(), this.messageSource.getMessage("training.paper.answer.result", null, locale), DateUtils.format((Date)new Date(), (String)"yyyyMMdd"));
        fileName = ExcelUtil.getFileName(fileName) + ".xlsx";
        ArrayList<ExportTaskPojo> taskList = new ArrayList<ExportTaskPojo>();
        final ExportTaskPojo exportTaskPojo = DownloadUtils.saveExportTask(fileName, JSON.toJSONString((Object)req), 28);
        final String finalFileName = this.messageSource.getMessage("training.paper.answer.result", null, locale);
        ThreadPoolUtil.getThreadPoolExecutor().execute(new Runnable(){

            @Override
            public void run() {
                TraineeAnalysisVo vo = TrainingServiceImpl.this.trainingApi.getTraineeAnalysis(req);
                XSSFWorkbook wb = new XSSFWorkbook();
                XSSFSheet sheet = wb.createSheet(finalFileName);
                XSSFCellStyle titleSty = wb.createCellStyle();
                XSSFFont font = wb.createFont();
                font.setFontHeightInPoints((short)16);
                titleSty.setFont((Font)font);
                sheet.setColumnWidth(0, 3000);
                String unStart = TrainingServiceImpl.this.messageSource.getMessage("training.course.status.unstart", null, locale);
                String going = TrainingServiceImpl.this.messageSource.getMessage("training.job.status.going", null, locale);
                String completed = TrainingServiceImpl.this.messageSource.getMessage("training.job.status.completed", null, locale);
                XSSFRow row = sheet.createRow(0);
                row.createCell(0).setCellValue("id");
                row.createCell(1).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.job.account.number", null, locale));
                row.createCell(2).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.user.details.name", null, locale));
                row.createCell(3).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.user.details.employeeNumber", null, locale));
                row.createCell(4).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.course.analysis.role", null, locale));
                row.createCell(5).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.job.post.name", null, locale));
                row.createCell(6).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.course.analysis.superior", null, locale));
                row.createCell(7).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.course.analysis.department", null, locale));
                row.createCell(8).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.course.analysis.starttime", null, locale));
                row.createCell(9).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.course.analysis.endtime", null, locale));
                row.createCell(10).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.task.complete.schedule", null, locale));
                row.createCell(11).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.shift.pass.status", null, locale));
                if (!CollectionUtils.isEmpty(vo.getUserList())) {
                    List<TraineeAnalysisUserVo> list = vo.getUserList();
                    for (int i = 0; i < list.size(); ++i) {
                        TraineeAnalysisUserVo userVo = list.get(i);
                        row = sheet.createRow(i + 1);
                        row.createCell(0).setCellValue((double)userVo.getUserId().intValue());
                        row.createCell(1).setCellValue(userVo.getUserName());
                        row.createCell(2).setCellValue(userVo.getShowName());
                        row.createCell(3).setCellValue(userVo.getEmployeeNumber());
                        row.createCell(4).setCellValue(userVo.getRole());
                        row.createCell(5).setCellValue(userVo.getPost());
                        row.createCell(6).setCellValue(userVo.getParentName());
                        row.createCell(7).setCellValue(userVo.getOrganizes());
                        row.createCell(8).setCellValue(DateUtils.format((Date)userVo.getStartTime(), (String)"MM/dd HH:mm"));
                        row.createCell(9).setCellValue(DateUtils.format((Date)userVo.getFinishTime(), (String)"MM/dd HH:mm"));
                        if (userVo.getStatus() != null && userVo.getStatus().equals(2)) {
                            row.createCell(10).setCellValue(going + " " + userVo.getCheckNum() + "/" + userVo.getCheckTotalNum());
                        } else if (userVo.getStatus() != null && userVo.getStatus().equals(3)) {
                            row.createCell(10).setCellValue(completed + " " + userVo.getCheckNum() + "/" + userVo.getCheckTotalNum());
                        } else {
                            row.createCell(10).setCellValue(unStart + " " + userVo.getCheckNum() + "/" + userVo.getCheckTotalNum());
                        }
                        if (userVo.getIsPass() == null) continue;
                        if (userVo.getIsPass().equals(1)) {
                            row.createCell(11).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.learn.pass", null, locale));
                            continue;
                        }
                        row.createCell(11).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.learn.unpass", null, locale));
                    }
                }
                try {
                    DownloadUtils.successExportTask((Workbook)wb, exportTaskPojo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DownloadUtils.errorExportTask(exportTaskPojo);
                }
            }
        });
        taskList.add(exportTaskPojo);
        return JsonResult.success(taskList);
    }

    @Override
    public String getExaminerAnalysis(final ExaminerAnalysisReq req) {
        final Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        OperateCheck operateCheck = this.trainingApi.getOperateCheckById(req.getOperateCheckId());
        String fileName = MessageFormat.format("{0}_{1}_{2}", operateCheck.getCheckName(), this.messageSource.getMessage("training.operate.analysis", null, locale), DateUtils.format((Date)new Date(), (String)"yyyyMMdd"));
        fileName = ExcelUtil.getFileName(fileName) + ".xlsx";
        ArrayList<ExportTaskPojo> taskList = new ArrayList<ExportTaskPojo>();
        final ExportTaskPojo exportTaskPojo = DownloadUtils.saveExportTask(fileName, JSON.toJSONString((Object)req), 29);
        final String finalFileName = this.messageSource.getMessage("training.operate.analysis", null, locale);
        ThreadPoolUtil.getThreadPoolExecutor().execute(new Runnable(){

            @Override
            public void run() {
                ExaminerAnalysisVo vo = TrainingServiceImpl.this.trainingApi.getExaminerAnalysis(req);
                XSSFWorkbook wb = new XSSFWorkbook();
                XSSFSheet sheet = wb.createSheet(finalFileName);
                XSSFCellStyle titleSty = wb.createCellStyle();
                XSSFFont font = wb.createFont();
                font.setFontHeightInPoints((short)16);
                titleSty.setFont((Font)font);
                sheet.setColumnWidth(0, 3000);
                String unStart = TrainingServiceImpl.this.messageSource.getMessage("training.course.status.unstart", null, locale);
                String going = TrainingServiceImpl.this.messageSource.getMessage("training.job.status.going", null, locale);
                String completed = TrainingServiceImpl.this.messageSource.getMessage("training.job.status.completed", null, locale);
                String notMark = TrainingServiceImpl.this.messageSource.getMessage("training.operate.not.mark", null, locale);
                XSSFRow row = sheet.createRow(0);
                row.createCell(0).setCellValue("id");
                row.createCell(1).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.job.account.number", null, locale));
                row.createCell(2).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.operate.checker", null, locale));
                row.createCell(3).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.user.details.employeeNumber", null, locale));
                row.createCell(4).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.course.analysis.role", null, locale));
                row.createCell(5).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.job.post.name", null, locale));
                row.createCell(6).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.course.analysis.superior", null, locale));
                row.createCell(7).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.course.analysis.department", null, locale));
                row.createCell(8).setCellValue(completed + "/" + TrainingServiceImpl.this.messageSource.getMessage("training.operate.people.count", null, locale));
                row.createCell(9).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.operate.schedule", null, locale) + "(" + TrainingServiceImpl.this.messageSource.getMessage("training.operate.order.number", null, locale) + ")");
                if (!CollectionUtils.isEmpty(vo.getUserList())) {
                    List<ExaminerAnalysisUserVo> list = vo.getUserList();
                    for (int i = 0; i < list.size(); ++i) {
                        ExaminerAnalysisUserVo userVo = list.get(i);
                        row = sheet.createRow(i + 1);
                        row.createCell(0).setCellValue((double)userVo.getUserId().intValue());
                        row.createCell(1).setCellValue(userVo.getUserName());
                        row.createCell(2).setCellValue(userVo.getShowName());
                        row.createCell(3).setCellValue(userVo.getEmployeeNumber());
                        row.createCell(4).setCellValue(userVo.getRole());
                        row.createCell(5).setCellValue(userVo.getPost());
                        row.createCell(6).setCellValue(userVo.getParentName());
                        row.createCell(7).setCellValue(userVo.getOrganizes());
                        if (userVo.getUserTotalNum() > 0) {
                            row.createCell(3).setCellValue(userVo.getUserNum() + "/" + userVo.getUserTotalNum());
                        } else {
                            row.createCell(3).setCellValue("-");
                        }
                        if (userVo.getStatus().equals(0)) {
                            row.createCell(4).setCellValue(notMark);
                            continue;
                        }
                        if (userVo.getStatus().equals(1)) {
                            if (userVo.getUserTotalNum() > 0) {
                                row.createCell(4).setCellValue(unStart + " " + userVo.getCheckNum() + "/" + userVo.getCheckTotalNum());
                                continue;
                            }
                            row.createCell(4).setCellValue(unStart + " ");
                            continue;
                        }
                        if (userVo.getStatus().equals(2)) {
                            row.createCell(4).setCellValue(going + " " + userVo.getCheckNum() + "/" + userVo.getCheckTotalNum());
                            continue;
                        }
                        if (!userVo.getStatus().equals(3)) continue;
                        row.createCell(4).setCellValue(completed + " " + userVo.getCheckNum() + "/" + userVo.getCheckTotalNum());
                    }
                }
                try {
                    DownloadUtils.successExportTask((Workbook)wb, exportTaskPojo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DownloadUtils.errorExportTask(exportTaskPojo);
                }
            }
        });
        taskList.add(exportTaskPojo);
        return JsonResult.success(taskList);
    }

    @Override
    public String downUserAnalysis(final String userName, final Integer activityId, final Integer applyMode, final Users user) {
        final Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        JSONObject param = new JSONObject();
        param.fluentPut("userName", (Object)userName).fluentPut("activityId", (Object)activityId).fluentPut("applyMode", (Object)applyMode).fluentPut("user", (Object)user);
        TrainingActivity activity = this.trainingApi.getActivityById(activityId);
        String fileName = MessageFormat.format("{0}_{1}_{2}", activity.getActivityName(), this.messageSource.getMessage("training.activity.registration.record", null, locale), DateUtils.format((Date)new Date(), (String)"yyyyMMdd"));
        fileName = ExcelUtil.getFileName(fileName) + ".xlsx";
        ArrayList<ExportTaskPojo> taskList = new ArrayList<ExportTaskPojo>();
        final ExportTaskPojo exportTaskPojo = DownloadUtils.saveExportTask(fileName, param.toJSONString(), 33);
        final String finalFileName = this.messageSource.getMessage("training.activity.registration.record", null, locale);
        ThreadPoolUtil.getThreadPoolExecutor().execute(new Runnable(){

            @Override
            public void run() {
                List<TrainingActivityUserVo> vo = TrainingServiceImpl.this.trainingApi.getTrainingActivityUserVoList(user, userName, activityId, applyMode);
                XSSFWorkbook wb = new XSSFWorkbook();
                XSSFSheet sheet = wb.createSheet(finalFileName);
                XSSFCellStyle titleSty = wb.createCellStyle();
                XSSFFont font = wb.createFont();
                font.setFontHeightInPoints((short)16);
                titleSty.setFont((Font)font);
                sheet.setColumnWidth(0, 3000);
                XSSFRow row = sheet.createRow(0);
                row.createCell(0).setCellValue("id");
                row.createCell(1).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.job.account.number", null, locale));
                row.createCell(2).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.course.analysis.name", null, locale));
                row.createCell(3).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.course.analysis.role", null, locale));
                row.createCell(4).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.job.post.name", null, locale));
                row.createCell(5).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.course.analysis.superior", null, locale));
                row.createCell(6).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.course.analysis.department", null, locale));
                row.createCell(7).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.operate.registration.time", null, locale));
                row.createCell(8).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.operate.registration.method", null, locale));
                row.createCell(9).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.operate.send.status", null, locale));
                row.createCell(10).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.operate.send.time", null, locale));
                row.createCell(11).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.operate.send.award", null, locale));
                for (int i = 0; i < vo.size(); ++i) {
                    TrainingActivityUserVo userVo = vo.get(i);
                    row = sheet.createRow(i + 1);
                    row.createCell(0).setCellValue((double)userVo.getUserId().intValue());
                    row.createCell(1).setCellValue(userVo.getUserName());
                    row.createCell(2).setCellValue(userVo.getShowName());
                    row.createCell(3).setCellValue(userVo.getRole());
                    row.createCell(4).setCellValue(userVo.getPost());
                    row.createCell(5).setCellValue(userVo.getParentName());
                    row.createCell(6).setCellValue(userVo.getOrganizeName());
                    row.createCell(7).setCellValue(DateUtils.format((Date)user.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                    if (userVo.getApplyMode() != null) {
                        if (userVo.getApplyMode() == 0) {
                            row.createCell(8).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.activity.independent.registration", null, locale));
                        } else if (userVo.getApplyMode() == 1) {
                            row.createCell(8).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.operate.manual.add", null, locale));
                        }
                    }
                    if (userVo.getSendTime() == null) {
                        row.createCell(9).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.operate.un.grant", null, locale));
                    } else {
                        row.createCell(9).setCellValue(TrainingServiceImpl.this.messageSource.getMessage("training.operate.has.grant", null, locale));
                    }
                    if (userVo.getSendTime() != null) {
                        row.createCell(10).setCellValue(DateUtils.format((Date)userVo.getSendTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                    }
                    row.createCell(11).setCellValue(userVo.getSendDetail());
                }
                try {
                    DownloadUtils.successExportTask((Workbook)wb, exportTaskPojo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DownloadUtils.errorExportTask(exportTaskPojo);
                }
            }
        });
        taskList.add(exportTaskPojo);
        return JsonResult.success(taskList);
    }
}

