/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.service.impl;

import com.alibaba.fastjson.JSON;
import com.ovopark.api.TrainingApi;
import com.ovopark.bo.Authenticator;
import com.ovopark.bo.JsonResult;
import com.ovopark.organize.common.model.pojo.ExportTaskPojo;
import com.ovopark.pojo.OpenShiftExcelVo;
import com.ovopark.pojo.StudentReportVo;
import com.ovopark.pojo.TrainingLearnShiftVo;
import com.ovopark.pojo.Users;
import com.ovopark.service.TrainingShiftExeclService;
import com.ovopark.utils.DateUtils;
import com.ovopark.utils.DownloadUtils;
import com.ovopark.utils.ThreadPoolUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;

@Service
public class TrainingShiftExeclServiceImpl
implements TrainingShiftExeclService {
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private TrainingApi trainingApi;

    @Override
    public String selectOpenShiftByExecl(final OpenShiftExcelVo vo) {
        final Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        final String openCount = this.messageSource.getMessage("training.shift.open.count", null, locale);
        String fileName = MessageFormat.format("{0}_{1}.xlsx", openCount, DateUtils.format((Date)new Date(), (String)"yyyyMMdd_HHmmss"));
        ArrayList<ExportTaskPojo> taskList = new ArrayList<ExportTaskPojo>();
        final ExportTaskPojo exportTaskPojo = DownloadUtils.saveExportTask(fileName, JSON.toJSONString((Object)vo), 8);
        ThreadPoolUtil.getThreadPoolExecutor().execute(new Runnable(){

            @Override
            public void run() {
                List<TrainingLearnShiftVo> list = TrainingShiftExeclServiceImpl.this.trainingApi.selectOpenShift(vo);
                XSSFWorkbook wb = new XSSFWorkbook();
                XSSFSheet sheet = wb.createSheet(openCount);
                XSSFCellStyle titleSty = wb.createCellStyle();
                XSSFFont font = wb.createFont();
                font.setFontHeightInPoints((short)16);
                titleSty.setFont((Font)font);
                XSSFRow row = sheet.createRow(0);
                row.createCell(0).setCellValue(TrainingShiftExeclServiceImpl.this.messageSource.getMessage("training.user.details.employeeNumber", null, locale));
                row.createCell(1).setCellValue(TrainingShiftExeclServiceImpl.this.messageSource.getMessage("training.learn.class.founder", null, locale));
                row.createCell(2).setCellValue(TrainingShiftExeclServiceImpl.this.messageSource.getMessage("training.learn.department", null, locale));
                row.createCell(3).setCellValue(TrainingShiftExeclServiceImpl.this.messageSource.getMessage("training.learn.class.number", null, locale));
                row.createCell(4).setCellValue(TrainingShiftExeclServiceImpl.this.messageSource.getMessage("training.job.status.draft", null, locale));
                row.createCell(5).setCellValue(TrainingShiftExeclServiceImpl.this.messageSource.getMessage("training.learn.wait.online", null, locale));
                row.createCell(6).setCellValue(TrainingShiftExeclServiceImpl.this.messageSource.getMessage("training.job.status.doing", null, locale));
                row.createCell(7).setCellValue(TrainingShiftExeclServiceImpl.this.messageSource.getMessage("training.job.status.pending", null, locale));
                row.createCell(8).setCellValue(TrainingShiftExeclServiceImpl.this.messageSource.getMessage("training.job.status.shift.closed", null, locale));
                for (int i = 0; i < list.size(); ++i) {
                    row = sheet.createRow(i + 1);
                    TrainingLearnShiftVo vo2 = list.get(i);
                    row.createCell(0).setCellValue(vo2.getUserName());
                    row.createCell(1).setCellValue(vo2.getCreatorName());
                    row.createCell(2).setCellValue(vo2.getOrganizeName());
                    row.createCell(3).setCellValue(vo2.getShiftNum());
                    row.createCell(4).setCellValue(vo2.getNotNum());
                    row.createCell(5).setCellValue(vo2.getWaitNum());
                    row.createCell(6).setCellValue(vo2.getGoingNum());
                    row.createCell(7).setCellValue(vo2.getClosingNum());
                    row.createCell(8).setCellValue(vo2.getFinishNum());
                }
                try {
                    DownloadUtils.successExportTask((Workbook)wb, exportTaskPojo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DownloadUtils.errorExportTask(exportTaskPojo);
                }
            }
        });
        taskList.add(exportTaskPojo);
        return JsonResult.success(taskList);
    }

    @Override
    public String selectStudentReportByExecl(final StudentReportVo vo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        vo.setEnterpriseId(user.getGroupId());
        final Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        final String draft = this.messageSource.getMessage("training.job.status.draft", null, locale);
        final String waitOnline = this.messageSource.getMessage("training.job.status.wait.online", null, locale);
        final String unStart = this.messageSource.getMessage("training.course.status.unstart", null, locale);
        final String waitOpen = this.messageSource.getMessage("training.job.status.wait.open", null, locale);
        final String doing = this.messageSource.getMessage("training.job.status.doing", null, locale);
        final String going = this.messageSource.getMessage("training.job.status.going", null, locale);
        final String pending = this.messageSource.getMessage("training.job.status.pending", null, locale);
        final String shiftClosed = this.messageSource.getMessage("training.job.status.shift.closed", null, locale);
        final String ended = this.messageSource.getMessage("training.job.status.ended", null, locale);
        final String completed = this.messageSource.getMessage("training.job.status.completed", null, locale);
        final String unpass = this.messageSource.getMessage("training.learn.unpass", null, locale);
        final String pass = this.messageSource.getMessage("training.paper.pass", null, locale);
        String fileName = MessageFormat.format("{0}_{1}.xlsx", this.messageSource.getMessage("training.learn.shift.student.report", null, locale), DateUtils.format((Date)new Date(), (String)"yyyyMMdd_HHmmss"));
        ArrayList<ExportTaskPojo> taskList = new ArrayList<ExportTaskPojo>();
        final ExportTaskPojo exportTaskPojo = DownloadUtils.saveExportTask(fileName, JSON.toJSONString((Object)vo), 9);
        ThreadPoolUtil.getThreadPoolExecutor().execute(new Runnable(){

            @Override
            public void run() {
                List<StudentReportVo> list = TrainingShiftExeclServiceImpl.this.trainingApi.selectStudentReport(vo);
                XSSFWorkbook wb = new XSSFWorkbook();
                XSSFSheet sheet = wb.createSheet(TrainingShiftExeclServiceImpl.this.messageSource.getMessage("training.learn.shift.student.report", null, locale) + "_" + DateUtils.format((Date)new Date(), (String)"yyyyMMdd"));
                XSSFCellStyle titleSty = wb.createCellStyle();
                XSSFDataFormat dataFormat = wb.createDataFormat();
                titleSty.setDataFormat(dataFormat.getFormat("@"));
                sheet.setDefaultColumnStyle(6, (CellStyle)titleSty);
                sheet.setColumnWidth(6, 3000);
                XSSFRow row = sheet.createRow(0);
                row.createCell(0).setCellValue(TrainingShiftExeclServiceImpl.this.messageSource.getMessage("training.learn.title", null, locale) + "/" + "\u5c97\u4f4d\u8ba4\u8bc1\u540d\u79f0");
                row.createCell(1).setCellValue(TrainingShiftExeclServiceImpl.this.messageSource.getMessage("training.learn.classes.name", null, locale));
                row.createCell(2).setCellValue(TrainingShiftExeclServiceImpl.this.messageSource.getMessage("training.learn.class.founder", null, locale));
                row.createCell(3).setCellValue(TrainingShiftExeclServiceImpl.this.messageSource.getMessage("training.learn.class.time", null, locale));
                row.createCell(4).setCellValue(TrainingShiftExeclServiceImpl.this.messageSource.getMessage("training.learn.classes.validity", null, locale) + "/" + TrainingShiftExeclServiceImpl.this.messageSource.getMessage("training.learn.shift.off.activity.time", null, locale));
                row.createCell(5).setCellValue(TrainingShiftExeclServiceImpl.this.messageSource.getMessage("training.learn.classes.status", null, locale));
                row.createCell(6).setCellValue(TrainingShiftExeclServiceImpl.this.messageSource.getMessage("training.user.details.id", null, locale));
                row.createCell(7).setCellValue(TrainingShiftExeclServiceImpl.this.messageSource.getMessage("training.user.details.username", null, locale));
                row.createCell(8).setCellValue(TrainingShiftExeclServiceImpl.this.messageSource.getMessage("training.course.trainee.name", null, locale));
                row.createCell(9).setCellValue(TrainingShiftExeclServiceImpl.this.messageSource.getMessage("training.user.details.employeeNumber", null, locale));
                row.createCell(10).setCellValue(TrainingShiftExeclServiceImpl.this.messageSource.getMessage("training.course.analysis.role", null, locale));
                row.createCell(11).setCellValue(TrainingShiftExeclServiceImpl.this.messageSource.getMessage("training.job.post.name", null, locale));
                row.createCell(12).setCellValue(TrainingShiftExeclServiceImpl.this.messageSource.getMessage("training.course.analysis.superior", null, locale));
                row.createCell(13).setCellValue(TrainingShiftExeclServiceImpl.this.messageSource.getMessage("training.course.analysis.department", null, locale));
                row.createCell(14).setCellValue(TrainingShiftExeclServiceImpl.this.messageSource.getMessage("training.learn.arrival.time", null, locale));
                row.createCell(15).setCellValue(TrainingShiftExeclServiceImpl.this.messageSource.getMessage("training.shift.start.time", null, locale));
                row.createCell(16).setCellValue(TrainingShiftExeclServiceImpl.this.messageSource.getMessage("training.shift.end.time", null, locale));
                row.createCell(17).setCellValue(TrainingShiftExeclServiceImpl.this.messageSource.getMessage("training.course.analysis.study.status", null, locale));
                row.createCell(18).setCellValue(TrainingShiftExeclServiceImpl.this.messageSource.getMessage("training.paper.total.score", null, locale));
                row.createCell(19).setCellValue(TrainingShiftExeclServiceImpl.this.messageSource.getMessage("training.job.online.paper.avgscore", null, locale));
                row.createCell(20).setCellValue(TrainingShiftExeclServiceImpl.this.messageSource.getMessage("training.job.offline.paper.avgscore", null, locale));
                row.createCell(21).setCellValue(TrainingShiftExeclServiceImpl.this.messageSource.getMessage("training.shift.pass.status", null, locale));
                for (int i = 0; i < list.size(); ++i) {
                    row = sheet.createRow(i + 1);
                    StudentReportVo reportVo = list.get(i);
                    row.createCell(0).setCellValue(reportVo.getProjectName());
                    row.createCell(1).setCellValue(reportVo.getShiftInfoDesc());
                    row.createCell(2).setCellValue(reportVo.getCreatorName());
                    row.createCell(3).setCellValue(StudentReportVo.formatTime(reportVo.getShiftCreateTime()));
                    String shiftTermOfValidity = "-";
                    if (reportVo.getShiftCreateTime() != null) {
                        if (reportVo.getIsNotimeLimit() != null && reportVo.getIsNotimeLimit() == 1) {
                            shiftTermOfValidity = StudentReportVo.formatTime(reportVo.getShiftCreateTime()) + " -> " + TrainingShiftExeclServiceImpl.this.messageSource.getMessage("training.learn.shift.indefinite", null, locale);
                        } else if (reportVo.getShiftEndTime() != null) {
                            shiftTermOfValidity = StudentReportVo.formatTime(reportVo.getShiftCreateTime()) + " -> " + StudentReportVo.formatTime(reportVo.getShiftEndTime());
                        }
                    }
                    row.createCell(4).setCellValue(shiftTermOfValidity);
                    String shiftStatusDesc = "-";
                    if (reportVo.getShiftStatus() != null) {
                        if (reportVo.getShiftStatus() == 0) {
                            shiftStatusDesc = draft;
                        } else if (reportVo.getShiftStatus() == 1) {
                            shiftStatusDesc = waitOpen;
                        } else if (reportVo.getShiftStatus() == 2) {
                            shiftStatusDesc = doing;
                        } else if (reportVo.getShiftStatus() == 3) {
                            shiftStatusDesc = pending;
                        } else if (reportVo.getShiftStatus() == 4) {
                            shiftStatusDesc = shiftClosed;
                        } else if (reportVo.getShiftStatus() == 5) {
                            shiftStatusDesc = unStart;
                        } else if (reportVo.getShiftStatus() == 6) {
                            shiftStatusDesc = going;
                        } else if (reportVo.getShiftStatus() == 7) {
                            shiftStatusDesc = ended;
                        }
                    }
                    row.createCell(5).setCellValue(shiftStatusDesc);
                    row.createCell(6).setCellValue((double)reportVo.getUserId().intValue());
                    sheet.setColumnWidth(6, 3000);
                    row.createCell(7).setCellValue(reportVo.getUserAccount());
                    row.createCell(8).setCellValue(reportVo.getUserName());
                    row.createCell(9).setCellValue(reportVo.getJobNumber());
                    row.createCell(10).setCellValue(reportVo.getRole());
                    row.createCell(11).setCellValue(reportVo.getDutiesName());
                    row.createCell(12).setCellValue(reportVo.getParentName());
                    row.createCell(13).setCellValue(reportVo.getOrganizeName());
                    row.createCell(14).setCellValue(StudentReportVo.formatTime(reportVo.getCreateTime()));
                    row.createCell(15).setCellValue(StudentReportVo.formatTime(reportVo.getStartLearnTime()));
                    row.createCell(16).setCellValue(StudentReportVo.formatTime(reportVo.getEndLearnTime()));
                    String learnStatusDesc = "-";
                    if (reportVo.getLearnStatus() != null) {
                        if (reportVo.getLearnStatus() == 0) {
                            learnStatusDesc = waitOnline;
                        } else if (reportVo.getLearnStatus() == 1) {
                            learnStatusDesc = unStart;
                        } else if (reportVo.getLearnStatus() == 2) {
                            learnStatusDesc = going;
                        } else if (reportVo.getLearnStatus() == 3) {
                            learnStatusDesc = completed;
                        }
                        learnStatusDesc = learnStatusDesc + " " + (reportVo.getFinishTask() == null ? "0" : reportVo.getFinishTask()) + "/" + (reportVo.getLearnTask() == null ? "0" : reportVo.getLearnTask());
                    }
                    row.createCell(17).setCellValue(learnStatusDesc);
                    row.createCell(18).setCellValue(reportVo.getScore() == null ? "-" : reportVo.getScore().toString());
                    row.createCell(19).setCellValue(reportVo.getXsScore() == null ? "-" : reportVo.getXsScore().toString());
                    row.createCell(20).setCellValue(reportVo.getXxScore() == null ? "-" : reportVo.getXxScore().toString());
                    String passStatusDesc = "-";
                    if (reportVo.getPassStatus() != null) {
                        if (reportVo.getPassStatus() == 0) {
                            passStatusDesc = unpass;
                        } else if (reportVo.getPassStatus() == 1) {
                            passStatusDesc = pass;
                        }
                    }
                    row.createCell(21).setCellValue(passStatusDesc);
                }
                try {
                    DownloadUtils.successExportTask((Workbook)wb, exportTaskPojo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DownloadUtils.errorExportTask(exportTaskPojo);
                }
            }
        });
        taskList.add(exportTaskPojo);
        return JsonResult.success(taskList);
    }
}

