/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.service.reportExport;

import com.alibaba.fastjson.JSON;
import com.ovopark.api.TrainingApi;
import com.ovopark.bo.Authenticator;
import com.ovopark.bo.JsonResult;
import com.ovopark.model.TrainingReportParam;
import com.ovopark.model.UserReportParam;
import com.ovopark.organize.common.model.pojo.ExportTaskPojo;
import com.ovopark.pojo.DepartmentTrainingReportVo;
import com.ovopark.pojo.UserReportTrainingVo;
import com.ovopark.pojo.UserReportVo;
import com.ovopark.service.reportExport.ReportService;
import com.ovopark.utils.DateUtils;
import com.ovopark.utils.DownloadUtils;
import com.ovopark.utils.ThreadPoolUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ReportServiceImpl
implements ReportService {
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private TrainingApi trainingApi;

    @Override
    public String getDepartmentTrainingReportByExport(final TrainingReportParam trainingReportParam) {
        final List str = trainingReportParam.getExcelStr().stream().map(String::toUpperCase).collect(Collectors.toList());
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        final String name = this.messageSource.getMessage("training.report.department", null, locale);
        final String departmentName = this.messageSource.getMessage("training.course.analysis.department", null, locale);
        final String userCount = this.messageSource.getMessage("training.dept.user.num", null, locale);
        final String userEnableCount = this.messageSource.getMessage("training.dept.enable.num", null, locale);
        final String trainCount = this.messageSource.getMessage("training.report.train.count", null, locale);
        final String trainUserCount = this.messageSource.getMessage("training.courser.study.user.num", null, locale);
        final String trainUserTimeCount = this.messageSource.getMessage("training.dept.course.total.study.num", null, locale);
        final String userAvgCount = this.messageSource.getMessage("training.report.user.avg.count", null, locale);
        final String finishUserTimeCount = this.messageSource.getMessage("training.dept.course.total.finish.num", null, locale);
        final String finishUserCount = this.messageSource.getMessage("training.report.finish.user.count", null, locale);
        final String userTime = this.messageSource.getMessage("training.report.user.time", null, locale);
        final String userAvgTime = this.messageSource.getMessage("training.report.user.avg.time", null, locale);
        String fileName = MessageFormat.format("{0}-\uff08{1}-{2}\uff09-{3}.xlsx", name, trainingReportParam.getStartDate().replaceAll("-", ""), trainingReportParam.getEndDate().replaceAll("-", ""), DateUtils.format((Date)new Date(), (String)"yyyMMddHHmm"));
        ArrayList<ExportTaskPojo> taskList = new ArrayList<ExportTaskPojo>();
        final ExportTaskPojo exportTaskPojo = DownloadUtils.saveExportTask(fileName, JSON.toJSONString((Object)trainingReportParam), 39);
        ThreadPoolUtil.getThreadPoolExecutor().execute(new Runnable(){

            @Override
            public void run() {
                List<DepartmentTrainingReportVo> list = ReportServiceImpl.this.trainingApi.getDepartmentTrainingReportByExport(trainingReportParam);
                XSSFWorkbook wb = new XSSFWorkbook();
                XSSFSheet sheet = wb.createSheet(name);
                XSSFCellStyle titleSty = wb.createCellStyle();
                titleSty.setWrapText(true);
                XSSFRow row = sheet.createRow(0);
                int currentNum = -1;
                if (str.contains("DEPARTMENTNAME")) {
                    row.createCell(++currentNum).setCellValue(departmentName);
                }
                if (str.contains("USERCOUNT")) {
                    row.createCell(++currentNum).setCellValue(userCount);
                }
                if (str.contains("USERENABLECOUNT")) {
                    row.createCell(++currentNum).setCellValue(userEnableCount);
                }
                if (str.contains("TRAINCOUNT")) {
                    row.createCell(++currentNum).setCellValue(trainCount);
                }
                if (str.contains("TRAINUSERCOUNT")) {
                    row.createCell(++currentNum).setCellValue(trainUserCount);
                }
                if (str.contains("TRAINUSERTIMECOUNT")) {
                    row.createCell(++currentNum).setCellValue(trainUserTimeCount);
                }
                if (str.contains("USERAVGCOUNT")) {
                    row.createCell(++currentNum).setCellValue(userAvgCount);
                }
                if (str.contains("FINISHUSERTIMECOUNT")) {
                    row.createCell(++currentNum).setCellValue(finishUserTimeCount);
                }
                if (str.contains("FINISHUSERCOUNT")) {
                    row.createCell(++currentNum).setCellValue(finishUserCount);
                }
                if (str.contains("USERTIME")) {
                    row.createCell(++currentNum).setCellValue(userTime);
                }
                if (str.contains("USERAVGTIME")) {
                    row.createCell(++currentNum).setCellValue(userAvgTime);
                }
                if (!CollectionUtils.isEmpty(list)) {
                    for (int i = 0; i < list.size(); ++i) {
                        currentNum = -1;
                        row = sheet.createRow(i + 1);
                        DepartmentTrainingReportVo vo = list.get(i);
                        if (str.contains("DEPARTMENTNAME")) {
                            row.createCell(++currentNum).setCellValue(vo.getDepartmentName());
                        }
                        if (str.contains("USERCOUNT")) {
                            row.createCell(++currentNum).setCellValue((double)vo.getUserCount().intValue());
                        }
                        if (str.contains("USERENABLECOUNT")) {
                            row.createCell(++currentNum).setCellValue((double)vo.getUserEnableCount().intValue());
                        }
                        if (str.contains("TRAINCOUNT")) {
                            row.createCell(++currentNum).setCellValue((double)vo.getTrainCount().intValue());
                        }
                        if (str.contains("TRAINUSERCOUNT")) {
                            row.createCell(++currentNum).setCellValue((double)vo.getTrainUserCount().intValue());
                        }
                        if (str.contains("TRAINUSERTIMECOUNT")) {
                            row.createCell(++currentNum).setCellValue((double)vo.getTrainUserTimeCount().intValue());
                        }
                        if (str.contains("USERAVGCOUNT")) {
                            row.createCell(++currentNum).setCellValue(vo.getUserAvgCount().toString());
                        }
                        if (str.contains("FINISHUSERTIMECOUNT")) {
                            row.createCell(++currentNum).setCellValue((double)vo.getFinishUserTimeCount().intValue());
                        }
                        if (str.contains("FINISHUSERCOUNT")) {
                            row.createCell(++currentNum).setCellValue(vo.getFinishUserCount().toString());
                        }
                        if (str.contains("USERTIME")) {
                            row.createCell(++currentNum).setCellValue(vo.getUserTime().toString());
                        }
                        if (!str.contains("USERAVGTIME")) continue;
                        row.createCell(++currentNum).setCellValue(vo.getUserAvgTime().toString());
                    }
                }
                try {
                    DownloadUtils.successExportTask((Workbook)wb, exportTaskPojo);
                }
                catch (Exception e) {
                    DownloadUtils.errorExportTask(exportTaskPojo);
                }
            }
        });
        taskList.add(exportTaskPojo);
        return JsonResult.success(taskList);
    }

    @Override
    public String getUserReportByExport(final UserReportParam param) {
        String fileName = "\u5b66\u4e60\u7edf\u8ba1-\u4e2a\u4eba\u7ef4\u5ea6-\u4e0a\u4f20\u8bfe\u7a0b-(" + DateUtils.format((Date)DateUtils.parse((String)param.getStartDate(), (String)"yyyy-MM-dd HH:mm:ss"), (String)"yyyyMMdd") + "-" + DateUtils.format((Date)DateUtils.parse((String)param.getEndDate(), (String)"yyyy-MM-dd HH:mm:ss"), (String)"yyyyMMdd") + ")-" + DateUtils.format((Date)new Date(), (String)"yyyMMddHHmm") + ".xlsx";
        ArrayList<ExportTaskPojo> taskList = new ArrayList<ExportTaskPojo>();
        final ExportTaskPojo exportTaskPojo = DownloadUtils.saveExportTask(fileName, JSON.toJSONString((Object)param), 40);
        ThreadPoolUtil.getThreadPoolExecutor().execute(new Runnable(){

            @Override
            public void run() {
                List<UserReportVo> list = ReportServiceImpl.this.trainingApi.getUserReportByExport(param);
                List<String> columnList = param.getSelectedColumn();
                XSSFWorkbook wb = new XSSFWorkbook();
                XSSFSheet sheet = wb.createSheet("\u4e2a\u4eba\u7ef4\u5ea6");
                XSSFCellStyle titleSty = wb.createCellStyle();
                titleSty.setWrapText(true);
                XSSFRow row = sheet.createRow(0);
                int currentNum = -1;
                if (columnList.contains("SHOWNAME")) {
                    row.createCell(++currentNum).setCellValue("\u59d3\u540d");
                }
                if (columnList.contains("ORGANIZENAME")) {
                    row.createCell(++currentNum).setCellValue("\u90e8\u95e8");
                }
                if (columnList.contains("ROLENAME")) {
                    row.createCell(++currentNum).setCellValue("\u89d2\u8272");
                }
                if (columnList.contains("MOBILEPHONE")) {
                    row.createCell(++currentNum).setCellValue("\u624b\u673a");
                }
                if (columnList.contains("EMAIL")) {
                    row.createCell(++currentNum).setCellValue("\u90ae\u7bb1");
                }
                if (columnList.contains("ONBOARDINGDATE")) {
                    row.createCell(++currentNum).setCellValue("\u5165\u804c\u65e5\u671f");
                }
                if (columnList.contains("USERSTATUS")) {
                    row.createCell(++currentNum).setCellValue("\u5b66\u5458\u72b6\u6001");
                }
                if (columnList.contains("NEWTRAININGCOUNT")) {
                    row.createCell(++currentNum).setCellValue("\u65b0\u589e\u8bfe\u7a0b\u4e2a\u6570");
                }
                if (columnList.contains("TRAININGNAME")) {
                    row.createCell(++currentNum).setCellValue("\u8bfe\u7a0b\u540d\u79f0");
                }
                if (columnList.contains("ISUSING")) {
                    row.createCell(++currentNum).setCellValue("\u8bfe\u7a0b\u72b6\u6001");
                }
                if (columnList.contains("FILETYPE")) {
                    row.createCell(++currentNum).setCellValue("\u8bfe\u7a0b\u7c7b\u578b");
                }
                if (columnList.contains("ISSHOW")) {
                    row.createCell(++currentNum).setCellValue("\u662f\u5426\u9690\u85cf");
                }
                if (columnList.contains("STANDARDTIME")) {
                    row.createCell(++currentNum).setCellValue("\u6807\u51c6\u65f6\u957f(min)");
                }
                if (columnList.contains("SCORE")) {
                    row.createCell(++currentNum).setCellValue("\u8bfe\u7a0b\u8bc4\u5206");
                }
                if (columnList.contains("RECOMMEND")) {
                    row.createCell(++currentNum).setCellValue("\u63a8\u8350\u7cfb\u6570");
                }
                if (columnList.contains("CREATETIME")) {
                    row.createCell(++currentNum).setCellValue("\u4e0a\u4f20\u65f6\u95f4");
                }
                if (columnList.contains("UPDATETIME")) {
                    row.createCell(++currentNum).setCellValue("\u66f4\u65b0\u65f6\u95f4");
                }
                if (columnList.contains("VERSION")) {
                    row.createCell(++currentNum).setCellValue("\u7248\u672c");
                }
                if (columnList.contains("STUDYNUM")) {
                    row.createCell(++currentNum).setCellValue("\u5b66\u4e60\u4eba\u6570");
                }
                if (columnList.contains("FINISHNUM")) {
                    row.createCell(++currentNum).setCellValue("\u5b8c\u6210\u4eba\u6570");
                }
                if (columnList.contains("LIKECOUNT")) {
                    row.createCell(++currentNum).setCellValue("\u70b9\u8d5e\u4eba\u6570");
                }
                if (columnList.contains("COLLECTNUM")) {
                    row.createCell(++currentNum).setCellValue("\u6536\u85cf\u4eba\u6570");
                }
                if (columnList.contains("COMMENTUSERNUM")) {
                    row.createCell(++currentNum).setCellValue("\u8bc4\u8bba\u4eba\u6570");
                }
                if (columnList.contains("COMMENTNUM")) {
                    row.createCell(++currentNum).setCellValue("\u8bc4\u8bba\u6b21\u6570");
                }
                if (columnList.contains("DOWNLOADS")) {
                    row.createCell(++currentNum).setCellValue("\u4e0b\u8f7d\u6b21\u6570");
                }
                if (columnList.contains("STUDYTIME")) {
                    row.createCell(++currentNum).setCellValue("\u5b66\u4e60\u65f6\u957f(min)");
                }
                if (!CollectionUtils.isEmpty(list)) {
                    int rowNum = 0;
                    for (int i = 0; i < list.size(); ++i) {
                        row = sheet.createRow(++rowNum);
                        currentNum = -1;
                        UserReportVo vo = list.get(i);
                        if (columnList.contains("SHOWNAME")) {
                            row.createCell(++currentNum).setCellValue(vo.getShowName());
                        }
                        if (columnList.contains("ORGANIZENAME")) {
                            row.createCell(++currentNum).setCellValue(vo.getOrganizeName());
                        }
                        if (columnList.contains("ROLENAME")) {
                            row.createCell(++currentNum).setCellValue(vo.getRoleName());
                        }
                        if (columnList.contains("MOBILEPHONE")) {
                            row.createCell(++currentNum).setCellValue(vo.getMobilePhone());
                        }
                        if (columnList.contains("EMAIL")) {
                            row.createCell(++currentNum).setCellValue(vo.getEmail());
                        }
                        if (columnList.contains("ONBOARDINGDATE")) {
                            row.createCell(++currentNum).setCellValue(vo.getOnboardingDate());
                        }
                        if (columnList.contains("USERSTATUS") && vo.getUserStatus() != null) {
                            if (vo.getUserStatus().equals(2)) {
                                row.createCell(++currentNum).setCellValue("\u79bb\u804c");
                            } else if (vo.getUserStatus().equals(1)) {
                                row.createCell(++currentNum).setCellValue("\u51bb\u7ed3");
                            } else if (vo.getUserStatus().equals(0)) {
                                row.createCell(++currentNum).setCellValue("\u6b63\u5e38");
                            }
                        }
                        if (columnList.contains("NEWTRAININGCOUNT")) {
                            row.createCell(++currentNum).setCellValue((double)vo.getNewTrainingCount());
                        }
                        if (!CollectionUtils.isEmpty(vo.getTrainingList())) {
                            List<UserReportTrainingVo> trainingVoList = vo.getTrainingList();
                            for (int j = 0; j < trainingVoList.size(); ++j) {
                                UserReportTrainingVo trainingVo = trainingVoList.get(j);
                                int newNum = currentNum;
                                if (j > 0) {
                                    row = sheet.createRow(++rowNum);
                                }
                                if (columnList.contains("TRAININGNAME")) {
                                    row.createCell(++newNum).setCellValue(trainingVo.getTrainingName());
                                }
                                if (columnList.contains("ISUSING") && trainingVo.getIsUsing() != null) {
                                    if (trainingVo.getIsUsing().equals(1)) {
                                        row.createCell(++newNum).setCellValue("\u4e0a\u67b6");
                                    } else if (trainingVo.getIsUsing().equals(0)) {
                                        row.createCell(++newNum).setCellValue("\u4e0b\u67b6");
                                    }
                                }
                                if (columnList.contains("FILETYPE") && trainingVo.getFileType() != null) {
                                    if (trainingVo.getFileType().equals(1)) {
                                        row.createCell(++newNum).setCellValue("\u6587\u6863");
                                    } else if (trainingVo.getFileType().equals(2)) {
                                        row.createCell(++newNum).setCellValue("\u56fe\u7247");
                                    } else if (trainingVo.getFileType().equals(3)) {
                                        row.createCell(++newNum).setCellValue("\u89c6\u9891");
                                    } else if (trainingVo.getFileType().equals(4)) {
                                        row.createCell(++newNum).setCellValue("\u97f3\u9891");
                                    } else if (trainingVo.getFileType().equals(5)) {
                                        row.createCell(++newNum).setCellValue("\u538b\u7f29\u6587\u4ef6");
                                    } else if (trainingVo.getFileType().equals(6)) {
                                        row.createCell(++newNum).setCellValue("\u5bcc\u6587\u672c");
                                    } else if (trainingVo.getFileType().equals(7)) {
                                        row.createCell(++newNum).setCellValue("\u5546\u54c1");
                                    } else if (trainingVo.getFileType().equals(8)) {
                                        row.createCell(++newNum).setCellValue("\u8bfe\u7a0b");
                                    }
                                }
                                if (columnList.contains("ISSHOW") && trainingVo.getIsShow() != null) {
                                    if (trainingVo.getIsShow().equals(1)) {
                                        row.createCell(++newNum).setCellValue("\u672a\u9690\u85cf");
                                    } else if (trainingVo.getIsShow().equals(0)) {
                                        row.createCell(++newNum).setCellValue("\u9690\u85cf");
                                    }
                                }
                                if (columnList.contains("STANDARDTIME")) {
                                    row.createCell(++newNum).setCellValue(trainingVo.getStandardTime().doubleValue());
                                }
                                if (columnList.contains("SCORE")) {
                                    row.createCell(++newNum).setCellValue(trainingVo.getScore() + "");
                                }
                                if (columnList.contains("RECOMMEND")) {
                                    row.createCell(++newNum).setCellValue((double)trainingVo.getRecommend());
                                }
                                if (columnList.contains("CREATETIME")) {
                                    row.createCell(++newNum).setCellValue(trainingVo.getCreateTime());
                                }
                                if (columnList.contains("UPDATETIME")) {
                                    row.createCell(++newNum).setCellValue(trainingVo.getUpdateTime());
                                }
                                if (columnList.contains("VERSION")) {
                                    row.createCell(++newNum).setCellValue((double)trainingVo.getVersion());
                                }
                                if (columnList.contains("STUDYNUM")) {
                                    row.createCell(++newNum).setCellValue((double)trainingVo.getStudyNum());
                                }
                                if (columnList.contains("FINISHNUM")) {
                                    row.createCell(++newNum).setCellValue((double)trainingVo.getFinishNum());
                                }
                                if (columnList.contains("LIKECOUNT")) {
                                    row.createCell(++newNum).setCellValue((double)trainingVo.getLikeCount());
                                }
                                if (columnList.contains("COLLECTNUM")) {
                                    row.createCell(++newNum).setCellValue((double)trainingVo.getCollectNum());
                                }
                                if (columnList.contains("COMMENTUSERNUM")) {
                                    row.createCell(++newNum).setCellValue((double)trainingVo.getCommentUserNum());
                                }
                                if (columnList.contains("COMMENTNUM")) {
                                    row.createCell(++newNum).setCellValue((double)trainingVo.getCommentNum());
                                }
                                if (columnList.contains("DOWNLOADS")) {
                                    row.createCell(++newNum).setCellValue((double)trainingVo.getDownloads());
                                }
                                if (!columnList.contains("STUDYTIME") || trainingVo.getStudyTime() == null) continue;
                                row.createCell(++newNum).setCellValue(trainingVo.getStudyTime().doubleValue());
                            }
                            continue;
                        }
                        if (columnList.contains("TRAININGNAME")) {
                            row.createCell(++currentNum).setCellValue("-");
                        }
                        if (columnList.contains("ISUSING")) {
                            row.createCell(++currentNum).setCellValue("-");
                        }
                        if (columnList.contains("FILETYPE")) {
                            row.createCell(++currentNum).setCellValue("-");
                        }
                        if (columnList.contains("ISSHOW")) {
                            row.createCell(++currentNum).setCellValue("-");
                        }
                        if (columnList.contains("STANDARDTIME")) {
                            row.createCell(++currentNum).setCellValue("-");
                        }
                        if (columnList.contains("SCORE")) {
                            row.createCell(++currentNum).setCellValue("-");
                        }
                        if (columnList.contains("RECOMMEND")) {
                            row.createCell(++currentNum).setCellValue("-");
                        }
                        if (columnList.contains("CREATETIME")) {
                            row.createCell(++currentNum).setCellValue("-");
                        }
                        if (columnList.contains("UPDATETIME")) {
                            row.createCell(++currentNum).setCellValue("-");
                        }
                        if (columnList.contains("VERSION")) {
                            row.createCell(++currentNum).setCellValue("-");
                        }
                        if (columnList.contains("STUDYNUM")) {
                            row.createCell(++currentNum).setCellValue("-");
                        }
                        if (columnList.contains("FINISHNUM")) {
                            row.createCell(++currentNum).setCellValue("-");
                        }
                        if (columnList.contains("LIKECOUNT")) {
                            row.createCell(++currentNum).setCellValue("-");
                        }
                        if (columnList.contains("COLLECTNUM")) {
                            row.createCell(++currentNum).setCellValue("-");
                        }
                        if (columnList.contains("COMMENTUSERNUM")) {
                            row.createCell(++currentNum).setCellValue("-");
                        }
                        if (columnList.contains("COMMENTNUM")) {
                            row.createCell(++currentNum).setCellValue("-");
                        }
                        if (columnList.contains("DOWNLOADS")) {
                            row.createCell(++currentNum).setCellValue("-");
                        }
                        if (!columnList.contains("STUDYTIME")) continue;
                        row.createCell(++currentNum).setCellValue("-");
                    }
                }
                try {
                    DownloadUtils.successExportTask((Workbook)wb, exportTaskPojo);
                }
                catch (Exception e) {
                    DownloadUtils.errorExportTask(exportTaskPojo);
                }
            }
        });
        taskList.add(exportTaskPojo);
        return JsonResult.success(taskList);
    }
}

