/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.utils;

import com.alibaba.fastjson.JSON;
import com.ovopark.bo.Authenticator;
import com.ovopark.model.ExportParam;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.common.model.pojo.ExportTaskPojo;
import com.ovopark.organize.sdk.api.ExportTaskApi;
import com.ovopark.pojo.Users;
import com.ovopark.utils.OssHelper;
import java.io.ByteArrayOutputStream;
import java.util.Date;
import javax.annotation.PostConstruct;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DownloadUtils {
    private static final Logger log = LoggerFactory.getLogger(DownloadUtils.class);
    @Autowired
    private ExportTaskApi exportTaskApi;
    @Autowired
    private OssHelper ossHelper;
    private static DownloadUtils utils;
    private static final int PENDING = 1;
    private static final int SUCCESS = 2;
    private static final int ERROR = 3;

    @PostConstruct
    public void init() {
        utils = this;
        DownloadUtils.utils.exportTaskApi = this.exportTaskApi;
        DownloadUtils.utils.ossHelper = this.ossHelper;
    }

    public static ExportTaskPojo saveExportTask(String fileName, String params, Integer taskType) {
        Users user = Authenticator.getUser();
        ExportTaskPojo exportTaskPojo = new ExportTaskPojo();
        exportTaskPojo.setCreatorId(user.getId());
        exportTaskPojo.setEnterpriseId(user.getGroupId());
        exportTaskPojo.setModuleType(Integer.valueOf(11));
        exportTaskPojo.setTaskType(taskType);
        exportTaskPojo.setName(fileName);
        exportTaskPojo.setParams(params);
        exportTaskPojo.setStatus(Integer.valueOf(1));
        exportTaskPojo.setCreateTime(new Date());
        boolean success = DownloadUtils.saveExportTask(exportTaskPojo);
        return success ? exportTaskPojo : null;
    }

    public static ExportTaskPojo saveExportTask(String fileName, String params) {
        return DownloadUtils.saveExportTask(fileName, params, 1);
    }

    private static boolean saveExportTask(ExportTaskPojo exportTaskPojo) {
        try {
            BaseResult result = DownloadUtils.utils.exportTaskApi.saveExportTask(exportTaskPojo);
            log.info("saveExportTask result {} ,params:{}", (Object)JSON.toJSONString((Object)result), (Object)JSON.toJSONString((Object)exportTaskPojo));
            if (result != null && result.getData() != null) {
                exportTaskPojo.setId((Integer)result.getData());
                return true;
            }
        }
        catch (Exception e) {
            log.error("saveExportTask error {}", (Throwable)e);
        }
        return false;
    }

    public static ExportTaskPojo successExportTask(Workbook workbook, ExportTaskPojo exportTaskPojo) {
        log.info("successExportTask:", (Object)JSON.toJSONString((Object)exportTaskPojo));
        String url = DownloadUtils.utils.ossHelper.uploadExcel(workbook, exportTaskPojo.getName());
        exportTaskPojo.setUpdateTime(new Date());
        exportTaskPojo.setStatus(Integer.valueOf(2));
        exportTaskPojo.setUrl(url);
        if (DownloadUtils.saveExportTask(exportTaskPojo)) {
            return exportTaskPojo;
        }
        return null;
    }

    public static ExportTaskPojo successExportTask(ByteArrayOutputStream bos, ExportTaskPojo exportTaskPojo, ExportParam param) {
        log.info("successExportTask:", (Object)JSON.toJSONString((Object)exportTaskPojo));
        String url = DownloadUtils.utils.ossHelper.uploadByteOutputStream(bos, param);
        log.info("successExportTask url:{}", (Object)url);
        exportTaskPojo.setUpdateTime(new Date());
        exportTaskPojo.setStatus(Integer.valueOf(2));
        exportTaskPojo.setUrl(url);
        if (DownloadUtils.saveExportTask(exportTaskPojo)) {
            return exportTaskPojo;
        }
        return null;
    }

    public static ExportTaskPojo errorExportTask(ExportTaskPojo exportTaskPojo) {
        exportTaskPojo.setUpdateTime(new Date());
        exportTaskPojo.setStatus(Integer.valueOf(3));
        if (DownloadUtils.saveExportTask(exportTaskPojo)) {
            return exportTaskPojo;
        }
        return null;
    }
}

