/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.enterprise;

import com.ovopark.training.enhancer.subject.resp.Result;
import com.ovopark.training.enhancer.subject.resp.ResultUtils;
import com.ovopark.training.model.Users;
import com.ovopark.training.model.domain.SearchHistoryDo;
import com.ovopark.training.service.enterprise.HistoryService;
import com.ovopark.training.util.ContextUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/training/history"})
public class HistoryController {
    private static final Logger log = LoggerFactory.getLogger(HistoryController.class);
    @Autowired
    private HistoryService historyService;

    @RequestMapping(value={"/getHistoryList"})
    @ResponseBody
    public Result<List<SearchHistoryDo>> getHistoryList() {
        Users user = ContextUtil.getUser();
        return ResultUtils.success(this.historyService.getHistoryList(user));
    }

    @RequestMapping(value={"/clearUserHistoryList"})
    @ResponseBody
    public Result<String> clearUserHistoryList() {
        Users user = ContextUtil.getUser();
        this.historyService.clearUserHistoryList(user);
        return ResultUtils.success();
    }
}

