/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.enterprise;

import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.enhancer.subject.resp.Result;
import com.ovopark.training.enhancer.subject.resp.ResultUtils;
import com.ovopark.training.model.Users;
import com.ovopark.training.model.view.RecommendTrainVo;
import com.ovopark.training.service.enterprise.RecommendService;
import com.ovopark.training.util.ContextUtil;
import com.ovopark.training.vo.TrainingTypeBannerVo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/training/recommend"})
public class RecommendController {
    private static final Logger log = LoggerFactory.getLogger(RecommendController.class);
    @Autowired
    private RecommendService recommendService;

    @RequestMapping(value={"/getRecommend"})
    @ResponseBody
    public Result<RecommendTrainVo> getRecommend() {
        Users user = ContextUtil.getUser();
        return ResultUtils.success((Object)this.recommendService.getRecommend(user));
    }

    @RequestMapping(value={"/saveRecommend"})
    @ResponseBody
    public Result<String> saveRecommend(@RequestBody RecommendTrainVo recommendTrainVo) {
        Users user = ContextUtil.getUser();
        this.recommendService.saveRecommend(recommendTrainVo, user);
        return ResultUtils.success();
    }

    @RequestMapping(value={"/getRecommendTrains"})
    @ResponseBody
    public Result<RecommendTrainVo> getRecommendTrains() {
        Users user = ContextUtil.getUser();
        return ResultUtils.success((Object)this.recommendService.getRecommendTrains(user));
    }

    @RequestMapping(value={"/addTypeBannerList"})
    @ResponseBody
    public String addTypeBannerList(@RequestBody List<TrainingTypeBannerVo> banner) {
        Integer enterpriseId = ContextUtil.getEnterpriseId();
        int userId = ContextUtil.getUserId();
        return this.recommendService.addTypeBannerList(enterpriseId, userId, banner);
    }

    @RequestMapping(value={"/getTypeBannerList"})
    @ResponseBody
    public String getTypeBannerList(Integer materialTypeId) {
        Integer enterpriseId = ContextUtil.getEnterpriseId();
        return this.recommendService.getTypeBannerList(enterpriseId, materialTypeId);
    }

    @RequestMapping(value={"/deleteTypeBannerById"})
    @ResponseBody
    public String deleteTypeBannerById(Integer id) {
        if (id == null) {
            return JsonResult.paramError();
        }
        Integer enterpriseId = ContextUtil.getEnterpriseId();
        return this.recommendService.deleteTypeBannerById(enterpriseId, id);
    }
}

