/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.feign;

import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.SysParams;
import com.ovopark.training.model.Training;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.SysParamsRemoteService;
import com.ovopark.training.service.TrainingPaperRemoteService;
import com.ovopark.training.service.TrainingRemoteService;
import com.ovopark.training.vo.TrainingPaperVo;
import com.ovopark.training.vo.TrainingsVo;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/training/config/feign"})
public class TrainingConfigFeign {
    private static final Logger log = LoggerFactory.getLogger(TrainingConfigFeign.class);
    @Autowired
    private TrainingRemoteService trainingRemoteService;
    @Autowired
    private SysParamsRemoteService sysParamsRemoteService;
    @Autowired
    private TrainingPaperRemoteService paperService;

    @RequestMapping(value={"/updateTrainingStatusById"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public BaseResult<String> updateTrainingStatusById(Integer id) {
        if (Objects.isNull(id)) {
            return BaseResult.paramError();
        }
        Training training = this.trainingRemoteService.getTrainingById(id);
        training.setStatus(Integer.valueOf(2));
        this.trainingRemoteService.updateTraining(training);
        return BaseResult.success();
    }

    @RequestMapping(value={"/updateCollect"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public BaseResult<String> updateCollect(Integer trainingId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (Objects.isNull(user)) {
            return BaseResult.invalidToken();
        }
        this.trainingRemoteService.updateCollect(user.getId(), trainingId);
        return BaseResult.success();
    }

    @RequestMapping(value={"/getCollect"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public BaseResult<Page<TrainingsVo>> getCollect(Page<TrainingsVo> page) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (Objects.isNull(user)) {
            return BaseResult.invalidToken();
        }
        List content = (page = this.trainingRemoteService.getCollect(page, user)).getContent();
        if (!CollectionUtils.isEmpty((Collection)content)) {
            for (TrainingsVo training : content) {
                if (training.getPath() == null || training.getPath().length() <= 4) continue;
                String path = training.getPath();
                if (training.getPath().startsWith("http")) continue;
                training.setPath(this.makePicUrl(path));
            }
        }
        page.setContent(content);
        return BaseResult.success(page);
    }

    @RequestMapping(value={"/getPaperByTrainingIdByPage"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public BaseResult<Page<TrainingPaperVo>> getPaperByTrainingIdByPage(Page<TrainingPaperVo> page, Integer trainingId, Integer enterpriseId, Integer showOptions) {
        if (Objects.isNull(trainingId)) {
            return BaseResult.paramError();
        }
        Users user = Authenticator.getInstance().getCurrentUser();
        return BaseResult.success(this.paperService.getPaperByTrainingIdByPage(page, user.getId(), trainingId, user.getGroupId(), enterpriseId, showOptions));
    }

    @RequestMapping(value={"/updateUserChapterPaper"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public BaseResult<String> updateUserChapterPaper(Integer trainingId, Integer paperId, Double score) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (Objects.isNull(user)) {
            return BaseResult.paramError();
        }
        this.trainingRemoteService.updateUserChapterPaper(user.getId(), trainingId, paperId, score);
        return BaseResult.success();
    }

    @RequestMapping(value={"/getTrainingCollectState"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public BaseResult<Boolean> getTrainingCollectState(Integer trainingId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (Objects.isNull(user)) {
            return BaseResult.invalidToken();
        }
        return BaseResult.success((Object)this.trainingRemoteService.getTrainingCollectState(user.getId(), trainingId));
    }

    private String makePicUrl(String srcPath) {
        if (!srcPath.startsWith("http")) {
            SysParams sysParams = this.sysParamsRemoteService.getSysParams();
            String filePath = srcPath.replace("/extend/shopweb/snapshot", "/snapshot");
            return "http://" + sysParams.getFileServerAddress() + ":" + sysParams.getFileServerPort() + filePath;
        }
        return srcPath;
    }
}

