/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.feign;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.training.mapper.TrainingUserPaperMapper;
import com.ovopark.training.mapper.TrainingUserViewTimeMaterialMapper;
import com.ovopark.training.mapper.TrainingWorkUserAnswerMapper;
import com.ovopark.training.mapper.UserOperateMapper;
import com.ovopark.training.model.StudyEvent;
import com.ovopark.training.model.TrainingUserPaper;
import com.ovopark.training.model.TrainingUserViewTime;
import com.ovopark.training.model.TrainingUserViewTimeMaterial;
import com.ovopark.training.model.TrainingWorkUserAnswer;
import com.ovopark.training.model.UserOperate;
import com.ovopark.training.util.DateUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/training/data/feign"})
public class TrainingDataFeign {
    private static final Logger log = LoggerFactory.getLogger(TrainingDataFeign.class);
    @Autowired
    private TrainingUserViewTimeMaterialMapper trainingUserViewTimeMaterialMapper;
    @Autowired
    private TrainingUserPaperMapper trainingUserPaperMapper;
    @Autowired
    private TrainingWorkUserAnswerMapper trainingWorkUserAnswerMapper;
    @Autowired
    private UserOperateMapper userOperateMapper;
    @Autowired
    private KafkaTemplate<String, String> kafkaTemplate;
    @Value(value="${kafkaTrainingTopic}")
    private String kafkaTrainingTopic;

    @RequestMapping(value={"/studyUserCount"})
    @ResponseBody
    public BaseResult<Map<String, Object>> studyUserCount(String startDateStr, String endDateStr) {
        Date startDate = null;
        startDate = StringUtils.isEmpty((Object)startDateStr) ? DateUtils.getStartTimeOfDay(new Date()) : DateUtils.getStartTimeOfDay(DateUtils.parse(startDateStr, "yyyy-MM-dd"));
        Date endDate = new Date();
        if (!StringUtils.isEmpty((Object)endDateStr)) {
            String endHour = DateUtils.format(endDate, "HH:mm:ss");
            String end = endDateStr + endHour;
            endDate = DateUtils.parse(end, "yyyy-MM-ddHH:mm:ss");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        LambdaQueryWrapper queryWrapper1 = new LambdaQueryWrapper();
        queryWrapper1.ge(TrainingUserViewTimeMaterial::getUpdateTime, (Object)startDate);
        queryWrapper1.le(TrainingUserViewTimeMaterial::getUpdateTime, (Object)endDate);
        List materials1 = this.trainingUserViewTimeMaterialMapper.selectList((Wrapper)queryWrapper1);
        List userList1 = materials1.stream().map(TrainingUserViewTime::getUserId).distinct().collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper2 = new LambdaQueryWrapper();
        queryWrapper2.ge(TrainingUserViewTimeMaterial::getUpdateTime, (Object)DateUtils.addDay(startDate, -1));
        queryWrapper2.le(TrainingUserViewTimeMaterial::getUpdateTime, (Object)DateUtils.addDay(endDate, -1));
        List materials2 = this.trainingUserViewTimeMaterialMapper.selectList((Wrapper)queryWrapper2);
        List userList2 = materials2.stream().map(TrainingUserViewTime::getUserId).distinct().collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper3 = new LambdaQueryWrapper();
        queryWrapper3.ge(TrainingUserPaper::getCreateTime, (Object)startDate);
        queryWrapper3.le(TrainingUserPaper::getCreateTime, (Object)endDate);
        List userPaperList1 = this.trainingUserPaperMapper.selectList((Wrapper)queryWrapper3);
        List userList3 = userPaperList1.stream().map(TrainingUserPaper::getUserId).distinct().collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper4 = new LambdaQueryWrapper();
        queryWrapper4.ge(TrainingUserPaper::getCreateTime, (Object)DateUtils.addDay(startDate, -1));
        queryWrapper4.le(TrainingUserPaper::getCreateTime, (Object)DateUtils.addDay(endDate, -1));
        List userPaperList2 = this.trainingUserPaperMapper.selectList((Wrapper)queryWrapper4);
        List userList4 = userPaperList2.stream().map(TrainingUserPaper::getUserId).distinct().collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper5 = new LambdaQueryWrapper();
        queryWrapper5.ne(TrainingWorkUserAnswer::getStatus, (Object)0);
        queryWrapper5.ge(TrainingWorkUserAnswer::getCommitTime, (Object)startDate);
        queryWrapper5.le(TrainingWorkUserAnswer::getCommitTime, (Object)endDate);
        List userAnswerList1 = this.trainingWorkUserAnswerMapper.selectList((Wrapper)queryWrapper5);
        List userList5 = userAnswerList1.stream().map(TrainingWorkUserAnswer::getUserId).distinct().collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper6 = new LambdaQueryWrapper();
        queryWrapper6.ne(TrainingWorkUserAnswer::getStatus, (Object)0);
        queryWrapper6.ge(TrainingWorkUserAnswer::getCommitTime, (Object)DateUtils.addDay(startDate, -1));
        queryWrapper6.le(TrainingWorkUserAnswer::getCommitTime, (Object)DateUtils.addDay(endDate, -1));
        List userAnswerList2 = this.trainingWorkUserAnswerMapper.selectList((Wrapper)queryWrapper6);
        List userList6 = userAnswerList2.stream().map(TrainingWorkUserAnswer::getUserId).distinct().collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper8 = new LambdaQueryWrapper();
        queryWrapper8.ge(UserOperate::getCreateTime, (Object)startDate);
        queryWrapper8.ge(UserOperate::getCreateTime, (Object)endDate);
        List userOperateList1 = this.userOperateMapper.selectList((Wrapper)queryWrapper8);
        List userList7 = userOperateList1.stream().map(UserOperate::getUserId).distinct().collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper9 = new LambdaQueryWrapper();
        queryWrapper9.ge(UserOperate::getCreateTime, (Object)DateUtils.addDay(startDate, -1));
        queryWrapper9.ge(UserOperate::getCreateTime, (Object)DateUtils.addDay(endDate, -1));
        List userOperateList2 = this.userOperateMapper.selectList((Wrapper)queryWrapper9);
        List userList8 = userOperateList2.stream().map(UserOperate::getUserId).distinct().collect(Collectors.toList());
        int lastUser = userList2.size() + userList4.size() + userList6.size() + userList8.size();
        int currUser = userList1.size() + userList3.size() + userList5.size() + userList7.size();
        BigDecimal growth = this.getGrowth(lastUser, currUser);
        if (growth.compareTo(new BigDecimal(0)) < 0) {
            map.put("rate", 0);
        } else {
            map.put("rate", 1);
        }
        if (lastUser == 0 && currUser != 0) {
            map.put("growth", "--");
        } else {
            map.put("growth", growth.multiply(new BigDecimal(100)));
        }
        map.put("todayUser", currUser);
        return BaseResult.success(map);
    }

    @RequestMapping(value={"/studyWeekUserCount"})
    @ResponseBody
    public BaseResult<List<Map<String, Object>>> studyWeekUserCount(String startDateStr, String endDateStr) {
        Date startDate = null;
        startDate = StringUtils.isEmpty((Object)startDateStr) ? DateUtils.getStartTimeOfDay(new Date()) : DateUtils.getStartTimeOfDay(DateUtils.parse(startDateStr, "yyyy-MM-dd"));
        Date endDate = null;
        if (StringUtils.isEmpty((Object)endDateStr)) {
            startDate = DateUtils.getEndTimeOfDay(new Date());
        } else {
            endDate = DateUtils.getEndTimeOfDay(DateUtils.parse(endDateStr, "yyyy-MM-dd"));
        }
        int countDays = DateUtils.countDays(startDate, endDate);
        ArrayList list = new ArrayList();
        for (int i = 0; i <= countDays; ++i) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            LambdaQueryWrapper queryWrapper1 = new LambdaQueryWrapper();
            queryWrapper1.ge(TrainingUserViewTimeMaterial::getUpdateTime, (Object)DateUtils.getStartTimeOfDay(startDate));
            queryWrapper1.le(TrainingUserViewTimeMaterial::getUpdateTime, (Object)DateUtils.getEndTimeOfDay(startDate));
            List materials1 = this.trainingUserViewTimeMaterialMapper.selectList((Wrapper)queryWrapper1);
            List userList1 = materials1.stream().map(TrainingUserViewTime::getUserId).distinct().collect(Collectors.toList());
            LambdaQueryWrapper queryWrapper3 = new LambdaQueryWrapper();
            queryWrapper3.ge(TrainingUserPaper::getCreateTime, (Object)DateUtils.getStartTimeOfDay(startDate));
            queryWrapper3.le(TrainingUserPaper::getCreateTime, (Object)DateUtils.getEndTimeOfDay(startDate));
            List userPaperList1 = this.trainingUserPaperMapper.selectList((Wrapper)queryWrapper3);
            List userList3 = userPaperList1.stream().map(TrainingUserPaper::getUserId).distinct().collect(Collectors.toList());
            LambdaQueryWrapper queryWrapper5 = new LambdaQueryWrapper();
            queryWrapper5.ne(TrainingWorkUserAnswer::getStatus, (Object)0);
            queryWrapper5.ge(TrainingWorkUserAnswer::getCommitTime, (Object)DateUtils.getStartTimeOfDay(startDate));
            queryWrapper5.le(TrainingWorkUserAnswer::getCommitTime, (Object)DateUtils.getEndTimeOfDay(startDate));
            List userAnswerList1 = this.trainingWorkUserAnswerMapper.selectList((Wrapper)queryWrapper5);
            List userList5 = userAnswerList1.stream().map(TrainingWorkUserAnswer::getUserId).distinct().collect(Collectors.toList());
            LambdaQueryWrapper queryWrapper8 = new LambdaQueryWrapper();
            queryWrapper8.ge(UserOperate::getCreateTime, (Object)DateUtils.getStartTimeOfDay(startDate));
            queryWrapper8.ge(UserOperate::getCreateTime, (Object)DateUtils.getEndTimeOfDay(startDate));
            List userOperateList1 = this.userOperateMapper.selectList((Wrapper)queryWrapper8);
            List userList7 = userOperateList1.stream().map(UserOperate::getUserId).distinct().collect(Collectors.toList());
            int currUser = userList1.size() + userList3.size() + userList5.size() + userList7.size();
            map.put("day", DateUtils.format(startDate, "yyyy-MM-dd"));
            map.put("nums", currUser);
            list.add(map);
            startDate = DateUtils.addDay(startDate, 1);
        }
        return BaseResult.success(list);
    }

    @RequestMapping(value={"/makeDataWithManUal"})
    @ResponseBody
    public BaseResult<List<StudyEvent>> makeDataWithManUal() {
        ArrayList<StudyEvent> list = new ArrayList<StudyEvent>();
        for (int i = 0; i < 10; ++i) {
            StudyEvent event = new StudyEvent();
            event.setDate(new Date());
            event.setCompanyName("\u4e07\u5e97\u638c\u7f51\u7edc\u79d1\u6280\u6709\u9650\u516c\u53f8");
            event.setEvent("\u57f9\u8bad\u5b66\u4e60\u4efb\u52a1");
            event.setShop("\u6d4b\u8bd5\u95e8\u5e97\u52ff\u52a8");
            event.setAddress("\u4e2d\u56fd\u82cf\u5dde\u521b\u4e1a\u56ed4\u53f7\u697c");
            event.setLatitude(Double.valueOf(31.298886));
            event.setLongitude(Double.valueOf(120.585315));
            list.add(event);
        }
        for (StudyEvent event : list) {
            this.kafkaTemplate.send(this.kafkaTrainingTopic, (Object)JSON.toJSONString((Object)event));
        }
        return BaseResult.success();
    }

    private BigDecimal getGrowth(int last, int curr) {
        if (last == 0) {
            return new BigDecimal(0);
        }
        BigDecimal l1 = new BigDecimal(last);
        BigDecimal l2 = new BigDecimal(curr);
        return l2.subtract(l1).divide(l1, 3, 4);
    }
}

