/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.feign;

import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.common.model.pojo.SimplePojo;
import com.ovopark.organize.common.model.pojo.UsersPojo;
import com.ovopark.organize.sdk.api.MessageApi;
import com.ovopark.organize.sdk.api.UserApi;
import com.ovopark.training.mapper.TrainingAndLecturerMapper;
import com.ovopark.training.mapper.TrainingAndMaterialMapper;
import com.ovopark.training.mapper.TrainingAttachMapper;
import com.ovopark.training.mapper.TrainingChapterAttachMapper;
import com.ovopark.training.mapper.TrainingChapterMapper;
import com.ovopark.training.mapper.TrainingChapterVideoMapper;
import com.ovopark.training.mapper.TrainingLabelMapper;
import com.ovopark.training.mapper.TrainingLabelTrainingMapper;
import com.ovopark.training.mapper.TrainingMapper;
import com.ovopark.training.mapper.TrainingPaperMapper;
import com.ovopark.training.mapper.TrainingVideoMapper;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.Training;
import com.ovopark.training.model.TrainingAttach;
import com.ovopark.training.model.TrainingChapter;
import com.ovopark.training.model.TrainingChapterVideo;
import com.ovopark.training.model.TrainingLabel;
import com.ovopark.training.model.TrainingLabelTraining;
import com.ovopark.training.model.TrainingLecturer;
import com.ovopark.training.model.TrainingPaper;
import com.ovopark.training.model.TrainingVideo;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.TrainingRemoteService;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.service.permission.material.MaterialPermissionFacade;
import com.ovopark.training.util.ImageUtil;
import com.ovopark.training.util.TencentLiveUtils;
import com.ovopark.training.vo.TrainingAddVo;
import com.ovopark.training.vo.TrainingChapterAttachVo;
import com.ovopark.training.vo.TrainingChapterVo;
import com.ovopark.training.vo.TrainingLabelVo;
import com.ovopark.training.vo.TrainingLecturerVo;
import com.ovopark.training.vo.TrainingMaterialVo;
import com.ovopark.training.vo.TrainingPaperVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/training/service/feign"})
public class TrainingServiceFeign {
    private static final Logger log = LoggerFactory.getLogger(TrainingServiceFeign.class);
    @Autowired
    private MessageApi messageApi;
    @Autowired
    private TrainingMapper trainingMapper;
    @Autowired
    private TrainingAttachMapper trainingAttachMapper;
    @Autowired
    private TrainingLabelTrainingMapper tltMapper;
    @Autowired
    private TrainingVideoMapper trainingVideoMapper;
    @Autowired
    private TrainingPaperMapper trainingPaperMapper;
    @Autowired
    private TrainingAndLecturerMapper andLecturerMapper;
    @Autowired
    private UserUtilService userUtilService;
    @Autowired
    private TrainingAndMaterialMapper andMaterialMapper;
    @Autowired
    private TrainingChapterMapper trainingChapterMapper;
    @Autowired
    private TrainingChapterAttachMapper trainingChapterAttachMapper;
    @Autowired
    private TrainingChapterVideoMapper trainingChapterVideoMapper;
    @Autowired
    private UserApi userApi;
    @Autowired
    private TrainingLabelMapper trainingLabelMapper;
    @Autowired
    private TrainingRemoteService trainingRemoteService;
    @Autowired
    private MaterialPermissionFacade materialPermissionFacade;

    @RequestMapping(value={"/delMessage"})
    public BaseResult<String> delMessage(long msgId) {
        return BaseResult.paramError();
    }

    @RequestMapping(value={"/saveTraining"})
    public BaseResult<Integer> saveTraining(Training training) {
        if (!StringUtils.isEmpty((Object)training.getId())) {
            this.trainingMapper.updateById(training);
        } else {
            this.trainingMapper.insert(training);
        }
        long txTime = 0L;
        txTime = training.getDuration() == null || training.getDuration() == 0 ? training.getStartTime().getTime() / 1000L + 86400L : training.getStartTime().getTime() / 1000L + (long)(training.getDuration() * 60);
        training.setRtmpPush("rtmp://3682.livepush.myqcloud.com/live/3682_" + training.getId() + "?bizid=3682&" + TencentLiveUtils.getSafeUrl("d2f12deefdc9b314cb31b107315fc65c", "3682_" + training.getId().toString(), txTime));
        training.setRtmpUrl("rtmp://3682.liveplay.myqcloud.com/live/3682_" + training.getId());
        training.setFlvUrl("http://3682.liveplay.myqcloud.com/live/3682_" + training.getId() + ".flv");
        training.setHlsUrl("http://3682.liveplay.myqcloud.com/live/3682_" + training.getId() + ".m3u8");
        this.trainingMapper.updateById(training);
        return BaseResult.success((Object)training.getId());
    }

    @RequestMapping(value={"/getTraining"})
    public BaseResult<TrainingAddVo> getTraining(Integer id) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (Objects.isNull(user)) {
            return BaseResult.invalidToken();
        }
        if (Objects.isNull(id)) {
            return BaseResult.paramError();
        }
        Training training = (Training)this.trainingMapper.selectById(id);
        List<TrainingLabelTraining> trainingLabelTrainings = this.tltMapper.selectByTrainingId(id);
        List<TrainingVideo> trainingVideos = this.trainingVideoMapper.selectByTrainingId(id);
        List<TrainingAttach> trainingAttachs = this.trainingAttachMapper.selectByTrainingId(id);
        List<TrainingPaperVo> trainingPaperVo = this.trainingPaperMapper.selectVoByTrainingId(id);
        List<TrainingLecturerVo> lecturerVos = this.andLecturerMapper.selectLecturerByTraining(id);
        if (!CollectionUtils.isEmpty(lecturerVos)) {
            Map<Integer, UsersPojo> userMap = this.userUtilService.selectUserMap(lecturerVos.stream().map(TrainingLecturer::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList()));
            for (TrainingLecturerVo vo : lecturerVos) {
                UsersPojo usersPojo;
                if (vo.getUserId() == null || ObjectUtils.isEmpty((Object)(usersPojo = userMap.get(vo.getUserId())))) continue;
                vo.setUserName(usersPojo.getShowName());
                vo.setThumbUrl(usersPojo.getThumbUrl());
            }
        }
        TrainingAddVo trainingAddVo = new TrainingAddVo();
        if (!StringUtils.isEmpty((Object)training)) {
            TrainingLabel trainingLabel;
            List<Integer> userIdsList;
            boolean trainContainsAll = this.materialPermissionFacade.isTrainContainsAll(user, id);
            trainingAddVo.setEnterpriseId(training.getEnterpriseId());
            trainingAddVo.setDescription(training.getDescription());
            trainingAddVo.setHeadUrl(training.getHeadUrl());
            trainingAddVo.setPath(training.getPath());
            trainingAddVo.setSpeaker(training.getSpeaker());
            trainingAddVo.setLecturerVos(lecturerVos);
            trainingAddVo.setIsPrivate(Integer.valueOf(trainContainsAll ? 0 : 1));
            trainingAddVo.setSpeakerDescription(training.getSpeakerDescription());
            trainingAddVo.setTitle(training.getTitle());
            trainingAddVo.setTrainingNavId(training.getTrainingNavId());
            trainingAddVo.setAttachUrls(trainingAttachs);
            trainingAddVo.setVideoUrls(trainingVideos);
            trainingAddVo.setIsChapter(training.getIsChapter());
            trainingAddVo.setIsLock(training.getIsLock());
            trainingAddVo.setIsShare(training.getIsShare());
            if (training.getPaperId() != null) {
                trainingAddVo.setPaperId(training.getPaperId());
                TrainingPaper cTraining = (TrainingPaper)this.trainingPaperMapper.selectById(training.getPaperId());
                trainingAddVo.setPaperName(cTraining == null ? "" : cTraining.getTitle());
            }
            List<Object> trainingMaterials = new ArrayList();
            ArrayList<TrainingChapterVo> chapterVos = new ArrayList<TrainingChapterVo>();
            if (training.getIsChapter() != null && training.getIsChapter() == 1) {
                List<TrainingChapter> trainingChapters = this.trainingChapterMapper.selectByTrainingId(id);
                if (!CollectionUtils.isEmpty(trainingChapters)) {
                    for (TrainingChapter trainingChapter : trainingChapters) {
                        List<TrainingChapterAttachVo> trainingChapterAttachs = this.trainingChapterAttachMapper.selectByChapterId(trainingChapter.getId());
                        List<TrainingChapterVideo> trainingChapterVideos = this.trainingChapterVideoMapper.selectByChapterId(trainingChapter.getId());
                        List<TrainingMaterialVo> trainingMaterialVos = this.andMaterialMapper.selectMaterialByTraining(id, trainingChapter.getId());
                        TrainingChapterVo chapterVo = new TrainingChapterVo();
                        chapterVo.setChapterSort(trainingChapter.getChapterSort());
                        chapterVo.setName(trainingChapter.getName());
                        chapterVo.setChapterAttachs(trainingChapterAttachs);
                        chapterVo.setChapterVideos(trainingChapterVideos);
                        chapterVo.setMaterialVos(trainingMaterialVos);
                        chapterVo.setId(trainingChapter.getId());
                        chapterVo.setTrainingId(id);
                        chapterVo.setPaperId(trainingChapter.getPaperId());
                        chapterVo.setScore(trainingChapter.getScore());
                        chapterVo.setStatus(trainingChapter.getStatus());
                        chapterVo.setIsLock(trainingChapter.getIsLock());
                        if (trainingChapter.getPaperId() != null) {
                            TrainingPaper cTraining = (TrainingPaper)this.trainingPaperMapper.selectById(trainingChapter.getPaperId());
                            chapterVo.setPaperName(cTraining == null ? "" : cTraining.getTitle());
                        }
                        chapterVos.add(chapterVo);
                    }
                }
            } else {
                trainingMaterials = this.andMaterialMapper.selectMaterialByTraining(id, null);
            }
            trainingAddVo.setMaterialVos(trainingMaterials);
            trainingAddVo.setChapterVos(chapterVos);
            if (!trainContainsAll && !CollectionUtils.isEmpty(userIdsList = this.materialPermissionFacade.getValidUserIdByTrainId(user, training.getId()))) {
                List userPojoList = (List)this.userApi.getSimpleUserByIdList(userIdsList).getData();
                ArrayList<Users> users = new ArrayList<Users>();
                if (!CollectionUtils.isEmpty((Collection)userPojoList)) {
                    for (SimplePojo pojo : userPojoList) {
                        Users usersId = new Users();
                        usersId.setId(pojo.getId());
                        usersId.setShowName(pojo.getName());
                        users.add(usersId);
                    }
                }
                trainingAddVo.setUsers(users);
            }
            trainingAddVo.setTrainingPaperVos(trainingPaperVo);
            if (!CollectionUtils.isEmpty(trainingLabelTrainings) && (trainingLabel = this.trainingLabelMapper.selectByPrimaryKey(trainingLabelTrainings.get(0).getTrainingLabelId())) != null) {
                trainingAddVo.setLabelIds(trainingLabel.getId().toString());
            }
        }
        return BaseResult.success((Object)trainingAddVo);
    }

    @RequestMapping(value={"/deleteTraining"})
    public BaseResult<String> deleteTraining(Training training) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (Objects.isNull(user)) {
            return BaseResult.invalidToken();
        }
        this.trainingRemoteService.deleteTrainingByIds(String.valueOf(training.getId()), user.getGroupId());
        return BaseResult.success();
    }

    @RequestMapping(value={"/getTrainingLabelByEnp"})
    public BaseResult<Map<String, Object>> getTrainingLabelByEnp() {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (Objects.nonNull(user)) {
            List<TrainingLabelVo> labelList = this.trainingRemoteService.getLabelByNameAndNavId(null, 1000000257, user.getGroupId());
            HashMap<String, List<TrainingLabelVo>> map = new HashMap<String, List<TrainingLabelVo>>();
            map.put("data", TrainingServiceFeign.trainingLabelVoConvert(labelList));
            return BaseResult.success(map);
        }
        return BaseResult.paramError();
    }

    private static List<TrainingLabelVo> trainingLabelVoConvert(List<TrainingLabelVo> trainingList) {
        ArrayList<TrainingLabelVo> resultList = new ArrayList<TrainingLabelVo>();
        if (!CollectionUtils.isEmpty(trainingList)) {
            for (TrainingLabelVo training : trainingList) {
                if (!StringUtils.isEmpty((Object)training.getPicUrl())) {
                    training.setPicUrl(ImageUtil.makePicUrl(training.getPicUrl()));
                }
                resultList.add(training);
            }
        }
        return resultList;
    }
}

