/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.material;

import com.ovopark.organize.common.model.pojo.ExportTaskPojo;
import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.enhancer.subject.resp.Result;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.Users;
import com.ovopark.training.param.material.MaterialBatchUpdateFinishRateParam;
import com.ovopark.training.param.material.MaterialBatchUpdatePermissionParam;
import com.ovopark.training.param.material.MaterialBatchUpdateShareableParam;
import com.ovopark.training.param.material.MaterialBatchUpdateTypeParam;
import com.ovopark.training.param.material.MaterialCopyUpdateParam;
import com.ovopark.training.param.material.MaterialQueryParam;
import com.ovopark.training.service.TrainingMaterialService;
import com.ovopark.training.util.ContextUtil;
import com.ovopark.training.vo.MaterialStudyVo;
import com.ovopark.training.vo.TrainingMaterialVo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/training/material"})
@RestController
public class MaterialController {
    private static final Logger log = LoggerFactory.getLogger(MaterialController.class);
    @Autowired
    private TrainingMaterialService materialService;

    @PostMapping(value={"get-material-by-page-v2"})
    public String getMaterialByPageV2(@RequestBody MaterialQueryParam param) {
        Users user = ContextUtil.getUser();
        if (param.getOrderType() == null) {
            param.setOrderType(Integer.valueOf(2));
        }
        if (param.getOrderByColumn() == null) {
            param.setOrderByColumn(Integer.valueOf(1));
        }
        if (param.getPermissionType() == null) {
            log.warn("get-material-by-page-v2 permissionType is null, set default Download");
            param.setPermissionType(Integer.valueOf(4));
        }
        return this.materialService.getMaterialByPageV2(param, user);
    }

    @PostMapping(value={"batch-update-permission"})
    public Result<Void> batchUpdatePermission(@RequestBody MaterialBatchUpdatePermissionParam param) {
        Users user = ContextUtil.getUser();
        return this.materialService.batchUpdatePermission(param, user);
    }

    @PostMapping(value={"batch-update-shareable"})
    public Result<Void> batchUpdateShareable(@RequestBody MaterialBatchUpdateShareableParam param) {
        Users user = ContextUtil.getUser();
        return this.materialService.batchUpdateShareable(param, user);
    }

    @PostMapping(value={"batch-update-finish-rate"})
    public Result<Void> batchUpdateFinishRate(@RequestBody MaterialBatchUpdateFinishRateParam param) {
        Users user = ContextUtil.getUser();
        return this.materialService.batchUpdateFinishRate(param, user);
    }

    @PostMapping(value={"batch-update-type"})
    public Result<Void> batchUpdateType(@RequestBody MaterialBatchUpdateTypeParam param) {
        Users user = ContextUtil.getUser();
        return this.materialService.batchUpdateTypeId(param, user);
    }

    @RequestMapping(value={"/getAppTrainingMaterialByPage"})
    public String getAppTrainingMaterialByPage(Page<TrainingMaterialVo> page, String title, Integer trainingType, Integer orderBy) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user == null || user.getId() == null) {
            return "INVALID_TOKEN";
        }
        page = this.materialService.getAppTrainingMaterialByPage(page, user, title, trainingType, orderBy);
        return JsonResult.success(page);
    }

    @PostMapping(value={"copyMaterial"})
    public Result<Void> copyMaterial(@RequestBody MaterialCopyUpdateParam param) {
        Users user = ContextUtil.getUser();
        return this.materialService.copyMaterial(param, user);
    }

    @PostMapping(value={"getMaterialStudyByPage"})
    public Result<Page<MaterialStudyVo>> getMaterialStudyByPage(Page<MaterialStudyVo> page, Integer materialId, Integer status, String showName, Integer roleId, String organizeIds, String depIds, @RequestParam(required=false, defaultValue="false") boolean forTrain, @RequestParam(required=false) Integer trainId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.materialService.getMaterialStudyByPage(page, user.getGroupId(), materialId, status, showName, roleId, organizeIds, depIds, forTrain, trainId);
    }

    @PostMapping(value={"exportMaterialStudyByPage"})
    public Result<ExportTaskPojo> exportMaterialStudyByPage(Page<MaterialStudyVo> page, Integer materialId, Integer status, String showName, Integer roleId, String organizeIds, String depIds, @RequestParam(required=false, defaultValue="false") boolean forTrain, @RequestParam(required=false) Integer trainId, @RequestParam(required=false, defaultValue="false") boolean all) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.materialService.exportMaterialStudyByPage(page, user.getGroupId(), materialId, status, showName, roleId, organizeIds, depIds, forTrain, trainId, all);
    }

    @PostMapping(value={"getStringByMaterialId"})
    public Result<List<String>> getStringByMaterialId(Integer materialId, String text) {
        return this.materialService.getStringByMaterialId(materialId, text);
    }
}

