/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.paper;

import com.ovopark.cloud.log.model.LogPojo;
import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.enhancer.subject.resp.Result;
import com.ovopark.training.enhancer.subject.resp.ResultUtils;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.Users;
import com.ovopark.training.request.ExamineeDetailRequest;
import com.ovopark.training.request.ItemAnalysisRequest;
import com.ovopark.training.request.PaperManagementRequest;
import com.ovopark.training.request.TrainingPapersListRequest;
import com.ovopark.training.request.TrainingPapersModifyRequest;
import com.ovopark.training.response.TrainingPaperDetailResponse;
import com.ovopark.training.service.TrainingPaperRemoteService;
import com.ovopark.training.service.exam.ITrainingPaperRefactorService;
import com.ovopark.training.util.CommonUtil;
import com.ovopark.training.util.ContextUtil;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"training/v2/paperConfig"})
public class TrainingPaperController {
    private static final Logger log = LoggerFactory.getLogger(TrainingPaperController.class);
    @Resource
    private TrainingPaperRemoteService paperService;
    @Resource
    private ITrainingPaperRefactorService trainingPaperRefactorService;

    @RequestMapping(value={"/saveTrainingPaper"})
    @ResponseBody
    public Result<Integer> saveTrainingPaper(@RequestBody TrainingPapersModifyRequest paper) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (paper.getEnterpriseId() == null && user.getGroupId() != null) {
            paper.setEnterpriseId(user.getGroupId());
        }
        if (!(StringUtils.isEmpty((Object)paper.getWhoCanSeeIds()) && StringUtils.isEmpty((Object)paper.getRoles()) && StringUtils.isEmpty((Object)paper.getOrganizes()) && StringUtils.isEmpty((Object)paper.getTags()))) {
            paper.setLookLevel(Integer.valueOf(1));
        } else {
            paper.setLookLevel(null);
        }
        Integer paperId = this.trainingPaperRefactorService.saveOrEditTrainingPaperInfo(paper, user);
        this.paperService.saveTrainingExaminer(paperId, paper.getEnterpriseId(), paper.getUserIds());
        List examRangeType = Arrays.stream(paper.getExamRangeType().split(",")).map(Integer::new).collect(Collectors.toList());
        if (examRangeType.contains(0)) {
            this.paperService.saveTrainingPaperUser(paper.getEnterpriseId(), paperId, paper.getWhoCanSeeIds(), user.getId(), paper.getRoles(), paper.getTags(), paper.getOrganizes());
        }
        return ResultUtils.success((Object)paperId);
    }

    @RequestMapping(value={"/showPaperDetail"})
    @ResponseBody
    public String showPaperDetail(Integer paperId) {
        TrainingPaperDetailResponse response = this.trainingPaperRefactorService.showPaperDetail(paperId);
        return JsonResult.success((Object)response);
    }

    @RequestMapping(value={"/getPaperList"})
    @ResponseBody
    public String getPaperList(@RequestBody TrainingPapersListRequest request) {
        Users user = ContextUtil.getUser();
        request.setGroupId(user.getGroupId());
        return JsonResult.success(this.trainingPaperRefactorService.getPaperList(request, user));
    }

    @RequestMapping(value={"/deletePaper"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String deletePaper(HttpServletRequest req, Integer paperId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        LogPojo pojo = new LogPojo();
        pojo.setUserId(user.getId());
        pojo.setOperation("exam_delete");
        pojo.setCreateTime(new Date());
        pojo.setRemoteIp(req.getRemoteAddr());
        pojo.setEnterpriseId(user.getGroupId());
        pojo.setUserName(user.getUserName());
        pojo.setI18nKey("operation.exam_delete.description");
        pojo.setPlatform(CommonUtil.getTerminalByToken(req));
        return this.trainingPaperRefactorService.deletePaper(paperId, pojo);
    }

    @RequestMapping(value={"/updatePaperState"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String updatePaperState(Integer paperId, Integer paperState) {
        Users user = Authenticator.getInstance().getCurrentUser();
        this.trainingPaperRefactorService.updatePaperState(paperId, paperState, user);
        return JsonResult.success();
    }

    @RequestMapping(value={"processPaperHistory"})
    @ResponseBody
    public String processPaperHistory(@RequestParam Integer enterpriseId) {
        this.trainingPaperRefactorService.processPaperHistory(enterpriseId);
        return JsonResult.success();
    }

    @RequestMapping(value={"/initializationPassState"})
    @ResponseBody
    public String initializationPassState() {
        this.trainingPaperRefactorService.initializationPassState();
        return JsonResult.success();
    }

    @RequestMapping(value={"/getPaperManagementBaseInfo"})
    @ResponseBody
    public String getPaperManagementBaseInfo(@RequestBody PaperManagementRequest request) {
        return JsonResult.success((Object)this.trainingPaperRefactorService.getPaperManagementBaseInfo(request));
    }

    @RequestMapping(value={"/getPaperManagementExamineeDetails"})
    @ResponseBody
    public String getPaperManagementExamineeDetails(@RequestBody ExamineeDetailRequest request) {
        Users user = ContextUtil.getUser();
        request.setUser(user);
        return JsonResult.success(this.trainingPaperRefactorService.getPaperManagementExamineeDetails(request));
    }

    @RequestMapping(value={"/removeUserPaperRecord"})
    @ResponseBody
    public String removeUserPaperRecord(HttpServletRequest req, Integer paperId, Integer userId, Integer userType, Integer shiftId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        LogPojo pojo = new LogPojo();
        pojo.setUserId(user.getId());
        pojo.setOperation("user_paper_delete");
        pojo.setCreateTime(new Date());
        pojo.setRemoteIp(req.getRemoteAddr());
        pojo.setEnterpriseId(user.getGroupId());
        pojo.setUserName(user.getUserName());
        pojo.setI18nKey("operation.user_paper_delete.description");
        pojo.setPlatform(CommonUtil.getTerminalByToken(req));
        this.trainingPaperRefactorService.removeUserPaperRecord(paperId, userId, userType, shiftId, pojo);
        return JsonResult.success();
    }

    @RequestMapping(value={"/getUserPaperRecordList"})
    @ResponseBody
    public String getUserPaperRecordList(@RequestBody PaperManagementRequest paperManagementRequest) {
        Users user = ContextUtil.getUser();
        paperManagementRequest.setUser(user);
        return JsonResult.success(this.trainingPaperRefactorService.getUserPaperRecordList(paperManagementRequest));
    }

    @RequestMapping(value={"/getUserPaperAnswerDetail"})
    @ResponseBody
    public String getUserPaperAnswerDetail(@RequestBody PaperManagementRequest request) {
        return JsonResult.success((Object)this.trainingPaperRefactorService.getUserPaperAnswerDetail(request));
    }

    @RequestMapping(value={"/getPaperManagementItemAnalysis"})
    @ResponseBody
    public String getPaperManagementItemAnalysis(@RequestBody ItemAnalysisRequest request) {
        Users user = ContextUtil.getUser();
        request.setUser(user);
        return JsonResult.success(this.trainingPaperRefactorService.getPaperManagementItemAnalysis(request));
    }

    @RequestMapping(value={"/getPaperManagementItemDetail"})
    @ResponseBody
    public String getPaperManagementItemDetail(@RequestBody PaperManagementRequest request) {
        Users user = ContextUtil.getUser();
        request.setUser(user);
        return JsonResult.success((Object)this.trainingPaperRefactorService.getPaperManagementItemDetail(request));
    }
}

