/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.permission;

import com.ovopark.training.enhancer.subject.resp.Result;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.permission.material.MaterialTypePermissionService;
import com.ovopark.training.service.permission.material.TypePermissionManage;
import com.ovopark.training.subject.permission.model.MaterialTypePermissionBO;
import com.ovopark.training.subject.permission.model.MaterialTypePermissionCreateParam;
import com.ovopark.training.subject.permission.model.MaterialTypePermissionUpdateAllParam;
import com.ovopark.training.util.ContextUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/training/material/type/permission"})
public class MaterialTypePermissionController {
    private static final Logger log = LoggerFactory.getLogger(MaterialTypePermissionController.class);
    @Autowired
    private MaterialTypePermissionService materialTypePermissionService;
    @Autowired
    private TypePermissionManage typePermissionManage;

    @PostMapping(value={"batch-create"})
    public Result<Void> batchCreate(@RequestBody MaterialTypePermissionCreateParam param) {
        Users user = ContextUtil.getUser();
        return this.materialTypePermissionService.create(param, user);
    }

    @PostMapping(value={"update-all"})
    public Result<Void> updateAll(@RequestBody MaterialTypePermissionUpdateAllParam param) {
        Users user = ContextUtil.getUser();
        return this.typePermissionManage.updateAll(param, user);
    }

    @PostMapping(value={"get-permission-list"})
    public Result<List<MaterialTypePermissionBO>> getPermissionList(@RequestParam Integer materialTypeId) {
        Users user = ContextUtil.getUser();
        return this.materialTypePermissionService.getList(materialTypeId, user);
    }
}

