/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.report;

import com.ovopark.training.bo.Page;
import com.ovopark.training.enhancer.subject.resp.Result;
import com.ovopark.training.enhancer.subject.resp.ResultUtils;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.Users;
import com.ovopark.training.model.param.TrainingReportParam;
import com.ovopark.training.model.param.UserReportParam;
import com.ovopark.training.model.view.DepartmentTrainingReportVo;
import com.ovopark.training.service.report.ReportService;
import com.ovopark.training.util.ContextUtil;
import com.ovopark.training.util.DateUtils;
import com.ovopark.training.vo.UserReportVo;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/training/report"})
public class ReportController {
    private static final Logger log = LoggerFactory.getLogger(ReportController.class);
    @Autowired
    private ReportService reportService;

    @PostMapping(value={"/getDepartmentTrainingReportByPage"})
    public Result<Page<DepartmentTrainingReportVo>> valid(@RequestBody TrainingReportParam trainingReportParam) {
        Page<DepartmentTrainingReportVo> page = this.reportService.getDepartmentTrainingReportByPage(trainingReportParam, ContextUtil.getUser());
        return ResultUtils.success(page);
    }

    @RequestMapping(value={"/getUserReportByPage"})
    @ResponseBody
    public Result<Page<UserReportVo>> getUserReportByPage(@RequestBody UserReportParam param) {
        String sDate = DateUtils.format(DateUtils.getStartTimeOfDay(new Date()), "yyyy-MM-dd HH:mm:ss");
        String eDate = DateUtils.format(DateUtils.getEndTimeOfDay(new Date()), "yyyy-MM-dd HH:mm:ss");
        if (!StringUtils.isEmpty((String)param.getStartDate())) {
            sDate = DateUtils.format(DateUtils.getStartTimeOfDay(DateUtils.parse(param.getStartDate(), "yyyy-MM-dd")), "yyyy-MM-dd HH:mm:ss");
        }
        if (!StringUtils.isEmpty((String)param.getEndDate())) {
            eDate = DateUtils.format(DateUtils.getEndTimeOfDay(DateUtils.parse(param.getEndDate(), "yyyy-MM-dd")), "yyyy-MM-dd HH:mm:ss");
        }
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.reportService.getUserReportByPage(user, param.getPageNumber(), param.getPageSize(), sDate, eDate, param.getUserStatus(), param.getOrganizeIds(), param.getDepIds(), param.getUserList());
    }
}

