/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.test;

import com.ovopark.training.domain.PermissionDO;
import com.ovopark.training.enhancer.subject.resp.Result;
import com.ovopark.training.enhancer.subject.resp.ResultUtils;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.permission.UnitService;
import com.ovopark.training.service.permission.material.MaterialPermissionFacade;
import com.ovopark.training.util.ContextUtil;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Profile;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RefreshScope
@Profile(value={"dev"})
@RequestMapping(value={"/training/dev-test"})
public class DevTestController {
    private static final Logger log = LoggerFactory.getLogger(DevTestController.class);
    @Value(value="${training.ok:default}")
    private String ok;
    @Autowired
    private MaterialPermissionFacade materialPermissionFacade;
    @Autowired
    private UnitService unitService;

    @RequestMapping(value={"ok"})
    public String ok() {
        return "ok:" + this.ok;
    }

    @RequestMapping(value={"error"})
    public String error(String msg) {
        throw new RuntimeException(StringUtils.defaultString((String)msg, (String)"msg"));
    }

    @PostMapping(value={"log-error"})
    public String logError(String msg) {
        RuntimeException e = new RuntimeException(StringUtils.defaultString((String)msg, (String)"msg"));
        log.error("msg: {}", (Throwable)e);
        return "success";
    }

    @PostMapping(value={"parse-error"})
    public Result<Object> parseError(@RequestBody PermissionDO param) {
        return ResultUtils.success((Object)"aaa");
    }

    @PostMapping(value={"valid-permission"})
    public boolean validPermission(Integer materialId, int userId, int permissionType, int enterpriseId) {
        ContextUtil.setEnterpriseId(enterpriseId);
        Users users = new Users();
        users.setGroupId(Integer.valueOf(enterpriseId));
        users.setId(Integer.valueOf(userId));
        return this.materialPermissionFacade.validMaterial(materialId, users, permissionType);
    }

    @PostMapping(value={"get-unit-by-user-id"})
    public List<Long> getUnitByUserId(int userId) {
        return this.unitService.getIdListByUserId(userId);
    }
}

