/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.train;

import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.enhancer.subject.resp.Result;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.Users;
import com.ovopark.training.param.material.MaterialBatchUpdatePermissionParam;
import com.ovopark.training.param.train.TrainBatchUpdateShareableParam;
import com.ovopark.training.request.DeptStudyTrainingOverviewReq;
import com.ovopark.training.service.train.TrainService;
import com.ovopark.training.util.ContextUtil;
import com.ovopark.training.vo.TrainingsVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/training/train"})
public class TrainController {
    private static final Logger log = LoggerFactory.getLogger(TrainController.class);
    @Autowired
    private TrainService trainService;

    @RequestMapping(value={"/addTrainingTrain"})
    @ResponseBody
    public String addTrainingTrain(@RequestBody TrainingsVo trainingsVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        this.trainService.addTrainingTrain(trainingsVo, user);
        return JsonResult.success();
    }

    @RequestMapping(value={"/updateTrainingTrain"})
    @ResponseBody
    public String updateTrainingTrain(@RequestBody TrainingsVo trainingsVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        this.trainService.updateTrainingTrain(trainingsVo, user);
        return JsonResult.success();
    }

    @RequestMapping(value={"/getTrainingTrainDetail"})
    @ResponseBody
    public String getTrainingTrainDetail(@RequestBody TrainingsVo trainingsVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return JsonResult.success((Object)this.trainService.getTrainingTrainDetail(trainingsVo, user));
    }

    @RequestMapping(value={"/getTrainContent"})
    @ResponseBody
    public String getTrainContent(@RequestBody TrainingsVo trainingsVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return JsonResult.success((Object)this.trainService.getTrainContent(trainingsVo, user));
    }

    @PostMapping(value={"/batch-update-permission"})
    public Result<Void> batchUpdatePermission(@RequestBody MaterialBatchUpdatePermissionParam param) {
        Users user = ContextUtil.getUser();
        return this.trainService.batchUpdatePermission(param, user);
    }

    @PostMapping(value={"/batch-update-shareable"})
    public Result<Void> batchUpdateShareable(@RequestBody TrainBatchUpdateShareableParam param) {
        Users user = ContextUtil.getUser();
        return this.trainService.batchUpdateShareable(param, user);
    }

    @PostMapping(value={"/getCompleteStudyUseTimeOverview"})
    @ResponseBody
    public String getCompleteStudyUseTimeOverview(@RequestBody DeptStudyTrainingOverviewReq req) {
        if (req.getTrainId() == null) {
            return JsonResult.error();
        }
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.trainService.getCompleteStudyUseTimeOverview(user.getGroupId(), user, req.getTrainId());
    }

    @PostMapping(value={"/getDeptStudyOverview"})
    @ResponseBody
    public String getDeptStudyOverview(@RequestBody DeptStudyTrainingOverviewReq req) {
        if (req.getTrainId() == null) {
            return JsonResult.error();
        }
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.trainService.getDeptStudyOverview(req, user);
    }

    @PostMapping(value={"/getStudyCourseOverview"})
    @ResponseBody
    public String getStudyCourseOverview(@RequestBody DeptStudyTrainingOverviewReq req) {
        if (req.getTrainId() == null) {
            return JsonResult.error();
        }
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.trainService.getStudyCourseOverview(req, user);
    }
}

