/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.zother;

import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.TrainingOperateService;
import com.ovopark.training.vo.OperateRankingVo;
import com.ovopark.training.vo.VerifyQuestionsReq;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/training/app/operate"})
public class AppTrainingOperateController {
    private static final Logger log = LoggerFactory.getLogger(AppTrainingOperateController.class);
    @Autowired
    private TrainingOperateService trainingOperateService;

    @RequestMapping(value={"/getMyPrivilegeUser"})
    @ResponseBody
    public String getMyPrivilegeUser() {
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.trainingOperateService.getMyPrivilegeUser(user.getGroupId(), user.getId());
    }

    @RequestMapping(value={"/getMyCheck"})
    @ResponseBody
    public String getMyCheck(Integer status) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.trainingOperateService.getMyCheck(user.getGroupId(), user.getId(), status);
    }

    @RequestMapping(value={"/getMyCheckDetail"})
    @ResponseBody
    public String getMyCheckDetail(Integer operateCheckId) {
        if (operateCheckId == null) {
            return "INVALID_PARAMETER";
        }
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.trainingOperateService.getMyCheckDetail(operateCheckId, user.getId());
    }

    @RequestMapping(value={"/getCheckMe"})
    @ResponseBody
    public String getCheckMe(Integer status) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.trainingOperateService.getCheckMe(user.getGroupId(), user.getId(), status);
    }

    @RequestMapping(value={"/getCheckMeDetail"})
    @ResponseBody
    public String getCheckMeDetail(Integer operateCheckId) {
        if (operateCheckId == null) {
            return "INVALID_PARAMETER";
        }
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.trainingOperateService.getCheckMeDetail(operateCheckId, user.getId());
    }

    @RequestMapping(value={"/addUncheckDescribe"})
    @ResponseBody
    public String addUncheckDescribe(Integer operateCheckId, String uncheckDescribe) {
        if (operateCheckId == null || StringUtils.isEmpty((Object)uncheckDescribe)) {
            return "INVALID_PARAMETER";
        }
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.trainingOperateService.addUncheckDescribe(user.getId(), operateCheckId, uncheckDescribe);
    }

    @RequestMapping(value={"/addCheckUser"})
    @ResponseBody
    public String addCheckUser(Integer operateCheckId, String userIds) {
        if (operateCheckId == null || StringUtils.isEmpty((Object)userIds)) {
            return "INVALID_PARAMETER";
        }
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.trainingOperateService.addCheckUser(operateCheckId, user.getId(), userIds);
    }

    @RequestMapping(value={"/deleteCheckUser"})
    @ResponseBody
    public String deleteCheckUser(Integer operateCheckId, String userIds) {
        if (operateCheckId == null || StringUtils.isEmpty((Object)userIds)) {
            return "INVALID_PARAMETER";
        }
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.trainingOperateService.deleteCheckUser(operateCheckId, user.getShowName(), userIds);
    }

    @RequestMapping(value={"/addExaminerRemark"})
    @ResponseBody
    public String addExaminerRemark(Integer userOperateId, String examinerRemark) {
        if (userOperateId == null) {
            return "INVALID_PARAMETER";
        }
        return this.trainingOperateService.addExaminerRemark(userOperateId, examinerRemark);
    }

    @RequestMapping(value={"/examinerJoinCheck"})
    @ResponseBody
    public String examinerJoinCheck(Integer operateCheckId, Integer userId) {
        if (operateCheckId == null || userId == null) {
            return "INVALID_PARAMETER";
        }
        return this.trainingOperateService.examinerJoinCheck(operateCheckId, userId);
    }

    @RequestMapping(value={"/getOperateDetailById"})
    @ResponseBody
    public String getOperateDetailById(Integer userOperateId) {
        if (userOperateId == null) {
            return "INVALID_PARAMETER";
        }
        return this.trainingOperateService.getOperateDetailById(userOperateId);
    }

    @RequestMapping(value={"/joinCheck"})
    @ResponseBody
    public String joinCheck(Integer operateCheckId) {
        if (operateCheckId == null) {
            return "INVALID_PARAMETER";
        }
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.trainingOperateService.joinCheck(user.getGroupId(), user.getId(), operateCheckId);
    }

    @RequestMapping(value={"/hasOperate"})
    @ResponseBody
    public String hasOperate(Integer operateCheckId) {
        if (operateCheckId == null) {
            return "INVALID_PARAMETER";
        }
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.trainingOperateService.hasOperate(user.getGroupId(), user.getId(), operateCheckId);
    }

    @RequestMapping(value={"/answerQuestions"})
    @ResponseBody
    public String answerQuestions(Integer userOperateDetailDataId, String answer, String remainingTime, Integer isRight) {
        if (userOperateDetailDataId == null || StringUtils.isEmpty((Object)remainingTime)) {
            return "INVALID_PARAMETER";
        }
        return this.trainingOperateService.answerQuestions(userOperateDetailDataId, answer, remainingTime, isRight);
    }

    @RequestMapping(value={"/verifyQuestions"})
    @ResponseBody
    public String verifyQuestions(@RequestBody VerifyQuestionsReq req) {
        if (req.getScore() == null || req.getIsRight() == null) {
            return "INVALID_PARAMETER";
        }
        return this.trainingOperateService.verifyQuestions(req);
    }

    @RequestMapping(value={"/viewExaminee"})
    @ResponseBody
    public String viewExaminee(Integer operateCheckId, Integer userId) {
        if (operateCheckId == null || userId == null) {
            return "INVALID_PARAMETER";
        }
        return this.trainingOperateService.viewExaminee(operateCheckId, userId);
    }

    @RequestMapping(value={"/examinerStartOperate"})
    @ResponseBody
    public String examinerStartOperate(Integer operateCheckId, Integer userId) {
        if (operateCheckId == null || userId == null) {
            return "INVALID_PARAMETER";
        }
        return this.trainingOperateService.examinerStartOperate(operateCheckId, userId);
    }

    @RequestMapping(value={"/examinerHandPapers"})
    @ResponseBody
    public String examinerHandPapers(Integer userOperateId, String examinerRemark, String remainingTime) {
        if (userOperateId == null || StringUtils.isEmpty((Object)remainingTime)) {
            return "INVALID_PARAMETER";
        }
        return this.trainingOperateService.examinerHandPapers(userOperateId, examinerRemark, remainingTime);
    }

    @RequestMapping(value={"/handPapers"})
    @ResponseBody
    public String handPapers(Integer userOperateId, String remainingTime) {
        if (userOperateId == null || StringUtils.isEmpty((Object)remainingTime)) {
            return "INVALID_PARAMETER";
        }
        return this.trainingOperateService.handPapers(userOperateId, remainingTime);
    }

    @RequestMapping(value={"/handPapersDetail"})
    @ResponseBody
    public String handPapersDetail(Integer userOperateId) {
        if (userOperateId == null) {
            return "INVALID_PARAMETER";
        }
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.trainingOperateService.handPapersDetail(user.getId(), userOperateId);
    }

    @RequestMapping(value={"/getScanList"})
    @ResponseBody
    public String getScanList(Integer userOperateDetailDataId) {
        if (userOperateDetailDataId == null) {
            return "INVALID_PARAMETER";
        }
        return this.trainingOperateService.getScanList(userOperateDetailDataId);
    }

    @RequestMapping(value={"/getUserOperateDetailById"})
    @ResponseBody
    public String getUserOperateDetailById(Integer userOperateDetailId) {
        if (userOperateDetailId == null) {
            return "INVALID_PARAMETER";
        }
        return this.trainingOperateService.getUserOperateDetailById(userOperateDetailId);
    }

    @RequestMapping(value={"/getUserOperateDetailDataById"})
    @ResponseBody
    public String getUserOperateDetailDataById(Integer userOperateDetailDataId) {
        if (userOperateDetailDataId == null) {
            return "INVALID_PARAMETER";
        }
        return this.trainingOperateService.getUserOperateDetailDataById(userOperateDetailDataId);
    }

    @RequestMapping(value={"/getOperateRanking"})
    @ResponseBody
    public String getOperateRanking(Integer operateCheckId) {
        if (operateCheckId == null) {
            return "INVALID_PARAMETER";
        }
        Users user = Authenticator.getInstance().getCurrentUser();
        OperateRankingVo vo = this.trainingOperateService.getOperateRanking(user.getId(), operateCheckId);
        return JsonResult.success((Object)vo);
    }

    @RequestMapping(value={"/checkIngExaminer"})
    @ResponseBody
    public String checkIngExaminer(Integer userOperateId) {
        if (userOperateId == null) {
            return "INVALID_PARAMETER";
        }
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.trainingOperateService.checkIngExaminer(user.getId(), userOperateId);
    }

    @RequestMapping(value={"/checkIngUser"})
    @ResponseBody
    public String checkIngUser(Integer userOperateId) {
        if (userOperateId == null) {
            return "INVALID_PARAMETER";
        }
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.trainingOperateService.checkIngUser(user.getId(), userOperateId);
    }

    @RequestMapping(value={"/deleteUserOperateById"})
    @ResponseBody
    public String deleteUserOperateById(Integer userOperateId) {
        if (userOperateId == null) {
            return "INVALID_PARAMETER";
        }
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.trainingOperateService.deleteUserOperateById(user.getGroupId(), userOperateId);
    }
}

