/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.zother;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ovopark.model.GoldModuleEnterpriseDetail;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.common.model.mo.EnterpriseGroupMo;
import com.ovopark.organize.common.model.mo.UsersAndOrgsMo;
import com.ovopark.organize.common.model.pojo.DepartmentPojo;
import com.ovopark.organize.common.model.pojo.UsersPojo;
import com.ovopark.organize.sdk.api.DepartmentApi;
import com.ovopark.organize.sdk.api.EnterpriseGroupsApi;
import com.ovopark.organize.sdk.api.UserApi;
import com.ovopark.organize.sdk.api.UserDepPrivilegeApi;
import com.ovopark.organize.sdk.api.UserOrganizeApi;
import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.StudyEvent;
import com.ovopark.training.model.TrainingUserPaper;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.AppTrainingLearnProjectService;
import com.ovopark.training.service.GoldService;
import com.ovopark.training.service.JPushService;
import com.ovopark.training.service.TrainingCourseService;
import com.ovopark.training.service.TrainingJobCertificationService;
import com.ovopark.training.service.TrainingPaperRemoteService;
import com.ovopark.training.service.TrainingPaperService;
import com.ovopark.training.util.CommonUtil;
import com.ovopark.training.util.ImageUtil;
import com.ovopark.training.vo.TheirPapersVo;
import com.ovopark.training.vo.TrainingPaperRankingUserVo;
import com.ovopark.training.vo.TrainingPaperRankingVo;
import com.ovopark.training.vo.TrainingPaperVo;
import com.ovopark.training.vo.TrainingQuestionVo;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/training/mobileTrainingPaper"})
public class MobileTrainingPaperController {
    private static final Logger log = LoggerFactory.getLogger(MobileTrainingPaperController.class);
    @Autowired
    private TrainingPaperRemoteService paperService;
    @Autowired
    private GoldService goldService;
    @Autowired
    private TrainingJobCertificationService jobCertificationService;
    @Resource
    private AppTrainingLearnProjectService appTrainingLearnProjectService;
    @Autowired
    private UserApi userApi;
    @Autowired
    private JPushService jPushService;
    @Autowired
    private TrainingCourseService trainingCourseService;
    @Autowired
    private KafkaTemplate<String, String> kafkaTemplate;
    @Autowired
    private EnterpriseGroupsApi enterpriseGroupsApi;
    @Autowired
    private UserOrganizeApi userOrganizeApi;
    @Value(value="${kafkaTrainingTopic}")
    private String kafkaTrainingTopic;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private DepartmentApi departmentApi;
    @Autowired
    private UserDepPrivilegeApi userDepPrivilegeApi;
    @Autowired
    private TrainingPaperService trainingPaperService;

    @RequestMapping(value={"/getErrorPaperByPage"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getErrorPaperByPage(Page<TrainingPaperVo> page) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return JsonResult.success(this.paperService.getErrorPaperByPage(page, user.getId()));
    }

    @RequestMapping(value={"/getPaperByPage"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getPaperByPage(Page<TrainingPaperVo> page, Integer navId, Integer enterpriseId, Integer status, Integer showOptions) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return JsonResult.success(this.paperService.getPaperByPage(page, user.getId(), user.getGroupId(), user.getGroupId(), navId, status, showOptions));
    }

    @RequestMapping(value={"/getRecommendPaperByPage"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getRecommendPaperByPage() {
        Users user = Authenticator.getInstance().getCurrentUser();
        return JsonResult.success(this.paperService.getRecommendPaperByPage(user.getId(), user.getGroupId()));
    }

    @RequestMapping(value={"/getQuestionListByPaperId"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getQuestionListByPaperId(Integer paperId) {
        if (paperId == null) {
            return JsonResult.paramError();
        }
        return JsonResult.success((Object)this.paperService.getQuestionListByPaperId(paperId));
    }

    @RequestMapping(value={"/getQuestionListByPaperIdByType"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getQuestionListByPaperIdByType(Integer paperId) {
        if (paperId == null) {
            return JsonResult.paramError();
        }
        return JsonResult.success(this.paperService.getQuestionListByPaperIdByType(paperId));
    }

    @RequestMapping(value={"/getMobileQuestionListByPaperId"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getMobileQuestionListByPaperId(Integer paperId, Integer type, String loginShowName, String loginDepName, String loginEmployeeNumber) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (type != null && type == 1) {
            user = new Users();
        }
        return JsonResult.success((Object)this.paperService.getMobileQuestionListByPaperId(paperId, user.getGroupId(), user.getId(), loginShowName, loginDepName, loginEmployeeNumber));
    }

    @RequestMapping(value={"/getMobileQuestionListIsPass"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getMobileQuestionListIsPass(Integer paperId, Integer type) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (type != null && type == 1) {
            user = new Users();
        }
        return JsonResult.success((Object)this.paperService.getMobileQuestionListIsPass(paperId, user.getGroupId(), user.getId()));
    }

    @RequestMapping(value={"/getDailyChallenge"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getDailyChallenge() {
        Users user = Authenticator.getInstance().getCurrentUser();
        return JsonResult.success((Object)this.paperService.getDailyChallenge(user.getGroupId()));
    }

    @RequestMapping(value={"/getErrorQuestionListById"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getErrorQuestionListById(Integer userPaperId, Integer status) {
        if (userPaperId == null) {
            return JsonResult.paramError();
        }
        return JsonResult.success(this.paperService.getErrorQuestionListById(userPaperId, status));
    }

    @RequestMapping(value={"/getAllErrorQuestionListsById"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getAllErrorQuestionListsById(Integer userPaperId, Integer status) {
        if (userPaperId == null) {
            return JsonResult.paramError();
        }
        return JsonResult.success(this.paperService.getErrorQuestionListById(userPaperId, status));
    }

    @RequestMapping(value={"/getErrorQuestionByPage"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getErrorQuestionByPage(Page<TrainingQuestionVo> page) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return JsonResult.success(this.paperService.getErrorQuestionByPage(page, user.getId()));
    }

    @RequestMapping(value={"/theirPapers"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String theirPapers(String jsonStr, Integer type) {
        TrainingPaperVo paper = (TrainingPaperVo)JSONObject.parseObject((String)jsonStr, TrainingPaperVo.class);
        Users users = Authenticator.getInstance().getCurrentUser();
        if (type != null && type == 1) {
            users = new Users();
        }
        TheirPapersVo result = this.paperService.theirPapers(paper, users.getId());
        result.setUserName(users.getShowName());
        result.setMyImageUrl(ImageUtil.getUserPicByUserId(users.getId()));
        return JsonResult.success((Object)result);
    }

    @RequestMapping(value={"/getUserPaperDetail"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getUserPaperDetail(Integer paperId) {
        Users users = Authenticator.getInstance().getCurrentUser();
        TheirPapersVo result = this.paperService.getUserPaperDetail(paperId, users.getId());
        result.setUserName(users.getShowName());
        result.setMyImageUrl(ImageUtil.getUserPicByUserId(users.getId()));
        return JsonResult.success((Object)result);
    }

    @RequestMapping(value={"/theirDailyChallenge"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String theirDailyChallenge(String jsonStr) {
        TrainingPaperVo paper = (TrainingPaperVo)JSONObject.parseObject((String)jsonStr, TrainingPaperVo.class);
        return JsonResult.success((Object)this.paperService.theirDailyChallenge(paper));
    }

    @RequestMapping(value={"/theirQuestion"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String theirQuestion(String jsonStr, Integer type) {
        TrainingPaperVo paper = (TrainingPaperVo)JSONObject.parseObject((String)jsonStr, TrainingPaperVo.class);
        if (paper.getId() == null || StringUtils.isEmpty((Object)paper.getQuestionList())) {
            return JsonResult.paramError();
        }
        Integer userId = Authenticator.getInstance().getCurrentUser().getId();
        if (type != null && type == 1) {
            userId = null;
        }
        this.paperService.theirQuestion(paper, userId);
        return JsonResult.success();
    }

    @RequestMapping(value={"/theirAllQuestions"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String theirAllQuestions(String jsonStr) {
        if (!StringUtils.isEmpty((Object)jsonStr)) {
            List paper = JSONObject.parseArray((String)jsonStr, TrainingPaperVo.class);
            if (!CollectionUtils.isEmpty((Collection)paper)) {
                TheirPapersVo result = new TheirPapersVo();
                TrainingPaperVo trainingPaperVo = (TrainingPaperVo)paper.get(0);
                final Integer userPaperId = trainingPaperVo.getUserPaperId();
                if (!StringUtils.isEmpty((Object)userPaperId)) {
                    TrainingUserPaper userPaper = this.paperService.getUserPaper(userPaperId);
                    if (!ObjectUtils.isEmpty((Object)userPaper)) {
                        final Integer userId = userPaper.getUserId();
                        try {
                            UsersPojo usersPojo = new UsersPojo();
                            if (!StringUtils.isEmpty((Object)userId)) {
                                usersPojo = (UsersPojo)this.userApi.getUserById(userId).getData();
                            }
                            userPaper = trainingPaperVo != null && trainingPaperVo.getExamId() != null && trainingPaperVo.getExamId() != 0 ? this.paperService.theirAllQuestionNew(paper, userId) : this.paperService.theirAllQuestion(paper, userId);
                            this.sendStudyEvent((TrainingPaperVo)paper.get(0));
                            result = this.paperService.theirPapers((TrainingPaperVo)paper.get(0), userId);
                            if (!StringUtils.isEmpty((Object)userId)) {
                                result.setUserName(usersPojo.getShowName());
                                List<GoldModuleEnterpriseDetail> goldModuleEnterpriseDetail = this.goldService.getGoldModuleEnterpriseDetailByEnterpriseId(usersPojo.getGroupId(), "TRSINING_PAPER");
                                if (!CollectionUtils.isEmpty(goldModuleEnterpriseDetail)) {
                                    result.setRuleScore(Integer.valueOf(-1));
                                }
                                result.setMyImageUrl(usersPojo.getThumbUrl());
                            } else {
                                result.setUserName(userPaper.getLoginShowName());
                            }
                        }
                        catch (Exception e) {
                            log.error("theirAllQuestions\u63d0\u4ea4\uff1a userPaperId=" + userPaperId, (Throwable)e);
                            return JsonResult.error((String)"\u53c2\u6570\u4e0d\u5168", (Object)e.getMessage());
                        }
                        final TrainingUserPaper finalUserPaper = userPaper;
                        CommonUtil.handleTask(new Runnable(){

                            @Override
                            public void run() {
                                if (Objects.nonNull(userPaperId)) {
                                    if (!StringUtils.isEmpty((Object)finalUserPaper.getSourceType())) {
                                        if (finalUserPaper.getSourceType() == 1) {
                                            MobileTrainingPaperController.this.paperService.updateStudyStatus(userPaperId);
                                        } else if (finalUserPaper.getSourceType() == 3) {
                                            try {
                                                MobileTrainingPaperController.this.appTrainingLearnProjectService.updateExamTaskStatus(finalUserPaper.getId());
                                            }
                                            catch (Exception e) {
                                                log.error("\u63d0\u4ea4\u8bd5\u5377\u9879\u76ee\u5b66\u4e60src\u903b\u8f91", (Throwable)e);
                                            }
                                        } else if (finalUserPaper.getSourceType() == 4) {
                                            try {
                                                MobileTrainingPaperController.this.jobCertificationService.updatePaperStatus(finalUserPaper.getId());
                                            }
                                            catch (Exception e) {
                                                log.error("\u5c97\u4f4d\u5b66\u4e60\u65b0\u52a0\u903b\u8f91", (Throwable)e);
                                            }
                                        } else if (finalUserPaper.getSourceType() == 5 && !StringUtils.isEmpty((Object)userId)) {
                                            try {
                                                MobileTrainingPaperController.this.trainingCourseService.saveCourseTaskEnd(userPaperId, 2, userId, null, null);
                                            }
                                            catch (Exception e) {
                                                log.error("\u57f9\u8bad\u8ba1\u5212\u8003\u8bd5\u7ed3\u675f", (Throwable)e);
                                            }
                                        }
                                    }
                                    if (!StringUtils.isEmpty((Object)userId)) {
                                        try {
                                            MobileTrainingPaperController.this.jPushService.deleteMessages(finalUserPaper.getTrainingPaperId(), "TYPE_PAPER_SYSTEM", userId, null, 1);
                                        }
                                        catch (Exception e) {
                                            log.error("\u5220\u9664\u63a8\u9001\u4fe1\u606f", (Throwable)e);
                                        }
                                    }
                                    if (!StringUtils.isEmpty((Object)finalUserPaper.getIsReview()) && finalUserPaper.getIsReview() == 1) {
                                        MobileTrainingPaperController.this.trainingPaperService.savePaperReviewer(finalUserPaper);
                                    }
                                }
                            }
                        });
                        return JsonResult.success((Object)result);
                    }
                    log.error("\u63d0\u4ea4 \u8bb0\u5f55\u4e3a\u7a7a \uff1auserPaper is null-" + userPaperId, (Object)("json = " + jsonStr));
                    return JsonResult.error((String)"\u8003\u8bd5\u88ab\u4fee\u6539\uff0c\u9000\u51fa\u91cd\u8003", (Object)"userPaper is null");
                }
                log.error("\u63d0\u4ea4 \uff1auserPaperId is null-" + trainingPaperVo.getId(), (Object)("json = " + jsonStr));
                return JsonResult.error((String)"\u8003\u8bd5\u88ab\u4fee\u6539", (Object)"userPaperId is null");
            }
            log.error("\u63d0\u4ea4 \uff1apaper is null-", (Object)("json = " + jsonStr));
            return JsonResult.error((String)"\u67e5\u65e0\u8003\u8bd5", (Object)"paper is null");
        }
        log.error("\u63d0\u4ea4 \uff1ajson is null-", (Object)("json = " + jsonStr));
        return JsonResult.error((String)"json is null", (Object)"json is null");
    }

    public void sendStudyEvent(TrainingPaperVo paper) {
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        StudyEvent event = new StudyEvent();
        event.setDate(new Date());
        Integer userId = paper.getUserId();
        Integer groupId = paper.getEnterpriseId();
        event.setShop(this.findShopNameByUserId(userId, groupId));
        String taskStudy = this.messageSource.getMessage("training.job.course.task.study", null, locale);
        event.setEvent(taskStudy);
        BaseResult baseResult1 = this.enterpriseGroupsApi.getEnterpriseByGroupIdApi(groupId);
        if (!baseResult1.getIsError().booleanValue() && Objects.nonNull(baseResult1.getData())) {
            event.setCompanyName(((EnterpriseGroupMo)baseResult1.getData()).getName());
        } else {
            event.setCompanyName("");
        }
        BaseResult baseResult2 = this.userDepPrivilegeApi.getPrivilegeDepBeanByUserIdAndGroupId(userId, groupId, Boolean.valueOf(true));
        if (!baseResult2.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)baseResult2.getData()))) {
            event.setLatitude(((DepartmentPojo)((List)baseResult2.getData()).get(0)).getLatitude());
            event.setLongitude(((DepartmentPojo)((List)baseResult2.getData()).get(0)).getLongitude());
            event.setAddress(((DepartmentPojo)((List)baseResult2.getData()).get(0)).getAddress());
        }
        if (!StringUtils.isEmpty((Object)event.getShop())) {
            this.kafkaTemplate.send(this.kafkaTrainingTopic, (Object)JSON.toJSONString((Object)event));
        }
    }

    private String findShopNameByUserId(Integer userId, Integer groupId) {
        Map shopMap = new HashMap();
        UsersAndOrgsMo mo = new UsersAndOrgsMo();
        mo.setGroupId(groupId);
        mo.setUserIdList(Collections.singletonList(userId));
        mo.setShowDepartment(Boolean.valueOf(true));
        BaseResult base = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
        if (base != null && !ObjectUtils.isEmpty((Object)base.getData())) {
            shopMap = (Map)base.getData();
        }
        List pojoList = (List)shopMap.get(userId);
        String shopName = "";
        if (!CollectionUtils.isEmpty((Collection)pojoList)) {
            pojoList = pojoList.stream().distinct().collect(Collectors.toList());
            shopName = (String)pojoList.get(0);
        }
        return shopName;
    }

    @RequestMapping(value={"/getRankingList"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getRankingList() {
        Users user = Authenticator.getInstance().getCurrentUser();
        TrainingPaperRankingVo vo = this.paperService.getRankingList(user.getGroupId(), user.getId());
        vo.setUserName(user.getShowName());
        if (!CollectionUtils.isEmpty((Collection)vo.getUserList())) {
            for (TrainingPaperRankingUserVo userVo : vo.getUserList()) {
                String imageUrl = ImageUtil.getUserPicByUserId(userVo.getUserId());
                if (StringUtils.isEmpty((Object)imageUrl)) continue;
                userVo.setImageUrl(imageUrl);
            }
        }
        ImageUtil.getUserPicByUserId(user.getId());
        vo.setMyImageUrl(ImageUtil.getUserPicByUserId(user.getId()));
        return JsonResult.success((Object)vo);
    }

    @RequestMapping(value={"/getPaperByTrainingIdByPage"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getPaperByTrainingIdByPage(Page<TrainingPaperVo> page, Integer trainingId, Integer enterpriseId, Integer showOptions) {
        if (trainingId == null) {
            return JsonResult.paramError();
        }
        Users user = Authenticator.getInstance().getCurrentUser();
        return JsonResult.success(this.paperService.getPaperByTrainingIdByPage(page, user.getId(), trainingId, user.getGroupId(), enterpriseId, showOptions));
    }
}

