/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.zother;

import com.ovopark.pojo.JsonResult;
import com.ovopark.training.service.TrainingCertificateService;
import com.ovopark.training.service.TrainingCourseStatisticalService;
import com.ovopark.training.service.TrainingLearnProjectService;
import com.ovopark.training.service.TrainingMaterialService;
import com.ovopark.training.service.TrainingPaperService;
import com.ovopark.training.service.TrainingService;
import com.ovopark.training.util.DateUtils;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/training/open"})
public class OpenController {
    @Autowired
    private TrainingService trainingService;
    @Autowired
    private TrainingLearnProjectService trainingLearnProjectService;
    @Autowired
    private TrainingCertificateService trainingCertificateService;
    @Autowired
    private TrainingMaterialService trainingMaterialService;
    @Autowired
    private TrainingPaperService trainingPaperService;
    @Autowired
    private TrainingCourseStatisticalService trainingCourseStatisticalService;

    @RequestMapping(value={"/getTrainingList"})
    @ResponseBody
    public String getTrainingList(Integer enterpriseId, String trainingName, String startTime, String endTime) {
        if (enterpriseId == null) {
            return JsonResult.paramError();
        }
        Date startDate = null;
        Date endDate = null;
        if (!StringUtils.isEmpty((Object)startTime)) {
            startDate = DateUtils.getStartTimeOfDay(DateUtils.parse(startTime, "yyyyMMdd"));
        }
        if (!StringUtils.isEmpty((Object)endTime)) {
            endDate = DateUtils.getEndTimeOfDay(DateUtils.parse(endTime, "yyyyMMdd"));
        }
        return this.trainingService.getOpenTrainingList(enterpriseId, trainingName, startDate, endDate);
    }

    @RequestMapping(value={"/getPaperList"})
    @ResponseBody
    public String getPaperList(Integer enterpriseId, String startTime, String endTime) {
        if (enterpriseId == null) {
            return JsonResult.paramError();
        }
        Date startDate = null;
        Date endDate = null;
        if (!StringUtils.isEmpty((Object)startTime)) {
            startDate = DateUtils.getStartTimeOfDay(DateUtils.parse(startTime, "yyyyMMdd"));
        }
        if (!StringUtils.isEmpty((Object)endTime)) {
            endDate = DateUtils.getEndTimeOfDay(DateUtils.parse(endTime, "yyyyMMdd"));
        }
        return this.trainingService.getOpenPaperList(enterpriseId, startDate, endDate);
    }

    @RequestMapping(value={"/getCourseList"})
    @ResponseBody
    public String getCourseList(Integer enterpriseId, String startTime, String endTime) {
        if (enterpriseId == null) {
            return JsonResult.paramError();
        }
        Date startDate = null;
        Date endDate = null;
        if (!StringUtils.isEmpty((Object)startTime)) {
            startDate = DateUtils.getStartTimeOfDay(DateUtils.parse(startTime, "yyyyMMdd"));
        }
        if (!StringUtils.isEmpty((Object)endTime)) {
            endDate = DateUtils.getEndTimeOfDay(DateUtils.parse(endTime, "yyyyMMdd"));
        }
        return this.trainingCourseStatisticalService.getOpenCourseList(enterpriseId, startDate, endDate);
    }

    @RequestMapping(value={"/getProjectList"})
    @ResponseBody
    public String getProjectList(Integer enterpriseId, String startTime, String endTime) {
        if (enterpriseId == null) {
            return JsonResult.paramError();
        }
        Date startDate = null;
        Date endDate = null;
        if (!StringUtils.isEmpty((Object)startTime)) {
            startDate = DateUtils.getStartTimeOfDay(DateUtils.parse(startTime, "yyyyMMdd"));
        }
        if (!StringUtils.isEmpty((Object)endTime)) {
            endDate = DateUtils.getEndTimeOfDay(DateUtils.parse(endTime, "yyyyMMdd"));
        }
        return this.trainingLearnProjectService.getOpenProjectList(enterpriseId, startDate, endDate);
    }

    @RequestMapping(value={"/getCertificateList"})
    @ResponseBody
    public String getCertificateList(Integer enterpriseId, String startTime, String endTime) {
        if (enterpriseId == null) {
            return JsonResult.paramError();
        }
        Date startDate = null;
        Date endDate = null;
        if (!StringUtils.isEmpty((Object)startTime)) {
            startDate = DateUtils.getStartTimeOfDay(DateUtils.parse(startTime, "yyyyMMdd"));
        }
        if (!StringUtils.isEmpty((Object)endTime)) {
            endDate = DateUtils.getEndTimeOfDay(DateUtils.parse(endTime, "yyyyMMdd"));
        }
        return this.trainingCertificateService.getOpenCertificateList(enterpriseId, startDate, endDate);
    }

    @RequestMapping(value={"/getUserViewTimeList"})
    @ResponseBody
    public String getUserViewTimeList(Integer enterpriseId, String startTime, String endTime) {
        if (enterpriseId == null) {
            return JsonResult.paramError();
        }
        Date startDate = null;
        Date endDate = null;
        if (!StringUtils.isEmpty((Object)startTime)) {
            startDate = DateUtils.getStartTimeOfDay(DateUtils.parse(startTime, "yyyyMMdd"));
        }
        if (!StringUtils.isEmpty((Object)endTime)) {
            endDate = DateUtils.getEndTimeOfDay(DateUtils.parse(endTime, "yyyyMMdd"));
        }
        return this.trainingMaterialService.getOpenUserViewTimeList(enterpriseId, startDate, endDate);
    }

    @RequestMapping(value={"/getUserPaperList"})
    @ResponseBody
    public String getUserPaperList(Integer enterpriseId, String startTime, String endTime) {
        if (enterpriseId == null) {
            return JsonResult.paramError();
        }
        Date startDate = null;
        Date endDate = null;
        if (!StringUtils.isEmpty((Object)startTime)) {
            startDate = DateUtils.getStartTimeOfDay(DateUtils.parse(startTime, "yyyyMMdd"));
        }
        if (!StringUtils.isEmpty((Object)endTime)) {
            endDate = DateUtils.getEndTimeOfDay(DateUtils.parse(endTime, "yyyyMMdd"));
        }
        return this.trainingPaperService.getOpenUserPaperList(enterpriseId, startDate, endDate);
    }

    @RequestMapping(value={"/getUserCourseList"})
    @ResponseBody
    public String getUserCourseList(Integer enterpriseId, String startTime, String endTime) {
        if (enterpriseId == null) {
            return JsonResult.paramError();
        }
        Date startDate = null;
        Date endDate = null;
        if (!StringUtils.isEmpty((Object)startTime)) {
            startDate = DateUtils.getStartTimeOfDay(DateUtils.parse(startTime, "yyyyMMdd"));
        }
        if (!StringUtils.isEmpty((Object)endTime)) {
            endDate = DateUtils.getEndTimeOfDay(DateUtils.parse(endTime, "yyyyMMdd"));
        }
        return this.trainingCertificateService.getOpenUserCourseList(enterpriseId, startDate, endDate);
    }

    @RequestMapping(value={"/getUserLeanList"})
    @ResponseBody
    public String getUserLeanList(Integer enterpriseId, String startTime, String endTime) {
        if (enterpriseId == null) {
            return JsonResult.paramError();
        }
        Date startDate = null;
        Date endDate = null;
        if (!StringUtils.isEmpty((Object)startTime)) {
            startDate = DateUtils.getStartTimeOfDay(DateUtils.parse(startTime, "yyyyMMdd"));
        }
        if (!StringUtils.isEmpty((Object)endTime)) {
            endDate = DateUtils.getEndTimeOfDay(DateUtils.parse(endTime, "yyyyMMdd"));
        }
        return this.trainingLearnProjectService.getOpenUserLeanList(enterpriseId, startDate, endDate);
    }
}

