/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.zother;

import com.ovopark.api.RedisBaseApi;
import com.ovopark.training.mapper.OperateTemplateMapper;
import com.ovopark.training.mapper.TrainingUserViewTimeMapper;
import com.ovopark.training.service.AppTrainingLearnProjectService;
import com.ovopark.training.vo.TrainingUserViewTimeVo;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/training/test"})
public class TestController {
    @Autowired
    private OperateTemplateMapper operateTemplateMapper;
    @Autowired
    private RedisBaseApi redisBaseApi;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private TrainingUserViewTimeMapper viewTimeMapper;
    @Autowired
    private AppTrainingLearnProjectService appTrainingLearnProjectService;

    @RequestMapping(value={"/test"})
    public String test(Integer userPaperId) {
        this.appTrainingLearnProjectService.updateExamTaskStatus(userPaperId);
        return "ok";
    }

    @RequestMapping(value={"/sync"})
    @ResponseBody
    public String sync(Integer enterpriseId) {
        List<TrainingUserViewTimeVo> userViewTimeVos = this.viewTimeMapper.selectTotalTimeByUser(enterpriseId, null, null, null);
        if (!CollectionUtils.isEmpty(userViewTimeVos)) {
            int expireTime = 604800;
            for (int i = 0; i < userViewTimeVos.size(); ++i) {
                TrainingUserViewTimeVo userViewTimeVo = userViewTimeVos.get(i);
                BigDecimal hour = new BigDecimal(userViewTimeVo.getViewTimes()).divide(new BigDecimal(3600), 2, 4);
                String value = i + 1 + "-" + hour.toString();
                this.redisBaseApi.setExpire("trainingRanking-" + userViewTimeVo.getUserId(), value, Integer.valueOf(expireTime));
            }
        }
        return "ok";
    }
}

