/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.zother;

import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.TrainingService;
import com.ovopark.training.vo.TrainingDeptAnalysisVo;
import com.ovopark.training.vo.TrainingLearnerAnalysisVo;
import com.ovopark.training.vo.TrainingLearnerDetailVo;
import com.ovopark.training.vo.TrainingLearnerMaterialDetailVo;
import com.ovopark.training.vo.TrainingLearnerPaperDetailVo;
import com.ovopark.training.vo.TrainingSummaryVo;
import com.ovopark.utils.DateUtils;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/training/analysis"})
public class TrainingAnalysisController {
    private static final Logger log = LoggerFactory.getLogger(TrainingAnalysisController.class);
    @Resource
    private TrainingService trainingService;

    @RequestMapping(value={"/getSummaryById"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String getSummaryById(@RequestParam Integer trainingId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            TrainingSummaryVo vo = this.trainingService.getSummaryById(user, trainingId);
            return JsonResult.successMapNullValue((Object)vo);
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/getLearnerSummary"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String getLearnerSummary(@RequestParam Integer trainingId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            Map<String, Object> summary = this.trainingService.getLearnerSummary(user, trainingId);
            return JsonResult.successMapNullValue(summary);
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/getLearnerPage"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String getLearnerPage(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, @RequestParam(required=false) Integer status, @RequestParam Integer trainingId, @RequestParam(required=false) String organizeIds, @RequestParam(required=false) String depIds, @RequestParam(required=false) String nameOrNumber) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            Page<TrainingLearnerAnalysisVo> page = this.trainingService.getLearnerPage(user.getId(), pageNumber, pageSize, status, trainingId, user.getGroupId(), organizeIds, depIds, nameOrNumber, null);
            return JsonResult.successMapNullValue(page);
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/getLearnerExcel"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getLearnerExcel(HttpServletResponse response, @RequestParam(required=false) Integer status, @RequestParam Integer trainingId, @RequestParam String excelStr, @RequestParam(required=false) String organizeIds, @RequestParam(required=false) String depIds, @RequestParam(required=false) String nameOrNumber) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            this.trainingService.getLearnerExcel(response, user.getId(), status, trainingId, user.getGroupId(), organizeIds, depIds, nameOrNumber, excelStr);
            return JsonResult.success();
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/getLearnerDetail"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String getLearnerDetail(@RequestParam Integer trainingId, @RequestParam Integer userId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        List<TrainingLearnerDetailVo> list = this.trainingService.getLearnerDetail(trainingId, userId, user.getGroupId());
        return JsonResult.success(list);
    }

    @RequestMapping(value={"/getMaterialAnalysis"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String getMaterialAnalysis(@RequestParam Integer trainingId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            List<TrainingLearnerDetailVo> list = this.trainingService.getMaterialAnalysis(user.getId(), trainingId);
            return JsonResult.successMapNullValue(list);
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/getMaterialDetailPage"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String getMaterialDetailPage(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, @RequestParam(required=false) Integer status, @RequestParam Integer trainingId, @RequestParam Integer materialId, @RequestParam(required=false) String nameOrNumber) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            Page<TrainingLearnerMaterialDetailVo> page = this.trainingService.getMaterialDetailPage(user.getId(), pageNumber, pageSize, status, trainingId, materialId, nameOrNumber, user.getGroupId());
            return JsonResult.successMapNullValue(page);
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/getMaterialDetailExcel"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getMaterialDetailExcel(HttpServletResponse response, @RequestParam(required=false) Integer status, @RequestParam Integer trainingId, @RequestParam Integer materialId, @RequestParam(required=false) String nameOrNumber, @RequestParam(required=false) String excelStr) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            this.trainingService.getMaterialDetailExcel(response, user.getId(), status, trainingId, user.getGroupId(), materialId, nameOrNumber, excelStr);
            return JsonResult.success();
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/getPaperDetailPage"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String getPaperDetailPage(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, @RequestParam(required=false) Integer status, @RequestParam Integer trainingId, @RequestParam Integer paperId, @RequestParam(required=false) String nameOrNumber) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            Page<TrainingLearnerPaperDetailVo> page = this.trainingService.getPaperDetailPage(user.getId(), pageNumber, pageSize, status, trainingId, paperId, nameOrNumber, user.getGroupId());
            return JsonResult.successMapNullValue(page);
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/getPaperDetailExcel"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getPaperDetailExcel(HttpServletResponse response, @RequestParam(required=false) Integer status, @RequestParam Integer trainingId, @RequestParam Integer paperId, @RequestParam(required=false) String nameOrNumber, @RequestParam(required=false) String excelStr, @RequestParam(required=false) Integer exportStatus) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            this.trainingService.getPaperDetailExcel(response, user.getId(), status, user.getGroupId(), trainingId, paperId, nameOrNumber, excelStr, exportStatus);
            return JsonResult.success();
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/getWeekExecl"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getWeekExecl(HttpServletResponse response, String startDate, String endDate) {
        Date start = DateUtils.getStartTimeOfDay((Date)DateUtils.parse((String)startDate, (String)"yyyy-MM-dd"));
        Date end = DateUtils.getEndTimeOfDay((Date)DateUtils.parse((String)endDate, (String)"yyyy-MM-dd"));
        this.trainingService.getWeekExecl(response, start, end);
        return JsonResult.success();
    }

    @RequestMapping(value={"/getDeptAnalysisPage"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getDeptAnalysisPage(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, Integer trainingId, Integer enterpriseId, Integer organizeLevel, Integer parentId, String organizeIds) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (enterpriseId == null) {
            enterpriseId = user.getGroupId();
        }
        if (organizeLevel == null) {
            organizeLevel = 1;
        }
        Page<TrainingDeptAnalysisVo> page = this.trainingService.getDeptAnalysisPage(pageNumber, pageSize, trainingId, enterpriseId, user.getId(), parentId, organizeLevel, organizeIds);
        return JsonResult.successMapNullValue(page);
    }

    @RequestMapping(value={"/getDeptAnalysisExcel"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getDeptAnalysisExcel(HttpServletResponse response, Integer trainingId, Integer enterpriseId, Integer organizeLevel, Integer parentId, String organizeIds) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (enterpriseId == null) {
            enterpriseId = user.getGroupId();
        }
        if (organizeLevel == null) {
            organizeLevel = 1;
        }
        this.trainingService.getDeptAnalysisExcel(response, trainingId, enterpriseId, user.getId(), parentId, organizeLevel, organizeIds);
        return JsonResult.success();
    }

    @RequestMapping(value={"/computeStudyStatus"})
    @ResponseBody
    public String computeStudyStatus() {
        this.trainingService.computeStudyStatus();
        return JsonResult.success();
    }
}

