/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.zother;

import com.ovopark.cloud.log.model.LogPojo;
import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.TrainingCertificate;
import com.ovopark.training.model.TrainingCertificateDetail;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.TrainingCertificateService;
import com.ovopark.training.util.CommonUtil;
import com.ovopark.training.vo.TrainingCertificateDetailVo;
import com.ovopark.training.vo.TrainingCertificateVo;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Font;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/training/certificate"})
public class TrainingCertificateController {
    private static final Logger log = LoggerFactory.getLogger(TrainingCertificateController.class);
    @Autowired
    private TrainingCertificateService certificateService;
    @Autowired
    private MessageSource messageSource;

    @RequestMapping(value={"/insertCertificate"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String insertCertificate(@RequestBody TrainingCertificateVo certificate) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                if (certificate == null) {
                    return "EMPTY_COMMENTER";
                }
            } else {
                return "INVALID_TOKEN";
            }
            certificate.setCreater(user.getId());
            certificate.setCreateTime(new Date());
            certificate.setEnterpriseId(user.getGroupId());
            this.certificateService.insertCertificate(certificate);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success();
    }

    @RequestMapping(value={"/updateCertificate"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String updateCertificate(@RequestBody TrainingCertificateVo certificate) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                if (certificate == null) {
                    return "EMPTY_COMMENTER";
                }
            } else {
                return "INVALID_TOKEN";
            }
            this.certificateService.updateCertificate(certificate);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success();
    }

    @RequestMapping(value={"/deleteCertificate"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String deleteCertificate(HttpServletRequest req, Integer id) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                LogPojo pojo = new LogPojo();
                pojo.setUserId(user.getId());
                pojo.setOperation("certificate_delete");
                pojo.setCreateTime(new Date());
                pojo.setRemoteIp(req.getRemoteAddr());
                pojo.setEnterpriseId(user.getGroupId());
                pojo.setUserName(user.getUserName());
                pojo.setI18nKey("operation.certificate_delete.description");
                pojo.setPlatform(CommonUtil.getTerminalByToken(req));
                return this.certificateService.deleteCertificate(id, pojo);
            }
            return "INVALID_TOKEN";
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
    }

    @RequestMapping(value={"/selectCertificateByPage"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectCertificateByPage(Page<TrainingCertificateVo> page, TrainingCertificate certificate) {
        Users user = Authenticator.getInstance().getCurrentUser();
        certificate.setEnterpriseId(user.getGroupId());
        return JsonResult.success(this.certificateService.selectCertificateByPage(page, certificate));
    }

    @RequestMapping(value={"/getCertificateDetailByPage"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getCertificateDetailByPage(Page<TrainingCertificateDetailVo> page, String userId, String userName, Integer status, Integer certificateId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        List<Integer> userIds = null;
        if (userId != null) {
            String[] str = userId.split(",");
            List<String> s = Arrays.asList(str);
            userIds = s.stream().map(Integer::parseInt).collect(Collectors.toList());
        }
        Map map = this.certificateService.selectDetailNum(certificateId);
        map.put("list", this.certificateService.getCertificateDetailByPage(page, user.getGroupId(), userIds, userName, status, certificateId));
        return JsonResult.success((Object)map);
    }

    @RequestMapping(value={"/getCertificateDetailByExecl"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getCertificateDetailByExecl(HttpServletResponse response, String userId, String userName, Integer status, Integer certificateId) throws IOException {
        Users user = Authenticator.getInstance().getCurrentUser();
        Page<TrainingCertificateDetailVo> page = new Page<TrainingCertificateDetailVo>();
        page.setPageSize(9999);
        page.setPageNumber(1);
        List userIds = null;
        if (userId != null) {
            String[] str = userId.split(",");
            List<String> s = Arrays.asList(str);
            userIds = s.stream().map(Integer::parseInt).collect(Collectors.toList());
        }
        page = this.certificateService.getCertificateDetailByPage(page, user.getGroupId(), userIds, userName, status, certificateId);
        List list = page.getContent();
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        String employeeNumber = this.messageSource.getMessage("training.user.details.employeeNumber", null, locale);
        String department = this.messageSource.getMessage("training.course.analysis.department", null, locale);
        String statusNames = this.messageSource.getMessage("training.paper.status", null, locale);
        String jobName = this.messageSource.getMessage("training.job.job.name", null, locale);
        String learnName = this.messageSource.getMessage("training.learn.title", null, locale);
        String courseName = this.messageSource.getMessage("training.job.course.name", null, locale);
        String trainName = this.messageSource.getMessage("training.job.train.name", null, locale);
        HSSFWorkbook wb = new HSSFWorkbook();
        String details = this.messageSource.getMessage("training.certificate.detail", null, locale);
        HSSFSheet sheet = wb.createSheet(details);
        HSSFCellStyle titleSty = wb.createCellStyle();
        HSSFFont font = wb.createFont();
        font.setFontHeightInPoints((short)16);
        titleSty.setFont((Font)font);
        HSSFRow row = sheet.createRow(0);
        String holder = this.messageSource.getMessage("training.certificate.holder", null, locale);
        row.createCell(0).setCellValue(holder);
        row.createCell(1).setCellValue(employeeNumber);
        row.createCell(2).setCellValue(department);
        String number = this.messageSource.getMessage("training.certificate.number", null, locale);
        row.createCell(3).setCellValue(number);
        row.createCell(4).setCellValue(this.messageSource.getMessage("training.shift.orgin", null, locale));
        row.createCell(5).setCellValue(this.messageSource.getMessage("training.task.name", null, locale));
        String issuer = this.messageSource.getMessage("training.certificate.issuer", null, locale);
        row.createCell(6).setCellValue(issuer);
        String issueTime = this.messageSource.getMessage("training.certificate.issue.time", null, locale);
        row.createCell(7).setCellValue(issueTime);
        String certValidity = this.messageSource.getMessage("training.certificate.validity", null, locale);
        row.createCell(8).setCellValue(certValidity);
        row.createCell(9).setCellValue(statusNames);
        SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd");
        for (int i = 0; i < list.size(); ++i) {
            row = sheet.createRow(i + 1);
            TrainingCertificateDetailVo vo = (TrainingCertificateDetailVo)list.get(i);
            row.createCell(0).setCellValue(vo.getUserName());
            row.createCell(1).setCellValue(vo.getEmployeeNumber());
            row.createCell(2).setCellValue(vo.getOrganizeName());
            row.createCell(3).setCellValue(vo.getCertificateNumber());
            String originName = "";
            if (vo.getOrigin() == 1) {
                String auto;
                originName = auto = this.messageSource.getMessage("training.certificate.auto", null, locale);
            } else if (vo.getOrigin() == 2) {
                originName = "\u624b\u52a8";
            } else if (vo.getOrigin() == 3) {
                originName = learnName;
            } else if (vo.getOrigin() == 4) {
                originName = jobName;
            } else if (vo.getOrigin() == 5) {
                originName = courseName;
            } else if (vo.getOrigin() == 6) {
                originName = trainName;
            }
            row.createCell(4).setCellValue(originName);
            row.createCell(5).setCellValue(vo.getTaskName());
            row.createCell(6).setCellValue(vo.getCreateName());
            row.createCell(7).setCellValue(format.format(vo.getCreateTime()));
            String validity = "";
            if (vo.getIsAlways() == 1) {
                String perpetual;
                validity = perpetual = this.messageSource.getMessage("training.certificate.perpetual", null, locale);
            } else {
                Calendar cal = Calendar.getInstance();
                cal.setTime(vo.getCreateTime());
                cal.add(2, vo.getValidity());
                validity = format.format(cal.getTime());
            }
            row.createCell(8).setCellValue(validity);
            String statusName = "";
            if (vo.getStatus() == 1) {
                String effective;
                statusName = effective = this.messageSource.getMessage("training.certificate.effective", null, locale);
            } else if (vo.getStatus() == 2) {
                String expired;
                statusName = expired = this.messageSource.getMessage("training.certificate.expired", null, locale);
            } else if (vo.getStatus() == 3) {
                String recovered;
                statusName = recovered = this.messageSource.getMessage("training.certificate.recovered", null, locale);
            }
            row.createCell(9).setCellValue(statusName);
        }
        response.setContentType("application/vnd.ms-excel; charset=utf-8");
        String detail = this.messageSource.getMessage("training.certificate.detail", null, locale);
        response.setHeader("Content-Disposition", "attachment; filename=" + detail + ".xls");
        ServletOutputStream out = response.getOutputStream();
        wb.write((OutputStream)out);
        out.flush();
        out.close();
        wb.close();
        return JsonResult.success();
    }

    @RequestMapping(value={"/insertCertificateDetail"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String insertCertificateDetail(@RequestBody List<TrainingCertificateDetailVo> certificateDetail) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                if (certificateDetail == null || certificateDetail.size() <= 0) {
                    return "EMPTY_COMMENTER";
                }
            } else {
                return "INVALID_TOKEN";
            }
            this.certificateService.insertCertificateDetail(certificateDetail, user);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success();
    }

    @RequestMapping(value={"/updateCertificateDetail"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String updateCertificateDetail(@RequestBody List<TrainingCertificateDetailVo> certificateDetail) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                if (certificateDetail == null || certificateDetail.size() <= 0) {
                    return "EMPTY_COMMENTER";
                }
            } else {
                return "INVALID_TOKEN";
            }
            this.certificateService.updateCertificateDetail(certificateDetail);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success();
    }

    @RequestMapping(value={"/updateDetailBack"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String updateDetailBack(@RequestBody TrainingCertificateDetailVo certificateDetail) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            this.certificateService.updateDetailBack(certificateDetail);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success();
    }

    @RequestMapping(value={"/updateDetailReissue"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String updateDetailReissue(@RequestBody TrainingCertificateDetailVo certificateDetail) {
        Users user = Authenticator.getInstance().getCurrentUser();
        try {
            this.certificateService.updateDetailReissue(certificateDetail);
            return JsonResult.success();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
    }

    @RequestMapping(value={"/selectMyAppCertificateByPage"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectMyAppCertificateByPage(Page<TrainingCertificateDetailVo> page) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                return JsonResult.success(this.certificateService.selectMyAppCertificateByPage(page, user));
            }
            return "INVALID_TOKEN";
        }
        catch (Exception e) {
            log.info("selectMyAppCertificateByPage: " + e);
            return JsonResult.error();
        }
    }

    @RequestMapping(value={"/updateAppDetailShow"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String updateAppDetailShow(@RequestBody TrainingCertificateDetail certificateDetail) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            this.certificateService.updateAppDetailShow(certificateDetail);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success();
    }
}

