/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.zother;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.common.model.mo.EnterpriseGroupMo;
import com.ovopark.organize.common.model.mo.UsersAndOrgsMo;
import com.ovopark.organize.common.model.pojo.DepartmentPojo;
import com.ovopark.organize.sdk.api.EnterpriseGroupsApi;
import com.ovopark.organize.sdk.api.UserDepPrivilegeApi;
import com.ovopark.organize.sdk.api.UserOrganizeApi;
import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.StudyEvent;
import com.ovopark.training.model.TrainingPaper;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.TrainingPaperRemoteService;
import com.ovopark.training.service.TrainingRemoteService;
import com.ovopark.training.service.TrainingService;
import com.ovopark.training.service.UserRemoteService;
import com.ovopark.training.util.ImageUtil;
import com.ovopark.training.vo.TheirPapersVo;
import com.ovopark.training.vo.TrainingAddVo;
import com.ovopark.training.vo.TrainingPaperVo;
import com.ovopark.training.vo.TrainingsVo;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/training/open"})
public class TrainingConfigOpenController {
    private static final Logger log = LoggerFactory.getLogger(TrainingConfigOpenController.class);
    @Autowired
    private TrainingRemoteService trainingRemoteService;
    @Autowired
    private TrainingPaperRemoteService trainingPaperRemoteService;
    @Autowired
    private UserRemoteService userRemoteService;
    @Autowired
    private TrainingService trainingService;
    @Autowired
    private KafkaTemplate<String, String> kafkaTemplate;
    @Autowired
    private EnterpriseGroupsApi enterpriseGroupsApi;
    @Autowired
    private UserOrganizeApi userOrganizeApi;
    @Autowired
    private MessageSource messageSource;
    @Value(value="${ovopark.sso.server.url}")
    private String ssoServerUrl;
    @Value(value="${kafkaTrainingTopic}")
    private String kafkaTrainingTopic;
    private static final int share_2 = 2;
    @Autowired
    private UserDepPrivilegeApi userDepPrivilegeApi;

    @RequestMapping(value={"/getTrainingByIdOpen"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getTrainingByIdOpen(Integer id) {
        if (id == null) {
            return JsonResult.paramError();
        }
        Users user = Authenticator.getInstance().getCurrentUser();
        TrainingAddVo training = this.trainingRemoteService.getTraining(id);
        if (training != null && training.getIsShare() != null && training.getIsShare() == 2 && user == null) {
            return "INVALID_TOKEN";
        }
        if (training != null && !StringUtils.isEmpty((Object)training.getPath())) {
            String path = training.getPath();
            training.setPath(ImageUtil.makePicUrl(path));
        }
        return JsonResult.success((Object)training);
    }

    @RequestMapping(value={"/getTrainingById"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getTrainingById(Integer id) {
        if (id == null) {
            return JsonResult.paramError();
        }
        Users user = Authenticator.getInstance().getCurrentUser();
        boolean hasLogin = user != null;
        TrainingAddVo training = this.trainingRemoteService.getTraining(id);
        if (training == null) {
            return JsonResult.paramError();
        }
        if (training.getIsShare() != null && training.getIsShare() == 2 && !hasLogin) {
            return "INVALID_TOKEN";
        }
        if (!StringUtils.isEmpty((Object)training.getPath())) {
            String path = training.getPath();
            training.setPath(ImageUtil.makePicUrl(path));
        }
        return JsonResult.success((Object)training);
    }

    @RequestMapping(value={"/getMobileQuestionListByPaperIdOpen"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getMobileQuestionListByPaperIdOpen(Integer paperId, Integer type, String loginShowName, String loginDepName, String loginEmployeeNumber) {
        return JsonResult.success((Object)this.trainingPaperRemoteService.getMobileQuestionListByPaperId(paperId, null, null, loginShowName, loginDepName, loginEmployeeNumber));
    }

    @RequestMapping(value={"/saveStartTimeByPaperId"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String saveStartTimeByPaperId(Integer userPaperId) {
        if (userPaperId == null) {
            return JsonResult.paramError();
        }
        this.trainingPaperRemoteService.saveStartTimeByPaperId(userPaperId);
        return JsonResult.success();
    }

    @RequestMapping(value={"/theirAllQuestionsOpen"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String theirAllQuestionsOpen(String jsonStr, Integer type) {
        try {
            List paper = JSONObject.parseArray((String)jsonStr, TrainingPaperVo.class);
            if (!CollectionUtils.isEmpty((Collection)paper)) {
                TrainingPaperVo trainingPaperVo = (TrainingPaperVo)paper.get(0);
                if (trainingPaperVo != null && trainingPaperVo.getExamId() != null && trainingPaperVo.getExamId() != 0) {
                    this.trainingPaperRemoteService.theirAllQuestionNew(paper, null);
                } else {
                    this.trainingPaperRemoteService.theirAllQuestion(paper, null);
                }
                TheirPapersVo result = this.trainingPaperRemoteService.theirPapers((TrainingPaperVo)paper.get(0), null);
                this.sendStudyEvent((TrainingPaperVo)paper.get(0));
                return JsonResult.success((Object)result);
            }
            return JsonResult.error((String)("json = " + jsonStr), (Object)"paper is null");
        }
        catch (Exception e) {
            log.error("theirAllQuestions", (Object)e.getMessage());
            return JsonResult.error((String)("json = " + jsonStr), (Object)e.getMessage());
        }
    }

    public void sendStudyEvent(TrainingPaperVo paper) {
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        StudyEvent event = new StudyEvent();
        event.setDate(new Date());
        Integer userId = paper.getUserId();
        Integer groupId = paper.getEnterpriseId();
        event.setShop(this.findShopNameByUserId(userId, groupId));
        String taskStudy = this.messageSource.getMessage("training.job.course.task.study", null, locale);
        event.setEvent(taskStudy);
        BaseResult baseResult = this.enterpriseGroupsApi.getEnterpriseByGroupIdApi(groupId);
        if (!baseResult.getIsError().booleanValue() && Objects.nonNull(baseResult.getData())) {
            event.setCompanyName(((EnterpriseGroupMo)baseResult.getData()).getName());
        } else {
            event.setCompanyName("");
        }
        BaseResult baseResult2 = this.userDepPrivilegeApi.getPrivilegeDepBeanByUserIdAndGroupId(userId, groupId, Boolean.valueOf(true));
        if (!baseResult2.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)baseResult2.getData()))) {
            event.setLatitude(((DepartmentPojo)((List)baseResult2.getData()).get(0)).getLatitude());
            event.setLongitude(((DepartmentPojo)((List)baseResult2.getData()).get(0)).getLongitude());
            event.setAddress(((DepartmentPojo)((List)baseResult2.getData()).get(0)).getAddress());
        }
        if (!StringUtils.isEmpty((Object)event.getShop())) {
            this.kafkaTemplate.send(this.kafkaTrainingTopic, (Object)JSON.toJSONString((Object)event));
        }
    }

    private String findShopNameByUserId(Integer userId, Integer groupId) {
        Map shopMap = new HashMap();
        UsersAndOrgsMo mo = new UsersAndOrgsMo();
        mo.setGroupId(groupId);
        mo.setUserIdList(Collections.singletonList(userId));
        mo.setShowDepartment(Boolean.valueOf(true));
        BaseResult base = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
        if (base != null && !ObjectUtils.isEmpty((Object)base.getData())) {
            shopMap = (Map)base.getData();
        }
        List pojoList = (List)shopMap.get(userId);
        String shopName = "";
        if (!CollectionUtils.isEmpty((Collection)pojoList)) {
            pojoList = pojoList.stream().distinct().collect(Collectors.toList());
            shopName = (String)pojoList.get(0);
        }
        return shopName;
    }

    @RequestMapping(value={"/getUserPaperIsLevelOpen"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getUserPaperIsLevelOpen(Integer paperId) {
        Integer isLevel = 0;
        TrainingPaper trainingPaper = this.trainingPaperRemoteService.getTrainingPaper(paperId);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if (!ObjectUtils.isEmpty((Object)trainingPaper)) {
            map.put("isDel", 0);
        } else {
            map.put("isDel", 1);
        }
        if (!ObjectUtils.isEmpty((Object)trainingPaper) && trainingPaper.getLookLevel() != null && trainingPaper.getLookLevel().equals(1)) {
            isLevel = 1;
        }
        if (!(ObjectUtils.isEmpty((Object)trainingPaper) || trainingPaper.getStartTime() == null || trainingPaper.getStartTime() == null || new Date().getTime() >= trainingPaper.getStartTime().getTime() && new Date().getTime() <= trainingPaper.getEndTime().getTime())) {
            map.put("isOverdue", 1);
        } else {
            map.put("isOverdue", 0);
        }
        map.put("isLevel", isLevel);
        if (!ObjectUtils.isEmpty((Object)trainingPaper) && trainingPaper.getRepetitionNum() != null) {
            map.put("repetitionNum", trainingPaper.getRepetitionNum());
        } else {
            map.put("repetitionNum", 1);
        }
        return JsonResult.success(map);
    }

    @RequestMapping(value={"/getAllErrorQuestionListsByIdOpen"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getAllErrorQuestionListsByIdOpen(Integer userPaperId, Integer status) {
        if (userPaperId == null) {
            return JsonResult.paramError();
        }
        return JsonResult.success(this.trainingPaperRemoteService.getErrorQuestionListById(userPaperId, status));
    }

    @RequestMapping(value={"/getAllErrorQuestionListByPaperIdOpen"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getAllErrorQuestionListByPaperIdOpen(Integer paperId, Integer status, Integer userPaperId, Integer type) {
        Integer userId = null;
        if (type != null && type == 1) {
            userId = null;
        } else {
            userPaperId = null;
        }
        return JsonResult.success(this.trainingPaperRemoteService.getAllErrorQuestionListsById(userId, paperId, status, userPaperId));
    }

    @RequestMapping(value={"/selectTrainingContentOpen"})
    @ResponseBody
    public String selectTrainingContentOpen(@RequestBody TrainingsVo trainingVo) {
        TrainingsVo vo = this.trainingService.selectTrainingContentOpen(trainingVo);
        return JsonResult.success((Object)vo);
    }
}

