/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.zother;

import com.ovopark.cloud.log.model.LogPojo;
import com.ovopark.organize.common.model.mo.UsersAndOrgsMo;
import com.ovopark.organize.sdk.api.UserOrganizeApi;
import com.ovopark.privilege.api.RoleApi;
import com.ovopark.privilege.pojo.RolePojo;
import com.ovopark.privilege.response.BaseResult;
import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.mapper.TrainingCourseMapper;
import com.ovopark.training.mapper.TrainingCourseStageTaskMapper;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.TrainingCourse;
import com.ovopark.training.model.TrainingCourseConfig;
import com.ovopark.training.model.TrainingCourseStage;
import com.ovopark.training.model.TrainingCourseStageTask;
import com.ovopark.training.model.TrainingCourseUserTask;
import com.ovopark.training.model.TrainingReviewHeadConfig;
import com.ovopark.training.model.Users;
import com.ovopark.training.param.material.MaterialTypeQueryParam;
import com.ovopark.training.service.TrainingCourseConfigService;
import com.ovopark.training.service.TrainingCourseExportService;
import com.ovopark.training.service.TrainingCourseService;
import com.ovopark.training.service.TrainingReviewConfigService;
import com.ovopark.training.service.TrainingService;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.service.materialtype.MaterialTypeService;
import com.ovopark.training.util.CommonUtil;
import com.ovopark.training.util.ContextUtil;
import com.ovopark.training.util.DateUtils;
import com.ovopark.training.vo.CourseAnalyseSearchVo;
import com.ovopark.training.vo.CoursePushUserVo;
import com.ovopark.training.vo.TrainingCollectionVo;
import com.ovopark.training.vo.TrainingCourseConfigVo;
import com.ovopark.training.vo.TrainingCoursePushVo;
import com.ovopark.training.vo.TrainingCourseStageTaskVo;
import com.ovopark.training.vo.TrainingCourseStageVo;
import com.ovopark.training.vo.TrainingCourseUserTaskVo;
import com.ovopark.training.vo.TrainingCourseVo;
import com.ovopark.training.vo.TrainingMaterialTypeVo;
import com.ovopark.training.vo.TrainingPapersVo;
import com.ovopark.training.vo.TrainingUserViewTimeVo;
import com.ovopark.training.vo.TrainingsVo;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/training/course"})
public class TrainingCourseController {
    private static final Logger log = LoggerFactory.getLogger(TrainingCourseController.class);
    @Autowired
    private TrainingCourseService courseService;
    @Autowired
    private RoleApi roleApi;
    @Autowired
    private UserOrganizeApi userOrganizeApi;
    @Autowired
    private TrainingService trainingService;
    @Autowired
    private TrainingCourseMapper courseMapper;
    @Autowired
    private TrainingCourseStageTaskMapper trainingCourseStageTaskMapper;
    @Autowired
    private UserUtilService userUtilService;
    @Autowired
    private TrainingCourseConfigService trainingCourseConfigService;
    @Autowired
    private TrainingReviewConfigService trainingReviewConfigService;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private TrainingCourseExportService trainingCourseExportService;
    @Autowired
    private MaterialTypeService materialTypeService;

    @RequestMapping(value={"/selectNewTrainingContent"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectNewTrainingContent(@RequestBody TrainingsVo trainingVo) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                return JsonResult.success((Object)this.trainingService.selectNewTrainingContent(trainingVo, user));
            }
            return "INVALID_TOKEN";
        }
        catch (Exception e) {
            log.info("selectNewTrainingContent: " + e);
            return JsonResult.error();
        }
    }

    @RequestMapping(value={"/saveNewTraining"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String saveNewTraining(@RequestBody TrainingsVo training) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            if (training.getCustomizedPush() != null && training.getCustomizedPush() == 1 && (org.springframework.util.StringUtils.isEmpty((Object)training.getPushTitle()) || org.springframework.util.StringUtils.isEmpty((Object)training.getPushMessage()))) {
                return JsonResult.success((Object)"PUSH_CONTENT_EMPTY");
            }
            if (this.trainingService.cheackSameTrainingName(training, user).booleanValue()) {
                return JsonResult.success((Object)this.trainingService.saveNewTraining(training, user));
            }
            return JsonResult.success((Object)"TRAINING_NAME_EXISTING");
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/saveChapterAttachSort"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String saveChapterAttachSort(@RequestBody TrainingsVo training) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                this.trainingService.saveChapterAttachSort(training, user);
                return JsonResult.success();
            }
            return "INVALID_TOKEN";
        }
        catch (Exception e) {
            log.info("saveChapterAttachSort: " + e);
            return JsonResult.error();
        }
    }

    @RequestMapping(value={"/selectNewTrainingByPage"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectNewTrainingByPage(Page<TrainingsVo> page, String title, Integer sourceType, Integer trainingType, Integer status, String userIds, String startTime, String endTime, String startUpdate, String endUpdate, Integer isRecommend, Integer isPaper, Integer newStatus, Integer isShow, Integer isChild, Integer orderByColumn, Integer orderType) {
        Users user = Authenticator.getInstance().getCurrentUser();
        orderByColumn = orderByColumn == null ? 1 : orderByColumn;
        orderType = orderType == null ? 2 : orderType;
        page = this.trainingService.selectNewTrainingByPage(page, user, title, sourceType, trainingType, status, userIds, startTime, endTime, startUpdate, endUpdate, isRecommend, isPaper, newStatus, isShow, isChild, orderByColumn, orderType);
        return JsonResult.success(page);
    }

    @RequestMapping(value={"/selectAppTrainingType"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectAppTrainingType() {
        Users user = ContextUtil.getUser();
        MaterialTypeQueryParam param = new MaterialTypeQueryParam();
        param.setMaterialTypeName("");
        param.setModuleType(Integer.valueOf(1));
        int permissionType = 1;
        List<TrainingMaterialTypeVo> list = this.materialTypeService.selectAllMaterialTypeByPermissionType(param, user, permissionType);
        return JsonResult.success(list);
    }

    @RequestMapping(value={"/selectAppNewTrainingByPage"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectAppNewTrainingByPage(Page<TrainingsVo> page, String title, Integer trainingType, Integer isRecommend, Integer orderBy) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user == null || user.getId() == null) {
            return "INVALID_TOKEN";
        }
        page = this.trainingService.selectAppNewTrainingByPage(page, user, title, trainingType, isRecommend, orderBy);
        return JsonResult.success(page);
    }

    @RequestMapping(value={"/saveTrainingCollection"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String saveTrainingCollection(@RequestBody TrainingCollectionVo trainingCollectionVo) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                this.trainingService.saveTrainingCollection(trainingCollectionVo, user);
                return JsonResult.success();
            }
            return "INVALID_TOKEN";
        }
        catch (Exception e) {
            log.error("saveTrainingCollection: " + e);
            return JsonResult.error();
        }
    }

    @RequestMapping(value={"/saveTrainingStars"})
    @ResponseBody
    public String saveTrainingStars(@RequestBody TrainingCollectionVo trainingCollectionVo) {
        try {
            Users users = Authenticator.getInstance().getCurrentUser();
            if (users != null && users.getId() != null) {
                this.trainingService.saveTrainingStars(trainingCollectionVo, users);
                return JsonResult.success();
            }
            return "INVALID_TOKEN";
        }
        catch (Exception e) {
            log.error("saveTrainingStars:" + e.getMessage());
            return JsonResult.error();
        }
    }

    @RequestMapping(value={"/selectTrainingCollection"})
    @ResponseBody
    public String selectTrainingCollection(@RequestBody TrainingsVo trainingVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        TrainingsVo vo = this.trainingService.selectTrainingCollection(trainingVo, user);
        return JsonResult.success((Object)vo);
    }

    @RequestMapping(value={"/selectTrainingContent"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectTrainingContent(@RequestBody TrainingsVo trainingVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        TrainingsVo vo = this.trainingService.selectTrainingContent(trainingVo, user);
        return JsonResult.success((Object)vo);
    }

    @RequestMapping(value={"/addRecommend"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String addRecommend(@RequestBody TrainingsVo training) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                Integer num = this.trainingService.addRecommend(training, user);
                if (num == 1) {
                    return JsonResult.success();
                }
                Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
                return JsonResult.success((Object)this.messageSource.getMessage("training.training.push.max", null, locale));
            }
            return "INVALID_TOKEN";
        }
        catch (Exception e) {
            log.error("addRecommend: " + e);
            return JsonResult.error();
        }
    }

    @RequestMapping(value={"/deleteRecommend"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String deleteRecommend(@RequestBody TrainingsVo training) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                this.trainingService.deleteRecommend(training, user);
                return JsonResult.success();
            }
            return "INVALID_TOKEN";
        }
        catch (Exception e) {
            log.error("deleteRecommend: " + e);
            return JsonResult.error();
        }
    }

    @RequestMapping(value={"/selectUsingTraining"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectUsingTraining(@RequestBody List<TrainingsVo> trainingVoList) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                List<TrainingsVo> usingList = this.trainingService.selectUsingTraining(trainingVoList, user);
                return JsonResult.success(usingList);
            }
            return "INVALID_TOKEN";
        }
        catch (Exception e) {
            log.error("selectUsingTraining: " + e);
            return JsonResult.error();
        }
    }

    @RequestMapping(value={"/updateTrainingList"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String updateTrainingList(HttpServletRequest req, @RequestBody List<TrainingsVo> trainingVoList) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                if (!CollectionUtils.isEmpty(trainingVoList) && !org.springframework.util.StringUtils.isEmpty((Object)trainingVoList.get(0).getUpdateType())) {
                    LogPojo pojo = new LogPojo();
                    pojo.setUserId(user.getId());
                    pojo.setOperation("course_delete");
                    pojo.setCreateTime(new Date());
                    pojo.setRemoteIp(req.getRemoteAddr());
                    pojo.setEnterpriseId(user.getGroupId());
                    pojo.setUserName(user.getUserName());
                    pojo.setI18nKey("operation.course_delete.description");
                    pojo.setPlatform(CommonUtil.getTerminalByToken(req));
                    return this.trainingService.updateTrainingList(trainingVoList, user, pojo);
                }
                return "INVALID_PARAMETER";
            }
            return "INVALID_TOKEN";
        }
        catch (Exception e) {
            log.error("saveNewTraining: " + e);
            return JsonResult.error();
        }
    }

    @RequestMapping(value={"/selectTrainingCourse"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectTrainingCourse(@RequestBody TrainingCourseVo trainingCourseVo) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                return JsonResult.success((Object)this.courseService.selectTrainingCourse(trainingCourseVo, user));
            }
            return "INVALID_TOKEN";
        }
        catch (Exception e) {
            log.error("selectTrainingCourse: " + e);
            return JsonResult.error();
        }
    }

    @RequestMapping(value={"/saveTrainingCourse"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String saveTrainingCourse(@RequestBody TrainingCourseVo trainingCourseVo) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                return JsonResult.success((Object)this.courseService.saveTrainingCourse(trainingCourseVo, user));
            }
            return "INVALID_TOKEN";
        }
        catch (Exception e) {
            log.error("saveTrainingCourse: " + e);
            return JsonResult.error();
        }
    }

    @RequestMapping(value={"/saveCopyTrainingCourse"})
    @ResponseBody
    public String saveCopyTrainingCourse(@RequestBody TrainingCourseVo trainingCourseVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            return JsonResult.success((Object)this.courseService.saveCopyTrainingCourse(trainingCourseVo, user));
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/updateTrainingCourse"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String updateTrainingCourse(@RequestBody TrainingCourseVo trainingCourseVo) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                this.courseService.updateTrainingCourse(trainingCourseVo, user);
                return JsonResult.success();
            }
            return "INVALID_TOKEN";
        }
        catch (Exception e) {
            log.error("updateTrainingCourse: " + e);
            return JsonResult.error();
        }
    }

    @RequestMapping(value={"/deleteCourse"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String deleteCourse(HttpServletRequest req, @RequestBody TrainingCourseVo trainingCourseVo) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                LogPojo pojo = new LogPojo();
                pojo.setUserId(user.getId());
                pojo.setOperation("learning_delete");
                pojo.setCreateTime(new Date());
                pojo.setRemoteIp(req.getRemoteAddr());
                pojo.setEnterpriseId(user.getGroupId());
                pojo.setUserName(user.getUserName());
                pojo.setI18nKey("operation.learning_delete.description");
                pojo.setPlatform(CommonUtil.getTerminalByToken(req));
                return this.courseService.deleteCourse(trainingCourseVo, user, pojo);
            }
            return "INVALID_TOKEN";
        }
        catch (Exception e) {
            log.error("deleteCourse: " + e);
            return JsonResult.error();
        }
    }

    @RequestMapping(value={"/saveTrainingCourseStage"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String saveTrainingCourseStage(@RequestBody TrainingCourseStageVo trainingCourseStageVo) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                return JsonResult.success((Object)this.courseService.saveTrainingCourseStage(trainingCourseStageVo, user));
            }
            return "INVALID_TOKEN";
        }
        catch (Exception e) {
            log.error("saveTrainingCourseStage: " + e);
            return JsonResult.error();
        }
    }

    @RequestMapping(value={"/deleteCourseStage"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String deleteCourseStage(@RequestBody TrainingCourseStageVo trainingCourseStageVo) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                this.courseService.deleteCourseStage(trainingCourseStageVo, user);
                return JsonResult.success();
            }
            return "INVALID_TOKEN";
        }
        catch (Exception e) {
            log.error("deleteCourseStage: " + e);
            return JsonResult.error();
        }
    }

    @RequestMapping(value={"/saveTrainingCourseStageTask"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String saveTrainingCourseStageTask(@RequestBody TrainingCourseStageTaskVo trainingCourseStageTaskVo) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                return JsonResult.success((Object)this.courseService.saveTrainingCourseStageTask(trainingCourseStageTaskVo, user));
            }
            return "INVALID_TOKEN";
        }
        catch (Exception e) {
            log.error("saveTrainingCourseStageTask: " + e);
            return JsonResult.error();
        }
    }

    @RequestMapping(value={"/deleteCourseStageTask"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String deleteCourseStageTask(@RequestBody TrainingCourseStageTaskVo trainingCourseStageTaskVo) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                this.courseService.deleteCourseStageTask(trainingCourseStageTaskVo, user);
                return JsonResult.success();
            }
            return "INVALID_TOKEN";
        }
        catch (Exception e) {
            log.error("deleteCourseStageTask: " + e);
            return JsonResult.error();
        }
    }

    @RequestMapping(value={"/updateStageSort"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String updateStageSort(@RequestBody List<TrainingCourseStage> voList) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                this.courseService.updateStageSort(voList, user);
                return JsonResult.success();
            }
            return "INVALID_TOKEN";
        }
        catch (Exception e) {
            log.error("updateStageSort: " + e);
            return JsonResult.error();
        }
    }

    @RequestMapping(value={"/updateTaskSort"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String updateTaskSort(@RequestBody List<TrainingCourseStageTask> voList) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                this.courseService.updateTaskSort(voList, user);
                return JsonResult.success();
            }
            return "INVALID_TOKEN";
        }
        catch (Exception e) {
            log.error("updateTaskSort: " + e);
            return JsonResult.error();
        }
    }

    @RequestMapping(value={"/updateIsBindingTraining"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String updateIsBindingTraining(@RequestBody TrainingCourseStageTaskVo courseStageTaskVo) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                return JsonResult.success((Object)this.trainingCourseConfigService.updateIsBindingTraining(courseStageTaskVo, user));
            }
            return "INVALID_TOKEN";
        }
        catch (Exception e) {
            log.error("updateIsBindingTraining: " + e);
            return JsonResult.error();
        }
    }

    @RequestMapping(value={"/selectTrainingCourseByPage"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectTrainingCourseByPage(Page<TrainingCourseVo> page, String courseName, Integer status) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                return JsonResult.success(this.courseService.selectTrainingCourseByPage(page, user, courseName, status));
            }
            return "INVALID_TOKEN";
        }
        catch (Exception e) {
            log.error("selectTrainingCourseByPage: " + e);
            return JsonResult.error();
        }
    }

    @RequestMapping(value={"/selectCourseUserStatus"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectCourseUserStatus(@RequestBody TrainingCourseVo courseVo) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                return JsonResult.success((Object)this.courseService.selectCourseUserStatus(courseVo, user));
            }
            return "INVALID_TOKEN";
        }
        catch (Exception e) {
            log.error("selectCourseUserStatus: " + e);
            return JsonResult.error();
        }
    }

    @RequestMapping(value={"/selectCourseOrganizeStatus"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectCourseOrganizeStatus(Integer courseId, Integer organizeId, String organizName) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                return JsonResult.success(this.courseService.selectCourseOrganizeStatus(courseId, organizeId, organizName, user));
            }
            return "INVALID_TOKEN";
        }
        catch (Exception e) {
            log.error("selectCourseOrganizeStatus: " + e);
            return JsonResult.error();
        }
    }

    @RequestMapping(value={"/selectCourseUserAnalysisByPage"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectCourseUserAnalysisByPage(Page<TrainingCourseUserTaskVo> page, Integer courseId, String name, Integer status, String organizeIds, Integer turns, @RequestParam(value="sort", required=false, defaultValue="0") Integer sort, String roles) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            page = this.courseService.selectCourseUserAnalysisByPage(page, courseId, user, name, status, organizeIds, turns, sort, roles);
            return JsonResult.success(page);
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/selectCourseUserAnalysisByExecl"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectCourseUserAnalysisByExecl(HttpServletResponse response, Integer courseId, String name, Integer status, String organizeIds, Integer turns, String excelStr, String roles) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                BaseResult base;
                Page<TrainingCourseUserTaskVo> page = new Page<TrainingCourseUserTaskVo>();
                page.setPageNumber(1);
                page.setPageSize(9999);
                page = this.courseService.selectCourseUserAnalysisByPage(page, courseId, user, name, status, organizeIds, turns, 0, roles);
                List list = page.getContent();
                String[] str = excelStr.split(",");
                List<Integer> userIdList = new ArrayList<Integer>();
                String userStr = "";
                Integer groupId = user.getGroupId();
                if (!CollectionUtils.isEmpty((Collection)list) && !CollectionUtils.isEmpty(userIdList = list.stream().map(TrainingCourseUserTask::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                    userStr = StringUtils.join(userIdList, (String)",");
                }
                Map<Integer, List<String>> organizeMap = this.userUtilService.selectOrganizeMap(userIdList, groupId);
                Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
                String accountNumber = this.messageSource.getMessage("training.job.account.number", null, locale);
                TrainingCourse course = (TrainingCourse)this.courseMapper.selectById(courseId);
                String fileName = MessageFormat.format("{0}_" + this.messageSource.getMessage("training.course.student.analysis", null, locale) + "_{1}.xls", course.getCourseName(), DateUtils.format(new Date(), "yyyyMMdd_HHmmss"));
                fileName = fileName.replace("[", "").replace("]", "").replace("*", "").replace("/", "").replace("?", "").replace("\\", "").replace(":", "").replace("<", "").replace(">", "");
                HSSFWorkbook wb = new HSSFWorkbook();
                HSSFSheet sheet = wb.createSheet(fileName);
                HSSFCellStyle titleSty = wb.createCellStyle();
                titleSty.setWrapText(true);
                HSSFRow row = sheet.createRow(0);
                row.createCell(0).setCellValue("id");
                int currentNum = 0;
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[1]) && str[1].equals("1")) {
                    row.createCell(++currentNum).setCellValue(accountNumber);
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[2]) && str[2].equals("1")) {
                    row.createCell(++currentNum).setCellValue(this.messageSource.getMessage("training.course.analysis.showname", null, locale));
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[3]) && str[3].equals("1")) {
                    String employeeNumber = this.messageSource.getMessage("training.user.details.employeeNumber", null, locale);
                    row.createCell(++currentNum).setCellValue(employeeNumber);
                }
                Map roleMap = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[4]) && str[4].equals("1")) {
                    String role = this.messageSource.getMessage("training.course.analysis.role", null, locale);
                    row.createCell(++currentNum).setCellValue(role);
                    if (!org.springframework.util.StringUtils.isEmpty((Object)userStr)) {
                        HashMap<String, Object> parameter = new HashMap<String, Object>();
                        parameter.put("userIds", userStr);
                        parameter.put("groupId", groupId);
                        base = this.roleApi.getUserRoleList(parameter);
                        if (base != null) {
                            roleMap = (Map)base.getData();
                        }
                    }
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[5]) && str[5].equals("1")) {
                    String leader = this.messageSource.getMessage("training.course.analysis.superior", null, locale);
                    row.createCell(++currentNum).setCellValue(leader);
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[6]) && str[6].equals("1")) {
                    row.createCell(++currentNum).setCellValue(this.messageSource.getMessage("training.learn.department", null, locale));
                }
                Map organMap1 = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[7]) && str[7].equals("1")) {
                    row.createCell(++currentNum).setCellValue(this.messageSource.getMessage("training.course.analysis.first.organize", null, locale));
                    if (!CollectionUtils.isEmpty(userIdList)) {
                        UsersAndOrgsMo mo = new UsersAndOrgsMo();
                        mo.setGroupId(groupId);
                        mo.setLevelList(Arrays.asList(1));
                        mo.setUserIdList(userIdList);
                        mo.setShowDepartment(Boolean.valueOf(false));
                        base = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                        if (base != null) {
                            organMap1 = (Map)base.getData();
                        }
                    }
                }
                Map organMap2 = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[8]) && str[8].equals("1")) {
                    row.createCell(++currentNum).setCellValue(this.messageSource.getMessage("training.course.analysis.second.organize", null, locale));
                    if (!CollectionUtils.isEmpty(userIdList)) {
                        UsersAndOrgsMo mo = new UsersAndOrgsMo();
                        mo.setGroupId(groupId);
                        mo.setLevelList(Arrays.asList(2));
                        mo.setUserIdList(userIdList);
                        mo.setShowDepartment(Boolean.valueOf(false));
                        com.ovopark.organize.common.base.BaseResult base2 = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                        if (base2 != null) {
                            organMap2 = (Map)base2.getData();
                        }
                    }
                }
                Map organMap3 = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[9]) && str[9].equals("1")) {
                    row.createCell(++currentNum).setCellValue(this.messageSource.getMessage("training.course.analysis.third.organize", null, locale));
                    if (!CollectionUtils.isEmpty(userIdList)) {
                        UsersAndOrgsMo mo = new UsersAndOrgsMo();
                        mo.setGroupId(groupId);
                        mo.setLevelList(Arrays.asList(3));
                        mo.setUserIdList(userIdList);
                        mo.setShowDepartment(Boolean.valueOf(false));
                        com.ovopark.organize.common.base.BaseResult base3 = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                        if (base3 != null) {
                            organMap3 = (Map)base3.getData();
                        }
                    }
                }
                Map organMap4 = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[10]) && str[10].equals("1")) {
                    row.createCell(++currentNum).setCellValue(this.messageSource.getMessage("training.course.analysis.fourth.organize", null, locale));
                    if (!CollectionUtils.isEmpty(userIdList)) {
                        UsersAndOrgsMo mo = new UsersAndOrgsMo();
                        mo.setGroupId(groupId);
                        mo.setLevelList(Arrays.asList(4));
                        mo.setUserIdList(userIdList);
                        mo.setShowDepartment(Boolean.valueOf(false));
                        com.ovopark.organize.common.base.BaseResult base4 = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                        if (base4 != null) {
                            organMap4 = (Map)base4.getData();
                        }
                    }
                }
                Map organMap5 = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[11]) && str[11].equals("1")) {
                    row.createCell(++currentNum).setCellValue(this.messageSource.getMessage("training.course.analysis.fifth.organize", null, locale));
                    if (!CollectionUtils.isEmpty(userIdList)) {
                        UsersAndOrgsMo mo = new UsersAndOrgsMo();
                        mo.setGroupId(groupId);
                        mo.setLevelList(Arrays.asList(5));
                        mo.setUserIdList(userIdList);
                        mo.setShowDepartment(Boolean.valueOf(false));
                        com.ovopark.organize.common.base.BaseResult base5 = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                        if (base5 != null) {
                            organMap5 = (Map)base5.getData();
                        }
                    }
                }
                Map shopMap = new HashMap();
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[12]) && str[12].equals("1")) {
                    String shopName = this.messageSource.getMessage("training.course.analysis.dep", null, locale);
                    row.createCell(++currentNum).setCellValue(shopName);
                    if (!CollectionUtils.isEmpty(userIdList)) {
                        UsersAndOrgsMo mo = new UsersAndOrgsMo();
                        mo.setGroupId(groupId);
                        mo.setUserIdList(userIdList);
                        mo.setShowDepartment(Boolean.valueOf(true));
                        com.ovopark.organize.common.base.BaseResult base6 = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                        if (base6 != null) {
                            shopMap = (Map)base6.getData();
                        }
                    }
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[13]) && str[13].equals("1")) {
                    row.createCell(++currentNum).setCellValue(this.messageSource.getMessage("training.course.assign.time", null, locale));
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[14]) && str[14].equals("1")) {
                    row.createCell(++currentNum).setCellValue(this.messageSource.getMessage("training.course.analysis.starttime", null, locale));
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[15]) && str[15].equals("1")) {
                    row.createCell(++currentNum).setCellValue(this.messageSource.getMessage("training.course.analysis.endtime", null, locale));
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)str[16]) && str[16].equals("1")) {
                    String studyStatus = this.messageSource.getMessage("training.course.analysis.study.status", null, locale);
                    row.createCell(++currentNum).setCellValue(studyStatus);
                }
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String unStart = this.messageSource.getMessage("training.course.status.unstart", null, locale);
                String going = this.messageSource.getMessage("training.job.status.going", null, locale);
                String completed = this.messageSource.getMessage("training.job.status.completed", null, locale);
                String timeOut = this.messageSource.getMessage("training.course.time.out", null, locale);
                String timeIn = this.messageSource.getMessage("training.course.time.in", null, locale);
                for (int i = 0; i < list.size(); ++i) {
                    List pojoList;
                    currentNum = 0;
                    row = sheet.createRow(i + 1);
                    TrainingCourseUserTaskVo vo = (TrainingCourseUserTaskVo)list.get(i);
                    row.createCell(0).setCellValue((double)vo.getUserId().intValue());
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[1]) && str[1].equals("1")) {
                        row.createCell(++currentNum).setCellValue(vo.getShowName());
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[2]) && str[2].equals("1")) {
                        row.createCell(++currentNum).setCellValue(vo.getUserName());
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[3]) && str[3].equals("1")) {
                        row.createCell(++currentNum).setCellValue(vo.getEmployeeNumber());
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[4]) && str[4].equals("1")) {
                        ++currentNum;
                        String roleName = "";
                        if (!org.springframework.util.StringUtils.isEmpty(roleMap) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)roleMap.get(vo.getUserId())))) {
                            List listStr = pojoList.stream().map(RolePojo::getRoleName).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                            roleName = StringUtils.join(listStr, (String)",");
                        }
                        row.createCell(currentNum).setCellValue(roleName);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[5]) && str[5].equals("1")) {
                        row.createCell(++currentNum).setCellValue(vo.getParentName());
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[6]) && str[6].equals("1")) {
                        ++currentNum;
                        String organizeName = "";
                        List<String> nameList = organizeMap.get(vo.getUserId());
                        if (!CollectionUtils.isEmpty(nameList)) {
                            organizeName = String.join((CharSequence)";\n", nameList);
                        }
                        HSSFCell cell = row.createCell(currentNum);
                        cell.setCellValue(organizeName);
                        cell.setCellStyle((CellStyle)titleSty);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[7]) && str[7].equals("1")) {
                        ++currentNum;
                        String organName1 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap1) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)organMap1.get(vo.getUserId())))) {
                            pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                            organName1 = StringUtils.join((Collection)pojoList, (String)",");
                        }
                        row.createCell(currentNum).setCellValue(organName1);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[8]) && str[8].equals("1")) {
                        ++currentNum;
                        String organName2 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap2) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)organMap2.get(vo.getUserId())))) {
                            pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                            organName2 = StringUtils.join((Collection)pojoList, (String)",");
                        }
                        row.createCell(currentNum).setCellValue(organName2);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[9]) && str[9].equals("1")) {
                        ++currentNum;
                        String organName3 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap3) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)organMap3.get(vo.getUserId())))) {
                            pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                            organName3 = StringUtils.join((Collection)pojoList, (String)",");
                        }
                        row.createCell(currentNum).setCellValue(organName3);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[10]) && str[10].equals("1")) {
                        ++currentNum;
                        String organName4 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap4) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)organMap4.get(vo.getUserId())))) {
                            pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                            organName4 = StringUtils.join((Collection)pojoList, (String)",");
                        }
                        row.createCell(currentNum).setCellValue(organName4);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[11]) && str[11].equals("1")) {
                        ++currentNum;
                        String organName5 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap5) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)organMap5.get(vo.getUserId())))) {
                            pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                            organName5 = StringUtils.join(pojoList, (String)",");
                        }
                        row.createCell(currentNum).setCellValue(organName5);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[12]) && str[12].equals("1")) {
                        ++currentNum;
                        String shopName = "";
                        if (!org.springframework.util.StringUtils.isEmpty(shopMap) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)shopMap.get(vo.getUserId())))) {
                            pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                            shopName = StringUtils.join(pojoList, (String)",");
                        }
                        row.createCell(currentNum).setCellValue(shopName);
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[13]) && str[13].equals("1")) {
                        row.createCell(++currentNum).setCellValue(vo.getAppointTime() == null ? "-" : format.format(vo.getAppointTime()));
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[14]) && str[14].equals("1")) {
                        row.createCell(++currentNum).setCellValue(vo.getTaskStatus() == 2 || vo.getTaskStatus() == 3 || vo.getTaskStatus() == 4 ? (vo.getStartTime() == null ? "-" : format.format(vo.getStartTime())) : "-");
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[15]) && str[15].equals("1")) {
                        row.createCell(++currentNum).setCellValue(vo.getTaskStatus() == 3 || vo.getTaskStatus() == 4 ? (vo.getEndTime() == null ? "-" : format.format(vo.getEndTime())) : "-");
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)str[16]) && str[16].equals("1")) {
                        ++currentNum;
                        String statusName = "";
                        if (vo.getTaskStatus() == 1) {
                            statusName = unStart + " " + vo.getFinishNum() + "/" + vo.getTaskNum();
                        } else if (vo.getTaskStatus() == 2) {
                            statusName = going + " " + vo.getFinishNum() + "/" + vo.getTaskNum();
                        } else if (vo.getTaskStatus() == 3) {
                            statusName = completed + "(" + timeIn + ") " + vo.getFinishNum() + "/" + vo.getTaskNum();
                        } else if (vo.getTaskStatus() == 4) {
                            statusName = completed + "(" + timeOut + ") " + vo.getFinishNum() + "/" + vo.getTaskNum();
                        }
                        row.createCell(currentNum).setCellValue(statusName);
                    }
                    sheet.autoSizeColumn(i + 1);
                }
                response.setContentType("application/vnd.ms-excel; charset=utf-8");
                response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(fileName, "UTF-8"));
                ServletOutputStream out = response.getOutputStream();
                wb.write((OutputStream)out);
                out.flush();
                out.close();
                wb.close();
                return JsonResult.success();
            }
            return "INVALID_TOKEN";
        }
        catch (Exception e) {
            log.error("selectCourseUserAnalysisByExecl: " + e);
            return JsonResult.error();
        }
    }

    @RequestMapping(value={"/selectUserRelearnCourse"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectUserRelearnCourse(@RequestBody TrainingCourseStageTaskVo vo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return JsonResult.success((Object)this.courseService.selectUserRelearnCourse(vo, user));
    }

    @RequestMapping(value={"/selectCourseTaskAnalysis"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectCourseTaskAnalysis(@RequestBody TrainingCourseVo vo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            vo = this.courseService.selectCourseTaskAnalysis(vo, user);
            return JsonResult.success((Object)vo);
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/selectCourseUserTaskStatus"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectCourseUserTaskStatus(@RequestBody TrainingCourseStageTaskVo taskVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            return JsonResult.success((Object)this.courseService.selectCourseUserTaskStatus(taskVo, user));
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/selectCourseTrainingByPage"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectCourseTrainingByPage(Page<TrainingCourseUserTaskVo> page, Integer taskId, String name, Integer status) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            return JsonResult.success(this.trainingCourseExportService.selectCourseTrainingByPage(page, taskId, name, status, user));
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/selectCourseTrainingByExecl"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectCourseTrainingByExecl(HttpServletResponse response, Integer taskId, String name, Integer status, Integer exportStatus) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                Page<TrainingCourseUserTaskVo> page = new Page<TrainingCourseUserTaskVo>();
                page.setPageNumber(1);
                page.setPageSize(9999);
                page = this.trainingCourseExportService.selectCourseTrainingByPage(page, taskId, name, status, user);
                List list = page.getContent();
                Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
                if (exportStatus == null || exportStatus == 1) {
                    HashMap organMap1 = new HashMap();
                    HashMap organMap2 = new HashMap();
                    HashMap organMap3 = new HashMap();
                    HashMap organMap4 = new HashMap();
                    HashMap organMap5 = new HashMap();
                    HashMap shopMap = new HashMap();
                    HSSFWorkbook wb = new HSSFWorkbook();
                    HSSFSheet sheet = wb.createSheet(this.messageSource.getMessage("training.course.analyze", null, locale));
                    HSSFCellStyle titleSty = wb.createCellStyle();
                    HSSFFont font = wb.createFont();
                    font.setFontHeightInPoints((short)16);
                    titleSty.setFont((Font)font);
                    HSSFRow row = sheet.createRow(0);
                    row.createCell(0).setCellValue("id");
                    row.createCell(1).setCellValue(this.messageSource.getMessage("training.user.details.name", null, locale));
                    row.createCell(2).setCellValue(this.messageSource.getMessage("training.user.details.employeeNumber", null, locale));
                    row.createCell(3).setCellValue(this.messageSource.getMessage("training.course.analysis.role", null, locale));
                    row.createCell(4).setCellValue(this.messageSource.getMessage("training.course.analysis.superior", null, locale));
                    row.createCell(5).setCellValue(this.messageSource.getMessage("training.course.analysis.department", null, locale));
                    row.createCell(6).setCellValue(this.messageSource.getMessage("training.course.analysis.first.organize", null, locale));
                    row.createCell(7).setCellValue(this.messageSource.getMessage("training.course.analysis.second.organize", null, locale));
                    row.createCell(8).setCellValue(this.messageSource.getMessage("training.course.analysis.third.organize", null, locale));
                    row.createCell(9).setCellValue(this.messageSource.getMessage("training.course.analysis.fourth.organize", null, locale));
                    row.createCell(10).setCellValue(this.messageSource.getMessage("training.course.analysis.fifth.organize", null, locale));
                    row.createCell(11).setCellValue(this.messageSource.getMessage("training.course.analysis.dep", null, locale));
                    row.createCell(12).setCellValue(this.messageSource.getMessage("training.course.analysis.starttime", null, locale));
                    row.createCell(13).setCellValue(this.messageSource.getMessage("training.course.analysis.endtime", null, locale));
                    row.createCell(14).setCellValue(this.messageSource.getMessage("training.job.course.learnCount", null, locale));
                    row.createCell(15).setCellValue(this.messageSource.getMessage("training.course.analysis.study.time", null, locale));
                    row.createCell(16).setCellValue(this.messageSource.getMessage("training.paper.status", null, locale));
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    for (int i = 0; i < list.size(); ++i) {
                        List pojoList;
                        List pojoList2;
                        List pojoList3;
                        List pojoList4;
                        List pojoList5;
                        List pojoList6;
                        List pojoList7;
                        row = sheet.createRow(i + 1);
                        TrainingCourseUserTaskVo vo = (TrainingCourseUserTaskVo)list.get(i);
                        row.createCell(0).setCellValue((double)vo.getId().intValue());
                        row.createCell(1).setCellValue(vo.getUserName());
                        row.createCell(2).setCellValue(vo.getEmployeeNumber());
                        HashMap roleMap = new HashMap();
                        String roleName = "";
                        if (!CollectionUtils.isEmpty(roleMap) && !CollectionUtils.isEmpty((Collection)(pojoList7 = (List)roleMap.get(vo.getUserId())))) {
                            List listStr = pojoList7.stream().map(RolePojo::getRoleName).filter(Objects::nonNull).collect(Collectors.toList());
                            roleName = StringUtils.join(listStr, (String)",");
                        }
                        row.createCell(3).setCellValue(roleName);
                        ArrayList<Integer> userIdList = new ArrayList<Integer>();
                        userIdList.add(vo.getUserId());
                        String parentName = "";
                        if (!org.springframework.util.StringUtils.isEmpty(this.userUtilService.selectParentMap(userIdList, vo.getEnterpriseId()))) {
                            parentName = this.userUtilService.selectParentMap(userIdList, vo.getEnterpriseId()).get(vo.getUserId());
                        }
                        row.createCell(4).setCellValue(parentName);
                        String organName1 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap1) && !CollectionUtils.isEmpty((Collection)(pojoList6 = (List)organMap1.get(vo.getUserId())))) {
                            pojoList6 = pojoList6.stream().distinct().collect(Collectors.toList());
                            organName1 = StringUtils.join(pojoList6, (String)",");
                        }
                        Map<Integer, List<String>> userOrganizeMap = this.userUtilService.selectOrganizeMap(userIdList, vo.getEnterpriseId());
                        List<String> userStr = userOrganizeMap.get(vo.getUserId());
                        row.createCell(5).setCellValue(CollectionUtils.isEmpty(userStr) ? "" : userStr.get(0));
                        row.createCell(6).setCellValue(organName1);
                        String organName2 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap2) && !CollectionUtils.isEmpty((Collection)(pojoList5 = (List)organMap2.get(vo.getUserId())))) {
                            pojoList5 = pojoList5.stream().distinct().collect(Collectors.toList());
                            organName2 = StringUtils.join(pojoList5, (String)",");
                        }
                        row.createCell(7).setCellValue(organName2);
                        String organName3 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap3) && !CollectionUtils.isEmpty((Collection)(pojoList4 = (List)organMap3.get(vo.getUserId())))) {
                            pojoList4 = pojoList4.stream().distinct().collect(Collectors.toList());
                            organName3 = StringUtils.join(pojoList4, (String)",");
                        }
                        row.createCell(8).setCellValue(organName3);
                        String organName4 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap4) && !CollectionUtils.isEmpty((Collection)(pojoList3 = (List)organMap4.get(vo.getUserId())))) {
                            pojoList3 = pojoList3.stream().distinct().collect(Collectors.toList());
                            organName4 = StringUtils.join(pojoList3, (String)",");
                        }
                        row.createCell(9).setCellValue(organName4);
                        String organName5 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap5) && !CollectionUtils.isEmpty((Collection)(pojoList2 = (List)organMap5.get(vo.getUserId())))) {
                            pojoList2 = pojoList2.stream().distinct().collect(Collectors.toList());
                            organName5 = StringUtils.join(pojoList2, (String)",");
                        }
                        row.createCell(10).setCellValue(organName5);
                        String shopName = "";
                        if (!org.springframework.util.StringUtils.isEmpty(shopMap) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)shopMap.get(vo.getUserId())))) {
                            pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                            shopName = StringUtils.join(pojoList, (String)",");
                        }
                        row.createCell(11).setCellValue(shopName);
                        row.createCell(12).setCellValue(vo.getTaskStatus() != 1 ? (vo.getStartTime() == null ? "-" : format.format(vo.getStartTime())) : "-");
                        row.createCell(13).setCellValue(vo.getTaskStatus() == 3 || vo.getTaskStatus() == 4 ? (vo.getEndTime() == null ? "-" : format.format(vo.getEndTime())) : "-");
                        row.createCell(14).setCellValue(vo.getLearnCount() == null ? 0.0 : (double)vo.getLearnCount().intValue());
                        row.createCell(15).setCellValue(vo.getTimeStr());
                        String statusName = this.messageSource.getMessage("training.course.status.ing", null, locale);
                        if (vo.getTaskStatus() == 1) {
                            statusName = this.messageSource.getMessage("training.course.status.unstart", null, locale);
                        } else if (vo.getTaskStatus() == 3 || vo.getTaskStatus() == 4) {
                            statusName = this.messageSource.getMessage("training.job.status.completed", null, locale);
                        }
                        row.createCell(16).setCellValue(statusName);
                    }
                    response.setContentType("application/vnd.ms-excel; charset=utf-8");
                    response.setHeader("Content-Disposition", "attachment; filename=\u8bfe\u7a0b\u5206\u6790.xls");
                    ServletOutputStream out = response.getOutputStream();
                    wb.write((OutputStream)out);
                    out.flush();
                    out.close();
                    wb.close();
                } else if (exportStatus == 2) {
                    // empty if block
                }
                return JsonResult.success();
            }
            return "INVALID_TOKEN";
        }
        catch (Exception e) {
            log.error("selectCourseTrainingByExecl: " + e);
            return JsonResult.error();
        }
    }

    @RequestMapping(value={"/selectCoursePaperByExecl"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectCoursePaperByExecl(HttpServletResponse response, Integer taskId, String name, Integer status, Integer exportStatus) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            List list;
            HSSFWorkbook wb = null;
            Page<TrainingCourseUserTaskVo> page = new Page<TrainingCourseUserTaskVo>();
            page.setPageNumber(1);
            page.setPageSize(9999);
            if (exportStatus == null || exportStatus == 1) {
                page = this.trainingCourseExportService.selectCourseTrainingByPage(page, taskId, name, status, user);
                list = page.getContent();
                List<Integer> userIdList = list.stream().map(TrainingCourseUserTask::getUserId).distinct().collect(Collectors.toList());
                Map<Integer, List<String>> organizeMap = this.userUtilService.selectOrganizeMap(userIdList, user.getGroupId());
                Map<Object, Object> roleMap = new HashMap();
                Map<Object, Object> parentMap = new HashMap();
                Map organMap1 = new HashMap();
                Map organMap2 = new HashMap();
                Map organMap3 = new HashMap();
                Map organMap4 = new HashMap();
                Map organMap5 = new HashMap();
                Map shopMap = new HashMap();
                Map shopDetailMap = new HashMap();
                if (!CollectionUtils.isEmpty(userIdList)) {
                    roleMap = this.userUtilService.selectRolesByUsers(userIdList, ((TrainingCourseUserTaskVo)list.get(0)).getEnterpriseId());
                    parentMap = this.userUtilService.selectParentMap(userIdList, ((TrainingCourseUserTaskVo)list.get(0)).getEnterpriseId());
                    UsersAndOrgsMo mo = new UsersAndOrgsMo();
                    mo.setGroupId(((TrainingCourseUserTaskVo)list.get(0)).getEnterpriseId());
                    mo.setLevelList(Collections.singletonList(1));
                    mo.setUserIdList(userIdList);
                    mo.setShowDepartment(Boolean.valueOf(false));
                    com.ovopark.organize.common.base.BaseResult base1 = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                    if (base1 != null) {
                        organMap1 = (Map)base1.getData();
                    }
                    mo.setLevelList(Collections.singletonList(2));
                    com.ovopark.organize.common.base.BaseResult base2 = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                    if (base2 != null) {
                        organMap2 = (Map)base2.getData();
                    }
                    mo.setLevelList(Collections.singletonList(3));
                    com.ovopark.organize.common.base.BaseResult base3 = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                    if (base3 != null) {
                        organMap3 = (Map)base3.getData();
                    }
                    mo.setLevelList(Collections.singletonList(4));
                    com.ovopark.organize.common.base.BaseResult base4 = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                    if (base4 != null) {
                        organMap4 = (Map)base4.getData();
                    }
                    mo.setLevelList(Collections.singletonList(5));
                    com.ovopark.organize.common.base.BaseResult base5 = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                    if (base5 != null) {
                        organMap5 = (Map)base5.getData();
                    }
                    UsersAndOrgsMo mo1 = new UsersAndOrgsMo();
                    mo1.setGroupId(((TrainingCourseUserTaskVo)list.get(0)).getEnterpriseId());
                    mo1.setUserIdList(userIdList);
                    mo1.setShowDepartment(Boolean.valueOf(true));
                    com.ovopark.organize.common.base.BaseResult base = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo1);
                    if (base != null && base.getData() != null) {
                        shopMap = (Map)base.getData();
                    }
                    mo1.setShowAllPath(Boolean.valueOf(true));
                    com.ovopark.organize.common.base.BaseResult bases = this.userOrganizeApi.getUserOrganizePathtByUserIds(mo1);
                    if (bases != null && bases.getData() != null) {
                        shopDetailMap = (Map)bases.getData();
                    }
                }
                Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
                String passName = this.messageSource.getMessage("training.learn.pass", null, locale);
                String unPassName = this.messageSource.getMessage("training.learn.unpass", null, locale);
                String waitRead = this.messageSource.getMessage("training.learn.wait.read", null, locale);
                wb = new HSSFWorkbook();
                HSSFSheet sheet = wb.createSheet(this.messageSource.getMessage("training.paper.analyze", null, locale));
                HSSFCellStyle titleSty = wb.createCellStyle();
                HSSFFont font = wb.createFont();
                font.setFontHeightInPoints((short)16);
                titleSty.setFont((Font)font);
                HSSFRow row = sheet.createRow(0);
                row.createCell(0).setCellValue("id");
                row.createCell(1).setCellValue(this.messageSource.getMessage("training.user.details.name", null, locale));
                row.createCell(2).setCellValue(this.messageSource.getMessage("training.user.details.employeeNumber", null, locale));
                row.createCell(3).setCellValue(this.messageSource.getMessage("training.course.analysis.role", null, locale));
                row.createCell(4).setCellValue(this.messageSource.getMessage("training.course.analysis.superior", null, locale));
                row.createCell(5).setCellValue(this.messageSource.getMessage("training.course.analysis.department", null, locale));
                row.createCell(6).setCellValue(this.messageSource.getMessage("training.course.analysis.first.organize", null, locale));
                row.createCell(7).setCellValue(this.messageSource.getMessage("training.course.analysis.second.organize", null, locale));
                row.createCell(8).setCellValue(this.messageSource.getMessage("training.course.analysis.third.organize", null, locale));
                row.createCell(9).setCellValue(this.messageSource.getMessage("training.course.analysis.fourth.organize", null, locale));
                row.createCell(10).setCellValue(this.messageSource.getMessage("training.course.analysis.fifth.organize", null, locale));
                row.createCell(11).setCellValue(this.messageSource.getMessage("training.course.analysis.dep", null, locale));
                row.createCell(12).setCellValue(this.messageSource.getMessage("training.paper.finish.time", null, locale));
                row.createCell(13).setCellValue(this.messageSource.getMessage("training.paper.num", null, locale));
                row.createCell(14).setCellValue(this.messageSource.getMessage("training.course.average.time", null, locale));
                row.createCell(15).setCellValue(this.messageSource.getMessage("training.paper.score", null, locale));
                row.createCell(16).setCellValue(this.messageSource.getMessage("training.paper.status", null, locale));
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                for (int i = 0; i < list.size(); ++i) {
                    List pojoList;
                    List pojoList2;
                    List pojoList3;
                    List pojoList4;
                    List pojoList5;
                    List pojoList6;
                    List pojoList7;
                    row = sheet.createRow(i + 1);
                    TrainingCourseUserTaskVo vo = (TrainingCourseUserTaskVo)list.get(i);
                    row.createCell(0).setCellValue(String.valueOf(vo.getUserId()));
                    row.createCell(1).setCellValue(vo.getUserName());
                    row.createCell(2).setCellValue(vo.getEmployeeNumber());
                    String roleName = "";
                    if (!CollectionUtils.isEmpty(roleMap) && !CollectionUtils.isEmpty((Collection)(pojoList7 = (List)roleMap.get(vo.getUserId())))) {
                        List listStr = pojoList7.stream().map(RolePojo::getRoleName).filter(Objects::nonNull).collect(Collectors.toList());
                        roleName = StringUtils.join(listStr, (String)",");
                    }
                    row.createCell(3).setCellValue(roleName);
                    String parentName = "";
                    if (!org.springframework.util.StringUtils.isEmpty(parentMap)) {
                        parentName = (String)parentMap.get(vo.getUserId());
                    }
                    row.createCell(4).setCellValue(parentName);
                    String organName1 = "";
                    if (!org.springframework.util.StringUtils.isEmpty(organMap1) && !CollectionUtils.isEmpty((Collection)(pojoList6 = (List)organMap1.get(vo.getUserId())))) {
                        pojoList6 = pojoList6.stream().distinct().collect(Collectors.toList());
                        organName1 = StringUtils.join(pojoList6, (String)",");
                    }
                    String departName = "";
                    List<String> nameList = organizeMap.get(vo.getUserId());
                    if (!CollectionUtils.isEmpty(nameList)) {
                        departName = String.join((CharSequence)";\n", nameList);
                    }
                    row.createCell(5).setCellValue(departName);
                    row.createCell(6).setCellValue(organName1);
                    String organName2 = "";
                    if (!org.springframework.util.StringUtils.isEmpty(organMap2) && !CollectionUtils.isEmpty((Collection)(pojoList5 = (List)organMap2.get(vo.getUserId())))) {
                        pojoList5 = pojoList5.stream().distinct().collect(Collectors.toList());
                        organName2 = StringUtils.join(pojoList5, (String)",");
                    }
                    row.createCell(7).setCellValue(organName2);
                    String organName3 = "";
                    if (!org.springframework.util.StringUtils.isEmpty(organMap3) && !CollectionUtils.isEmpty((Collection)(pojoList4 = (List)organMap3.get(vo.getUserId())))) {
                        pojoList4 = pojoList4.stream().distinct().collect(Collectors.toList());
                        organName3 = StringUtils.join(pojoList4, (String)",");
                    }
                    row.createCell(8).setCellValue(organName3);
                    String organName4 = "";
                    if (!org.springframework.util.StringUtils.isEmpty(organMap4) && !CollectionUtils.isEmpty((Collection)(pojoList3 = (List)organMap4.get(vo.getUserId())))) {
                        pojoList3 = pojoList3.stream().distinct().collect(Collectors.toList());
                        organName4 = StringUtils.join(pojoList3, (String)",");
                    }
                    row.createCell(9).setCellValue(organName4);
                    String organName5 = "";
                    if (!org.springframework.util.StringUtils.isEmpty(organMap5) && !CollectionUtils.isEmpty((Collection)(pojoList2 = (List)organMap5.get(vo.getUserId())))) {
                        pojoList2 = pojoList2.stream().distinct().collect(Collectors.toList());
                        organName5 = StringUtils.join(pojoList2, (String)",");
                    }
                    row.createCell(10).setCellValue(organName5);
                    String shopName = "";
                    if (!org.springframework.util.StringUtils.isEmpty(shopMap) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)shopMap.get(vo.getUserId())))) {
                        pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                        shopName = StringUtils.join(pojoList, (String)",");
                    }
                    row.createCell(11).setCellValue(shopName);
                    row.createCell(12).setCellValue(vo.getTaskStatus() == 3 || vo.getTaskStatus() == 4 || vo.getTaskStatus() == 5 || vo.getTaskStatus() == 6 ? (vo.getEndTime() == null ? "-" : format.format(vo.getEndTime())) : "-");
                    row.createCell(13).setCellValue((vo.getTaskStatus() == 3 || vo.getTaskStatus() == 4 || vo.getTaskStatus() == 5 || vo.getTaskStatus() == 6) && vo.getPaperCount() != null ? vo.getPaperCount().toString() : "-");
                    row.createCell(14).setCellValue(vo.getTaskStatus() == 3 || vo.getTaskStatus() == 4 || vo.getTaskStatus() == 5 || vo.getTaskStatus() == 6 ? vo.getTimeStr() : "-");
                    row.createCell(15).setCellValue((vo.getTaskStatus() == 3 || vo.getTaskStatus() == 4 || vo.getTaskStatus() == 5 || vo.getTaskStatus() == 6) && vo.getScore() != null && vo.getScore().compareTo(new BigDecimal(-1)) > 0 ? vo.getScore().toString() : "-");
                    String statusName = this.messageSource.getMessage("training.paper.ing", null, locale);
                    if (vo.getTaskStatus() == 1) {
                        statusName = this.messageSource.getMessage("training.course.status.unexam", null, locale);
                    } else if (vo.getTaskStatus() == 3 || vo.getTaskStatus() == 4) {
                        statusName = passName;
                    } else if (vo.getTaskStatus() == 5) {
                        statusName = unPassName;
                    } else if (vo.getTaskStatus() == 6) {
                        statusName = waitRead;
                    }
                    row.createCell(16).setCellValue(statusName);
                }
            } else if (exportStatus == 2) {
                page = this.trainingCourseExportService.selectCourseTrainingByPage2(page, taskId, name, status, user);
                list = page.getContent();
                List<Integer> userIdList = list.stream().map(TrainingCourseUserTask::getUserId).distinct().collect(Collectors.toList());
                Map<Integer, List<String>> organizeMap = this.userUtilService.selectOrganizeMap(userIdList, user.getGroupId());
                Map<Object, Object> roleMap = new HashMap();
                Map<Object, Object> parentMap = new HashMap();
                Map organMap1 = new HashMap();
                Map organMap2 = new HashMap();
                Map organMap3 = new HashMap();
                Map organMap4 = new HashMap();
                Map organMap5 = new HashMap();
                Map shopMap = new HashMap();
                Map shopDetailMap = new HashMap();
                if (!CollectionUtils.isEmpty(userIdList)) {
                    roleMap = this.userUtilService.selectRolesByUsers(userIdList, ((TrainingCourseUserTaskVo)list.get(0)).getEnterpriseId());
                    parentMap = this.userUtilService.selectParentMap(userIdList, ((TrainingCourseUserTaskVo)list.get(0)).getEnterpriseId());
                    UsersAndOrgsMo mo = new UsersAndOrgsMo();
                    mo.setGroupId(((TrainingCourseUserTaskVo)list.get(0)).getEnterpriseId());
                    mo.setLevelList(Collections.singletonList(1));
                    mo.setUserIdList(userIdList);
                    mo.setShowDepartment(Boolean.valueOf(false));
                    com.ovopark.organize.common.base.BaseResult base1 = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                    if (base1 != null) {
                        organMap1 = (Map)base1.getData();
                    }
                    mo.setLevelList(Collections.singletonList(2));
                    com.ovopark.organize.common.base.BaseResult base2 = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                    if (base2 != null) {
                        organMap2 = (Map)base2.getData();
                    }
                    mo.setLevelList(Collections.singletonList(3));
                    com.ovopark.organize.common.base.BaseResult base3 = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                    if (base3 != null) {
                        organMap3 = (Map)base3.getData();
                    }
                    mo.setLevelList(Collections.singletonList(4));
                    com.ovopark.organize.common.base.BaseResult base4 = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                    if (base4 != null) {
                        organMap4 = (Map)base4.getData();
                    }
                    mo.setLevelList(Collections.singletonList(5));
                    com.ovopark.organize.common.base.BaseResult base5 = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                    if (base5 != null) {
                        organMap5 = (Map)base5.getData();
                    }
                    UsersAndOrgsMo mo1 = new UsersAndOrgsMo();
                    mo1.setGroupId(((TrainingCourseUserTaskVo)list.get(0)).getEnterpriseId());
                    mo1.setUserIdList(userIdList);
                    mo1.setShowDepartment(Boolean.valueOf(true));
                    com.ovopark.organize.common.base.BaseResult base = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo1);
                    if (base != null && base.getData() != null) {
                        shopMap = (Map)base.getData();
                    }
                    mo1.setShowAllPath(Boolean.valueOf(true));
                    com.ovopark.organize.common.base.BaseResult bases = this.userOrganizeApi.getUserOrganizePathtByUserIds(mo1);
                    if (bases != null && bases.getData() != null) {
                        shopDetailMap = (Map)bases.getData();
                    }
                }
                Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
                String unExam = this.messageSource.getMessage("training.course.status.unexam", null, locale);
                String passName = this.messageSource.getMessage("training.learn.pass", null, locale);
                String unPassName = this.messageSource.getMessage("training.learn.unpass", null, locale);
                String waitRead = this.messageSource.getMessage("training.learn.wait.read", null, locale);
                wb = new HSSFWorkbook();
                HSSFSheet sheet = wb.createSheet(this.messageSource.getMessage("training.paper.analyze", null, locale));
                HSSFCellStyle titleSty = wb.createCellStyle();
                HSSFFont font = wb.createFont();
                font.setFontHeightInPoints((short)16);
                titleSty.setFont((Font)font);
                HSSFRow row = sheet.createRow(0);
                row.createCell(0).setCellValue("id");
                row.createCell(1).setCellValue(this.messageSource.getMessage("training.user.details.name", null, locale));
                row.createCell(2).setCellValue(this.messageSource.getMessage("training.user.details.employeeNumber", null, locale));
                row.createCell(3).setCellValue(this.messageSource.getMessage("training.course.analysis.role", null, locale));
                row.createCell(4).setCellValue(this.messageSource.getMessage("training.course.analysis.superior", null, locale));
                row.createCell(5).setCellValue(this.messageSource.getMessage("training.course.analysis.department", null, locale));
                row.createCell(6).setCellValue(this.messageSource.getMessage("training.course.analysis.first.organize", null, locale));
                row.createCell(7).setCellValue(this.messageSource.getMessage("training.course.analysis.second.organize", null, locale));
                row.createCell(8).setCellValue(this.messageSource.getMessage("training.course.analysis.third.organize", null, locale));
                row.createCell(9).setCellValue(this.messageSource.getMessage("training.course.analysis.fourth.organize", null, locale));
                row.createCell(10).setCellValue(this.messageSource.getMessage("training.course.analysis.fifth.organize", null, locale));
                row.createCell(11).setCellValue(this.messageSource.getMessage("training.course.analysis.dep", null, locale));
                row.createCell(12).setCellValue(this.messageSource.getMessage("training.paper.handtime", null, locale));
                row.createCell(13).setCellValue(this.messageSource.getMessage("training.operate.usetime", null, locale));
                row.createCell(14).setCellValue(this.messageSource.getMessage("training.paper.score", null, locale));
                row.createCell(15).setCellValue(this.messageSource.getMessage("training.paper.status", null, locale));
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                for (int i = 0; i < list.size(); ++i) {
                    List pojoList;
                    List pojoList8;
                    List pojoList9;
                    List pojoList10;
                    List pojoList11;
                    List pojoList12;
                    List pojoList13;
                    row = sheet.createRow(i + 1);
                    TrainingCourseUserTaskVo vo = (TrainingCourseUserTaskVo)list.get(i);
                    row.createCell(0).setCellValue(String.valueOf(vo.getUserId()));
                    row.createCell(1).setCellValue(vo.getUserName());
                    row.createCell(2).setCellValue(vo.getEmployeeNumber());
                    String roleName = "";
                    if (!CollectionUtils.isEmpty(roleMap) && !CollectionUtils.isEmpty((Collection)(pojoList13 = (List)roleMap.get(vo.getUserId())))) {
                        List listStr = pojoList13.stream().map(RolePojo::getRoleName).filter(Objects::nonNull).collect(Collectors.toList());
                        roleName = StringUtils.join(listStr, (String)",");
                    }
                    row.createCell(3).setCellValue(roleName);
                    String parentName = "";
                    if (!org.springframework.util.StringUtils.isEmpty(parentMap)) {
                        parentName = (String)parentMap.get(vo.getUserId());
                    }
                    row.createCell(4).setCellValue(parentName);
                    String organName1 = "";
                    if (!org.springframework.util.StringUtils.isEmpty(organMap1) && !CollectionUtils.isEmpty((Collection)(pojoList12 = (List)organMap1.get(vo.getUserId())))) {
                        pojoList12 = pojoList12.stream().distinct().collect(Collectors.toList());
                        organName1 = StringUtils.join(pojoList12, (String)",");
                    }
                    String departName = "";
                    List<String> nameList = organizeMap.get(vo.getUserId());
                    if (!CollectionUtils.isEmpty(nameList)) {
                        departName = String.join((CharSequence)";\n", nameList);
                    }
                    row.createCell(5).setCellValue(departName);
                    row.createCell(6).setCellValue(organName1);
                    String organName2 = "";
                    if (!org.springframework.util.StringUtils.isEmpty(organMap2) && !CollectionUtils.isEmpty((Collection)(pojoList11 = (List)organMap2.get(vo.getUserId())))) {
                        pojoList11 = pojoList11.stream().distinct().collect(Collectors.toList());
                        organName2 = StringUtils.join(pojoList11, (String)",");
                    }
                    row.createCell(7).setCellValue(organName2);
                    String organName3 = "";
                    if (!org.springframework.util.StringUtils.isEmpty(organMap3) && !CollectionUtils.isEmpty((Collection)(pojoList10 = (List)organMap3.get(vo.getUserId())))) {
                        pojoList10 = pojoList10.stream().distinct().collect(Collectors.toList());
                        organName3 = StringUtils.join(pojoList10, (String)",");
                    }
                    row.createCell(8).setCellValue(organName3);
                    String organName4 = "";
                    if (!org.springframework.util.StringUtils.isEmpty(organMap4) && !CollectionUtils.isEmpty((Collection)(pojoList9 = (List)organMap4.get(vo.getUserId())))) {
                        pojoList9 = pojoList9.stream().distinct().collect(Collectors.toList());
                        organName4 = StringUtils.join(pojoList9, (String)",");
                    }
                    row.createCell(9).setCellValue(organName4);
                    String organName5 = "";
                    if (!org.springframework.util.StringUtils.isEmpty(organMap5) && !CollectionUtils.isEmpty((Collection)(pojoList8 = (List)organMap5.get(vo.getUserId())))) {
                        pojoList8 = pojoList8.stream().distinct().collect(Collectors.toList());
                        organName5 = StringUtils.join(pojoList8, (String)",");
                    }
                    row.createCell(10).setCellValue(organName5);
                    String shopName = "";
                    if (!org.springframework.util.StringUtils.isEmpty(shopMap) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)shopMap.get(vo.getUserId())))) {
                        pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                        shopName = StringUtils.join(pojoList, (String)",");
                    }
                    row.createCell(11).setCellValue(shopName);
                    row.createCell(12).setCellValue(vo.getCommitTime() == null ? "-" : format.format(vo.getCommitTime()));
                    row.createCell(13).setCellValue(vo.getTimeStr() == null ? "-" : vo.getTimeStr());
                    String statusName = "";
                    String score = "";
                    if (vo.getTaskStatus() == 1) {
                        String unexam;
                        statusName = unexam = this.messageSource.getMessage("training.paper.unexam", null, locale);
                        score = "-";
                    } else if (vo.getTaskStatus() == 2) {
                        statusName = this.messageSource.getMessage("training.paper.ing", null, locale);
                        score = "-";
                    } else if (vo.getTaskStatus() == 3) {
                        statusName = passName;
                        score = String.valueOf(vo.getScore());
                    } else if (vo.getTaskStatus() == 4) {
                        statusName = unPassName;
                        score = String.valueOf(vo.getScore());
                    } else if (vo.getTaskStatus() == 5) {
                        statusName = waitRead;
                        score = "-";
                    }
                    row.createCell(14).setCellValue(score);
                    row.createCell(15).setCellValue(statusName);
                }
            }
            try {
                response.setContentType("application/vnd.ms-excel; charset=utf-8");
                response.setHeader("Content-Disposition", "attachment; filename=\u8003\u8bd5\u5206\u6790.xls");
                ServletOutputStream out = response.getOutputStream();
                wb.write((OutputStream)out);
                out.flush();
                out.close();
                wb.close();
                return JsonResult.success();
            }
            catch (IOException e) {
                log.error("", (Throwable)e);
                return JsonResult.error();
            }
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/selectCourseMaterialByExecl"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectCourseMaterialByExecl(HttpServletResponse response, Integer taskId, String name, Integer status) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                Page<TrainingCourseUserTaskVo> page = new Page<TrainingCourseUserTaskVo>();
                page.setPageNumber(1);
                page.setPageSize(9999);
                page = this.trainingCourseExportService.selectCourseTrainingByPage(page, taskId, name, status, user);
                List list = page.getContent();
                Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
                String employeeNumber = this.messageSource.getMessage("training.user.details.employeeNumber", null, locale);
                String department = this.messageSource.getMessage("training.course.analysis.department", null, locale);
                String statusNames = this.messageSource.getMessage("training.paper.status", null, locale);
                String unStart = this.messageSource.getMessage("training.course.status.unstart", null, locale);
                String completed = this.messageSource.getMessage("training.job.status.completed", null, locale);
                HSSFWorkbook wb = new HSSFWorkbook();
                HSSFSheet sheet = wb.createSheet(this.messageSource.getMessage("training.material.analyze", null, locale));
                HSSFCellStyle titleSty = wb.createCellStyle();
                HSSFFont font = wb.createFont();
                font.setFontHeightInPoints((short)16);
                titleSty.setFont((Font)font);
                HSSFRow row = sheet.createRow(0);
                row.createCell(0).setCellValue(this.messageSource.getMessage("training.user.details.name", null, locale));
                row.createCell(1).setCellValue(employeeNumber);
                row.createCell(2).setCellValue(department);
                row.createCell(3).setCellValue(this.messageSource.getMessage("training.course.analysis.starttime", null, locale));
                row.createCell(4).setCellValue(this.messageSource.getMessage("training.course.analysis.endtime", null, locale));
                row.createCell(5).setCellValue(this.messageSource.getMessage("training.job.course.learnCount", null, locale));
                row.createCell(6).setCellValue(this.messageSource.getMessage("training.course.analysis.study.time", null, locale));
                row.createCell(7).setCellValue(statusNames);
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                for (int i = 0; i < list.size(); ++i) {
                    row = sheet.createRow(i + 1);
                    TrainingCourseUserTaskVo vo = (TrainingCourseUserTaskVo)list.get(i);
                    row.createCell(0).setCellValue(vo.getUserName());
                    row.createCell(1).setCellValue(vo.getEmployeeNumber());
                    row.createCell(2).setCellValue(vo.getOrganizeName());
                    row.createCell(3).setCellValue(vo.getTaskStatus() != 1 ? (vo.getStartTime() == null ? "-" : format.format(vo.getStartTime())) : "-");
                    row.createCell(4).setCellValue(vo.getTaskStatus() == 3 || vo.getTaskStatus() == 4 ? (vo.getEndTime() == null ? "-" : format.format(vo.getEndTime())) : "-");
                    row.createCell(5).setCellValue(vo.getLearnCount() == null ? 0.0 : (double)vo.getLearnCount().intValue());
                    row.createCell(6).setCellValue(vo.getTimeStr());
                    String statusName = this.messageSource.getMessage("training.course.status.ing", null, locale);
                    if (vo.getTaskStatus() == 1) {
                        statusName = unStart;
                    } else if (vo.getTaskStatus() == 3 || vo.getTaskStatus() == 4) {
                        statusName = completed;
                    }
                    row.createCell(7).setCellValue(statusName);
                }
                response.setContentType("application/vnd.ms-excel; charset=utf-8");
                response.setHeader("Content-Disposition", "attachment; filename=\u7d20\u6750\u5206\u6790.xls");
                ServletOutputStream out = response.getOutputStream();
                wb.write((OutputStream)out);
                out.flush();
                out.close();
                wb.close();
                return JsonResult.success();
            }
            return "INVALID_TOKEN";
        }
        catch (Exception e) {
            log.error("selectCourseMaterialByExecl: " + e);
            return JsonResult.error();
        }
    }

    @RequestMapping(value={"/selectCourseWorkByExecl"})
    @ResponseBody
    public String selectCourseWorkByExecl(HttpServletResponse response, Integer taskId, String name, Integer status) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                List<Integer> userIdList;
                Page<TrainingCourseUserTaskVo> page = new Page<TrainingCourseUserTaskVo>();
                page.setPageNumber(1);
                page.setPageSize(9999);
                page = this.trainingCourseExportService.selectCourseTrainingByPage(page, taskId, name, status, user);
                List list = page.getContent();
                Map<Object, Object> roleMap = new HashMap();
                Map<Object, Object> parentMap = new HashMap();
                Map organMap1 = new HashMap();
                Map organMap2 = new HashMap();
                Map organMap3 = new HashMap();
                Map organMap4 = new HashMap();
                Map organMap5 = new HashMap();
                Map shopMap = new HashMap();
                if (!CollectionUtils.isEmpty((Collection)list) && !CollectionUtils.isEmpty(userIdList = list.stream().map(TrainingCourseUserTask::getUserId).distinct().collect(Collectors.toList()))) {
                    roleMap = this.userUtilService.selectRolesByUsers(userIdList, user.getGroupId());
                    parentMap = this.userUtilService.selectParentMap(userIdList, user.getGroupId());
                    UsersAndOrgsMo mo = new UsersAndOrgsMo();
                    mo.setGroupId(user.getGroupId());
                    mo.setLevelList(Collections.singletonList(1));
                    mo.setUserIdList(userIdList);
                    mo.setShowDepartment(Boolean.valueOf(false));
                    com.ovopark.organize.common.base.BaseResult base1 = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                    if (base1 != null) {
                        organMap1 = (Map)base1.getData();
                    }
                    mo.setLevelList(Collections.singletonList(2));
                    com.ovopark.organize.common.base.BaseResult base2 = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                    if (base2 != null) {
                        organMap2 = (Map)base2.getData();
                    }
                    mo.setLevelList(Collections.singletonList(3));
                    com.ovopark.organize.common.base.BaseResult base3 = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                    if (base3 != null) {
                        organMap3 = (Map)base3.getData();
                    }
                    mo.setLevelList(Collections.singletonList(4));
                    com.ovopark.organize.common.base.BaseResult base4 = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                    if (base4 != null) {
                        organMap4 = (Map)base4.getData();
                    }
                    mo.setLevelList(Collections.singletonList(5));
                    com.ovopark.organize.common.base.BaseResult base5 = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                    if (base5 != null) {
                        organMap5 = (Map)base5.getData();
                    }
                    UsersAndOrgsMo mo1 = new UsersAndOrgsMo();
                    mo1.setGroupId(user.getGroupId());
                    mo1.setUserIdList(userIdList);
                    mo1.setShowDepartment(Boolean.valueOf(true));
                    com.ovopark.organize.common.base.BaseResult base = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo1);
                    if (base != null) {
                        shopMap = (Map)base.getData();
                    }
                }
                Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
                String employeeNumber = this.messageSource.getMessage("training.user.details.employeeNumber", null, locale);
                String role = this.messageSource.getMessage("training.course.analysis.role", null, locale);
                String leader = this.messageSource.getMessage("training.course.analysis.superior", null, locale);
                String shopNames = this.messageSource.getMessage("training.course.analysis.dep", null, locale);
                String statusNames = this.messageSource.getMessage("training.paper.status", null, locale);
                String waitRead = this.messageSource.getMessage("training.learn.wait.read", null, locale);
                String passName = this.messageSource.getMessage("training.job.status.pass", null, locale);
                String notPassName = this.messageSource.getMessage("training.job.status.not.pass", null, locale);
                HSSFWorkbook wb = new HSSFWorkbook();
                HSSFSheet sheet = wb.createSheet(this.messageSource.getMessage("training.learn.job.analyze", null, locale));
                HSSFCellStyle titleSty = wb.createCellStyle();
                HSSFFont font = wb.createFont();
                font.setFontHeightInPoints((short)16);
                titleSty.setFont((Font)font);
                HSSFRow row = sheet.createRow(0);
                row.createCell(0).setCellValue("id");
                row.createCell(1).setCellValue(this.messageSource.getMessage("training.course.trainee.name", null, locale));
                row.createCell(2).setCellValue(employeeNumber);
                row.createCell(3).setCellValue(role);
                row.createCell(4).setCellValue(leader);
                row.createCell(5).setCellValue(this.messageSource.getMessage("training.course.analysis.first.organize", null, locale));
                row.createCell(6).setCellValue(this.messageSource.getMessage("training.course.analysis.second.organize", null, locale));
                row.createCell(7).setCellValue(this.messageSource.getMessage("training.course.analysis.third.organize", null, locale));
                row.createCell(8).setCellValue(this.messageSource.getMessage("training.course.analysis.fourth.organize", null, locale));
                row.createCell(9).setCellValue(this.messageSource.getMessage("training.course.analysis.fifth.organize", null, locale));
                row.createCell(10).setCellValue(shopNames);
                row.createCell(11).setCellValue(this.messageSource.getMessage("training.course.submit.time", null, locale));
                row.createCell(12).setCellValue(this.messageSource.getMessage("training.course.reply.num", null, locale));
                row.createCell(13).setCellValue(this.messageSource.getMessage("training.paper.score", null, locale));
                row.createCell(14).setCellValue(statusNames);
                if (!CollectionUtils.isEmpty((Collection)list)) {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    for (int i = 0; i < list.size(); ++i) {
                        List pojoList;
                        List pojoList2;
                        List pojoList3;
                        List pojoList4;
                        List pojoList5;
                        List pojoList6;
                        List pojoList7;
                        row = sheet.createRow(i + 1);
                        TrainingCourseUserTaskVo vo = (TrainingCourseUserTaskVo)list.get(i);
                        row.createCell(0).setCellValue((double)vo.getUserId().intValue());
                        row.createCell(1).setCellValue(vo.getUserName());
                        row.createCell(2).setCellValue(vo.getEmployeeNumber());
                        String roleName = "";
                        if (!CollectionUtils.isEmpty(roleMap) && !CollectionUtils.isEmpty((Collection)(pojoList7 = (List)roleMap.get(vo.getUserId())))) {
                            List listStr = pojoList7.stream().map(RolePojo::getRoleName).filter(Objects::nonNull).collect(Collectors.toList());
                            roleName = StringUtils.join(listStr, (String)",");
                        }
                        row.createCell(3).setCellValue(roleName);
                        String parentName = "";
                        if (!org.springframework.util.StringUtils.isEmpty(parentMap)) {
                            parentName = (String)parentMap.get(vo.getUserId());
                        }
                        row.createCell(4).setCellValue(parentName);
                        String organName1 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap1) && !CollectionUtils.isEmpty((Collection)(pojoList6 = (List)organMap1.get(vo.getUserId())))) {
                            pojoList6 = pojoList6.stream().distinct().collect(Collectors.toList());
                            organName1 = StringUtils.join(pojoList6, (String)",");
                        }
                        row.createCell(5).setCellValue(organName1);
                        String organName2 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap2) && !CollectionUtils.isEmpty((Collection)(pojoList5 = (List)organMap2.get(vo.getUserId())))) {
                            pojoList5 = pojoList5.stream().distinct().collect(Collectors.toList());
                            organName2 = StringUtils.join(pojoList5, (String)",");
                        }
                        row.createCell(6).setCellValue(organName2);
                        String organName3 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap3) && !CollectionUtils.isEmpty((Collection)(pojoList4 = (List)organMap3.get(vo.getUserId())))) {
                            pojoList4 = pojoList4.stream().distinct().collect(Collectors.toList());
                            organName3 = StringUtils.join(pojoList4, (String)",");
                        }
                        row.createCell(7).setCellValue(organName3);
                        String organName4 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap4) && !CollectionUtils.isEmpty((Collection)(pojoList3 = (List)organMap4.get(vo.getUserId())))) {
                            pojoList3 = pojoList3.stream().distinct().collect(Collectors.toList());
                            organName4 = StringUtils.join(pojoList3, (String)",");
                        }
                        row.createCell(8).setCellValue(organName4);
                        String organName5 = "";
                        if (!org.springframework.util.StringUtils.isEmpty(organMap5) && !CollectionUtils.isEmpty((Collection)(pojoList2 = (List)organMap5.get(vo.getUserId())))) {
                            pojoList2 = pojoList2.stream().distinct().collect(Collectors.toList());
                            organName5 = StringUtils.join(pojoList2, (String)",");
                        }
                        row.createCell(9).setCellValue(organName5);
                        String shopName = "";
                        if (!org.springframework.util.StringUtils.isEmpty(shopMap) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)shopMap.get(vo.getUserId())))) {
                            pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                            shopName = StringUtils.join(pojoList, (String)",");
                        }
                        row.createCell(10).setCellValue(shopName);
                        row.createCell(11).setCellValue(vo.getCommitTime() == null ? "-" : format.format(vo.getCommitTime()));
                        row.createCell(12).setCellValue((double)vo.getAnswerCount().intValue());
                        row.createCell(13).setCellValue(vo.getScore() == null ? "" : vo.getScore().toString());
                        String statusName = passName;
                        if (vo.getTaskStatus() == 6) {
                            statusName = waitRead;
                        } else if (vo.getTaskStatus() == 5) {
                            statusName = notPassName;
                        } else if (vo.getTaskStatus() == 1) {
                            statusName = this.messageSource.getMessage("training.course.unsubmit", null, locale);
                        }
                        row.createCell(14).setCellValue(statusName);
                    }
                }
                String taskName = "";
                TrainingCourseStageTask trainingCourseStageTask = (TrainingCourseStageTask)this.trainingCourseStageTaskMapper.selectById(taskId);
                if (!ObjectUtils.isEmpty((Object)trainingCourseStageTask)) {
                    taskName = trainingCourseStageTask.getTaskName();
                }
                response.setContentType("application/vnd.ms-excel; charset=utf-8");
                String fileName = taskName + "_" + this.messageSource.getMessage("training.answer.result", null, locale) + "\u4f5c\u7b54\u7ed3\u679c_" + DateUtils.format(new Date(), "yyyyMMdd") + ".xls";
                response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(fileName, "UTF-8"));
                ServletOutputStream out = response.getOutputStream();
                wb.write((OutputStream)out);
                out.flush();
                out.close();
                wb.close();
                return JsonResult.success();
            }
            return "INVALID_TOKEN";
        }
        catch (Exception e) {
            log.error("selectCourseWorkByExecl: " + e);
            return JsonResult.error();
        }
    }

    @RequestMapping(value={"/selectCourseUserPaper"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectCourseUserPaper(@RequestBody TrainingCourseUserTaskVo vo) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                return JsonResult.success(this.courseService.selectCourseUserPaper(vo, user));
            }
            return "INVALID_TOKEN";
        }
        catch (Exception e) {
            log.error("selectCourseUserPaper: " + e);
            return JsonResult.error();
        }
    }

    @RequestMapping(value={"/selectTrainingUrl"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectTrainingUrl(@RequestBody TrainingsVo training) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                return JsonResult.success((Object)this.trainingService.selectTrainingUrl(training, user));
            }
            return "INVALID_TOKEN";
        }
        catch (Exception e) {
            log.error("selectTrainingUrl: " + e);
            return JsonResult.error();
        }
    }

    @RequestMapping(value={"/updateTraining"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String updateTraining(@RequestBody TrainingsVo training) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                this.trainingService.updateTraining(training, user);
                return JsonResult.success();
            }
            return "INVALID_TOKEN";
        }
        catch (Exception e) {
            log.error("updateTraining: " + e);
            return JsonResult.error();
        }
    }

    @RequestMapping(value={"/updatePaper"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String updatePaper(@RequestBody TrainingPapersVo paperVo) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                this.trainingService.updatePaper(paperVo, user);
                return JsonResult.success();
            }
            return "INVALID_TOKEN";
        }
        catch (Exception e) {
            log.error("updateTraining: " + e);
            return JsonResult.error();
        }
    }

    @RequestMapping(value={"/selectLastViewTime"})
    @ResponseBody
    public String selectLastViewTime(@RequestBody TrainingUserViewTimeVo viewTime) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            return JsonResult.success((Object)this.trainingService.selectLastViewTime(viewTime, user));
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/selectNewWebTrainingByPage"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectNewWebTrainingByPage(Page<TrainingsVo> page, String title, Integer trainingType, @RequestParam(required=false) Integer permissionType) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (permissionType == null) {
                permissionType = 3;
            }
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            page = this.trainingService.selectNewWebTrainingByPage(page, user, title, trainingType, permissionType);
        }
        catch (Exception e) {
            log.error("selectNewWebTrainingByPage: " + e);
        }
        return JsonResult.success(page);
    }

    @RequestMapping(value={"/selectAppCourse"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectAppCourse(@RequestBody TrainingCourseVo courseVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            return JsonResult.success((Object)this.courseService.selectAppCourse(courseVo, user));
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/selectAppCourseContent"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectAppCourseContent(@RequestBody TrainingCourseVo courseVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            TrainingCourseVo vo = this.courseService.selectAppCourseContent(courseVo, user);
            return JsonResult.success((Object)vo);
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/selectAppTrainingHistory"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectAppTrainingHistory(Page<TrainingCourseVo> page, Integer taskType, Integer taskStatus) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                return JsonResult.success(this.courseService.selectAppTrainingHistory(page, taskType, taskStatus, user));
            }
            return "INVALID_TOKEN";
        }
        catch (Exception e) {
            log.error("selectAppTrainingHistory: " + e);
            return JsonResult.error();
        }
    }

    @RequestMapping(value={"/updateAppCourseRelearn"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String updateAppCourseRelearn(@RequestBody TrainingCourseStageVo vo) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                this.courseService.updateAppCourseRelearn(vo, user);
                return JsonResult.success();
            }
            return "INVALID_TOKEN";
        }
        catch (Exception e) {
            log.error("updateAppCourseRelearn: " + e);
            return JsonResult.error();
        }
    }

    @RequestMapping(value={"/updateAppCourseRelearnNew"})
    @ResponseBody
    public String updateAppCourseRelearnNew(@RequestBody List<TrainingCourseStageVo> vo) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                this.courseService.updateAppCourseRelearnNew(vo, user);
                return JsonResult.success();
            }
            return "INVALID_TOKEN";
        }
        catch (Exception e) {
            log.error("updateAppCourseRelearnNew: " + e);
            return JsonResult.error();
        }
    }

    @RequestMapping(value={"/addCoursePush"})
    @ResponseBody
    public String addCoursePush(final @RequestBody TrainingCoursePushVo push) {
        if (push.getCourseId() == null) {
            return JsonResult.paramError();
        }
        final Users user = Authenticator.getInstance().getCurrentUser();
        push.setEnterpriseId(user.getGroupId());
        CommonUtil.handleTask(new Runnable(){

            @Override
            public void run() {
                push.setPushUserId(user.getId());
                TrainingCourseController.this.courseService.addCoursePush(push);
            }
        });
        return JsonResult.success();
    }

    @RequestMapping(value={"/vaildPush"})
    @ResponseBody
    public String vaildPush(Integer courseId) {
        if (courseId == null) {
            return JsonResult.paramError();
        }
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.courseService.vaildPush(user.getGroupId(), courseId);
    }

    @RequestMapping(value={"/getCoursePushList"})
    @ResponseBody
    public String getCoursePushList(Integer courseId) {
        if (courseId == null) {
            return JsonResult.paramError();
        }
        return this.courseService.getCoursePushList(courseId);
    }

    @RequestMapping(value={"/getCoursePushUserByPage"})
    @ResponseBody
    public String getCoursePushUserByPage(Page<CoursePushUserVo> page, Integer coursePushId, String userName, Integer isSuccess) {
        if (coursePushId == null) {
            return JsonResult.paramError();
        }
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.courseService.getCoursePushUserByPage(user, page, coursePushId, userName, isSuccess);
    }

    @RequestMapping(value={"/getCoursePushNum"})
    @ResponseBody
    public String getCoursePushNum(Integer coursePushId, String userName) {
        if (coursePushId == null) {
            return JsonResult.paramError();
        }
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.courseService.getCoursePushNum(user, coursePushId, userName);
    }

    @RequestMapping(value={"/selectCourseAnalyse"})
    @ResponseBody
    public String selectCourseAnalyse(CourseAnalyseSearchVo vo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (Objects.isNull(user) || Objects.isNull(user.getGroupId())) {
            return JsonResult.error();
        }
        return JsonResult.success((Object)this.courseService.selectCoursePaperAnalyse(vo));
    }

    @RequestMapping(value={"/selectCourseAnalyseByExcel"})
    @ResponseBody
    public String selectCourseAnalyseByExcel(HttpServletResponse response, CourseAnalyseSearchVo vo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (Objects.isNull(user) || Objects.isNull(user.getGroupId())) {
            return JsonResult.error();
        }
        this.courseService.selectCourseAnalyseByExcel(response, vo);
        return JsonResult.success();
    }

    @RequestMapping(value={"/selectIsCoursePower"})
    @ResponseBody
    public String selectIsCoursePower(@RequestBody TrainingCourse trainingCourse) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return JsonResult.success(this.courseService.selectIsCoursePower(trainingCourse.getId(), user));
    }

    @RequestMapping(value={"/selectCourseDirectorConfig"})
    @ResponseBody
    public String selectCourseDirectorConfig() {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (Objects.isNull(user) || Objects.isNull(user.getGroupId())) {
            return JsonResult.error();
        }
        return JsonResult.success(this.trainingCourseConfigService.selectCourseDirectorConfig(user));
    }

    @RequestMapping(value={"/saveCourseDirectorConfig"})
    @ResponseBody
    public String saveCourseDirectorConfig(@RequestBody List<TrainingCourseConfigVo> configVoList) {
        this.trainingCourseConfigService.saveConfig(configVoList);
        return JsonResult.success();
    }

    @RequestMapping(value={"/deleteCourseDirectorConfig"})
    @ResponseBody
    public String deleteCourseDirectorConfig(@RequestParam(value="id") String ids) {
        this.trainingCourseConfigService.deleteConfig(ids);
        return JsonResult.success();
    }

    @RequestMapping(value={"/updateCourseDirectorConfig"})
    @ResponseBody
    public String updateCourseDirectorConfig(TrainingCourseConfig config) {
        this.trainingCourseConfigService.updateConfig(config);
        return JsonResult.success();
    }

    @RequestMapping(value={"/saveReviewDirectorConfig"})
    @ResponseBody
    public String saveReviewDirectorConfig(TrainingReviewHeadConfig config) {
        this.trainingReviewConfigService.saveConfig(config);
        return JsonResult.success();
    }

    @RequestMapping(value={"/selectCourseDirectorCount"})
    @ResponseBody
    public String selectCourseDirectorCount() {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (Objects.isNull(user) || Objects.isNull(user.getGroupId())) {
            return JsonResult.error();
        }
        return JsonResult.success((Object)this.trainingCourseConfigService.selectCourseDirectorCount(user));
    }

    @RequestMapping(value={"/selectReviewDirectorConfig"})
    @ResponseBody
    public String selectReviewDirectorConfig() {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (Objects.isNull(user)) {
            return JsonResult.error();
        }
        return JsonResult.success((Object)this.trainingReviewConfigService.selectReviewDirectorConfig(user));
    }
}

