/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.zother;

import com.alibaba.fastjson.JSON;
import com.ovopark.cloud.log.model.LogPojo;
import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.TrainingExamType;
import com.ovopark.training.model.TrainingQuestionType;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.TrainingExamService;
import com.ovopark.training.util.CommonUtil;
import com.ovopark.training.vo.TrainingExamQuestionVo;
import com.ovopark.training.vo.TrainingExamVo;
import com.ovopark.training.vo.TrainingOptionsVo;
import com.ovopark.training.vo.TrainingPapersVo;
import com.ovopark.training.vo.TrainingQuestionVo;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.io.FileUtils;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Font;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

@Controller
@RequestMapping(value={"/training/exam"})
public class TrainingExamController {
    private static final Logger log = LoggerFactory.getLogger(TrainingExamController.class);
    @Autowired
    private TrainingExamService examService;
    @Autowired
    private MessageSource messageSource;

    @RequestMapping(value={"/selectExamByPage"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectExamByPage(Page<TrainingExamVo> page, Integer typeId, String name, String creaters, String startTime, String endTime, Integer status) {
        List creater;
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            creater = null;
            if (!StringUtils.isEmpty((Object)creaters)) {
                String[] createrStr = creaters.split(",");
                List<String> createrS = Arrays.asList(createrStr);
                creater = createrS.stream().map(Integer::parseInt).collect(Collectors.toList());
            }
        } else {
            return "INVALID_TOKEN";
        }
        page = this.examService.selectExamByPage(page, user.getGroupId(), typeId, name, creater, startTime, endTime, status);
        return JsonResult.success(page);
    }

    @RequestMapping(value={"/insertExam"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String insertExam(@RequestBody TrainingExamVo exam) {
        Integer id = 0;
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                if (exam.getId() == null) {
                    exam.setEnterpriseId(user.getGroupId());
                    exam.setCreater(user.getId());
                    exam.setCreateTime(new Date());
                }
            } else {
                return "INVALID_TOKEN";
            }
            exam.setOriginalStatus(exam.getStatus());
            id = this.examService.insertExam(exam);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success((Object)id);
    }

    @RequestMapping(value={"/selectRandomQuestion"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectRandomQuestion(@RequestBody TrainingExamVo exam) {
        List<Object> questionList = new ArrayList();
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            exam.setEnterpriseId(user.getGroupId());
            exam.setCreater(user.getId());
            exam.setCreateTime(new Date());
            questionList = this.examService.selectRandomQuestion(exam);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success(questionList);
    }

    @RequestMapping(value={"/updateExam"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String updateExam(@RequestBody TrainingExamVo exam) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                if (exam != null && exam.getStatus() == 2) {
                    exam.setArchiverId(user.getId());
                    exam.setArchiveTime(new Date());
                } else {
                    exam.setOriginalStatus(exam.getStatus());
                }
            } else {
                return "INVALID_TOKEN";
            }
            this.examService.updateExam(exam);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success();
    }

    @RequestMapping(value={"/selectPaperExam"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectPaperExam(Integer examId) {
        Map paper = new HashMap();
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            paper = this.examService.selectPaperExam(examId);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success(paper);
    }

    @RequestMapping(value={"/deleteExam"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String deleteExam(HttpServletRequest req, @RequestBody TrainingExamVo exam) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                LogPojo pojo = new LogPojo();
                pojo.setUserId(user.getId());
                pojo.setOperation("paper_delete");
                pojo.setCreateTime(new Date());
                pojo.setRemoteIp(req.getRemoteAddr());
                pojo.setEnterpriseId(user.getGroupId());
                pojo.setUserName(user.getUserName());
                pojo.setI18nKey("operation.paper_delete.description");
                pojo.setPlatform(CommonUtil.getTerminalByToken(req));
                return this.examService.deleteExam(exam.getId(), pojo);
            }
            return "INVALID_TOKEN";
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
    }

    @RequestMapping(value={"/selectExamQuestion"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectExamQuestion(@RequestBody TrainingExamVo exam) {
        List<Object> questionList = new ArrayList();
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null) {
                return "INVALID_TOKEN";
            }
            questionList = this.examService.selectExamQuestion(exam.getId());
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return JsonResult.success(questionList);
    }

    @RequestMapping(value={"/selectRandomType"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectRandomType(@RequestBody TrainingExamVo exam) {
        List<Object> list = new ArrayList();
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null) {
                return "INVALID_TOKEN";
            }
            list = this.examService.selectRandomType(user, exam.getId());
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return JsonResult.success(list);
    }

    @RequestMapping(value={"/selectQuestionTypeId"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectQuestionTypeId(@RequestBody Map<String, Object> param) {
        List<Object> typeList = new ArrayList();
        List questionTypes = JSON.parseArray((String)JSON.toJSONString((Object)param.get("questionTypes")), TrainingQuestionType.class);
        Integer materialId = (Integer)param.get("materialId");
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            List<Integer> typeIds = null;
            String title = null;
            if (!CollectionUtils.isEmpty((Collection)questionTypes)) {
                typeIds = questionTypes.stream().map(TrainingQuestionType::getId).collect(Collectors.toList());
                typeIds.removeAll(Collections.singleton(null));
                title = ((TrainingQuestionType)questionTypes.get(0)).getTitle();
            }
            if (user == null) {
                return "INVALID_TOKEN";
            }
            typeList = this.examService.selectQuestionTypeId(user.getGroupId(), typeIds, title, materialId);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return JsonResult.success(typeList);
    }

    @RequestMapping(value={"/selectQuestionType"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectQuestionType(@RequestBody List<TrainingQuestionType> questionTypes) {
        List<Object> typeList = new ArrayList();
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            List<Integer> typeIds = null;
            if (!CollectionUtils.isEmpty(questionTypes)) {
                typeIds = questionTypes.stream().map(TrainingQuestionType::getId).collect(Collectors.toList());
            }
            if (user == null) {
                return "INVALID_TOKEN";
            }
            typeList = this.examService.selectQuestionType(user.getGroupId(), typeIds);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return JsonResult.success(typeList);
    }

    @RequestMapping(value={"/selectQuestionListByPage"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectQuestionListByPage(Page<TrainingQuestionVo> page, String typeId, String questionName, String questionType, Integer isNotType) {
        try {
            List questionTypes;
            List typeIds;
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                typeIds = null;
                if (typeId != null && !"".equals(typeId)) {
                    String[] typeStr = typeId.split(",");
                    List<String> types = Arrays.asList(typeStr);
                    typeIds = types.stream().map(Integer::parseInt).collect(Collectors.toList());
                }
                questionTypes = null;
                if (questionType != null && !"".equals(questionType)) {
                    String[] questionTypeStr = questionType.split(",");
                    List<String> types = Arrays.asList(questionTypeStr);
                    questionTypes = types.stream().map(Integer::parseInt).collect(Collectors.toList());
                }
            } else {
                return "INVALID_TOKEN";
            }
            page = this.examService.selectQuestionListByPage(page, user.getGroupId(), typeIds, questionName, questionTypes, isNotType);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return JsonResult.success(page);
    }

    @RequestMapping(value={"/selectQuestionById"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectQuestionById(@RequestBody List<TrainingQuestionVo> questionVo) {
        List<TrainingQuestionVo> trainingQuestionVo = null;
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            trainingQuestionVo = this.examService.selectQuestionById(questionVo);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return JsonResult.success(trainingQuestionVo);
    }

    @RequestMapping(value={"/selectExamType"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectExamType(TrainingExamType examType) {
        List<TrainingExamType> examTypeList = null;
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                if (examType == null) {
                    return "EMPTY_COMMENTER";
                }
            } else {
                return "INVALID_TOKEN";
            }
            examType.setEnterpriseId(user.getGroupId());
            examTypeList = this.examService.selectExamType(examType);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success(examTypeList);
    }

    @RequestMapping(value={"/insertExamType"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String insertExamType(TrainingExamType examType) {
        block5: {
            try {
                Users user = Authenticator.getInstance().getCurrentUser();
                if (user != null && user.getId() != null) {
                    if (examType != null) {
                        examType.setEnterpriseId(user.getGroupId());
                        examType.setCreater(user.getId());
                        examType.setCreateTime(new Date());
                        Map map = this.examService.insertExamType(examType);
                        String isNum = map.get("isNum").toString();
                        examType = (TrainingExamType)map.get("examType");
                        if ("0".equals(isNum)) {
                            return JsonResult.error((String)"\u5b58\u5728\u76f8\u540c\u7c7b\u578b\u540d\u79f0", null);
                        }
                        break block5;
                    }
                    return "EMPTY_COMMENTER";
                }
                return "INVALID_TOKEN";
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
                return "EXCEPTION";
            }
        }
        return JsonResult.success((Object)examType);
    }

    @RequestMapping(value={"/deleteExamType"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String deleteExamType(Integer id) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            this.examService.deleteExamType(id);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success();
    }

    public MultipartFile getMultipartFile(File file) {
        DiskFileItem item = new DiskFileItem("file", "multipart/form-data", true, file.getName(), (int)file.length(), file.getParentFile());
        try {
            OutputStream os = item.getOutputStream();
            os.write(FileUtils.readFileToByteArray((File)file));
        }
        catch (IOException e) {
            log.error("\u9898\u5e93\u5bfc\u51fa\u8f6c\u6362\u8868\u683c\u5f02\u5e38\uff1a", (Throwable)e);
        }
        return new CommonsMultipartFile((FileItem)item);
    }

    private String userSelect(Integer s) {
        String select = "";
        switch (s) {
            case 0: {
                select = "A";
                break;
            }
            case 1: {
                select = "B";
                break;
            }
            case 2: {
                select = "C";
                break;
            }
            case 3: {
                select = "D";
                break;
            }
            case 4: {
                select = "E";
                break;
            }
            case 5: {
                select = "F";
                break;
            }
            case 6: {
                select = "G";
                break;
            }
            case 7: {
                select = "H";
                break;
            }
            case 8: {
                select = "I";
                break;
            }
            case 9: {
                select = "J";
                break;
            }
        }
        return select;
    }

    @RequestMapping(value={"/selectQuestionsByExecl"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectQuestionsByExecl(HttpServletResponse response, String questionIds, Integer typeId, Integer isAll, Integer isNotType, Integer enterpriseId) {
        try {
            int m;
            String answer;
            List optionsVos;
            TrainingQuestionVo vo;
            int i;
            Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
            List<Integer> questionIdList = new ArrayList<Integer>();
            if (!StringUtils.isEmpty((Object)questionIds)) {
                questionIdList = Arrays.stream(questionIds.split(",")).map(Integer::parseInt).collect(Collectors.toList());
            }
            Map<Integer, List<TrainingQuestionVo>> questionMap = this.examService.selectQuestionsByExecl(questionIdList, typeId, isAll, isNotType, enterpriseId);
            List<TrainingQuestionVo> list1 = questionMap.get(0);
            List<TrainingQuestionVo> list2 = questionMap.get(3);
            List<TrainingQuestionVo> list3 = questionMap.get(4);
            List<TrainingQuestionVo> list4 = questionMap.get(2);
            List<TrainingQuestionVo> list5 = questionMap.get(1);
            List<TrainingQuestionVo> list6 = questionMap.get(5);
            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFSheet sheet1 = wb.createSheet(this.messageSource.getMessage("training.user.details.singleChoiceQuestion", null, locale));
            HSSFSheet sheet2 = wb.createSheet(this.messageSource.getMessage("training.user.details.multipleChoiceQuestion", null, locale));
            HSSFSheet sheet3 = wb.createSheet(this.messageSource.getMessage("training.user.details.trueOrFalseQuestions", null, locale));
            HSSFSheet sheet4 = wb.createSheet(this.messageSource.getMessage("training.user.details.fillBlankQuestion", null, locale));
            HSSFSheet sheet5 = wb.createSheet(this.messageSource.getMessage("training.user.details.essayQuestion", null, locale));
            HSSFSheet sheet6 = wb.createSheet(this.messageSource.getMessage("training.user.details.opertate", null, locale));
            HSSFCellStyle titleSty = wb.createCellStyle();
            HSSFFont font = wb.createFont();
            font.setFontHeightInPoints((short)16);
            titleSty.setFont((Font)font);
            HSSFRow row = sheet1.createRow(0);
            row.createCell(0).setCellValue(this.messageSource.getMessage("training.question.content", null, locale));
            row.createCell(1).setCellValue(this.messageSource.getMessage("training.user.subject.bank", null, locale));
            row.createCell(2).setCellValue(this.messageSource.getMessage("training.answer.not.null", null, locale));
            row.createCell(3).setCellValue(this.messageSource.getMessage("training.exam.answer.explain", null, locale));
            row.createCell(4).setCellValue(this.messageSource.getMessage("training.user.details.option", null, locale) + "A");
            row.createCell(5).setCellValue(this.messageSource.getMessage("training.user.details.option", null, locale) + "B");
            row.createCell(6).setCellValue(this.messageSource.getMessage("training.user.details.option", null, locale) + "C");
            row.createCell(7).setCellValue(this.messageSource.getMessage("training.user.details.option", null, locale) + "D");
            row.createCell(8).setCellValue(this.messageSource.getMessage("training.user.details.option", null, locale) + "E");
            row.createCell(9).setCellValue(this.messageSource.getMessage("training.user.details.option", null, locale) + "F");
            row.createCell(10).setCellValue(this.messageSource.getMessage("training.user.details.option", null, locale) + "G");
            row.createCell(11).setCellValue(this.messageSource.getMessage("training.user.details.option", null, locale) + "H");
            row.createCell(12).setCellValue(this.messageSource.getMessage("training.user.details.option", null, locale) + "I");
            row.createCell(13).setCellValue(this.messageSource.getMessage("training.user.details.option", null, locale) + "J");
            if (!CollectionUtils.isEmpty(list1)) {
                for (i = 0; i < list1.size(); ++i) {
                    row = sheet1.createRow(i + 1);
                    vo = list1.get(i);
                    row.createCell(0).setCellValue(vo.getName() + "\n" + (StringUtils.isEmpty((Object)vo.getPicturePath()) ? "" : vo.getPicturePath()));
                    row.createCell(1).setCellValue(vo.getTypeName());
                    optionsVos = vo.getOptionsList();
                    answer = "";
                    if (!CollectionUtils.isEmpty((Collection)optionsVos)) {
                        for (m = 0; m < optionsVos.size(); ++m) {
                            if (StringUtils.isEmpty(optionsVos.get(m)) || ((TrainingOptionsVo)optionsVos.get(m)).getIsAnswer() != 1) continue;
                            answer = this.userSelect(m);
                            break;
                        }
                    }
                    row.createCell(2).setCellValue(answer);
                    row.createCell(3).setCellValue(vo.getRemark());
                    if (CollectionUtils.isEmpty((Collection)optionsVos)) continue;
                    for (m = 0; m < optionsVos.size(); ++m) {
                        if (StringUtils.isEmpty(optionsVos.get(m))) continue;
                        row.createCell(m + 4).setCellValue(((TrainingOptionsVo)optionsVos.get(m)).getOptionsName() + "\n" + (StringUtils.isEmpty((Object)((TrainingOptionsVo)optionsVos.get(m)).getPicturePath()) ? "" : ((TrainingOptionsVo)optionsVos.get(m)).getPicturePath()));
                    }
                }
            }
            row = sheet2.createRow(0);
            row.createCell(0).setCellValue(this.messageSource.getMessage("training.question.content", null, locale));
            row.createCell(1).setCellValue(this.messageSource.getMessage("training.user.subject.bank", null, locale));
            row.createCell(2).setCellValue(this.messageSource.getMessage("training.answer.not.null", null, locale));
            row.createCell(3).setCellValue(this.messageSource.getMessage("training.exam.answer.explain", null, locale));
            row.createCell(4).setCellValue(this.messageSource.getMessage("training.user.details.option", null, locale) + "A");
            row.createCell(5).setCellValue(this.messageSource.getMessage("training.user.details.option", null, locale) + "B");
            row.createCell(6).setCellValue(this.messageSource.getMessage("training.user.details.option", null, locale) + "C");
            row.createCell(7).setCellValue(this.messageSource.getMessage("training.user.details.option", null, locale) + "D");
            row.createCell(8).setCellValue(this.messageSource.getMessage("training.user.details.option", null, locale) + "E");
            row.createCell(9).setCellValue(this.messageSource.getMessage("training.user.details.option", null, locale) + "F");
            row.createCell(10).setCellValue(this.messageSource.getMessage("training.user.details.option", null, locale) + "G");
            row.createCell(11).setCellValue(this.messageSource.getMessage("training.user.details.option", null, locale) + "H");
            row.createCell(12).setCellValue(this.messageSource.getMessage("training.user.details.option", null, locale) + "I");
            row.createCell(13).setCellValue(this.messageSource.getMessage("training.user.details.option", null, locale) + "J");
            if (!CollectionUtils.isEmpty(list2)) {
                for (i = 0; i < list2.size(); ++i) {
                    row = sheet2.createRow(i + 1);
                    vo = list2.get(i);
                    row.createCell(0).setCellValue(vo.getName() + "\n" + (StringUtils.isEmpty((Object)vo.getPicturePath()) ? "" : vo.getPicturePath()));
                    row.createCell(1).setCellValue(vo.getTypeName());
                    optionsVos = vo.getOptionsList();
                    answer = "";
                    if (!CollectionUtils.isEmpty((Collection)optionsVos)) {
                        for (m = 0; m < optionsVos.size(); ++m) {
                            if (StringUtils.isEmpty(optionsVos.get(m)) || ((TrainingOptionsVo)optionsVos.get(m)).getIsAnswer() != 1) continue;
                            answer = "".equals(answer) ? this.userSelect(m) : answer + this.userSelect(m);
                        }
                    }
                    row.createCell(2).setCellValue(answer);
                    row.createCell(3).setCellValue(vo.getRemark());
                    if (CollectionUtils.isEmpty((Collection)optionsVos)) continue;
                    for (m = 0; m < optionsVos.size(); ++m) {
                        if (StringUtils.isEmpty(optionsVos.get(m))) continue;
                        row.createCell(m + 4).setCellValue(((TrainingOptionsVo)optionsVos.get(m)).getOptionsName() + "\n" + (StringUtils.isEmpty((Object)((TrainingOptionsVo)optionsVos.get(m)).getPicturePath()) ? "" : ((TrainingOptionsVo)optionsVos.get(m)).getPicturePath()));
                    }
                }
            }
            row = sheet3.createRow(0);
            row.createCell(0).setCellValue(this.messageSource.getMessage("training.question.content", null, locale));
            row.createCell(1).setCellValue(this.messageSource.getMessage("training.user.subject.bank", null, locale));
            row.createCell(2).setCellValue(this.messageSource.getMessage("training.answer.not.null", null, locale));
            row.createCell(3).setCellValue(this.messageSource.getMessage("training.exam.answer.explain", null, locale));
            row.createCell(4).setCellValue(this.messageSource.getMessage("training.user.details.option", null, locale) + "A");
            row.createCell(5).setCellValue(this.messageSource.getMessage("training.user.details.option", null, locale) + "B");
            if (!CollectionUtils.isEmpty(list3)) {
                for (i = 0; i < list3.size(); ++i) {
                    row = sheet3.createRow(i + 1);
                    vo = list3.get(i);
                    row.createCell(0).setCellValue(vo.getName() + "\n" + (StringUtils.isEmpty((Object)vo.getPicturePath()) ? "" : vo.getPicturePath()));
                    row.createCell(1).setCellValue(vo.getTypeName());
                    String answer2 = "";
                    if (!StringUtils.isEmpty((Object)vo.getIsCorrect())) {
                        answer2 = vo.getIsCorrect() == 1 ? "A" : "B";
                    }
                    row.createCell(2).setCellValue(answer2);
                    row.createCell(3).setCellValue(vo.getRemark());
                    row.createCell(4).setCellValue(this.messageSource.getMessage("training.exam.right", null, locale));
                    row.createCell(5).setCellValue(this.messageSource.getMessage("training.exam.error", null, locale));
                }
            }
            row = sheet4.createRow(0);
            row.createCell(0).setCellValue(this.messageSource.getMessage("training.question.content", null, locale));
            row.createCell(1).setCellValue(this.messageSource.getMessage("training.user.subject.bank", null, locale));
            row.createCell(2).setCellValue(this.messageSource.getMessage("training.exam.answer.explain", null, locale));
            row.createCell(3).setCellValue(this.messageSource.getMessage("training.user.details.gap.filling", null, locale) + "1");
            row.createCell(4).setCellValue(this.messageSource.getMessage("training.user.details.gap.filling", null, locale) + "2");
            row.createCell(5).setCellValue(this.messageSource.getMessage("training.user.details.gap.filling", null, locale) + "3");
            row.createCell(6).setCellValue(this.messageSource.getMessage("training.user.details.gap.filling", null, locale) + "4");
            row.createCell(7).setCellValue(this.messageSource.getMessage("training.user.details.gap.filling", null, locale) + "5");
            row.createCell(8).setCellValue(this.messageSource.getMessage("training.user.details.gap.filling", null, locale) + "6");
            row.createCell(9).setCellValue(this.messageSource.getMessage("training.user.details.gap.filling", null, locale) + "7");
            row.createCell(10).setCellValue(this.messageSource.getMessage("training.user.details.gap.filling", null, locale) + "8");
            row.createCell(11).setCellValue(this.messageSource.getMessage("training.user.details.gap.filling", null, locale) + "9");
            row.createCell(12).setCellValue(this.messageSource.getMessage("training.user.details.gap.filling", null, locale) + "10");
            row.createCell(13).setCellValue(this.messageSource.getMessage("training.user.details.gap.filling", null, locale) + "11");
            row.createCell(14).setCellValue(this.messageSource.getMessage("training.user.details.gap.filling", null, locale) + "12");
            row.createCell(15).setCellValue(this.messageSource.getMessage("training.user.details.gap.filling", null, locale) + "13");
            row.createCell(16).setCellValue(this.messageSource.getMessage("training.user.details.gap.filling", null, locale) + "14");
            row.createCell(17).setCellValue(this.messageSource.getMessage("training.user.details.gap.filling", null, locale) + "15");
            row.createCell(18).setCellValue(this.messageSource.getMessage("training.user.details.gap.filling", null, locale) + "16");
            row.createCell(19).setCellValue(this.messageSource.getMessage("training.user.details.gap.filling", null, locale) + "17");
            row.createCell(20).setCellValue(this.messageSource.getMessage("training.user.details.gap.filling", null, locale) + "18");
            row.createCell(21).setCellValue(this.messageSource.getMessage("training.user.details.gap.filling", null, locale) + "19");
            row.createCell(22).setCellValue(this.messageSource.getMessage("training.user.details.gap.filling", null, locale) + "20");
            if (!CollectionUtils.isEmpty(list4)) {
                for (i = 0; i < list4.size(); ++i) {
                    row = sheet4.createRow(i + 1);
                    vo = list4.get(i);
                    row.createCell(0).setCellValue(vo.getName() + "\n" + (StringUtils.isEmpty((Object)vo.getPicturePath()) ? "" : vo.getPicturePath()));
                    row.createCell(1).setCellValue(vo.getTypeName());
                    optionsVos = vo.getOptionsList();
                    row.createCell(2).setCellValue(vo.getRemark());
                    if (CollectionUtils.isEmpty((Collection)optionsVos)) continue;
                    for (int m2 = 0; m2 < optionsVos.size(); ++m2) {
                        if (StringUtils.isEmpty(optionsVos.get(m2))) continue;
                        row.createCell(m2 + 3).setCellValue(((TrainingOptionsVo)optionsVos.get(m2)).getOptionsName() + "\n" + (StringUtils.isEmpty((Object)((TrainingOptionsVo)optionsVos.get(m2)).getPicturePath()) ? "" : ((TrainingOptionsVo)optionsVos.get(m2)).getPicturePath()));
                    }
                }
            }
            row = sheet5.createRow(0);
            row.createCell(0).setCellValue(this.messageSource.getMessage("training.question.content", null, locale));
            row.createCell(1).setCellValue(this.messageSource.getMessage("training.user.subject.bank", null, locale));
            row.createCell(2).setCellValue(this.messageSource.getMessage("training.exam.answer.explain", null, locale));
            if (!CollectionUtils.isEmpty(list5)) {
                for (i = 0; i < list5.size(); ++i) {
                    row = sheet5.createRow(i + 1);
                    vo = list5.get(i);
                    row.createCell(0).setCellValue(vo.getName() + "\n" + (StringUtils.isEmpty((Object)vo.getPicturePath()) ? "" : vo.getPicturePath()));
                    row.createCell(1).setCellValue(vo.getTypeName());
                    row.createCell(2).setCellValue(vo.getRemark());
                }
            }
            row = sheet6.createRow(0);
            row.createCell(0).setCellValue(this.messageSource.getMessage("training.question.content", null, locale));
            row.createCell(1).setCellValue(this.messageSource.getMessage("training.user.subject.bank", null, locale));
            row.createCell(2).setCellValue(this.messageSource.getMessage("training.user.executive.standard", null, locale));
            if (!CollectionUtils.isEmpty(list6)) {
                for (i = 0; i < list6.size(); ++i) {
                    row = sheet6.createRow(i + 1);
                    vo = list6.get(i);
                    row.createCell(0).setCellValue(vo.getName() + "\n" + (StringUtils.isEmpty((Object)vo.getPicturePath()) ? "" : vo.getPicturePath()));
                    row.createCell(1).setCellValue(vo.getTypeName());
                    row.createCell(2).setCellValue(vo.getRemark());
                }
            }
            response.setContentType("application/vnd.ms-excel; charset=utf-8");
            response.setHeader("Content-Disposition", "attachment; filename=\u8bd5\u9898\u5bfc\u51fa.xls");
            ServletOutputStream out = response.getOutputStream();
            wb.write((OutputStream)out);
            out.flush();
            out.close();
            wb.close();
            return JsonResult.success();
        }
        catch (Exception e) {
            log.info("selectQuestionsByExecl: " + e);
            return JsonResult.error();
        }
    }

    @RequestMapping(value={"/selectExamPaperByPage"})
    @ResponseBody
    public String selectExamPaperByPage(Page<TrainingPapersVo> page, Integer questionId, String paperName) {
        Users user = Authenticator.getInstance().getCurrentUser();
        page = this.examService.selectExamPaperByPage(page, questionId, paperName, user);
        return JsonResult.success(page);
    }

    @RequestMapping(value={"/updateExamQuestion"})
    @ResponseBody
    public String updateExamQuestion(@RequestBody List<TrainingExamQuestionVo> examQuestionVoList) {
        Users user = Authenticator.getInstance().getCurrentUser();
        this.examService.updateExamQuestion(examQuestionVoList, user);
        return JsonResult.success();
    }
}

