/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.zother;

import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.TrainingJobExcelService;
import com.ovopark.training.util.DateUtils;
import com.ovopark.training.vo.TrainingJobCertificationVo;
import com.ovopark.training.vo.TrainingJobStageTaskVo;
import com.ovopark.training.vo.TrainingJobStudentAnalyseVo;
import com.ovopark.training.vo.TrainingJobUserTaskVo;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Font;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/training/jobExecl"})
public class TrainingJobExcelController {
    private static final Logger log = LoggerFactory.getLogger(TrainingJobExcelController.class);
    @Autowired
    private TrainingJobExcelService jobExcelService;
    @Autowired
    private MessageSource messageSource;

    @PostMapping(value={"/selectJobStudentDetailByPage"})
    @ResponseBody
    public String selectJobStudentDetailByPage(@RequestBody TrainingJobStudentAnalyseVo vo) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            Page<TrainingJobStudentAnalyseVo> list = this.jobExcelService.selectJobStudentDetailByPage(vo, user);
            return JsonResult.success(list);
        }
        catch (Exception e) {
            log.error("selectJobStudentDetail", (Throwable)e);
            return "EXCEPTION";
        }
    }

    @PostMapping(value={"/selectJobStudentDetailByExecl"})
    @ResponseBody
    public String selectJobStudentDetailByExecl(HttpServletResponse response, @RequestBody TrainingJobStudentAnalyseVo vo) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            List<TrainingJobStudentAnalyseVo> list = this.jobExcelService.selectJobStudentDetail(vo, user);
            Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
            String employeeNumber = this.messageSource.getMessage("training.user.details.employeeNumber", null, locale);
            String postName = this.messageSource.getMessage("training.job.post.name", null, locale);
            String department = this.messageSource.getMessage("training.course.analysis.department", null, locale);
            String studyStatus = this.messageSource.getMessage("training.course.analysis.study.status", null, locale);
            String passStatusNames = this.messageSource.getMessage("training.shift.pass.status", null, locale);
            String unStart = this.messageSource.getMessage("training.course.status.unstart", null, locale);
            String going = this.messageSource.getMessage("training.job.status.going", null, locale);
            String completed = this.messageSource.getMessage("training.job.status.completed", null, locale);
            String passName = this.messageSource.getMessage("training.learn.pass", null, locale);
            String unPassName = this.messageSource.getMessage("training.learn.unpass", null, locale);
            String unapproveName = this.messageSource.getMessage("training.job.unapprove", null, locale);
            HSSFWorkbook wb = new HSSFWorkbook();
            String nameStr = DateUtils.format(new Date(), "yyyyMMdd");
            HSSFSheet sheet = wb.createSheet(this.messageSource.getMessage("training.job.student.detail", null, locale) + "_" + nameStr);
            HSSFCellStyle titleSty = wb.createCellStyle();
            HSSFFont font = wb.createFont();
            font.setFontHeightInPoints((short)16);
            titleSty.setFont((Font)font);
            HSSFRow row = sheet.createRow(0);
            row.createCell(0).setCellValue(this.messageSource.getMessage("training.course.trainee.name", null, locale));
            row.createCell(1).setCellValue(employeeNumber);
            row.createCell(2).setCellValue(postName);
            row.createCell(3).setCellValue(department);
            row.createCell(4).setCellValue(this.messageSource.getMessage("training.course.analysis.starttime", null, locale));
            row.createCell(5).setCellValue(this.messageSource.getMessage("training.course.analysis.endtime", null, locale));
            row.createCell(6).setCellValue(studyStatus);
            row.createCell(7).setCellValue(this.messageSource.getMessage("training.job.online.paper.avgscore", null, locale));
            row.createCell(8).setCellValue(this.messageSource.getMessage("training.job.offline.paper.avgscore", null, locale));
            row.createCell(9).setCellValue(passStatusNames);
            row.createCell(10).setCellValue(this.messageSource.getMessage("training.job.auth.name", null, locale));
            row.createCell(11).setCellValue(this.messageSource.getMessage("training.job.map", null, locale));
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            for (int i = 0; i < list.size(); ++i) {
                row = sheet.createRow(i + 1);
                TrainingJobStudentAnalyseVo vos = list.get(i);
                row.createCell(0).setCellValue(vos.getUserName());
                row.createCell(1).setCellValue(vos.getEmployeeNumber());
                row.createCell(2).setCellValue(vos.getDutiesName());
                row.createCell(3).setCellValue(vos.getOrganizeName());
                row.createCell(4).setCellValue(vos.getStartTime() == null ? "" : format.format(vos.getStartTime()));
                row.createCell(5).setCellValue(vos.getEndTime() == null ? "-" : format.format(vos.getEndTime()));
                String learnStatusName = "-";
                if (!StringUtils.isEmpty((Object)vos.getLearnStatus())) {
                    if (vos.getLearnStatus() == 1) {
                        learnStatusName = unStart + vos.getFinishTask() + "/" + vos.getLearnTask();
                    } else if (vos.getLearnStatus() == 2) {
                        learnStatusName = going + " " + vos.getFinishTask() + "/" + vos.getLearnTask();
                    } else if (vos.getLearnStatus() == 3) {
                        learnStatusName = completed + " " + vos.getFinishTask() + "/" + vos.getLearnTask();
                    } else if (vos.getLearnStatus() == 4) {
                        learnStatusName = unapproveName + " " + vos.getFinishTask() + "/" + vos.getLearnTask();
                    }
                }
                row.createCell(6).setCellValue(learnStatusName);
                row.createCell(7).setCellValue(vos.getXsScore() == null ? "-" : vos.getXsScore().toString());
                row.createCell(8).setCellValue(vos.getXxScore() == null ? "-" : vos.getXxScore().toString());
                String passStatusName = "-";
                if (!StringUtils.isEmpty((Object)vos.getPassStatus())) {
                    passStatusName = vos.getPassStatus() == 1 ? this.messageSource.getMessage("training.job.unapprove", null, locale) : (vos.getPassStatus() == 2 ? unPassName : (vos.getPassStatus() == 3 ? passName + " " : "-"));
                }
                row.createCell(9).setCellValue(passStatusName);
                row.createCell(10).setCellValue(vos.getCertificationName());
                row.createCell(11).setCellValue(StringUtils.isEmpty((Object)vos.getMapName()) ? "-" : vos.getMapName());
            }
            response.setContentType("application/vnd.ms-excel; charset=utf-8");
            response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(this.messageSource.getMessage("training.job.student.detail", null, locale) + "_" + nameStr + ".xls", "UTF-8"));
            ServletOutputStream out = response.getOutputStream();
            wb.write((OutputStream)out);
            out.flush();
            out.close();
            wb.close();
            return JsonResult.success();
        }
        catch (Exception e) {
            log.error("selectJobStudentDetailByExecl", (Throwable)e);
            return "EXCEPTION";
        }
    }

    @PostMapping(value={"/selectJobList"})
    @ResponseBody
    public String selectJobList(Integer type) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            List list = this.jobExcelService.selectJobList(type, user);
            return JsonResult.success((Object)list);
        }
        catch (Exception e) {
            log.error("selectJobList", (Throwable)e);
            return "EXCEPTION";
        }
    }

    @PostMapping(value={"/selectJobOrganizeStudentByPage"})
    @ResponseBody
    public String selectJobOrganizeStudentByPage(Page<TrainingJobStageTaskVo> page, Integer mapId, Integer certificationId, Integer taskId) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            Page<TrainingJobStageTaskVo> list = this.jobExcelService.selectJobOrganizeStudentByPage(page, user, mapId, certificationId, taskId);
            return JsonResult.success(list);
        }
        catch (Exception e) {
            log.error("selectJobOrganizeStudentByPage", (Throwable)e);
            return "EXCEPTION";
        }
    }

    @PostMapping(value={"/selectOrganizeStudentByPage"})
    @ResponseBody
    public String selectOrganizeStudentByPage(Page<TrainingJobUserTaskVo> page, Integer jobId, String userName, Integer id) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            Page<TrainingJobUserTaskVo> list = this.jobExcelService.selectOrganizeStudentByPage(page, user, jobId, userName, id);
            return JsonResult.success(list);
        }
        catch (Exception e) {
            log.error("selectOrganizeStudentByPage", (Throwable)e);
            return "EXCEPTION";
        }
    }

    @PostMapping(value={"/importJobMainData"})
    @ResponseBody
    public String importJobMainData(@RequestParam(value="file") MultipartFile file, Integer enterpriseId) throws Exception {
        List<Map> result = this.jobExcelService.importJobMainData(file, enterpriseId);
        return JsonResult.success(result);
    }

    @PostMapping(value={"/importJobMaterialData"})
    @ResponseBody
    public String importJobMaterialData(@RequestParam(value="file") MultipartFile file, Integer enterpriseId) throws Exception {
        List<Map> result = this.jobExcelService.importJobMaterialData(file, enterpriseId);
        return JsonResult.success(result);
    }

    @PostMapping(value={"/importJobPaperData"})
    @ResponseBody
    public String importJobPaperData(@RequestParam(value="file") MultipartFile file, Integer enterpriseId) throws Exception {
        List<Map> result = this.jobExcelService.importJobPaperData(file, enterpriseId);
        return JsonResult.success(result);
    }

    @PostMapping(value={"/importJobShiftData"})
    @ResponseBody
    public String importJobShiftData(@RequestParam(value="file") MultipartFile file, Integer enterpriseId) throws Exception {
        List<Map> result = this.jobExcelService.importJobShiftData(file, enterpriseId);
        return JsonResult.success(result);
    }

    @PostMapping(value={"/importJobDataPush"})
    @ResponseBody
    public String importJobDataPush(@RequestParam(value="file") MultipartFile file, Integer enterpriseId) throws Exception {
        List<Map> result = this.jobExcelService.importJobDataPush(file, enterpriseId);
        return JsonResult.success(result);
    }

    @PostMapping(value={"/selectJobByPage"})
    @ResponseBody
    public String selectJobByPage(Page<TrainingJobCertificationVo> page, String certificationName) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return JsonResult.success(this.jobExcelService.selectJobByPage(page, certificationName, user));
    }

    @PostMapping(value={"/selectUserJobDetailByPage"})
    @ResponseBody
    public String selectUserJobDetailByPage(@RequestBody TrainingJobStudentAnalyseVo vo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        Page<TrainingJobStudentAnalyseVo> list = this.jobExcelService.selectUserJobDetailByPage(vo, user);
        return JsonResult.success(list);
    }
}

