/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.zother;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ovopark.cloud.log.model.LogPojo;
import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.TrainingAppShow;
import com.ovopark.training.model.TrainingJobMapAndCertification;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.TrainingJobMapService;
import com.ovopark.training.util.CommonUtil;
import com.ovopark.training.util.DateUtils;
import com.ovopark.training.vo.TrainingJobMapVo;
import com.ovopark.training.vo.TrainingJobStageTaskVo;
import com.ovopark.training.vo.TrainingUserPaperVo;
import java.util.Date;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/training/jobMap"})
public class TrainingJobMapController {
    private static final Logger log = LoggerFactory.getLogger(TrainingJobMapController.class);
    @Resource
    private TrainingJobMapService trainingJobMapService;

    @RequestMapping(value={"/saveTrainingMap"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String saveTrainingMap(@RequestBody TrainingJobMapVo jobMap) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (this.trainingJobMapService.mapNameIsUse(jobMap, user)) {
            return JsonResult.error((String)"NAME_EXISTING", null);
        }
        this.trainingJobMapService.saveTrainingMap(jobMap, user);
        return JsonResult.success();
    }

    @RequestMapping(value={"/getTrainingMaps"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String getTrainingMaps(long size, long current, String name, Integer state) {
        Users user = Authenticator.getInstance().getCurrentUser();
        Page page = new Page();
        page.setSize(size);
        page.setCurrent(current);
        return JsonResult.success(this.trainingJobMapService.getTrainingMaps((IPage<TrainingJobMapVo>)page, name, state, user));
    }

    @RequestMapping(value={"/updateTrainingState"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String updateTrainingState(HttpServletRequest req, Integer id, Integer state) {
        Users user = Authenticator.getInstance().getCurrentUser();
        LogPojo pojo = new LogPojo();
        pojo.setUserId(user.getId());
        pojo.setOperation("job_map_delete");
        pojo.setCreateTime(new Date());
        pojo.setRemoteIp(req.getRemoteAddr());
        pojo.setEnterpriseId(user.getGroupId());
        pojo.setUserName(user.getUserName());
        pojo.setI18nKey("operation.job_map_delete.description");
        pojo.setPlatform(CommonUtil.getTerminalByToken(req));
        return this.trainingJobMapService.updateTrainingState(id, state, pojo);
    }

    @RequestMapping(value={"/getTrainingMapDetail"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String getTrainingMapDetail(Integer id) {
        return JsonResult.success((Object)this.trainingJobMapService.getTrainingMapDetail(id));
    }

    @RequestMapping(value={"/getTrainingMapCertification"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String getTrainingMapCertification(Integer id) {
        return JsonResult.success(this.trainingJobMapService.getTrainingMapCertification(id));
    }

    @RequestMapping(value={"/getMapsByUser"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String getMapsByUser() {
        Users user = Authenticator.getInstance().getCurrentUser();
        return JsonResult.success(this.trainingJobMapService.getMapsByUser(user));
    }

    @RequestMapping(value={"/selectMapsByMapId"})
    @ResponseBody
    public String selectMapsByMapId(@RequestBody TrainingJobMapVo trainingJobMapVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return JsonResult.success((Object)this.trainingJobMapService.selectMapsByMapId(trainingJobMapVo, user));
    }

    @RequestMapping(value={"/getUserCertificationByMapId"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String getUserCertificationByMapId(Integer mapId, Integer userId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return JsonResult.success(this.trainingJobMapService.getUserCertificationByMapId(mapId, userId, user));
    }

    @RequestMapping(value={"/selectJobStagesById"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectJobStagesById(Integer id, String versions) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return JsonResult.success((Object)this.trainingJobMapService.selectJobStagesById(id, user, versions));
    }

    @RequestMapping(value={"/getUserTask"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String getUserTask(Integer id) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return JsonResult.success(this.trainingJobMapService.getUserTask(id, user));
    }

    @RequestMapping(value={"/saveAppProjectShow"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String saveAppProjectShow(@RequestBody TrainingAppShow appShow) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                appShow.setUserId(user.getId());
                appShow.setCreateTime(new Date());
                appShow.setCreater(user.getId());
                appShow.setEnterpriseId(user.getGroupId());
                this.trainingJobMapService.saveAppProjectShow(appShow, user);
                return JsonResult.success();
            }
            return "INVALID_TOKEN";
        }
        catch (Exception e) {
            log.error("saveAppProjectShow: " + e);
            return JsonResult.error();
        }
    }

    @RequestMapping(value={"/getUserAllTaskByPage"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String getUserAllTaskByPage(com.ovopark.training.bo.Page<TrainingJobStageTaskVo> page, Integer taskType, Integer moduleType2, Integer version) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            return JsonResult.success((Object)this.trainingJobMapService.getUserAllTask(page, user, taskType, moduleType2, version));
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/push85Certification"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String push85Certification(Integer userId, String postName, String mapName, String isPass, String passTime) {
        Users user = Authenticator.getInstance().getCurrentUser();
        this.trainingJobMapService.push85Certification(user.getGroupId(), userId, postName, mapName, isPass, DateUtils.parse(passTime, DateUtils.FORMAT_SHORT));
        return JsonResult.success();
    }

    @RequestMapping(value={"/selectPaperCountById"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectPaperCountById(Integer id, Integer sourceType, Integer sourceProjectId, Integer sourceTaskId, Integer sourceShiftId) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                TrainingUserPaperVo userPaper = this.trainingJobMapService.selectPaperCountById(id, sourceType, sourceProjectId, sourceTaskId, sourceShiftId, user);
                return JsonResult.success((Object)userPaper);
            }
            return "INVALID_TOKEN";
        }
        catch (Exception e) {
            log.error("app\u6821\u9a8c\u8003\u8bd5\u662f\u5426\u8003\u8fc7", (Throwable)e);
            return "EXCEPTION";
        }
    }

    @RequestMapping(value={"/selectLastCertificationList"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectLastCertificationList(@RequestBody TrainingJobMapAndCertification job) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                return JsonResult.success(this.trainingJobMapService.selectLastCertificationList(job, user));
            }
            return "INVALID_TOKEN";
        }
        catch (Exception e) {
            log.error("selectLastCertificationList: " + e);
            return JsonResult.error();
        }
    }

    @RequestMapping(value={"/selectIsFinishProject"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectIsFinishProject(Integer taskType, Integer id) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                return JsonResult.success((Object)this.trainingJobMapService.selectIsFinishProject(taskType, id, user));
            }
            return "INVALID_TOKEN";
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return JsonResult.error();
        }
    }
}

