/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.zother;

import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.StudentCountNumber;
import com.ovopark.training.model.TrainingJobExamine;
import com.ovopark.training.model.UsersDutiesPojo;
import com.ovopark.training.service.TrainingJobParticipantsManagementService;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/training/jobStudent"})
public class TrainingJobParticipantsManagementController {
    @Autowired
    private TrainingJobParticipantsManagementService trainingJobParticipantsService;
    @Autowired
    private MessageSource messageSource;

    @GetMapping(value={"queryStudent"}, produces={"text/html;charset=UTF-8"})
    public String queryStudent(@RequestParam(value="groupId", required=true) Integer groupId, @RequestParam(value="jobId", required=true) Integer jobId, @RequestParam(value="shiftTaskId", required=true) Integer shiftTaskId, @RequestParam(value="deptId", required=false) List<String> deptId, @RequestParam(value="state", defaultValue="-1") Integer state, @RequestParam(value="jobOrName", required=false) String jobOrName, @RequestParam(value="pageNumber", defaultValue="1") Integer pageNumber, @RequestParam(value="pageSize", defaultValue="20") Integer pageSize) {
        Page<UsersDutiesPojo> usersDutiesPojoPage = this.trainingJobParticipantsService.queryStudent(groupId, jobId, shiftTaskId, deptId, state, jobOrName, pageNumber, pageSize);
        return JsonResult.success(usersDutiesPojoPage);
    }

    @GetMapping(value={"candidateComponents"}, produces={"text/html;charset=UTF-8"})
    public String candidateComponents(@RequestParam(value="jobId", required=true) Integer jobId, @RequestParam(value="dutiesId", required=true) Integer dutiesId, @RequestParam(value="jobOrName", required=false) String jobOrName, @RequestParam(value="groupId", required=true) Integer groupId, @RequestParam(value="pageNumber", defaultValue="1") Integer pageNumber, @RequestParam(value="pageSize", defaultValue="20") Integer pageSize) {
        Page<UsersDutiesPojo> usersDutiesPojoPage = this.trainingJobParticipantsService.candidateComponents(jobId, dutiesId, jobOrName, groupId, pageNumber, pageSize);
        return JsonResult.success(usersDutiesPojoPage);
    }

    @GetMapping(value={"removeStudent"})
    public String removeStudent(@RequestParam(value="jobId", required=true) Integer jobId, @RequestParam(value="shiftTaskId", required=true) Integer shiftTaskId, @RequestParam(value="studentList", required=true) List<Integer> studentList) {
        Integer integer = this.trainingJobParticipantsService.removeStudent(jobId, shiftTaskId, studentList);
        if (integer == 1) {
            return JsonResult.success((String)"555", (Object)"\u8bf7\u4fdd\u7559\u6700\u540e\u4e00\u4f4d\u5b66\u5458");
        }
        return JsonResult.success();
    }

    @GetMapping(value={"addStudent"})
    public String addStudent(@RequestParam(value="groupId", required=true) Integer groupId, @RequestParam(value="jobId", required=true) Integer jobId, @RequestParam(value="stageTaskId", required=true) Integer stageTaskId, @RequestParam(value="shiftTaskId", required=true) Integer shiftTaskId, @RequestParam(value="studentList", required=true) List<Integer> studentList) {
        this.trainingJobParticipantsService.addStudent(groupId, jobId, stageTaskId, shiftTaskId, studentList);
        return JsonResult.success();
    }

    @GetMapping(value={"studenTanalyse"}, produces={"text/html;charset=UTF-8"})
    public String studenTanalyse(@RequestParam(value="groupId", required=true) Integer groupId, @RequestParam(value="jobId", required=true) Integer jobId, @RequestParam(value="deptId", required=false) List<String> deptId, @RequestParam(value="jobOrName", required=false) String jobOrName, @RequestParam(value="learnStatus", required=false) Integer learnStatus, @RequestParam(value="passStatus", required=false) Integer passStatus, @RequestParam(value="isFrozen", required=false) Integer isFrozen, @RequestParam(value="pageNumber", defaultValue="1") Integer pageNumber, @RequestParam(value="pageSize", defaultValue="20") Integer pageSize) {
        Page<UsersDutiesPojo> usersDutiesPojoPage = this.trainingJobParticipantsService.studentAnalyse(groupId, jobId, deptId, jobOrName, learnStatus, passStatus, isFrozen, pageNumber, pageSize);
        StudentCountNumber studentCountNumber = this.trainingJobParticipantsService.countStudentAnalyse(groupId, jobId, null, null);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("page", usersDutiesPojoPage);
        map.put("countStudenTanalyse", studentCountNumber);
        return JsonResult.success(map);
    }

    @GetMapping(value={"studenApproval"}, produces={"text/html;charset=UTF-8"})
    public String studenApproval(@RequestParam(value="jobId", required=true) Integer jobId, @RequestParam(value="stageTaskId", required=false) Integer stageTaskId, @RequestParam(value="shiftTaskId", required=false) Integer shiftTaskId, @RequestParam(value="userId", required=true) Integer userId) {
        List<TrainingJobExamine> trainingJobExamines = this.trainingJobParticipantsService.studentApproval(jobId, stageTaskId, shiftTaskId, userId);
        return JsonResult.success(trainingJobExamines);
    }

    @GetMapping(value={"studenApprovalProcess"}, produces={"text/html;charset=UTF-8"})
    public String studentApprovalProcess(@RequestParam(value="jobId", required=true) Integer jobId, @RequestParam(value="stageTaskId", required=false) Integer stageTaskId, @RequestParam(value="shiftTaskId", required=false) Integer shiftTaskId, @RequestParam(value="userId", required=true) Integer userId, @RequestParam(value="passStatus", required=true) Integer passStatus, @RequestParam(value="remark", required=true) String remark) {
        this.trainingJobParticipantsService.studentApprovalProcess(jobId, stageTaskId, shiftTaskId, userId, passStatus, remark);
        return JsonResult.success();
    }

    @GetMapping(value={"studenTanalyseExport"}, produces={"text/html;charset=UTF-8"})
    public void studentAnalyseExport(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="groupId", required=true) Integer groupId, @RequestParam(value="jobId", required=true) Integer jobId, @RequestParam(value="deptId", required=false) List<String> deptId, @RequestParam(value="jobOrName", required=false) String jobOrName, @RequestParam(value="learnStatus", required=false) Integer learnStatus, @RequestParam(value="passStatus", required=false) Integer passStatus, @RequestParam(value="isFrozen", required=false) Integer isFrozen, @RequestParam(value="pageNumber", defaultValue="1") Integer pageNumber, @RequestParam(value="pageSize", defaultValue="20") Integer pageSize) {
        Page<UsersDutiesPojo> usersDutiesPojoPage = this.trainingJobParticipantsService.studentAnalyse(groupId, jobId, deptId, jobOrName, learnStatus, passStatus, isFrozen, 1, 9999);
        List content = usersDutiesPojoPage.getContent();
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        XSSFWorkbook workbook = new XSSFWorkbook();
        String employeeNumber = this.messageSource.getMessage("training.user.details.employeeNumber", null, locale);
        String postName = this.messageSource.getMessage("training.job.post.name", null, locale);
        String department = this.messageSource.getMessage("training.course.analysis.department", null, locale);
        String studyStatus = this.messageSource.getMessage("training.course.analysis.study.status", null, locale);
        String passStatusName = this.messageSource.getMessage("training.shift.pass.status", null, locale);
        String passName = this.messageSource.getMessage("training.learn.pass", null, locale);
        String unPassName = this.messageSource.getMessage("training.learn.unpass", null, locale);
        String unStart = this.messageSource.getMessage("training.course.status.unstart", null, locale);
        String going = this.messageSource.getMessage("training.job.status.going", null, locale);
        String completed = this.messageSource.getMessage("training.job.status.completed", null, locale);
        Sheet sheet = workbook.createSheet(this.messageSource.getMessage("training.job.statistics.table", null, locale));
        Row row1 = sheet.createRow(0);
        Cell cell10 = row1.createCell(0);
        cell10.setCellValue(this.messageSource.getMessage("training.user.details.name", null, locale));
        Cell cell12 = row1.createCell(1);
        cell12.setCellValue(employeeNumber);
        sheet.setColumnWidth(1, 4024);
        Cell cell13 = row1.createCell(2);
        cell13.setCellValue(postName);
        Cell cell14 = row1.createCell(3);
        cell14.setCellValue(department);
        sheet.setColumnWidth(2, 4024);
        Cell cell15 = row1.createCell(4);
        cell15.setCellValue(this.messageSource.getMessage("training.course.analysis.starttime", null, locale));
        Cell cell16 = row1.createCell(5);
        cell16.setCellValue(this.messageSource.getMessage("training.course.analysis.endtime", null, locale));
        Cell cell17 = row1.createCell(6);
        cell17.setCellValue(studyStatus);
        Cell cell18 = row1.createCell(7);
        cell18.setCellValue(passStatusName);
        Cell cell19 = row1.createCell(8);
        cell19.setCellValue(this.messageSource.getMessage("training.job.certificate", null, locale));
        cell19.setCellValue(this.messageSource.getMessage("training.job.certificate", null, locale));
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        int i = 1;
        if (!CollectionUtils.isEmpty((Collection)content)) {
            for (UsersDutiesPojo usersDutiesPojo : content) {
                Row row = sheet.createRow(i++);
                Cell cellX0 = row.createCell(0);
                cellX0.setCellValue(usersDutiesPojo.getShowName());
                Cell cellX2 = row.createCell(1);
                cellX2.setCellValue(usersDutiesPojo.getEmployeeNumber());
                Cell cellX3 = row.createCell(2);
                cellX3.setCellValue(usersDutiesPojo.getDutiesName());
                Cell cellX4 = row.createCell(3);
                cellX4.setCellValue(usersDutiesPojo.getOrganizeName());
                Cell cellX5 = row.createCell(4);
                if (usersDutiesPojo.getStartTime() == null) {
                    cellX5.setCellValue("- -");
                } else {
                    String format2 = format.format(usersDutiesPojo.getStartTime());
                    cellX5.setCellValue(format2);
                }
                Cell cellX6 = row.createCell(5);
                if (usersDutiesPojo.getEndTime() == null) {
                    cellX6.setCellValue("- -");
                } else {
                    String format3 = format.format(usersDutiesPojo.getEndTime());
                    cellX6.setCellValue(format3);
                }
                Cell cellX7 = row.createCell(6);
                String s = "";
                Integer state = usersDutiesPojo.getState();
                if (state == null || state == 1) {
                    s = s + unStart + "\uff1a";
                } else if (state == 2) {
                    s = s + going + "\uff1a";
                } else if (state == 3) {
                    s = s + completed + "\uff1a";
                }
                s = s + usersDutiesPojo.getCompleteNumber() + "/" + usersDutiesPojo.getTotalNumber();
                cellX7.setCellValue(s);
                Cell cellX8 = row.createCell(7);
                Integer passStatus1 = usersDutiesPojo.getPassStatus();
                if (passStatus1 == null || passStatus1 == 0) {
                    cellX8.setCellValue("- -");
                } else if (passStatus1 == 1) {
                    cellX8.setCellValue(this.messageSource.getMessage("training.job.unapprove", null, locale));
                } else if (passStatus1 == 2) {
                    cellX8.setCellValue(unPassName);
                } else if (passStatus1 == 3) {
                    cellX8.setCellValue(passName);
                }
                Cell cellX9 = row.createCell(8);
                String url = usersDutiesPojo.getUrl();
                if (url == null) {
                    cellX9.setCellValue("- -");
                    continue;
                }
                cellX9.setCellValue(url);
            }
        }
        try {
            response.setContentType("application/vnd.ms-excel; charset=utf-8");
            response.setHeader("Content-Disposition", "attachment; filename=" + this.messageSource.getMessage("training.job.statistics.table", null, locale) + ".xls");
            ServletOutputStream output = response.getOutputStream();
            workbook.write((OutputStream)output);
            output.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

