/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.zother;

import com.ovopark.cloud.log.model.LogPojo;
import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.CommonRemoteService;
import com.ovopark.training.service.TrainingLearnShiftService;
import com.ovopark.training.util.CommonUtil;
import com.ovopark.training.vo.TrainingLearnShiftVo;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/training/trainingLearnShift"})
public class TrainingLearnShiftController {
    private static final Logger log = LoggerFactory.getLogger(TrainingLearnShiftController.class);
    @Autowired
    private TrainingLearnShiftService trainingLearnShiftService;
    @Autowired
    private CommonRemoteService commonRemoteService;

    @RequestMapping(value={"/addTrainingLearnShift"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String addTrainingLearnShift(@RequestBody TrainingLearnShiftVo trainingLearnShift) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (Objects.isNull(user) || Objects.isNull(user.getId())) {
            return "INVALID_TOKEN";
        }
        Integer shiftId = 0;
        if (Objects.isNull(trainingLearnShift.getId())) {
            trainingLearnShift.setCreatorId(user.getId());
            shiftId = this.trainingLearnShiftService.saveTrainingLearnShift(trainingLearnShift, user.getId());
        } else {
            shiftId = this.trainingLearnShiftService.updateShift(trainingLearnShift, null);
        }
        return JsonResult.success((Object)shiftId);
    }

    @RequestMapping(value={"/deleteTrainingLearnShift"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String deleteTrainingTask(HttpServletRequest req, Integer trainingLearnShiftId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (Objects.isNull(user) || Objects.isNull(user.getId())) {
            return "INVALID_TOKEN";
        }
        LogPojo pojo = new LogPojo();
        pojo.setUserId(user.getId());
        pojo.setOperation("study_program_class_delete");
        pojo.setCreateTime(new Date());
        pojo.setRemoteIp(req.getRemoteAddr());
        pojo.setEnterpriseId(user.getGroupId());
        pojo.setUserName(user.getUserName());
        pojo.setI18nKey("operation.study_program_class_delete.description");
        pojo.setPlatform(CommonUtil.getTerminalByToken(req));
        return this.trainingLearnShiftService.deleteShift(trainingLearnShiftId, user, pojo);
    }

    @RequestMapping(value={"/modifyTrainingLearnShift"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String modifyTrainingLearnShift(@RequestBody TrainingLearnShiftVo trainingLearnShift) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (Objects.isNull(user) || Objects.isNull(user.getId())) {
            return "INVALID_TOKEN";
        }
        Integer shiftId = this.trainingLearnShiftService.updateShift(trainingLearnShift, user.getId());
        return JsonResult.success((Object)shiftId);
    }

    @RequestMapping(value={"/selectTrainingLearnShiftByPage"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectTrainingLearnShiftByPage(Page<TrainingLearnShiftVo> page, String shiftName, Integer status, String creatorId, String startTime, String endTime, String createTime, Integer enterpriseId, Integer projectId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (Objects.isNull(user) || Objects.isNull(user.getId())) {
            return "INVALID_TOKEN";
        }
        Integer isSuperAdmin = 0;
        boolean t = this.commonRemoteService.isSuper(user.getId());
        if (t) {
            isSuperAdmin = 1;
        }
        List<Integer> creatorIds = null;
        if (!StringUtils.isEmpty((Object)creatorId)) {
            String[] createrStr = creatorId.split(",");
            List<String> createrS = Arrays.asList(createrStr);
            creatorIds = createrS.stream().map(Integer::parseInt).collect(Collectors.toList());
        }
        HashMap<String, Long> map = new HashMap<String, Long>();
        Page<TrainingLearnShiftVo> page1 = this.trainingLearnShiftService.selectLearnShiftByPage(page, user, shiftName, null, creatorIds, startTime, endTime, createTime, enterpriseId, projectId, isSuperAdmin);
        Long shiftNum = page1.getTotalCount();
        map.put("shiftNum", shiftNum);
        Page<TrainingLearnShiftVo> page2 = this.trainingLearnShiftService.selectLearnShiftByPage(page, user, shiftName, 2, creatorIds, startTime, endTime, createTime, enterpriseId, projectId, isSuperAdmin);
        Long ingNum = page2.getTotalCount();
        map.put("ingNum", ingNum);
        Page<TrainingLearnShiftVo> page3 = this.trainingLearnShiftService.selectLearnShiftByPage(page, user, shiftName, 3, creatorIds, startTime, endTime, createTime, enterpriseId, projectId, isSuperAdmin);
        Long waitNum = page3.getTotalCount();
        map.put("waitNum", waitNum);
        Page<TrainingLearnShiftVo> page4 = this.trainingLearnShiftService.selectLearnShiftByPage(page, user, shiftName, 4, creatorIds, startTime, endTime, createTime, enterpriseId, projectId, isSuperAdmin);
        Long finishNum = page4.getTotalCount();
        map.put("finishNum", finishNum);
        map.put("notNum", shiftNum - ingNum - waitNum - finishNum);
        Page<TrainingLearnShiftVo> page0 = this.trainingLearnShiftService.selectLearnShiftByPage(page, user, shiftName, status, creatorIds, startTime, endTime, createTime, enterpriseId, projectId, isSuperAdmin);
        map.put("data", (Long)page0);
        return JsonResult.success(map);
    }

    @RequestMapping(value={"/releaseTrainingLearnShift"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String releaseTrainingLearnShift(String startTime, String endTime, Integer shiftId, Integer status, Integer isOnlineNow, Integer isNotimeLimit, Integer projectId, @RequestParam(value="isSendMessage", required=false, defaultValue="0") Integer isSendMessage) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (Objects.isNull(user) || Objects.isNull(user.getId())) {
            return "INVALID_TOKEN";
        }
        shiftId = this.trainingLearnShiftService.releaseTrainingLearnShift(startTime, endTime, shiftId, status, isOnlineNow, isNotimeLimit, projectId, isSendMessage);
        return JsonResult.success((Object)shiftId);
    }

    @RequestMapping(value={"/selectReleaseShift"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectReleaseShift(Integer shiftId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (Objects.isNull(user) || Objects.isNull(user.getId())) {
            return "INVALID_TOKEN";
        }
        TrainingLearnShiftVo trainingLearnShiftVo = this.trainingLearnShiftService.selectReleaseLearnShift(shiftId, user.getGroupId());
        return JsonResult.success((Object)trainingLearnShiftVo);
    }

    @RequestMapping(value={"/selectIsUserShift"})
    @ResponseBody
    public String selectIsUserShift(Integer projectId, Integer type) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return JsonResult.success((Object)this.trainingLearnShiftService.selectIsUserShift(projectId, type, user));
    }

    @RequestMapping(value={"/getShiftPaperIdByTask"})
    @ResponseBody
    public String getShiftPaperIdByTask(@RequestParam Integer taskId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return JsonResult.success(this.trainingLearnShiftService.getShiftPaperIdByTask(taskId, user));
    }
}

