/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.zother;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ovopark.cloud.log.model.LogPojo;
import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.TrainingLecturer;
import com.ovopark.training.model.TrainingLecturerLevel;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.TrainingLecturerService;
import com.ovopark.training.util.CommonUtil;
import com.ovopark.training.util.ExcelUtil;
import com.ovopark.training.vo.TrainingLearnShiftVo;
import com.ovopark.training.vo.TrainingLecturerLevelVo;
import com.ovopark.training.vo.TrainingLecturerVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/training/lecturer"})
public class TrainingLecturerController {
    private static final Logger log = LoggerFactory.getLogger(TrainingLecturerController.class);
    @Resource
    private TrainingLecturerService trainingLecturerService;
    @Autowired
    private MessageSource messageSource;

    @RequestMapping(value={"/saveTrainingLecturerLevel"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String saveTrainingLecturerLevel(@RequestBody TrainingLecturerLevel trainingLecturerLevel) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (this.trainingLecturerService.nameIsUse(trainingLecturerLevel, null, user.getGroupId())) {
            return JsonResult.error((String)"NAME_EXISTING", (Object)"\u540d\u5b57\u91cd\u590d");
        }
        this.trainingLecturerService.saveTrainingLecturerLevel(trainingLecturerLevel, user);
        return JsonResult.success();
    }

    @RequestMapping(value={"/deleteTrainingLecturerLevel"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String deleteTrainingLecturerLevel(HttpServletRequest req, Integer id) {
        Users user = Authenticator.getInstance().getCurrentUser();
        LogPojo pojo = new LogPojo();
        pojo.setUserId(user.getId());
        pojo.setOperation("lecturer_level_delete");
        pojo.setCreateTime(new Date());
        pojo.setRemoteIp(req.getRemoteAddr());
        pojo.setEnterpriseId(user.getGroupId());
        pojo.setUserName(user.getUserName());
        pojo.setI18nKey("operation.lecturer_level_delete.description");
        pojo.setPlatform(CommonUtil.getTerminalByToken(req));
        return this.trainingLecturerService.deleteTrainingLecturerLevel(id, pojo);
    }

    @RequestMapping(value={"/getTrainingLecturerLevel"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getTrainingLecturerLevel(long size, long current) {
        Page trainingLecturerLevelIPage = new Page();
        trainingLecturerLevelIPage.setSize(size);
        trainingLecturerLevelIPage.setCurrent(current);
        Users user = Authenticator.getInstance().getCurrentUser();
        return JsonResult.success(this.trainingLecturerService.getTrainingLecturerLevel((IPage<TrainingLecturerLevelVo>)trainingLecturerLevelIPage, user));
    }

    @RequestMapping(value={"/getTrainingLecturerLevelAll"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getTrainingLecturerLevelAll(Integer lecturerType) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return JsonResult.success(this.trainingLecturerService.getTrainingLecturerLevelAll(user, lecturerType));
    }

    @RequestMapping(value={"/saveTrainingLecturer"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String saveTrainingLecturer(@RequestBody TrainingLecturer trainingLecturer) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (this.trainingLecturerService.nameIsUse(null, trainingLecturer, user.getGroupId())) {
            return JsonResult.error((String)"NAME_EXISTING", (Object)"\u540d\u5b57\u91cd\u590d");
        }
        this.trainingLecturerService.saveTrainingLecturer(trainingLecturer, user);
        return JsonResult.success();
    }

    @RequestMapping(value={"/saveTrainingLecturerList"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String saveTrainingLecturerList(@RequestBody List<TrainingLecturer> list) {
        Users user = Authenticator.getInstance().getCurrentUser();
        this.trainingLecturerService.saveTrainingLecturerList(list, user);
        return JsonResult.success();
    }

    @RequestMapping(value={"/deleteTrainingLecturer"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String deleteTrainingLecturer(HttpServletRequest req, Integer id) {
        Users user = Authenticator.getInstance().getCurrentUser();
        LogPojo pojo = new LogPojo();
        pojo.setUserId(user.getId());
        pojo.setOperation("lecturer_delete");
        pojo.setCreateTime(new Date());
        pojo.setRemoteIp(req.getRemoteAddr());
        pojo.setEnterpriseId(user.getGroupId());
        pojo.setUserName(user.getUserName());
        pojo.setI18nKey("operation.lecturer_delete.description");
        pojo.setPlatform(CommonUtil.getTerminalByToken(req));
        return this.trainingLecturerService.deleteTrainingLecturer(id, pojo);
    }

    @RequestMapping(value={"/getTrainingLecturers"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getTrainingLecturers(long size, long current, String name, Integer lecturerType, Integer levelId, Integer status) {
        Page trainingLecturerIPage = new Page();
        trainingLecturerIPage.setSize(size);
        trainingLecturerIPage.setCurrent(current);
        Users user = Authenticator.getInstance().getCurrentUser();
        return JsonResult.success(this.trainingLecturerService.getTrainingLecturers((IPage<TrainingLecturer>)trainingLecturerIPage, user, name, lecturerType, levelId, status));
    }

    @RequestMapping(value={"/getTrainingLecturer"})
    @ResponseBody
    public String getTrainingLecturer(String name, Integer lecturerType, Integer levelId, Integer status) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return JsonResult.success(this.trainingLecturerService.getTrainingLecturer(user, name, lecturerType, levelId, status));
    }

    @RequestMapping(value={"/updateTrainingLecturerStatus"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String updateTrainingLecturerStatus(Integer id, Integer status) {
        this.trainingLecturerService.updateTrainingLecturerStatus(id, status);
        return JsonResult.success();
    }

    @RequestMapping(value={"/selectLecturerDetailByPage"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectLecturerDetailByPage(long size, long current, Integer id) {
        IPage<TrainingLearnShiftVo> page = new IPage<TrainingLearnShiftVo>();
        page.setSize(size);
        page.setCurrent(current);
        try {
            page = this.trainingLecturerService.selectLecturerDetailByPage(page, id);
        }
        catch (Exception e) {
            log.error("selectLecturerDetailByPage" + e);
            e.printStackTrace();
        }
        return JsonResult.success(page);
    }

    @RequestMapping(value={"/saveIsMatchUser"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String saveIsMatchUser(@RequestParam(value="file") MultipartFile file, Integer enterpriseId) {
        try {
            Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
            if (!file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf(".") + 1).equals("xls") && !file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf(".") + 1).equals("xlsx")) {
                return JsonResult.error((String)"4", (Object)"\u6587\u4ef6\u683c\u5f0f\u9519\u8bef");
            }
            Map map = new HashMap();
            List<List<Object>> excelList0 = ExcelUtil.getBankListByExcel(file.getInputStream(), file.getOriginalFilename(), 0);
            if (CollectionUtils.isEmpty(excelList0) || !CollectionUtils.isEmpty(excelList0) && excelList0.size() < 3 || !CollectionUtils.isEmpty(excelList0) && excelList0.size() > 1 && excelList0.get(1).size() < 6 || !CollectionUtils.isEmpty(excelList0) && excelList0.size() > 1 && !this.messageSource.getMessage("training.lecturer.intro", null, locale).equals(excelList0.get(1).get(5).toString().trim())) {
                return JsonResult.error((String)this.messageSource.getMessage("training.training.check.content", null, locale), (Object)"");
            }
            if (!CollectionUtils.isEmpty(excelList0) && excelList0.size() > 1002 && !CollectionUtils.isEmpty((Collection)excelList0.get(1002))) {
                return JsonResult.error((String)this.messageSource.getMessage("training.training.over.content", null, locale), (Object)"");
            }
            if (!CollectionUtils.isEmpty(excelList0) && (excelList0.size() < 1003 || excelList0.size() >= 1003 && CollectionUtils.isEmpty((Collection)excelList0.get(1002)))) {
                ArrayList<TrainingLecturerVo> usersMoList = new ArrayList<TrainingLecturerVo>();
                for (int i = 2; i < excelList0.size(); ++i) {
                    List<Object> list = excelList0.get(i);
                    if (CollectionUtils.isEmpty(list)) continue;
                    TrainingLecturerVo mo = new TrainingLecturerVo();
                    mo.setRowNum(Integer.valueOf(i + 1));
                    Integer index = 0;
                    if (list.size() >= 1 && !StringUtils.isEmpty((Object)list.get(0))) {
                        String userName = list.get(0).toString().trim();
                        mo.setUserName(userName);
                        index = 1;
                    }
                    if (list.size() >= 2 && !StringUtils.isEmpty((Object)list.get(1))) {
                        String employeeNumber = list.get(1).toString().trim();
                        mo.setEmployeeNumber(employeeNumber);
                        index = 1;
                    }
                    if (list.size() >= 3 && !StringUtils.isEmpty((Object)list.get(2))) {
                        String sex = list.get(2).toString().trim();
                        mo.setSex(Integer.valueOf(1));
                        if (this.messageSource.getMessage("training.lecturer.female", null, locale).equals(sex)) {
                            mo.setSex(Integer.valueOf(0));
                        }
                        index = 1;
                    }
                    if (list.size() >= 4 && !StringUtils.isEmpty((Object)list.get(3))) {
                        String type = list.get(3).toString().trim();
                        mo.setLecturerType(Integer.valueOf(0));
                        if (this.messageSource.getMessage("training.out.lecturer", null, locale).equals(type)) {
                            mo.setLecturerType(Integer.valueOf(1));
                        }
                        index = 1;
                    }
                    if (list.size() >= 5 && !StringUtils.isEmpty((Object)list.get(4))) {
                        String levelName = list.get(4).toString().trim();
                        mo.setLevelName(levelName);
                        index = 1;
                    }
                    if (list.size() >= 6 && !StringUtils.isEmpty((Object)list.get(5))) {
                        String description = list.get(5).toString().trim();
                        mo.setDescription(description);
                        index = 1;
                    }
                    if (StringUtils.isEmpty((Object)mo) || index != 1) continue;
                    usersMoList.add(mo);
                }
                map = this.trainingLecturerService.selectMatchLecturer(usersMoList, enterpriseId);
            }
            return JsonResult.success(map);
        }
        catch (Exception e) {
            log.error("\u5bfc\u5165\u8bb2\u5e08\u662f\u5426\u5339\u914d:", (Object)e.getMessage());
            e.printStackTrace();
            return JsonResult.error((String)"", (Object)e.getMessage());
        }
    }
}

